/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.data.meta.io;

import com.kingdee.bos.ctrl.data.meta.MetaClass;
import com.kingdee.bos.ctrl.data.meta.MetaField;
import com.kingdee.bos.ctrl.data.meta.MetaLibrary;
import com.kingdee.bos.ctrl.data.meta.MetaPackage;
import com.kingdee.bos.ctrl.data.meta.io.IMeta2Xml;
import com.kingdee.bos.ctrl.data.modal.io.Def2Xml;
import com.kingdee.bos.ctrl.data.modal.io.ParameterIO;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Element;

public class Meta2Xml {
    public static final String T_LIBRARY = "Library";
    public static final String T_PACKAGE = "Package";
    public static final String T_CLASS = "Class";
    public static final String T_FIELD = "Field";
    public static final String A_DATASOURCE_TYPE = "dataSourceType";
    public static final String V_VERSION = "1.1";

    public Element transform(MetaLibrary mp) {
        return Meta2Xml.makeLibrary(mp, null);
    }

    public static Element makeLibrary(MetaLibrary lib, IMeta2Xml saver) {
        Element xmlLib = Meta2Xml.makePackage(lib.getRootPackage(), saver);
        xmlLib.setName(T_LIBRARY);
        xmlLib.setAttribute("version", V_VERSION);
        Def2Xml.makeDefObj(lib, xmlLib);
        return xmlLib;
    }

    public static void makePackage(MetaPackage pkg, Element xmlPkg, IMeta2Xml saver) {
        List subGrps;
        Def2Xml.makeDefObj(pkg, xmlPkg);
        List subTabs = pkg.getClasses();
        if (subTabs != null) {
            int len = subTabs.size();
            for (int i = 0; i < len; ++i) {
                MetaClass subTab = (MetaClass)subTabs.get(i);
                if (saver != null) {
                    saver.enterClass(subTab, pkg);
                }
                Element xmlSubCls = Meta2Xml.makeClass(subTab, saver);
                if (saver != null) {
                    saver.saveClass(subTab, xmlSubCls, pkg, xmlPkg);
                    continue;
                }
                xmlPkg.addContent((Content)xmlSubCls);
            }
        }
        if ((subGrps = pkg.getPackages()) != null) {
            int len = subGrps.size();
            for (int i = 0; i < len; ++i) {
                MetaPackage subOrg = (MetaPackage)subGrps.get(i);
                if (saver != null) {
                    saver.enterPackage(subOrg, pkg);
                }
                Element xmlSubPkg = Meta2Xml.makePackage(subOrg, saver);
                if (saver != null) {
                    saver.savePackage(subOrg, xmlSubPkg, pkg, xmlPkg);
                    continue;
                }
                xmlPkg.addContent((Content)xmlSubPkg);
            }
        }
    }

    public static Element makePackage(MetaPackage pkg, IMeta2Xml saver) {
        Element xmlPkg = new Element(T_PACKAGE);
        Meta2Xml.makePackage(pkg, xmlPkg, saver);
        return xmlPkg;
    }

    public static Element makeClass(MetaClass cls, IMeta2Xml saver) {
        List flds;
        List ps;
        Element xmlCls = new Element(T_CLASS);
        xmlCls.setAttribute("version", V_VERSION);
        Def2Xml.makeDefObj(cls, xmlCls);
        xmlCls.setAttribute("type", cls.getType());
        String s = cls.getExpr();
        if (s != null) {
            xmlCls.setAttribute("expr", s);
        }
        if ((ps = cls.getParameters()) != null) {
            ParameterIO.makeParameters(ps);
        }
        if ((flds = cls.getFields()) != null) {
            int len = flds.size();
            for (int i = 0; i < len; ++i) {
                MetaField fld = (MetaField)flds.get(i);
                if (saver != null) {
                    saver.enterField(fld, cls);
                }
                Element xmlFld = Meta2Xml.makeField(fld);
                if (saver != null) {
                    saver.saveField(fld, xmlFld, cls, xmlCls);
                    continue;
                }
                xmlCls.addContent((Content)xmlFld);
            }
        }
        return xmlCls;
    }

    public static Element makeField(MetaField fld) {
        Element xmlFld = new Element(T_FIELD);
        Def2Xml.makeDefObj(fld, xmlFld);
        xmlFld.setAttribute("type", fld.getType().getName());
        String s = fld.getExpr();
        if (s != null) {
            xmlFld.setAttribute("expr", s);
        }
        return xmlFld;
    }
}

