/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.formatter;

import com.kingdee.bos.ctrl.kdf.expr.SyntaxErrorException;
import com.kingdee.bos.ctrl.kdf.expr.Variant;
import com.kingdee.bos.ctrl.kdf.formatter.DateParser;
import com.kingdee.bos.ctrl.kdf.formatter.FormatException;
import com.kingdee.bos.ctrl.kdf.formatter.FormatProperty;
import com.kingdee.bos.ctrl.kdf.formatter.FormatType;
import com.kingdee.bos.ctrl.kdf.formatter.IRounding;
import com.kingdee.bos.ctrl.kdf.formatter.PatternPaster;
import com.kingdee.bos.ctrl.kdf.util.CtrlFormatUtilities;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class Formatter {
    private FormatType type;
    private IRounding roundMode = FormatProperty.getInstance().getRoundMode();
    private Locale locale = FormatProperty.getInstance().getLocale();
    private TimeZone zone = FormatProperty.getInstance().getTimeZone();

    private Formatter() {
    }

    public Formatter(FormatType type) {
        this();
        this.type = type;
    }

    public Formatter(String pattern) throws FormatException {
        this();
        this.type = FormatType.paserFormatType(pattern);
    }

    public void setType(FormatType type) {
        this.type = type;
    }

    private String fillCenter(String source, int width, String place) {
        int pos;
        int i;
        if (source.length() >= width) {
            return source;
        }
        char[] p1 = place.toCharArray();
        int len1 = source.length();
        int len2 = place.length();
        int start = width - len1 >> 1;
        int rep1 = (int)Math.ceil((double)start / (double)len2);
        int rep2 = (int)Math.ceil((double)(width - len1 - start) / (double)len2);
        int length = start + len1 + len2 * rep2;
        char[] dist = new char[length];
        for (i = 0; i < rep1; ++i) {
            pos = len2 * i;
            System.arraycopy(p1, 0, dist, pos, len2);
        }
        for (i = 0; i < rep2; ++i) {
            pos = len2 * i + (len1 + start);
            System.arraycopy(p1, 0, dist, pos, len2);
        }
        char[] src = source.toCharArray();
        System.arraycopy(src, 0, dist, start, len1);
        return new String(dist).substring(0, width);
    }

    private String fillLeft(String source, int width, String place) {
        if (source.length() >= width) {
            return source;
        }
        char[] p1 = place.toCharArray();
        int len1 = source.length();
        int len2 = place.length();
        int rep = (int)Math.ceil((double)(width - len1) / (double)len2);
        int length = len1 + len2 * rep;
        char[] dist = new char[length];
        for (int i = 0; i < rep; ++i) {
            int pos = len2 * i;
            System.arraycopy(p1, 0, dist, pos, len2);
        }
        char[] src = source.toCharArray();
        System.arraycopy(src, 0, dist, length - len1, len1);
        return new String(dist).substring(length - width, length);
    }

    private String fillRight(String source, int width, String place) {
        if (source.length() >= width) {
            return source;
        }
        int len1 = source.length();
        char[] p1 = place.toCharArray();
        int len2 = place.length();
        int rep = (int)Math.ceil((double)(width - len1) / (double)len2);
        int length = len1 + len2 * rep;
        char[] dist = new char[length];
        char[] src = source.toCharArray();
        System.arraycopy(src, 0, dist, 0, len1);
        for (int i = 0; i < rep; ++i) {
            int pos = len2 * i + len1;
            System.arraycopy(p1, 0, dist, pos, len2);
        }
        return new String(dist).substring(0, width);
    }

    public String format(String source) {
        return this.format(new Variant(source, 11));
    }

    public String format(Variant source) {
        String result;
        if (this.type.getType() == FormatType.Type.GENERAL) {
            result = this.formatGeneral(source);
        } else if (this.type.getType() == FormatType.Type.NUMBER) {
            if (!source.isNumeric()) {
                result = source.toString();
            }
            result = this.formatNumber(source);
        } else {
            result = this.type.getType() == FormatType.Type.CURRENCY ? this.formatCurrency(source) : (this.type.getType() == FormatType.Type.DATETIME ? this.formatDateTime(source) : (this.type.getType() == FormatType.Type.FRACTION ? this.formatFraction(source) : (this.type.getType() == FormatType.Type.RATE ? this.formatRate(source) : (this.type.getType() == FormatType.Type.SCIENTIFIC ? this.formatScientific(source) : (this.type.getType() == FormatType.Type.HEX ? this.formatHex(source) : (this.type.getType() == FormatType.Type.BIG_HEX ? this.formatBigHex(source) : (this.type.getType() == FormatType.Type.OCTAL ? this.formatOctal(source) : (this.type.getType() == FormatType.Type.BINARY ? this.formatBinary(source) : (this.type.getType() == FormatType.Type.CUSTOM ? source.toString() : source.toString())))))))));
        }
        return this.fill(result);
    }

    private String fill(String source) {
        String result = "";
        result = this.type.getAlign() == FormatType.Align.LEFT ? this.fillRight(source, this.type.getWidth(), this.type.getPlaceCharacter()) : (this.type.getAlign() == FormatType.Align.CENTER ? this.fillCenter(source, this.type.getWidth(), this.type.getPlaceCharacter()) : this.fillLeft(source, this.type.getWidth(), this.type.getPlaceCharacter()));
        return result;
    }

    private String fill(String src1, String src2) {
        if (src1.length() + src2.length() > this.type.getWidth()) {
            return src1 + src2;
        }
        StringBuffer result = new StringBuffer(this.type.getWidth());
        if (this.type.getAlign() == FormatType.Align.LEFT) {
            int len = this.type.getWidth() - src2.length();
            String src = this.fillRight(src1, this.type.getWidth(), this.type.getPlaceCharacter());
            result.append(src.substring(0, len)).append(src2);
        } else if (this.type.getAlign() == FormatType.Align.CENTER) {
            int len = this.type.getWidth() - src1.length();
            String res = this.fillLeft(src2, this.type.getWidth(), this.type.getPlaceCharacter());
            result.append(src1).append(res.substring(res.length() - len));
        } else if (this.type.getAlign() == FormatType.Align.RIGHT) {
            int len = src1.length();
            String res = this.fillLeft(src2, this.type.getWidth(), this.type.getPlaceCharacter());
            result.append(src1).append(res.substring(len));
        }
        return result.toString();
    }

    String formatGeneral(Variant source) {
        String result = source.toString();
        if (this.type.getScale() > 0) {
            result = result.substring(0, this.type.getScale() + 1);
        }
        PatternPaster paster = PatternPaster.getStringPasterInstance();
        paster.paster(this.type.getPattern());
        String[] res = paster.format(result);
        result = res.length == 2 ? this.fill(res[0], res[1]) : res[0];
        return result;
    }

    String formatDateTime(Variant source) {
        if (source.getVt() == 13) {
            SimpleDateFormat df = new SimpleDateFormat(this.type.getPattern(), this.getLocale());
            df.setTimeZone(this.getTimeZone());
            Date date = ((Calendar)source.getValue()).getTime();
            return df.format(date);
        }
        if (source.getVt() == 12) {
            SimpleDateFormat df = new SimpleDateFormat(this.type.getPattern(), this.getLocale());
            df.setTimeZone(this.getTimeZone());
            return df.format(source.getValue());
        }
        if (!source.isNumber()) {
            try {
                Date date = DateParser.pasterDate(source.toString());
                SimpleDateFormat df = new SimpleDateFormat(this.type.getPattern(), this.getLocale());
                df.setTimeZone(this.getTimeZone());
                return df.format(date);
            }
            catch (FormatException e) {
                return source.toString();
            }
        }
        return source.toString();
    }

    String formatNumber(Variant source) {
        PatternPaster paster = PatternPaster.getNumberPasterInstance();
        String pattern = paster.paster(this.type.getPattern());
        if (pattern == null || pattern.length() == 0) {
            String result = null;
            String[] res = paster.format(source.toString());
            result = res.length == 2 ? this.fill(res[0], res[1]) : res[0];
            return result;
        }
        int pos = pattern.indexOf(46);
        if (pos >= 0) {
            this.type.setScale(pattern.length() - pos - 1);
        }
        if (source.isNumeric()) {
            String[] res;
            BigDecimal value = null;
            try {
                value = this.roundMode.round(source.toBigDecimal(), this.type.getScale());
            }
            catch (Exception e) {
                return source.toString();
            }
            NumberFormat nf = NumberFormat.getNumberInstance(this.getLocale());
            DecimalFormat df = (DecimalFormat)nf;
            df.setDecimalFormatSymbols(CtrlFormatUtilities.getDecimalFormatSymbols());
            df.applyPattern(pattern);
            int sign = value.signum();
            value = value.abs();
            String result = df.format(value);
            if (this.type.getDisplaySymol() != FormatType.SymbolDisplayModal.NONE) {
                if (this.type.getDisplaySymol() == FormatType.SymbolDisplayModal.PLUS && sign == 1) {
                    result = "+" + result;
                } else if (sign == -1) {
                    result = "-" + result;
                }
            }
            result = (res = paster.format(result)).length == 2 ? this.fill(res[0], res[1]) : res[0];
            return result;
        }
        return source.toString();
    }

    String formatRate(Variant source) {
        float f = 0.0f;
        if (source.getVt() == 0) {
            return "";
        }
        try {
            f = source.floatValue();
        }
        catch (SyntaxErrorException e) {
            return source.toString();
        }
        Variant v = new Variant(f *= 100.0f);
        String result = this.formatNumber(v);
        DecimalFormatSymbols dfs = new DecimalFormatSymbols(this.getLocale());
        char percent = dfs.getPercent();
        return result + percent;
    }

    String formatFraction(Variant source) {
        return source.toString();
    }

    public String formatScientific(Variant source) {
        if (source.isNumeric()) {
            BigDecimal value = null;
            try {
                value = source.toBigDecimal();
            }
            catch (SyntaxErrorException e) {
                return source.toString();
            }
            int sign = value.signum();
            value = value.abs();
            StringBuffer result = new StringBuffer();
            if (this.type.getDisplaySymol() != FormatType.SymbolDisplayModal.NONE) {
                if (this.type.getDisplaySymol() == FormatType.SymbolDisplayModal.PLUS && sign == 1) {
                    result.append("+");
                } else if (sign == -1) {
                    result.append("-");
                }
            }
            int scale = value.scale();
            String val = null;
            val = scale > 0 ? value.movePointRight(scale).toString() : (scale < 0 ? value.movePointLeft(scale).toString() : value.toString());
            int exp = val.length() - 1 - scale;
            String expSignum = "";
            if (exp >= 0) {
                expSignum = "+";
            }
            StringBuffer sb = new StringBuffer(val.length() + 1);
            sb.append(val.substring(0, 1)).append('.').append(val.substring(1));
            value = this.roundMode.round(new BigDecimal(sb.toString()), this.type.getScale());
            return result.append(value.toString()).append('E').append(expSignum).append(exp).toString();
        }
        return source.toString();
    }

    String formatBinary(Variant source) {
        if (source.isNumeric()) {
            try {
                String value = Long.toBinaryString(source.longValue());
                if (value.length() < this.type.getScale()) {
                    value = this.fillLeft(value, this.type.getScale(), "0");
                }
                return value;
            }
            catch (SyntaxErrorException e) {
                return source.toString();
            }
        }
        return source.toString();
    }

    String formatOctal(Variant source) {
        if (source.isNumeric()) {
            try {
                String value = Long.toOctalString(source.longValue());
                if (value.length() < this.type.getScale()) {
                    value = this.fillLeft(value, this.type.getScale(), "0");
                }
                return value;
            }
            catch (SyntaxErrorException e) {
                return source.toString();
            }
        }
        return source.toString();
    }

    String formatHex(Variant source) {
        if (source.isNumeric()) {
            String value = null;
            try {
                value = Long.toHexString(source.longValue());
            }
            catch (SyntaxErrorException e) {
                return source.toString();
            }
            if (value.length() < this.type.getScale()) {
                value = this.fillLeft(value, this.type.getScale(), "0");
            }
            return "0x" + value.toLowerCase();
        }
        return source.toString();
    }

    String formatBigHex(Variant source) {
        return this.formatHex(source).toUpperCase();
    }

    String formatCurrency(Variant source) {
        return source.toString();
    }

    public IRounding getRounding() {
        return this.roundMode;
    }

    public void setRounding(IRounding round) {
        this.roundMode = round;
    }

    public double round(BigDecimal source, int scale) {
        return this.roundMode.round(source, scale).doubleValue();
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public TimeZone getTimeZone() {
        return this.zone;
    }

    public void setTimeZone(TimeZone zone) {
        this.zone = zone;
    }
}

