/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.formatter;

import com.kingdee.bos.ctrl.kdf.formatter.NumberTransEnglish;
import com.kingdee.bos.ctrl.kdf.formatter.NumberTranslate;
import com.kingdee.bos.ctrl.kdf.formatter.PRCChineseBigNumberResource;
import com.kingdee.bos.ctrl.kdf.formatter.PRCChineseNumberResource;
import com.kingdee.bos.ctrl.kdf.formatter.TraditionaryChineseBigNumberResource;
import com.kingdee.bos.ctrl.kdf.formatter.TraditionaryChineseNumberResource;
import java.math.BigDecimal;
import java.util.Locale;

public class StringFormatter {
    private StringFormatter() {
    }

    public static final String toPlural(String source) {
        if (source == null || source.length() == 0 || source.trim().length() == 0) {
            return source;
        }
        return source + "s";
    }

    public static final String toUpperCaseFirst(String source) {
        return StringFormatter.toUpperCaseFirst(source, Locale.CHINA);
    }

    public static final String toUpperCaseFirst(String source, Locale l) {
        if (source == null || source.length() == 0) {
            return source;
        }
        StringBuffer sb = new StringBuffer(source.length());
        return sb.append(source.substring(0, 1).toUpperCase(l)).append(source.substring(1, source.length())).toString();
    }

    public static final String toUpperCase(String source) {
        return StringFormatter.toUpperCase(source, Locale.CHINA);
    }

    public static final String toUpperCase(String source, Locale l) {
        if (source == null || source.length() == 0) {
            return source;
        }
        return source.toUpperCase(l);
    }

    public static final String toUpperCase(String source, int start) {
        return StringFormatter.toUpperCase(source, start, source.length());
    }

    public static final String toUpperCase(String source, int start, int length) {
        return StringFormatter.toUpperCase(source, start, length, Locale.CHINA);
    }

    public static final String toUpperCase(String source, int start, int length, Locale l) {
        if (source == null || source.length() == 0 || length <= 0 || start >= source.length()) {
            return source;
        }
        start = Math.max(start, 0);
        int end = Math.min(source.length(), start + length);
        StringBuffer sb = new StringBuffer(source.length());
        if (start == 0) {
            sb.append(source.substring(start, end).toUpperCase(l));
        } else {
            sb.append(source.substring(0, start)).append(source.substring(start, end).toUpperCase(l));
        }
        if (end < source.length()) {
            sb.append(source.substring(end, source.length()));
        }
        return sb.toString();
    }

    public static final String toLowerCaseFirst(String source) {
        return StringFormatter.toLowerCaseFirst(source, Locale.CHINA);
    }

    public static final String toLowerCaseFirst(String source, Locale l) {
        StringBuffer sb = new StringBuffer(source.length());
        return sb.append(source.substring(0, 1).toLowerCase(l)).append(source.substring(1, source.length())).toString();
    }

    public static final String toLowerCase(String source) {
        return StringFormatter.toLowerCase(source, Locale.CHINA);
    }

    public static final String toLowerCase(String source, Locale l) {
        if (source == null || source.length() == 0) {
            return source;
        }
        return source.toLowerCase(l);
    }

    public static final String toLowerCase(String source, int start) {
        return StringFormatter.toLowerCase(source, start, source.length());
    }

    public static final String toLowerCase(String source, int start, int length) {
        return StringFormatter.toLowerCase(source, start, length, Locale.CHINA);
    }

    public static final String toLowerCase(String source, int start, int length, Locale l) {
        if (source == null || source.length() == 0 || length <= 0 || start >= source.length()) {
            return source;
        }
        start = Math.max(start, 0);
        int end = Math.min(source.length(), start + length);
        StringBuffer sb = new StringBuffer(source.length());
        if (start == 0) {
            sb.append(source.substring(start, end).toLowerCase(l));
        } else {
            sb.append(source.substring(0, start)).append(source.substring(start, end).toLowerCase(l));
        }
        if (end < source.length()) {
            sb.append(source.substring(end, source.length()));
        }
        return sb.toString();
    }

    public static final String toSChineseUpperNumber(String source) {
        try {
            BigDecimal value = new BigDecimal(source);
            NumberTranslate trans = new NumberTranslate(PRCChineseBigNumberResource.getInstance());
            return trans.toNumber(value);
        }
        catch (NumberFormatException nfe) {
            return source;
        }
    }

    public static final String toSChineseLowerNumber(String source) {
        try {
            BigDecimal value = new BigDecimal(source);
            NumberTranslate trans = new NumberTranslate(PRCChineseNumberResource.getInstance());
            return trans.toNumber(value);
        }
        catch (NumberFormatException nfe) {
            return source;
        }
    }

    public static final String toTChineseUpperNumber(String source) {
        try {
            BigDecimal value = new BigDecimal(source);
            NumberTranslate trans = new NumberTranslate(TraditionaryChineseBigNumberResource.getInstance());
            return trans.toNumber(value);
        }
        catch (NumberFormatException nfe) {
            return source;
        }
    }

    public static final String toTChineseLowerNumber(String source) {
        try {
            BigDecimal value = new BigDecimal(source);
            NumberTranslate trans = new NumberTranslate(TraditionaryChineseNumberResource.getInstance());
            return trans.toNumber(value);
        }
        catch (NumberFormatException nfe) {
            return source;
        }
    }

    public static final String toEnglishNumber(String source) {
        try {
            return NumberTransEnglish.toEnglishNumber(source);
        }
        catch (NumberFormatException nfe) {
            return source;
        }
    }

    public static final String toEnglishNumber(String source, int type) {
        try {
            return NumberTransEnglish.toEnglishNumber(source, type);
        }
        catch (NumberFormatException nfe) {
            return source;
        }
    }
}

