/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common.currency;

import com.kingdee.bos.ctrl.common.currency.ICurrencyUpperFunction;
import com.kingdee.bos.ctrl.common.digitalstyle.Format;
import com.kingdee.bos.ctrl.common.digitalstyle.Formats;
import com.kingdee.bos.ctrl.common.variant.Variant;
import java.util.Locale;

public class FormatMYR
implements ICurrencyUpperFunction {
    private Format format;

    @Override
    public String format(Locale locale, Variant variant, boolean isAddPrefix) {
        String result = null;
        if (locale == Locale.ENGLISH) {
            this.format = Formats.getFormat("[ENG-MYR]0.00");
        } else if (locale == Locale.SIMPLIFIED_CHINESE) {
            this.format = Formats.getFormat("[CHS-MYR]0.00;[CHS-MYR]0.00");
        } else if (locale == Locale.TRADITIONAL_CHINESE) {
            this.format = Formats.getFormat("[CHT-MYR]0.00;[CHT-MYR]0.00");
        } else {
            throw new RuntimeException("Not support language: " + locale);
        }
        result = this.format.format4Print(variant).toString();
        if (isAddPrefix && locale != Locale.ENGLISH) {
            if (locale == Locale.SIMPLIFIED_CHINESE) {
                result = "\u4ee4\u5409" + result;
            } else if (locale == Locale.TRADITIONAL_CHINESE) {
                result = "\u4ee4\u5409" + result;
            } else {
                throw new RuntimeException("Not support language: " + locale);
            }
        }
        return result;
    }
}

