/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common.currency;

import com.kingdee.bos.ctrl.common.currency.ICurrencyUpperFunction;
import com.kingdee.bos.ctrl.common.digitalstyle.Format;
import com.kingdee.bos.ctrl.common.digitalstyle.FormatResult;
import com.kingdee.bos.ctrl.common.digitalstyle.Formats;
import com.kingdee.bos.ctrl.common.variant.Variant;
import java.util.Locale;

public class FormatRMB
implements ICurrencyUpperFunction {
    private Format format;

    public String format(Variant variant) {
        this.format = Formats.getFormat("[Rmb]G/\u901a\u7528\u683c\u5f0f;[Rmb](\u8d1f\u6570)G/\u901a\u7528\u683c\u5f0f");
        FormatResult result = this.format.format(variant);
        return result.toString();
    }

    @Override
    public String format(Locale locale, Variant variant, boolean isAddPrefix) {
        String result = null;
        if (locale == Locale.ENGLISH) {
            this.format = Formats.getFormat("[ENG-RMB]g/\u901a\u7528\u683c\u5f0f");
        } else if (locale == Locale.SIMPLIFIED_CHINESE) {
            this.format = Formats.getFormat("[Rmb]G/\u901a\u7528\u683c\u5f0f;[Rmb](\u8d1f\u6570)G/\u901a\u7528\u683c\u5f0f");
        } else if (locale == Locale.TRADITIONAL_CHINESE) {
            this.format = Formats.getFormat("[CHT-Rmb]G/\u901a\u7528\u683c\u5f0f;[CHT-Rmb](\u8d1f\u6570)G/\u901a\u7528\u683c\u5f0f");
        } else {
            throw new RuntimeException("Not support language: " + locale);
        }
        result = this.format.format4Print(variant).toString();
        if (isAddPrefix && locale != Locale.ENGLISH) {
            if (locale == Locale.SIMPLIFIED_CHINESE) {
                result = "\u4eba\u6c11\u5e01" + result;
            } else if (locale == Locale.TRADITIONAL_CHINESE) {
                result = "\u4eba\u6c11\u5e63" + result;
            } else {
                throw new RuntimeException("Not support language: " + locale);
            }
        }
        return result;
    }
}

