/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common.currency;

import com.kingdee.bos.ctrl.common.currency.ICurrencyUpperFunction;
import com.kingdee.bos.ctrl.common.digitalstyle.Format;
import com.kingdee.bos.ctrl.common.digitalstyle.Formats;
import com.kingdee.bos.ctrl.common.variant.Variant;
import java.util.Locale;

public class FormatTHB
implements ICurrencyUpperFunction {
    private Format format;

    @Override
    public String format(Locale locale, Variant variant, boolean isAddPrefix) {
        String result = null;
        if (locale == Locale.ENGLISH) {
            this.format = Formats.getFormat("[ENG-THB]0.00");
        } else if (locale == Locale.SIMPLIFIED_CHINESE) {
            this.format = Formats.getFormat("[CHS-THB]0.00;[CHS-THB]0.00");
        } else if (locale == Locale.TRADITIONAL_CHINESE) {
            this.format = Formats.getFormat("[CHT-THB]0.00;[CHT-THB]0.00");
        } else {
            throw new RuntimeException("Not support language: " + locale);
        }
        result = this.format.format4Print(variant).toString();
        if (isAddPrefix && locale != Locale.ENGLISH) {
            if (locale == Locale.SIMPLIFIED_CHINESE) {
                result = "\u6cf0\u94e2" + result;
            } else if (locale == Locale.TRADITIONAL_CHINESE) {
                result = "\u6cf0\u9296" + result;
            } else {
                throw new RuntimeException("Not support language: " + locale);
            }
        }
        return result;
    }
}

