/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common.ui.formulawizard;

import com.kingdee.bos.ctrl.common.layout.table.Table;
import com.kingdee.bos.ctrl.common.layout.table.TableLayout;
import com.kingdee.bos.ctrl.common.ui.formulawizard.DefaultFormulaWizardDialog;
import com.kingdee.bos.ctrl.common.ui.formulawizard.Formula;
import com.kingdee.bos.ctrl.common.ui.formulawizard.Group;
import com.kingdee.bos.ctrl.common.ui.formulawizard.GroupEvent;
import com.kingdee.bos.ctrl.common.ui.formulawizard.GroupListener;
import com.kingdee.bos.ctrl.common.ui.formulawizard.IExtCtrl;
import com.kingdee.bos.ctrl.common.ui.formulawizard.IOwner;
import com.kingdee.bos.ctrl.common.ui.resource.ResourceManager;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDSplitPane;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;

public class FormulaWizard
extends KDPanel {
    private static final long serialVersionUID = -3351052051851140676L;
    private IOwner owner;
    private String title;
    private boolean btnVisible = true;
    private KDPanel panSupply;
    private KDPanel panResult;
    private KDPanel panExample;
    private JTextComponent txaResult;
    private KDTextArea txaExample;
    private KDScrollPane scpResultsOwner;
    private KDSplitPane spl2;
    private KDPanel panExtend;
    private ArrayList groups = new ArrayList();
    private GroupHandler groupHandler = new GroupHandler();
    private ArrayList listExts;
    private ExtListener extListener;

    public FormulaWizard() {
        this.setOpaque(false);
        this.init();
    }

    public FormulaWizard(boolean flag) {
        this.btnVisible = flag;
        this.setOpaque(false);
        this.init();
    }

    private void init() {
        this.setOwner(new DefaultFormulaWizardDialog());
        this.initPanSupply();
        this.initPanExample();
        this.initPanResult();
        KDSplitPane spl = new KDSplitPane(0);
        spl.setTopComponent((Component)this.panSupply);
        spl.setBottomComponent((Component)this.panResult);
        spl.setDividerLocation(180);
        this.spl2 = new KDSplitPane(0);
        this.spl2.setTopComponent((Component)spl);
        this.spl2.setBottomComponent((Component)this.panExample);
        this.spl2.setDividerLocation(300);
        this.setLayout(new BorderLayout());
        this.add((Component)this.spl2, "Center");
        this.txaResult.requestFocusInWindow();
    }

    public void addNotify() {
        super.addNotify();
        this.txaResult.requestFocusInWindow();
    }

    private void initPanSupply() {
        this.panSupply = new KDPanel((LayoutManager)new BorderLayout());
        this.panSupply.setOpaque(false);
    }

    private void initPanExample() {
        this.txaExample = new KDTextArea();
        this.txaExample.setEditable(false);
        this.txaExample.setTabSize(4);
        KDScrollPane scp = new KDScrollPane((Component)this.txaExample);
        TableLayout tl = TableLayout.split((int)2, (int)1);
        tl.rowStyle(0).setHeight(20);
        tl.rowStyle(0).setMarginBottom(3);
        tl.rowStyle(1).setPriY(1);
        this.panExample = new KDPanel((LayoutManager)tl);
        this.panExample.setOpaque(false);
        this.panExample.add((Component)new KDLabel(ResourceManager.getMLS("example", "\u793a\u4f8b\uff1a")), (Object)tl.cell(0));
        this.panExample.add((Component)scp, (Object)tl.cell(1));
    }

    private void initPanResult() {
        this.txaResult = new KDTextArea();
        ((KDTextArea)this.txaResult).setTabSize(4);
        ((KDTextArea)this.txaResult).setSelectAllOnFocus(false);
        this.scpResultsOwner = new KDScrollPane((Component)this.txaResult);
        this.panExtend = new KDPanel();
        TableLayout tl = TableLayout.split((int)2, (int)1);
        tl.rowStyle(0).setHeight(25);
        tl.rowStyle(0).setMarginBottom(3);
        tl.rowStyle(1).setPriY(1);
        Table row0 = tl.cell(0).split(1, 2);
        row0.colStyle(0).setWidth(120);
        row0.colStyle(1).setPriX(1);
        this.panResult = new KDPanel((LayoutManager)tl);
        this.panResult.setOpaque(false);
        this.panResult.add((Component)new KDLabel(ResourceManager.getMLS("content", "\u5185\u5bb9\uff1a")), (Object)row0.cell(0));
        this.panResult.add((Component)this.panExtend, (Object)row0.cell(1));
        this.panResult.add((Component)this.scpResultsOwner, (Object)tl.cell(1));
        if (!this.btnVisible) {
            this.panExtend.setVisible(false);
        }
    }

    public void setEditCtrl(JTextComponent ctrl) {
        this.txaResult = ctrl;
        this.scpResultsOwner.getViewport().removeAll();
        this.scpResultsOwner.getViewport().add(this.txaResult);
    }

    public void setEditCtrlHeight(int height) {
        this.spl2.setDividerLocation(200 + height);
    }

    public void setExampleShow(boolean isShow) {
        this.spl2.getComponent(0).setVisible(isShow);
        this.spl2.getBottomComponent().setVisible(isShow);
    }

    public Group getGroup(int idx) {
        return (Group)((Object)this.groups.get(idx));
    }

    public void removeSupplyGroup(Group group) {
        if (group == null) {
            return;
        }
        this.groups.remove((Object)group);
        group.removeGroupListener(this.groupHandler);
    }

    public void addSupplyGroup(Group group) {
        this.insertSupplyGroup(group, -1);
    }

    public void insertSupplyGroup(Group group, int index) {
        if (index == -1) {
            index = this.groups.size();
        }
        this.initGroup(group);
        this.groups.add(index, group);
    }

    public void validateChildren() {
        this.panSupply.removeAll();
        KDSplitPane parent = null;
        for (int i = 0; i < this.groups.size() - 1; ++i) {
            KDSplitPane splPane = new KDSplitPane();
            splPane.setBorder(BorderFactory.createEmptyBorder());
            splPane.setDividerLocation((this.getOwner().getSize().width - 20) / this.groups.size() - splPane.getDividerSize());
            splPane.setLeftComponent((Component)((Object)((Group)((Object)this.groups.get(i)))));
            if (parent == null) {
                this.panSupply.add((Component)splPane, (Object)"Center");
            } else {
                parent.setRightComponent((Component)splPane);
            }
            parent = splPane;
        }
        if (this.groups.size() > 1) {
            parent.setRightComponent((Component)((Object)((Group)((Object)this.groups.get(this.groups.size() - 1)))));
        } else {
            this.panSupply.add((Component)((Object)((Group)((Object)this.groups.get(0)))), (Object)"Center");
        }
        this.validateExtends();
    }

    private void validateExtends() {
        if (this.listExts == null) {
            return;
        }
        this.panExtend.removeAll();
        int count = this.getExts().size();
        TableLayout ly = TableLayout.splitCol((int)(count + 1));
        ly.colStyle(0).setPriX(1);
        this.panExtend.setLayout((LayoutManager)ly);
        for (int i = 0; i < count; ++i) {
            IExtCtrl ext = (IExtCtrl)this.getExts().get(i);
            JComponent ctrl = ext.getCtrl();
            int w = ctrl.getPreferredSize().width;
            ly.colStyle(i + 1).setWidth(w == 0 ? 26 : w);
            ly.colStyle(i + 1).setMarginRight(3);
            this.panExtend.add((Component)ctrl, (Object)ly.cell(i + 1));
        }
    }

    private void initGroup(Group group) {
        group.expandRoot();
        group.addGroupListener(this.groupHandler);
    }

    public boolean showWindow() {
        return this.owner.showDialog();
    }

    public void setResult(String text) {
        this.txaResult.setText(text);
    }

    public String getResult() {
        return this.txaResult.getText();
    }

    public IOwner getOwner() {
        return this.owner;
    }

    public void setOwner(IOwner owner) {
        this.owner = owner;
        owner.setWizardPane(this);
        owner.setTitle(this.getTitle());
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
        if (this.getOwner() != null) {
            this.getOwner().setTitle(title);
        }
    }

    private ArrayList getExts() {
        if (this.listExts == null) {
            this.listExts = new ArrayList();
        }
        return this.listExts;
    }

    private ExtListener getExtListener() {
        if (this.extListener == null) {
            this.extListener = new ExtListener();
        }
        return this.extListener;
    }

    public void addExt(IExtCtrl ext) {
        this.getExts().add(ext);
        ext.addEditListener(this.getExtListener());
    }

    private class ExtListener
    implements IExtCtrl.EditListener {
        private ExtListener() {
        }

        @Override
        public void startEdit(IExtCtrl.EditEvent evt) {
            IExtCtrl ext = (IExtCtrl)evt.getSource();
            if (ext.getProcessPolicy() == 16) {
                ext.setProcessString(FormulaWizard.this.getResult());
            } else if (ext.getProcessPolicy() == 32) {
                ext.setProcessString(FormulaWizard.this.txaResult.getSelectedText());
            }
        }

        @Override
        public void finishEdit(IExtCtrl.EditEvent evt) {
            IExtCtrl ext = (IExtCtrl)evt.getSource();
            if (ext.getExtResultPolicy() == 1) {
                FormulaWizard.this.setResult(ext.getExtResult());
            } else if (ext.getExtResultPolicy() == 2) {
                String rv;
                int idxStart = FormulaWizard.this.txaResult.getSelectionStart();
                int idxEnd = FormulaWizard.this.txaResult.getSelectionEnd();
                String result = FormulaWizard.this.getResult();
                StringBuffer newResult = new StringBuffer();
                if (result != null) {
                    newResult.append(result.substring(0, idxStart));
                }
                if ((rv = ext.getExtResult()) != null) {
                    newResult.append(rv);
                }
                if (result != null) {
                    newResult.append(result.substring(idxEnd));
                }
                FormulaWizard.this.setResult(newResult.toString());
                FormulaWizard.this.txaResult.setCaretPosition(idxStart);
            }
        }
    }

    private class GroupHandler
    implements GroupListener {
        private GroupHandler() {
        }

        @Override
        public void doubleClicked(GroupEvent e) {
            Formula formula = e.getFormula();
            String str = null;
            if (formula != null) {
                str = formula.getData();
            }
            if (StringUtil.isEmptyString(str)) {
                return;
            }
            FormulaWizard.this.txaResult.replaceSelection(str);
            if (formula.isMethodWithParam()) {
                int left = str.indexOf("(\"");
                if (left >= 0) {
                    int minus = str.length() - left - 2;
                    FormulaWizard.this.txaResult.setCaretPosition(FormulaWizard.this.txaResult.getCaretPosition() - minus);
                } else {
                    left = str.indexOf("(");
                    if (left >= 0) {
                        int minus = str.length() - left - 1;
                        FormulaWizard.this.txaResult.setCaretPosition(FormulaWizard.this.txaResult.getCaretPosition() - minus);
                    }
                }
            }
            FormulaWizard.this.txaResult.grabFocus();
        }

        @Override
        public void selection(GroupEvent e) {
            String str = e.getFormula() == null ? "" : e.getFormula().getExample();
            FormulaWizard.this.txaExample.setText(str);
            FormulaWizard.this.txaExample.setCaretPosition(0);
        }
    }
}

