/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common.ui.formulawizard;

import com.kingdee.bos.ctrl.common.ui.formulawizard.Formula;
import com.kingdee.bos.ctrl.common.ui.formulawizard.FormulaWizard;
import com.kingdee.bos.ctrl.common.ui.formulawizard.Group;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.StreamUtil;
import com.kingdee.bos.ctrl.common.util.xml.XmlUtil;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import java.io.Closeable;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom2.Element;

public class FormulaWizardFactory {
    private static final Logger log = LogUtil.getPackageLogger(FormulaWizardFactory.class);
    private static boolean flag = true;
    private IXmlParseListener _xmlParseListener;

    private FormulaWizardFactory() {
    }

    public FormulaWizardFactory(IXmlParseListener l) {
        this._xmlParseListener = l;
    }

    public static FormulaWizard createDefaultWizard() {
        return FormulaWizardFactory.createWizard("/com/kingdee/bos/ctrl/common/ui/formulawizard/DefaultFormulaWizard.xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FormulaWizard createWizard(String clientCfg) {
        InputStream in = null;
        try {
            in = FormulaWizard.class.getResourceAsStream(clientCfg);
            FormulaWizard formulaWizard = FormulaWizardFactory.createWizard(in);
            return formulaWizard;
        }
        catch (Exception ex) {
            log.error((Object)"Load wizard config failed!", (Throwable)ex);
            FormulaWizard formulaWizard = null;
            return formulaWizard;
        }
        finally {
            StreamUtil.closeCloseable((Closeable)in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FormulaWizard createWizard(String clientCfg, boolean f) {
        flag = f;
        InputStream in = null;
        try {
            in = FormulaWizardFactory.class.getResourceAsStream(clientCfg);
            FormulaWizard formulaWizard = FormulaWizardFactory.createWizard(in);
            return formulaWizard;
        }
        catch (Exception ex) {
            log.error((Object)"Load wizard config failed!", (Throwable)ex);
            FormulaWizard formulaWizard = null;
            return formulaWizard;
        }
        finally {
            StreamUtil.closeCloseable((Closeable)in);
        }
    }

    public static FormulaWizard createWizard(InputStream cfg) {
        try {
            return FormulaWizardFactory.createWizard(XmlUtil.loadXmlStream((InputStream)cfg));
        }
        catch (Exception ex) {
            log.error((Object)"Load wizard config failed!", (Throwable)ex);
            return null;
        }
    }

    public static FormulaWizard createWizard(Element xmlCfg) {
        FormulaWizard wizard = !flag ? new FormulaWizard(flag) : new FormulaWizard();
        FormulaWizardFactory factory = new FormulaWizardFactory();
        Group[] groups = factory.createGroups(xmlCfg);
        for (int i = 0; i < groups.length; ++i) {
            wizard.addSupplyGroup(groups[i]);
        }
        wizard.validateChildren();
        String title = xmlCfg.getAttributeValue("text");
        if (title != null) {
            wizard.setTitle(title);
        }
        return wizard;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Group[] createGroups(String clientCfg) {
        InputStream in = null;
        try {
            in = FormulaWizard.class.getResourceAsStream(clientCfg);
            Group[] groupArray = FormulaWizardFactory.createGroups(in);
            return groupArray;
        }
        catch (Exception ex) {
            log.error((Object)"Load wizard config failed!", (Throwable)ex);
            Group[] groupArray = null;
            return groupArray;
        }
        finally {
            StreamUtil.closeCloseable((Closeable)in);
        }
    }

    public static Group[] createGroups(InputStream cfg) {
        FormulaWizardFactory factory = new FormulaWizardFactory();
        return factory.createGroupsByStream(cfg);
    }

    public Group[] createGroupsByStream(InputStream cfg) {
        try {
            return this.createGroups(XmlUtil.loadXmlStream((InputStream)cfg));
        }
        catch (Exception ex) {
            log.error((Object)"Load wizard config failed!", (Throwable)ex);
            return null;
        }
    }

    private Group[] createGroups(Element root) {
        return this.parseGroupNodes(root.getChildren("Group"));
    }

    private Group[] parseGroupNodes(List groupsList) {
        Group[] groups = new Group[groupsList.size()];
        for (int i = 0; i < groupsList.size(); ++i) {
            Element nodeGroup = (Element)groupsList.get(i);
            groups[i] = new Group();
            groups[i].setTitle(nodeGroup.getAttributeValue("text"));
            if (this._xmlParseListener != null) {
                this._xmlParseListener.parseGroup(nodeGroup, groups[i]);
            }
            Iterator itNodes = nodeGroup.getChildren().iterator();
            while (itNodes.hasNext()) {
                this.parseNode(groups[i], (Element)itNodes.next(), null);
            }
        }
        return groups;
    }

    private void parseNode(Group group, Element node, DefaultKingdeeTreeNode parentTreeNode) {
        if (node.getName().equals("Node")) {
            Element nodeData = node.getChild("data");
            String data = nodeData == null ? node.getAttributeValue("data") : nodeData.getTextTrim();
            Formula formula = new Formula(data);
            formula.setTip(node.getAttributeValue("tip"));
            formula.setExample(FormulaWizardFactory.getExample(node));
            formula.setMethodWithParam("true".equals(node.getAttributeValue("withParam")));
            DefaultKingdeeTreeNode treeNode = group.addNode(parentTreeNode, node.getAttributeValue("text"), formula);
            if (this._xmlParseListener != null) {
                this._xmlParseListener.parseNode(node, treeNode);
            }
        } else if (node.getName().equals("Nodes")) {
            DefaultKingdeeTreeNode newTreeNode = group.addNode(parentTreeNode, node.getAttributeValue("text"), null);
            if (this._xmlParseListener != null) {
                this._xmlParseListener.parseNodes(node, newTreeNode);
            }
            Iterator it = node.getChildren().iterator();
            while (it.hasNext()) {
                this.parseNode(group, (Element)it.next(), newTreeNode);
            }
        }
    }

    private static String getExample(Element node) {
        Element nodeExam = node.getChild("example");
        String example = nodeExam != null ? nodeExam.getTextTrim() : "";
        return example;
    }

    public static interface IXmlParseListener {
        public void parseGroup(Element var1, Group var2);

        public void parseNodes(Element var1, DefaultKingdeeTreeNode var2);

        public void parseNode(Element var1, DefaultKingdeeTreeNode var2);
    }
}

