/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common.ui.formulawizard;

import com.kingdee.bos.ctrl.common.ui.formulawizard.Formula;
import com.kingdee.bos.ctrl.common.ui.formulawizard.GroupEvent;
import com.kingdee.bos.ctrl.common.ui.formulawizard.GroupListener;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.KDTreeView;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.ITreeNode;
import com.kingdee.bos.ctrl.swing.tree.NonIcon;
import java.awt.Dimension;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Comparator;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.UIResource;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;

public class Group
extends KDTreeView {
    private static final long serialVersionUID = -5233345405428236592L;

    public Group() {
        this.setShowButton(false);
        KDTree tree = new KDTree((ITreeNode)new DefaultKingdeeTreeNode((Object)"root"), false);
        tree.setFocusable(false);
        this.setTree(tree);
        this.getTree().setRootVisible(false);
        this.getTree().setShowsRootHandles(true);
        this.getTree().getSelectionModel().setSelectionMode(1);
        this.getTree().setDragEnabled(true);
        this.getTree().setTransferHandler((TransferHandler)new CustomTransferHandler());
        this.installListener();
    }

    private void installListener() {
        this.getTree().addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() != 2) {
                    return;
                }
                TreePath path = Group.this.getTree().getSelectionPath();
                if (path != null && path.equals(Group.this.getTree().getClosestPath(e.getX(), e.getY()))) {
                    DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
                    if (node.getChildCount() != 0) {
                        return;
                    }
                    Group.this.fireSelectionEvent(Group.this.getTree(), 0, node);
                }
            }
        });
        this.getTree().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreePath path = e.getNewLeadSelectionPath();
                if (path != null) {
                    DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
                    Group.this.fireSelectionEvent(Group.this.getTree(), 1, node);
                }
            }
        });
    }

    public DefaultKingdeeTreeNode addNode(DefaultKingdeeTreeNode parent, String text) {
        return this.addNode(parent, text, new Formula(text));
    }

    public DefaultKingdeeTreeNode addNode(DefaultKingdeeTreeNode parent, Formula userObject) {
        return this.addNode(parent, userObject.getData(), userObject);
    }

    public DefaultKingdeeTreeNode addNode(DefaultKingdeeTreeNode parent, String text, Formula userObject) {
        DefaultKingdeeTreeNode node = new DefaultKingdeeTreeNode();
        node.setCustomIcon((Icon)NonIcon.getInstance());
        node.setText(text == null ? userObject.getData() : text);
        node.setUserObject((Object)userObject);
        this.getTree().addNodeInto((MutableTreeNode)node, (MutableTreeNode)(parent == null ? this.getRoot() : parent));
        return node;
    }

    public void removeAllChildren(DefaultKingdeeTreeNode parent) {
        this.getTree().removeAllChildrenFromParent((MutableTreeNode)parent);
    }

    public void removeNodeFromParent(DefaultKingdeeTreeNode node) {
        this.getTree().removeNodeFromParent((MutableTreeNode)node);
    }

    public DefaultKingdeeTreeNode getRoot() {
        return (DefaultKingdeeTreeNode)this.getTree().getModel().getRoot();
    }

    public void expandRoot() {
        this.getTree().expandPath(new TreePath(this.getRoot().getPath()));
    }

    public Dimension getMinimumSize() {
        return new Dimension(0, 0);
    }

    public Dimension getPreferredSize() {
        return new Dimension(1200, 0);
    }

    public void addGroupListener(GroupListener l) {
        this.listenerList.add(GroupListener.class, l);
    }

    public void removeGroupListener(GroupListener l) {
        this.listenerList.remove(GroupListener.class, l);
    }

    protected void fireSelectionEvent(Object source, int funcCode, Formula formula) {
        this.fireSelectionEvent(source, funcCode, null, formula);
    }

    private void fireSelectionEvent(Object source, int funcCode, DefaultKingdeeTreeNode node) {
        this.fireSelectionEvent(source, funcCode, node.getText(), (Formula)node.getUserObject());
    }

    private void fireSelectionEvent(Object source, int funcCode, String text, Formula formula) {
        Object[] listeners = this.listenerList.getListenerList();
        GroupEvent event = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != GroupListener.class) continue;
            if (event == null) {
                event = new GroupEvent(source, formula);
                event.setText(text);
            }
            if (funcCode == 0) {
                ((GroupListener)listeners[i + 1]).doubleClicked(event);
                continue;
            }
            ((GroupListener)listeners[i + 1]).selection(event);
        }
    }

    private class CustomTransferHandler
    extends TransferHandler
    implements UIResource,
    Comparator {
        private static final long serialVersionUID = 3647252035822107475L;
        private JTree tree;

        private CustomTransferHandler() {
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            this.tree = (JTree)c;
            TreePath path = this.tree.getSelectionPath();
            if (path == null) {
                return null;
            }
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
            if (!(node.getUserObject() instanceof Formula)) {
                return null;
            }
            StringBuffer sb = new StringBuffer();
            sb.append(((Formula)node.getUserObject()).getData());
            return new StringSelection(sb.toString());
        }

        public int compare(Object o1, Object o2) {
            int row1 = this.tree.getRowForPath((TreePath)o1);
            int row2 = this.tree.getRowForPath((TreePath)o2);
            return row1 - row2;
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 1;
        }
    }
}

