/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common.ui.restree;

import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.common.restype.def.ActionDef;
import com.kingdee.bos.ctrl.common.restype.def.ActionExecutorDef;
import com.kingdee.bos.ctrl.common.restype.spi.IResActionHandler;
import com.kingdee.bos.ctrl.common.restype.spi.IResObject;
import com.kingdee.bos.ctrl.common.ui.restree.ResObjectNode;
import com.kingdee.bos.ctrl.common.ui.tree.ATreeAction;
import com.kingdee.bos.ctrl.common.ui.tree.ATreeController;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class ResNodeAction
extends ATreeAction {
    public static final Logger log = LogUtil.getPackageLogger(ResNodeAction.class);
    private ActionDef actionDef;
    private ResObjectNode resNode;

    public static String getDisplayName(ActionDef actionDef) {
        String display = LanguageManager.getProperty((HashMap)actionDef.getProperties(), (String)"display-label");
        if (display == null) {
            display = actionDef.getName();
        }
        return display;
    }

    public ResNodeAction(ATreeController treeCtrl, ActionDef actionDef, ResObjectNode resNode) {
        super((Object)ResNodeAction.getDisplayName(actionDef), treeCtrl);
        this.actionDef = actionDef;
        this.resNode = resNode;
        String tooltips = LanguageManager.getProperty((HashMap)actionDef.getProperties(), (String)"tooltip-label");
        if (!StringUtil.isEmptyString((String)tooltips)) {
            this.putValue("ShortDescription", tooltips);
        }
    }

    @Override
    public final boolean isVisible(TreePath[] paths) {
        return this.actionDef.isEnable();
    }

    public ActionDef getActionDef() {
        return this.actionDef;
    }

    @Override
    public void doAction(ActionEvent e) throws Exception {
        ActionDef actionDef = this.getActionDef();
        if (actionDef.getActionExecutorDef() == null) {
            throw new UnsupportedOperationException("\u672a\u6307\u660e\u8be5\u4e8b\u4ef6\u7684\u5b9e\u73b0\u7c7b\u6216\u811a\u672c\u4ee3\u7801");
        }
        IResActionHandler handler = ResNodeAction.createResActionHandler(actionDef);
        handler.handle(actionDef, (IResObject)this.resNode, (Object)e, true);
    }

    @Override
    public String getTitle() {
        String s = super.getTitle();
        if (StringUtil.isEmptyString((String)s)) {
            s = (String)this.getValue("ShortDescription");
        }
        return s;
    }

    public static IResActionHandler createResActionHandler(ActionDef actionDef) throws Exception {
        ActionExecutorDef nExecutor = actionDef.getActionExecutorDef();
        if (StringUtil.isEmptyString((String)nExecutor.getJavaClassName())) {
            throw new UnsupportedOperationException("\u6682\u4e0d\u63d0\u4f9b\u6b64\u529f\u80fd\uff08\u672a\u6307\u5b9a\u5b9e\u73b0\u7c7b\uff09");
        }
        Class<?> cls = nExecutor.getJavaClass();
        if (cls == null) {
            cls = Class.forName(nExecutor.getJavaClassName());
            nExecutor.setJavaClass(cls);
        }
        return (IResActionHandler)cls.newInstance();
    }

    public String toString() {
        return "action_name:" + this.actionDef.getName() + ",action_class" + this.actionDef.getActionExecutorDef();
    }
}

