/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.util;

import com.kingdee.bos.ctrl.kdf.expr.Variant;
import com.kingdee.bos.ctrl.kdf.formatter.FormatException;
import com.kingdee.bos.ctrl.kdf.formatter.FormatType;
import com.kingdee.bos.ctrl.kdf.formatter.Formatter;
import com.kingdee.bos.ctrl.kdf.formatter.StringFormatter;
import com.kingdee.bos.ctrl.kdf.util.render.layout.SureTextLine;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.KeyEvent;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.List;

public final class Tools {
    public static final int HASH_ROOT_SEED = 7;

    public static String htmlDecode(String source) {
        source = source.replaceAll("&lt;", "<");
        source = source.replaceAll("&gt;", ">");
        source = source.replaceAll("&quot;", "\"");
        source = source.replaceAll("&euro;", "?");
        source = source.replaceAll("&amp;", "&");
        return source;
    }

    public static Dimension getTextAreaSize(String source, Style style, FontRenderContext frc) {
        SureTextLine stl = new SureTextLine(source, (Font)style.getKDFont(), frc);
        return new Dimension((int)(stl.getAdvance() * 254.0 / 72.0), (int)(stl.getHeight() * 254.0 / 72.0));
    }

    public static Color parseColor(String strColor) {
        Color color = null;
        try {
            String strR = strColor.substring(1, 3);
            String strG = strColor.substring(3, 5);
            String strB = strColor.substring(5, 7);
            color = new Color(Integer.parseInt(strR, 16), Integer.parseInt(strG, 16), Integer.parseInt(strB, 16));
        }
        catch (Exception err) {
            throw new IllegalArgumentException("\u8f93\u5165\u7684\u989c\u8272\u8868\u8fbe\u5f0f\u4e0d\u5408\u6cd5\uff0c\u6b63\u786e\u683c\u5f0f\u5982\uff1a#00ff99");
        }
        return color;
    }

    public static String creatColorHexString(Color color) {
        StringBuffer buf = new StringBuffer("#");
        String red = Integer.toHexString(color.getRed());
        String green = Integer.toHexString(color.getGreen());
        String blue = Integer.toHexString(color.getBlue());
        if (red.length() == 1) {
            buf.append("0");
        }
        buf.append(red);
        if (green.length() == 1) {
            buf.append("0");
        }
        buf.append(green);
        if (blue.length() == 1) {
            buf.append("0");
        }
        buf.append(blue);
        return buf.toString();
    }

    public static String xmlEncode(String source) {
        source = source.replaceAll("&", "&amp;");
        source = source.replaceAll("<", "&lt;");
        source = source.replaceAll(">", "&gt;");
        source = source.replaceAll("\"", "&quot;");
        return source;
    }

    public static String xmlDecode(String source) {
        source = source.replaceAll("&lt;", "<");
        source = source.replaceAll("&gt;", ">");
        source = source.replaceAll("&quot;", "\"");
        source = source.replaceAll("&amp;", "&");
        return source;
    }

    public static double mmToPx(double mmValue) {
        return mmValue * 72.0 / 25.4;
    }

    public static double pxToMm(double pxValue) {
        return pxValue * 25.4 / 72.0;
    }

    public static Rectangle2D.Double mmAreaToPxArea(Rectangle2D area) {
        Rectangle2D.Double rect = new Rectangle2D.Double(Tools.mmToPx(area.getMinX()), Tools.mmToPx(area.getMinY()), Tools.mmToPx(area.getWidth()), Tools.mmToPx(area.getHeight()));
        return rect;
    }

    public static int hashCalculate(int[] seeds) {
        int result = 7;
        for (int i = 0; i < seeds.length; ++i) {
            result = 2 * result + seeds[i];
        }
        return result;
    }

    public static void debugOutLine(String s) {
        System.out.println(s);
    }

    public static String getCharacterFromIndex(int index) {
        StringBuffer sb = new StringBuffer();
        sb.append((char)(65 + index % 26));
        index /= 26;
        while (index > 0) {
            int deal = index % 26 - 1;
            if (deal < 0) {
                index += deal;
                deal += 26;
            }
            sb.append((char)(65 + deal));
            index /= 26;
        }
        sb.reverse();
        return sb.toString();
    }

    public static String getCharacterFromIndex(int index, char beginChar) {
        StringBuffer sb = new StringBuffer();
        sb.append((char)(beginChar + index % 26));
        index /= 26;
        while (index > 0) {
            int deal = index % 26 - 1;
            if (deal < 0) {
                index += deal;
                deal += 26;
            }
            sb.append((char)(beginChar + deal));
            index /= 26;
        }
        sb.reverse();
        return sb.toString();
    }

    public static void addUniqueElement(List list, Object element) {
        Iterator it = list.iterator();
        boolean unique = true;
        while (it.hasNext()) {
            Object obj = it.next();
            if (!obj.equals(element)) continue;
            unique = false;
            break;
        }
        if (unique) {
            list.add(element);
        }
    }

    public static boolean isVisibleChar(KeyEvent anEvent) {
        if (anEvent == null || anEvent.isAltDown() || anEvent.isControlDown()) {
            return false;
        }
        char keyChar = anEvent.getKeyChar();
        return keyChar >= ' ' && keyChar <= '~';
    }

    public static final boolean equalsObject(Object obj, Object obj2) {
        if (null == obj) {
            return null == obj2;
        }
        return obj.equals(obj2);
    }

    public static String format(String nFormat, Object data) {
        if (nFormat != null && !nFormat.equals("")) {
            if (nFormat.startsWith("%")) {
                try {
                    Formatter fmt = new Formatter(FormatType.paserFormatType((String)nFormat));
                    return fmt.format(new Variant(data));
                }
                catch (FormatException e) {
                    return null;
                }
            }
            if (Tools.startWith(nFormat, "$LOWERCASE", 10)) {
                String cf;
                String[] cfs = nFormat.split("\\.");
                int m = 0;
                int s = 0;
                int l = 0;
                if (cfs.length > 1 && Tools.isInteger(cf = cfs[1])) {
                    m = 1;
                    s = Integer.parseInt(cf);
                    if (cfs.length > 2 && Tools.isInteger(cf = cfs[2])) {
                        m = 2;
                        l = Integer.parseInt(cf);
                    }
                }
                switch (m) {
                    case 0: {
                        return StringFormatter.toLowerCase((String)new Variant(data).toString());
                    }
                    case 1: {
                        return StringFormatter.toLowerCase((String)new Variant(data).toString(), (int)s);
                    }
                    case 2: {
                        return StringFormatter.toLowerCase((String)new Variant(data).toString(), (int)s, (int)l);
                    }
                }
            } else if (Tools.startWith(nFormat, "$UPPERCASE", 10)) {
                String cf;
                String[] cfs = nFormat.split("\\.");
                int m = 0;
                int s = 0;
                int l = 0;
                if (cfs.length > 1 && Tools.isInteger(cf = cfs[1])) {
                    m = 1;
                    s = Integer.parseInt(cf);
                    if (cfs.length > 2 && Tools.isInteger(cf = cfs[2])) {
                        m = 2;
                        l = Integer.parseInt(cf);
                    }
                }
                switch (m) {
                    case 0: {
                        return StringFormatter.toUpperCase((String)new Variant(data).toString());
                    }
                    case 1: {
                        return StringFormatter.toUpperCase((String)new Variant(data).toString(), (int)s);
                    }
                    case 2: {
                        return StringFormatter.toUpperCase((String)new Variant(data).toString(), (int)s, (int)l);
                    }
                }
            } else {
                if (Tools.startWith(nFormat, "$PLURAL", 7)) {
                    return StringFormatter.toPlural((String)new Variant(data).toString());
                }
                if (Tools.startWith(nFormat, "$LOWERCHSNUM", 12)) {
                    return StringFormatter.toSChineseLowerNumber((String)new Variant(data).toString());
                }
                if (Tools.startWith(nFormat, "$UPPERCHSNUM", 12)) {
                    return StringFormatter.toSChineseUpperNumber((String)new Variant(data).toString());
                }
                if (Tools.startWith(nFormat, "$LOWERCHTNUM", 12)) {
                    return StringFormatter.toTChineseLowerNumber((String)new Variant(data).toString());
                }
                if (Tools.startWith(nFormat, "$UPPERCHTNUM", 12)) {
                    return StringFormatter.toTChineseUpperNumber((String)new Variant(data).toString());
                }
            }
        }
        return null;
    }

    public static boolean startWith(String src, String des, int len) {
        if (len > src.length()) {
            return false;
        }
        return src.substring(0, len).equalsIgnoreCase(des);
    }

    public static boolean isInteger(String str) {
        try {
            Integer.parseInt(str);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

