/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.util.render;

import com.kingdee.bos.ctrl.kdf.util.render.layout.CommonLayout;
import com.kingdee.bos.ctrl.kdf.util.render.layout.ICellLayout;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.text.AttributedString;

public class TextDetail {
    private AttributedString text;
    private String source;
    private ICellLayout layouter;
    private Style cellStyle;

    public void draw(Graphics2D g2d, Shape clip) {
        if (this.text != null || this.source != null && this.source.length() > 0) {
            this.getLayouter().draw(g2d, clip, this);
            this.layouter = null;
        }
    }

    public TextDetail() {
        this.text = null;
        this.cellStyle = null;
    }

    public TextDetail(AttributedString text, Style cellStyle) {
        this.text = text;
        this.cellStyle = cellStyle;
    }

    public TextDetail(String source, Style cellStyle) {
        this.source = source;
        this.cellStyle = cellStyle;
    }

    public Styles.HorizontalAlignment getHAlign() {
        return this.cellStyle.getHorizontalAlign();
    }

    public int getRotate() {
        return this.cellStyle.getRotation();
    }

    public Styles.VerticalAlignment getVAlign() {
        return this.cellStyle.getVerticalAlign();
    }

    public boolean isAutoShrink() {
        return this.cellStyle.isShrinkText();
    }

    public boolean isAutoWrap() {
        return this.cellStyle.isWrapText();
    }

    public AttributedString getText() {
        return this.text;
    }

    public ICellLayout getLayouter() {
        if (this.layouter == null) {
            this.layouter = new CommonLayout();
        }
        return this.layouter;
    }

    public void setLayouter(ICellLayout layouter) {
        this.layouter = layouter;
    }

    public float getLineSpace() {
        return this.cellStyle.getLinespacing();
    }

    public Style getCellStyle() {
        return this.cellStyle;
    }

    public void setCellStyle(Style style) {
        this.cellStyle = style;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String string) {
        this.source = string;
        this.text = null;
    }

    public void setText(AttributedString string) {
        this.text = string;
        this.source = null;
    }
}

