/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.util.render.splitrectangle;

import com.kingdee.bos.ctrl.common.CtrlUIEnv;
import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.kdf.util.render.splitrectangle.AbstractTableSplitRectInfo;
import com.kingdee.bos.ctrl.kdf.util.render.splitrectangle.ISplitRectInfo;
import com.kingdee.bos.ctrl.kdf.util.render.splitrectangle.SplitRectTextRender;
import com.kingdee.bos.ctrl.kdf.util.render.splitrectangle.TriangleInfo;
import com.kingdee.bos.ctrl.kdf.util.style.LineStyle;
import com.kingdee.bos.ctrl.kdf.util.style.PenStyle;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.kdf.util.style.styledesigner.FontPane;
import com.kingdee.bos.ctrl.kdf.util.style.styledesigner.LazyStyleDesigner;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDComboColor;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class TableSplitRectDesigner
extends KDDialog {
    private static final Composite COMPOSITE = AlphaComposite.getInstance(3, 0.2f);
    private static LazyStyleDesigner sd;
    private TableSplitDesignerPanel _panel;
    private KDTextField _editField;
    private KDComboBox _cnerSelector;
    private KDCheckBox _zoomBtn;
    private KDCheckBox _leanBtn;
    private KDCheckBox _drawBackBtn;
    private KDWorkButton _styleBtn;
    private KDButton _okBtn;
    private KDButton _escBtn;
    private boolean _changed;
    private boolean _isSync;
    private KDComboColor _boxColor;

    public TableSplitRectDesigner() {
        this.initComponents();
    }

    public TableSplitRectDesigner(Frame parent) {
        this(parent, true);
    }

    public TableSplitRectDesigner(Dialog parent) {
        this(parent, true);
    }

    public TableSplitRectDesigner(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    public TableSplitRectDesigner(Dialog parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    public void setInfo(DesignerInfo info) {
        this._panel.setInfo(info);
        this.syncComponents();
    }

    public DesignerInfo getInfo() {
        if (this._changed) {
            return this._panel.getInfo();
        }
        return null;
    }

    private void initComponents() {
        this.setResizable(false);
        this.setSize(640, 480);
        KDSeparator separator = new KDSeparator();
        this.initOkCancel();
        KDPanel panRender = this.createRenderPanel();
        KDPanel panType = this.createTypePanel();
        KDPanel panAttrs = this.createAttrsPanel();
        KDLabel labRender = new KDLabel(TableSplitRectDesigner.getLocaleLanguage("diagonalSplit", "\u659c\u7ebf\u5207\u5206\uff1a"));
        Container ctn = this.getContentPane();
        ctn.setLayout(null);
        ctn.add((Component)panType);
        ctn.add((Component)labRender);
        ctn.add((Component)panRender);
        ctn.add((Component)panAttrs);
        ctn.add((Component)separator);
        ctn.add((Component)this._okBtn);
        ctn.add((Component)this._escBtn);
        panType.setBounds(10, 10, 200, 30);
        labRender.setBounds(10, 40, 320, 20);
        panRender.setBounds(10, 60, 320, 320);
        panAttrs.setBounds(340, 64, 284, 180);
        separator.setBounds(0, 410, 640, 2);
        this._okBtn.setBounds(456, 420, 80, 21);
        this._escBtn.setBounds(540, 420, 80, 21);
    }

    private KDPanel createRenderPanel() {
        this._panel = new TableSplitDesignerPanel();
        this._panel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                DesignerInfo info = TableSplitRectDesigner.this._panel.getInfo();
                if (info != null) {
                    TableSplitRectDesigner.this.commitValue();
                    boolean b = TableSplitRectDesigner.this.pressOnPoint(e.getPoint());
                    if (!b) {
                        b = TableSplitRectDesigner.this.pressOnTriangle(e.getPoint());
                    }
                    if (b) {
                        TableSplitRectDesigner.this.syncComponents();
                    }
                }
            }
        });
        return this._panel;
    }

    private KDPanel createTypePanel() {
        this._cnerSelector = new KDComboBox();
        this._cnerSelector.setFocusable(false);
        this._cnerSelector.addItems((Object[])new String[]{TableSplitRectDesigner.getLocaleLanguage("upleft", "\u5de6\u4e0a"), TableSplitRectDesigner.getLocaleLanguage("upright", "\u53f3\u4e0a"), TableSplitRectDesigner.getLocaleLanguage("bottomleft", "\u5de6\u4e0b"), TableSplitRectDesigner.getLocaleLanguage("bottomright", "\u53f3\u4e0b")});
        this._cnerSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DesignerInfo info = TableSplitRectDesigner.this._panel.getInfo();
                if (!TableSplitRectDesigner.this._isSync && info != null) {
                    KDComboBox cb = (KDComboBox)e.getSource();
                    int index = cb.getSelectedIndex();
                    Integer pos = null;
                    pos = index == 0 ? ISplitRectInfo.RELATE_TO_UPLEFT : (index == 1 ? ISplitRectInfo.RELATE_TO_UPRIGHT : (index == 2 ? ISplitRectInfo.RELATE_TO_DOWNLEFT : ISplitRectInfo.RELATE_TO_DOWNRIGHT));
                    int rows = info._row2 - info._row + 1;
                    int cols = info._col2 - info._col + 1;
                    int[] rOffs = new int[rows - 1];
                    Arrays.fill(rOffs, 1);
                    int[] cOffs = new int[cols - 1];
                    Arrays.fill(cOffs, 1);
                    info.setSplitInfo(pos, rOffs, cOffs);
                    TableSplitRectDesigner.this.syncComponents();
                }
            }
        });
        this._cnerSelector.setSelectedIndex(0);
        this._cnerSelector.setEditable(false);
        this._cnerSelector.setLimitedSize(false);
        String label = TableSplitRectDesigner.getLocaleLanguage("basePoint", "\u57fa\u70b9\u4f4d\u7f6e");
        KDLabelContainer lbc = CtrlSwingUtilities.createLabelContainer((JComponent)this._cnerSelector, (String)label, (int)80);
        lbc.setBounds(0, 0, 200, 20);
        KDPanel pan = new KDPanel(null);
        pan.add((Component)lbc);
        return pan;
    }

    private KDPanel createAttrsPanel() {
        this._editField = new KDTextField();
        this._editField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DesignerInfo info = TableSplitRectDesigner.this._panel.getInfo();
                int index = TableSplitRectDesigner.this._panel.getIndex();
                if (!TableSplitRectDesigner.this._isSync && info != null && index >= 0 && index < info.size()) {
                    TableSplitRectDesigner.this.commitValue();
                    if (++index == info.size()) {
                        index = 0;
                    }
                    TableSplitRectDesigner.this._panel.setIndex(index);
                    TableSplitRectDesigner.this.syncComponents();
                }
            }
        });
        this._drawBackBtn = new KDCheckBox(TableSplitRectDesigner.getLocaleLanguage("background", "\u80cc\u666f"));
        this._drawBackBtn.setFocusable(false);
        this._drawBackBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DesignerInfo info = TableSplitRectDesigner.this._panel.getInfo();
                if (!TableSplitRectDesigner.this._isSync && info != null) {
                    TableSplitRectDesigner.this.commitValue();
                    boolean b = info.getTriangleInfo(TableSplitRectDesigner.this._panel.getIndex()).isDrawBackground();
                    if (b != TableSplitRectDesigner.this._drawBackBtn.isSelected()) {
                        info.setDrawBackground(TableSplitRectDesigner.this._drawBackBtn.isSelected(), TableSplitRectDesigner.this._panel.getIndex());
                    }
                    TableSplitRectDesigner.this.syncComponents();
                }
            }
        });
        this._zoomBtn = new KDCheckBox(TableSplitRectDesigner.getLocaleLanguage("scale", "\u7f29\u653e"));
        this._zoomBtn.setFocusable(false);
        this._zoomBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DesignerInfo info = TableSplitRectDesigner.this._panel.getInfo();
                if (!TableSplitRectDesigner.this._isSync && info != null) {
                    TableSplitRectDesigner.this.commitValue();
                    boolean b = info.getTriangleInfo(TableSplitRectDesigner.this._panel.getIndex()).isAutoZoom();
                    if (b != TableSplitRectDesigner.this._zoomBtn.isSelected()) {
                        info.setAutoZoom(TableSplitRectDesigner.this._zoomBtn.isSelected(), TableSplitRectDesigner.this._panel.getIndex());
                    }
                    TableSplitRectDesigner.this.syncComponents();
                }
            }
        });
        this._leanBtn = new KDCheckBox(TableSplitRectDesigner.getLocaleLanguage("dip", "\u503e\u659c"));
        this._leanBtn.setFocusable(false);
        this._leanBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DesignerInfo info = TableSplitRectDesigner.this._panel.getInfo();
                if (!TableSplitRectDesigner.this._isSync && info != null) {
                    TableSplitRectDesigner.this.commitValue();
                    boolean b = info.getTriangleInfo(TableSplitRectDesigner.this._panel.getIndex()).isLean();
                    if (b != TableSplitRectDesigner.this._leanBtn.isSelected()) {
                        info.setLean(TableSplitRectDesigner.this._leanBtn.isSelected(), TableSplitRectDesigner.this._panel.getIndex());
                    }
                    TableSplitRectDesigner.this.syncComponents();
                }
            }
        });
        this._styleBtn = new KDWorkButton(TableSplitRectDesigner.getLocaleLanguage("format", "\u683c\u5f0f"));
        this._styleBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DesignerInfo _info = TableSplitRectDesigner.this._panel.getInfo();
                int index = TableSplitRectDesigner.this._panel.getIndex();
                LazyStyleDesigner sd = TableSplitRectDesigner.this.getStyleDesigner();
                Style style = _info.getTriangleInfo(index).getStyle();
                if (style == null) {
                    style = Styles.getDefaultStyle();
                }
                sd.setSA(Styles.getSA(style));
                if (sd.showDialog()) {
                    _info.getTriangleInfo(index).setStyle(Styles.getStyle(sd.getSA()));
                    TableSplitRectDesigner.this.repaint();
                    TableSplitRectDesigner.this._editField.requestFocus();
                }
            }
        });
        int labelWidth = 60;
        this._boxColor = new KDComboColor();
        KDLabelContainer boxCon = new KDLabelContainer((JComponent)this._boxColor);
        boxCon.setBoundLabelText(TableSplitRectDesigner.getLocaleLanguage("slantcolor", "\u659c\u7ebf\u989c\u8272"));
        boxCon.setBoundLabelUnderline(true);
        boxCon.setBoundLabelLength(labelWidth);
        this._boxColor.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                int index;
                DesignerInfo info = TableSplitRectDesigner.this._panel.getInfo();
                Style style = info.getTriangleInfo(index = TableSplitRectDesigner.this._panel.getIndex()).getStyle();
                if (style == null) {
                    style = Styles.getDefaultStyle();
                }
                StyleAttributes sa = Styles.getSA(style);
                sa.setBorderLineStyle(Styles.Position.LEFT, LineStyle.SINGLE_LINE);
                sa.setBorderPenStyle(Styles.Position.LEFT, PenStyle.PS_SOLID);
                sa.setBorderColor(Styles.Position.LEFT, (Color)eventObj.getNewValue());
                info.getTriangleInfo(index).setStyle(Styles.getStyle(sa));
                TableSplitRectDesigner.this.repaint();
            }
        });
        KDLabelContainer lbcText = CtrlSwingUtilities.createLabelContainer((JComponent)this._editField, (String)TableSplitRectDesigner.getLocaleLanguage("titleText", "\u6587\u5b57"), (int)labelWidth);
        KDPanel pan = new KDPanel(null);
        pan.setBorder((Border)BorderFactory.createTitledBorder(TableSplitRectDesigner.getLocaleLanguage("selectedAttributes", "\u9009\u4e2d\u533a\u57df\u5c5e\u6027")));
        pan.add((Component)boxCon);
        pan.add((Component)lbcText);
        pan.add((Component)this._drawBackBtn);
        pan.add((Component)this._zoomBtn);
        pan.add((Component)this._leanBtn);
        pan.add((Component)this._styleBtn);
        lbcText.setBounds(10, 24, 260, 20);
        boxCon.setBounds(10, 48, 260, 20);
        this._drawBackBtn.setBounds(10, 72, 120, 20);
        this._zoomBtn.setBounds(10, 96, 120, 20);
        this._leanBtn.setBounds(10, 120, 120, 20);
        this._styleBtn.setBounds(10, 144, 60, 20);
        return pan;
    }

    private void initOkCancel() {
        this._okBtn = new KDButton(TableSplitRectDesigner.getLocaleLanguage("confirm", "\u786e\u5b9a"));
        this._okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableSplitRectDesigner.this.commitValue();
                TableSplitRectDesigner.this.setVisible(false);
                TableSplitRectDesigner.this.dispose();
                TableSplitRectDesigner.this._changed = true;
            }
        });
        this._escBtn = new KDButton(TableSplitRectDesigner.getLocaleLanguage("cancel", "\u53d6\u6d88"));
        this._escBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableSplitRectDesigner.this.setVisible(false);
                TableSplitRectDesigner.this.dispose();
                TableSplitRectDesigner.this._changed = false;
            }
        });
    }

    private void commitValue() {
        DesignerInfo info = this._panel.getInfo();
        int index = this._panel.getIndex();
        info.getTriangleInfo(index).setText(this._editField.getText());
    }

    private LazyStyleDesigner getStyleDesigner() {
        if (null == sd) {
            Window w = SwingUtilities.getWindowAncestor((Component)((Object)this));
            sd = w instanceof Dialog ? new LazyStyleDesigner((Dialog)w) : (w instanceof Frame ? new LazyStyleDesigner((Frame)w) : new LazyStyleDesigner((Frame)null));
            sd.setPanels(new String[]{"font", "interior"});
            FontPane fp = (FontPane)sd.getPanel("font");
            fp.setEnableStrikethrought(false);
            fp.setEnableUnderline(false);
            sd.setTitle(TableSplitRectDesigner.getLocaleLanguage("format", "\u683c\u5f0f"));
            sd.setLocationRelativeTo((Component)((Object)this));
        }
        return sd;
    }

    private void resetIndex(int at, boolean bInsert) {
        if (bInsert) {
            if (at <= this._panel.getIndex()) {
                this._panel.setIndex(this._panel.getIndex() + 1);
            }
        } else if (at < this._panel.getIndex()) {
            this._panel.setIndex(this._panel.getIndex() - 1);
        }
    }

    private boolean pressOnPoint(Point p) {
        Shape[] ptShapes = this._panel.getPtShapes();
        DesignerInfo info = this._panel.getInfo();
        int size = ptShapes.length;
        int pi = -1;
        for (int i = 0; i < size; ++i) {
            if (!ptShapes[i].contains(p)) continue;
            pi = i;
            break;
        }
        if (pi >= 0) {
            int rows = info._row2 - info._row + 1;
            int cols = info._col2 - info._col + 1;
            Integer pos = info._relatePos;
            int x2 = cols;
            int x3 = rows + cols;
            int x4 = rows + cols * 2;
            if (pos == ISplitRectInfo.RELATE_TO_UPLEFT) {
                if (pi > x2 && pi < x3) {
                    int osize = info.size();
                    int at = info.actionRow(pi - x2);
                    int nsize = info.size();
                    this.resetIndex(at, nsize > osize);
                    return true;
                }
                if (pi > x3 && pi < x4) {
                    int osize = info.size();
                    int at = info.actionCol(x4 - pi);
                    int nsize = info.size();
                    this.resetIndex(at, nsize > osize);
                    return true;
                }
            } else if (pos == ISplitRectInfo.RELATE_TO_UPRIGHT) {
                if (pi > x4) {
                    int osize = info.size();
                    int at = info.actionRow(size - pi);
                    int nsize = info.size();
                    this.resetIndex(at, nsize > osize);
                    return true;
                }
                if (pi > x3 && pi < x4) {
                    int osize = info.size();
                    int at = info.actionCol(x4 - pi);
                    int nsize = info.size();
                    this.resetIndex(at, nsize > osize);
                    return true;
                }
            } else if (pos == ISplitRectInfo.RELATE_TO_DOWNRIGHT) {
                if (pi < x2) {
                    int osize = info.size();
                    int at = info.actionCol(pi);
                    int nsize = info.size();
                    this.resetIndex(at, nsize > osize);
                    return true;
                }
                if (pi > x4) {
                    int osize = info.size();
                    int at = info.actionRow(size - pi);
                    int nsize = info.size();
                    this.resetIndex(at, nsize > osize);
                    return true;
                }
            } else {
                if (pi < x2) {
                    int osize = info.size();
                    int at = info.actionCol(pi);
                    int nsize = info.size();
                    this.resetIndex(at, nsize > osize);
                    return true;
                }
                if (pi > x2 && pi < x3) {
                    int osize = info.size();
                    int at = info.actionRow(pi - x2);
                    int nsize = info.size();
                    this.resetIndex(at, nsize > osize);
                    return true;
                }
            }
        }
        return false;
    }

    private boolean pressOnTriangle(Point p) {
        DesignerInfo info = this._panel.getInfo();
        int index = info.contains(p);
        if (index >= 0) {
            this._panel.setIndex(index);
            return true;
        }
        return false;
    }

    private void syncComponents() {
        int index = this._panel.getIndex();
        DesignerInfo info = this._panel.getInfo();
        if (info != null) {
            if (index < 0) {
                index = 0;
            } else if (index >= info.size()) {
                index = info.size() - 1;
            }
            this._isSync = true;
            TriangleInfo ti = info.getTriangleInfo(index);
            this._editField.setText(ti.getText());
            this._editField.selectAll();
            this._cnerSelector.setSelectedIndex(info.getPosition().intValue());
            this._zoomBtn.setSelected(ti.isAutoZoom());
            this._leanBtn.setSelected(ti.isLean());
            this._drawBackBtn.setSelected(ti.isDrawBackground());
            if (this._boxColor != null && ti.getStyle() != null) {
                this._boxColor.setColor(ti.getStyle().getBorderColor(Styles.Position.LEFT));
            }
            this._isSync = false;
            this.repaint();
        }
        this._editField.requestFocus();
    }

    public static String getLocaleLanguage(String key, String defaultValue) {
        return LanguageManager.getLangMessage((String)key, TableSplitRectDesigner.class, (String)defaultValue);
    }

    public static void main(String[] args) {
        Locale.setDefault(Locale.TRADITIONAL_CHINESE);
        CtrlUIEnv.setKingdeeLAF();
        DesignerInfo info = new DesignerInfo();
        info.setRowCol(0, 0, 6, 3);
        info.setSplitInfo(ISplitRectInfo.RELATE_TO_UPLEFT, new int[]{1, 2}, new int[]{1, 1});
        for (int i = 0; i < info.size(); ++i) {
            info.setText(String.valueOf(i), i);
        }
        info.setText("sdfafdagg", 0);
        info.setLean(true, 0);
        TableSplitRectDesigner dg = new TableSplitRectDesigner();
        dg.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        dg.setInfo(info);
        dg.setVisible(true);
    }

    public static final class DesignerInfo
    extends AbstractTableSplitRectInfo {
        int actionRow(int rowOff) {
            int i;
            TriangleInfo[] tInfos;
            int size;
            Integer pos;
            int[] rowOffs;
            int temp = 0;
            for (int i2 = 0; i2 < this._rowOffs.length; ++i2) {
                temp += this._rowOffs[i2];
            }
            int rOff = rowOff - temp;
            int at = this._rowOffs.length;
            boolean bInsert = true;
            temp = 0;
            for (int i3 = 0; i3 < this._rowOffs.length; ++i3) {
                if ((temp += this._rowOffs[i3]) == rowOff) {
                    at = i3;
                    bInsert = false;
                    rOff = this._rowOffs[i3];
                    break;
                }
                if (temp <= rowOff) continue;
                at = i3;
                rOff = rowOff - temp + this._rowOffs[i3];
                break;
            }
            if (bInsert) {
                rowOffs = new int[this._rowOffs.length + 1];
                System.arraycopy(this._rowOffs, 0, rowOffs, 0, at);
                System.arraycopy(this._rowOffs, at, rowOffs, at + 1, this._rowOffs.length - at);
                rowOffs[at] = rOff;
                if (at < rowOffs.length - 1) {
                    int n = at + 1;
                    rowOffs[n] = rowOffs[n] - rOff;
                }
            } else {
                rowOffs = new int[this._rowOffs.length - 1];
                System.arraycopy(this._rowOffs, 0, rowOffs, 0, at);
                System.arraycopy(this._rowOffs, at + 1, rowOffs, at, this._rowOffs.length - at - 1);
                if (at < rowOffs.length) {
                    int n = at;
                    rowOffs[n] = rowOffs[n] + rOff;
                }
            }
            int tat = RELATE_TO_UPLEFT.equals(pos = this._relatePos) ? at : (RELATE_TO_UPRIGHT.equals(pos) ? this.size() - 2 - at : (RELATE_TO_DOWNRIGHT.equals(pos) ? this._ySplitNum - at : this._xSplitNum + 1 + at));
            if (bInsert) {
                size = this.size();
                tInfos = new TriangleInfo[size + 1];
                for (i = 0; i < tat; ++i) {
                    tInfos[i] = new TriangleInfo();
                    tInfos[i].copyFrom(this.getTriangleInfo(i), true);
                }
                for (i = tat; i < size; ++i) {
                    tInfos[i + 1] = new TriangleInfo();
                    tInfos[i + 1].copyFrom(this.getTriangleInfo(i), true);
                }
                tInfos[tat] = new TriangleInfo();
            } else {
                size = this.size();
                tInfos = new TriangleInfo[size - 1];
                for (i = 0; i < tat; ++i) {
                    tInfos[i] = new TriangleInfo();
                    tInfos[i].copyFrom(this.getTriangleInfo(i), true);
                }
                for (i = tat; i < size - 1; ++i) {
                    tInfos[i] = new TriangleInfo();
                    tInfos[i].copyFrom(this.getTriangleInfo(i + 1), true);
                }
            }
            this.setSplitInfo(pos, rowOffs, this._colOffs);
            size = this.size();
            for (i = 0; i < size; ++i) {
                this.setAutoZoom(tInfos[i].isAutoZoom(), i);
                this.setDrawBackground(tInfos[i].isDrawBackground(), i);
                this.setLean(tInfos[i].isLean(), i);
                this.setText(tInfos[i].getText(), i);
                this.setStyle(tInfos[i].getStyle(), i);
            }
            return at;
        }

        int actionCol(int colOff) {
            int i;
            TriangleInfo[] tInfos;
            int size;
            Integer pos;
            int[] colOffs;
            int temp = 0;
            for (int i2 = 0; i2 < this._colOffs.length; ++i2) {
                temp += this._colOffs[i2];
            }
            int cOff = colOff - temp;
            int at = this._colOffs.length;
            boolean bInsert = true;
            temp = 0;
            for (int i3 = 0; i3 < this._colOffs.length; ++i3) {
                if ((temp += this._colOffs[i3]) == colOff) {
                    at = i3;
                    bInsert = false;
                    cOff = this._colOffs[i3];
                    break;
                }
                if (temp <= colOff) continue;
                at = i3;
                cOff = colOff - temp + this._colOffs[i3];
                break;
            }
            if (bInsert) {
                colOffs = new int[this._colOffs.length + 1];
                System.arraycopy(this._colOffs, 0, colOffs, 0, at);
                System.arraycopy(this._colOffs, at, colOffs, at + 1, this._colOffs.length - at);
                colOffs[at] = cOff;
                if (at < colOffs.length - 1) {
                    int n = at + 1;
                    colOffs[n] = colOffs[n] - cOff;
                }
            } else {
                colOffs = new int[this._colOffs.length - 1];
                System.arraycopy(this._colOffs, 0, colOffs, 0, at);
                System.arraycopy(this._colOffs, at + 1, colOffs, at, this._colOffs.length - at - 1);
                if (at < colOffs.length) {
                    int n = at;
                    colOffs[n] = colOffs[n] + cOff;
                }
            }
            int tat = RELATE_TO_UPLEFT.equals(pos = this._relatePos) ? this.size() - 1 - at : (RELATE_TO_UPRIGHT.equals(pos) ? this._xSplitNum - at : (RELATE_TO_DOWNRIGHT.equals(pos) ? this._ySplitNum + at + 1 : at));
            if (bInsert) {
                size = this.size();
                tInfos = new TriangleInfo[size + 1];
                for (i = 0; i < tat; ++i) {
                    tInfos[i] = new TriangleInfo();
                    tInfos[i].copyFrom(this.getTriangleInfo(i), true);
                }
                for (i = tat; i < size; ++i) {
                    tInfos[i + 1] = new TriangleInfo();
                    tInfos[i + 1].copyFrom(this.getTriangleInfo(i), true);
                }
                tInfos[tat] = new TriangleInfo();
            } else {
                size = this.size();
                tInfos = new TriangleInfo[size - 1];
                for (i = 0; i < tat; ++i) {
                    tInfos[i] = new TriangleInfo();
                    tInfos[i].copyFrom(this.getTriangleInfo(i), true);
                }
                for (i = tat; i < size - 1; ++i) {
                    tInfos[i] = new TriangleInfo();
                    tInfos[i].copyFrom(this.getTriangleInfo(i + 1), true);
                }
            }
            this.setSplitInfo(pos, this._rowOffs, colOffs);
            size = this.size();
            for (i = 0; i < size; ++i) {
                this.setAutoZoom(tInfos[i].isAutoZoom(), i);
                this.setDrawBackground(tInfos[i].isDrawBackground(), i);
                this.setLean(tInfos[i].isLean(), i);
                this.setText(tInfos[i].getText(), i);
                this.setStyle(tInfos[i].getStyle(), i);
            }
            return at;
        }

        @Override
        public void setSplitInfo(Integer relatePos, int[] rOffs, int[] cOffs) {
            super.setSplitInfo(relatePos, rOffs, cOffs);
            this._xOffs = null;
            this._yOffs = null;
        }

        @Override
        public double[] getXSplitOffs() {
            if (this._xOffs == null) {
                this._xOffs = new double[this._xSplitNum];
                double x = 300.0 / (double)(this._col2 - this._col + 1);
                for (int i = 0; i < this._xSplitNum; ++i) {
                    this._xOffs[i] = (double)this._colOffs[i] * x;
                }
            }
            return this._xOffs;
        }

        @Override
        public double[] getYSplitOffs() {
            if (this._yOffs == null) {
                this._yOffs = new double[this._ySplitNum];
                double y = 300.0 / (double)(this._row2 - this._row + 1);
                for (int i = 0; i < this._ySplitNum; ++i) {
                    this._yOffs[i] = (double)this._rowOffs[i] * y;
                }
            }
            return this._yOffs;
        }
    }

    static class TableSplitDesignerPanel
    extends KDPanel {
        private static final long serialVersionUID = 1L;
        private static final Rectangle SPLITRECT = new Rectangle(10, 10, 300, 300);
        private Shape[] _ptShapes;
        private DesignerInfo _info;
        private int _index;
        private SplitRectTextRender _render = new SplitRectTextRender();

        public TableSplitDesignerPanel(DesignerInfo curRectInfo) {
            this.setInfo(curRectInfo);
        }

        public TableSplitDesignerPanel() {
        }

        public void setInfo(DesignerInfo info) {
            this._info = info;
            this._index = 0;
            if (this._info != null) {
                this.syncPoints();
            }
        }

        public DesignerInfo getInfo() {
            return this._info;
        }

        public Shape[] getPtShapes() {
            return this._ptShapes;
        }

        public int getIndex() {
            return this._index;
        }

        public void setIndex(int index) {
            this._index = index;
        }

        private void syncPoints() {
            int i;
            int x = TableSplitDesignerPanel.SPLITRECT.x;
            int y = TableSplitDesignerPanel.SPLITRECT.y;
            int w = TableSplitDesignerPanel.SPLITRECT.width;
            int h = TableSplitDesignerPanel.SPLITRECT.height;
            int rows = this._info._row2 - this._info._row + 1;
            int cols = this._info._col2 - this._info._col + 1;
            this._ptShapes = new Shape[rows * 2 + cols * 2];
            int x1 = 0;
            int x2 = cols;
            int x3 = rows + cols;
            int x4 = rows + cols * 2;
            this._ptShapes[x1] = this.creatLittleShape(x, y);
            this._ptShapes[x2] = this.creatLittleShape(x + w - 1, y);
            this._ptShapes[x3] = this.creatLittleShape(x + w - 1, y + h - 1);
            this._ptShapes[x4] = this.creatLittleShape(x, y + h - 1);
            int dx = w / cols;
            int dy = h / rows;
            int tx = dx;
            int ty = dy;
            for (i = x1 + 1; i < x2; ++i) {
                this._ptShapes[i] = this.creatLittleShape(x + tx, y);
                tx += dx;
            }
            for (i = x2 + 1; i < x3; ++i) {
                this._ptShapes[i] = this.creatLittleShape(x + w - 1, y + ty);
                ty += dy;
            }
            tx = dx;
            for (i = x3 + 1; i < x4; ++i) {
                this._ptShapes[i] = this.creatLittleShape(x + w - 1 - tx, y + h - 1);
                tx += dx;
            }
            ty = dy;
            for (i = x4 + 1; i < rows * 2 + cols * 2; ++i) {
                this._ptShapes[i] = this.creatLittleShape(x, y + h - 1 - ty);
                ty += dy;
            }
        }

        private Shape creatLittleShape(int x, int y) {
            return new Rectangle2D.Double(x - 4, y - 4, 9.0, 9.0);
        }

        public void paint(Graphics g) {
            super.paint(g);
            if (this._info != null) {
                int i;
                this._render.draw(g, SPLITRECT, this._info, Styles.getDefaultStyle());
                Graphics2D g2d = (Graphics2D)g;
                g2d.setColor(Color.black);
                g2d.draw(SPLITRECT);
                int rows = this._info._row2 - this._info._row + 1;
                int cols = this._info._col2 - this._info._col + 1;
                int p1 = 0;
                int p2 = cols;
                int p3 = rows + cols;
                int p4 = rows + cols * 2;
                g2d.setColor(Color.white);
                for (i = p1 + 1; i < p2; ++i) {
                    g2d.fill(this._ptShapes[i]);
                }
                for (i = p2 + 1; i < p3; ++i) {
                    g2d.fill(this._ptShapes[i]);
                }
                for (i = p3 + 1; i < p4; ++i) {
                    g2d.fill(this._ptShapes[i]);
                }
                for (i = p4 + 1; i < 2 * (rows + cols); ++i) {
                    g2d.fill(this._ptShapes[i]);
                }
                g2d.setColor(Color.black);
                for (i = p1 + 1; i < p2; ++i) {
                    g2d.draw(this._ptShapes[i]);
                }
                for (i = p2 + 1; i < p3; ++i) {
                    g2d.draw(this._ptShapes[i]);
                }
                for (i = p3 + 1; i < p4; ++i) {
                    g2d.draw(this._ptShapes[i]);
                }
                for (i = p4 + 1; i < 2 * (rows + cols); ++i) {
                    g2d.draw(this._ptShapes[i]);
                }
                Integer pos = this._info.getPosition();
                int i2 = p1;
                if (pos == ISplitRectInfo.RELATE_TO_UPRIGHT) {
                    i2 = p2;
                }
                if (pos == ISplitRectInfo.RELATE_TO_DOWNRIGHT) {
                    i2 = p3;
                }
                if (pos == ISplitRectInfo.RELATE_TO_DOWNLEFT) {
                    i2 = p4;
                }
                g2d.setColor(Color.black);
                g2d.fill(this._ptShapes[i2]);
                g2d.draw(this._ptShapes[i2]);
                if (this._index >= 0 && this._index < this._info.size()) {
                    g2d.setColor(Color.blue);
                    g2d.setComposite(COMPOSITE);
                    g2d.fill(this._info.getTriangleInfo(this._index).getAwtShape());
                }
            }
        }
    }
}

