/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.util.style;

import com.kingdee.bos.ctrl.common.digitalstyle.AdapterFormat;
import com.kingdee.bos.ctrl.common.digitalstyle.Formats;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;

public class I18nStyleAttributes
extends StyleAttributes {
    private boolean i18nDisabled;
    private boolean localized;

    public I18nStyleAttributes(ShareStyleAttributes ssa, boolean i18nEnabled) {
        super(ssa);
        this.i18nDisabled = !i18nEnabled;
    }

    @Override
    public void setNumberFormat(String fmt) {
        boolean flag = fmt == null ? false : fmt.startsWith("&");
        if (this.i18nDisabled) {
            if (flag) {
                return;
            }
            super.setNumberFormat(fmt);
        } else if (flag) {
            super.setNumberFormat(this.getGlobalFormat(fmt));
            this.localized = true;
        } else if (!this.localized) {
            super.setNumberFormat(fmt);
        }
    }

    private String getGlobalFormat(String fmt) {
        if (fmt != null) {
            if (fmt.equals("&int")) {
                fmt = CtrlFormatUtilities.getIntegerFormatString();
                if (StringUtil.isEmptyString((String)fmt)) {
                    DecimalFormat format = (DecimalFormat)CtrlFormatUtilities.getDecimalFormat();
                    if (format == null) {
                        format = CtrlFormatUtilities.getDisplayNumberFormat();
                    }
                    if (format != null) {
                        format = (DecimalFormat)format.clone();
                        format.setMaximumFractionDigits(0);
                        format.setDecimalSeparatorAlwaysShown(false);
                        format.setParseIntegerOnly(true);
                        fmt = format.toPattern();
                    } else {
                        format = (DecimalFormat)NumberFormat.getIntegerInstance();
                        fmt = format.toPattern();
                    }
                }
            } else if (fmt.equals("&double")) {
                fmt = CtrlFormatUtilities.getDecimalFormatString();
                if (StringUtil.isEmptyString((String)fmt)) {
                    DecimalFormat format = (DecimalFormat)CtrlFormatUtilities.getDecimalFormat();
                    if (format == null) {
                        format = CtrlFormatUtilities.getDisplayNumberFormat();
                    }
                    if (format != null) {
                        fmt = format.toPattern();
                    } else {
                        format = (DecimalFormat)NumberFormat.getNumberInstance();
                        fmt = format.toPattern();
                    }
                }
            } else if (fmt.equals("&currency")) {
                fmt = CtrlFormatUtilities.getCurrencyFormatString();
                if (StringUtil.isEmptyString((String)fmt)) {
                    DecimalFormat format = (DecimalFormat)CtrlFormatUtilities.getCurrencyFormat();
                    if (format != null) {
                        fmt = format.toPattern();
                    } else {
                        format = (DecimalFormat)NumberFormat.getCurrencyInstance();
                        fmt = format.toPattern();
                    }
                }
            } else if (fmt.equals("&date")) {
                fmt = CtrlFormatUtilities.getDateFormatString();
                if (StringUtil.isEmptyString((String)fmt)) {
                    SimpleDateFormat format = (SimpleDateFormat)CtrlFormatUtilities.getDateFormat();
                    if (format != null) {
                        fmt = format.toPattern();
                    } else {
                        format = (SimpleDateFormat)DateFormat.getDateInstance();
                        fmt = format.toPattern();
                    }
                }
            } else if (fmt.equals("&time")) {
                fmt = CtrlFormatUtilities.getTimeFormatString();
                if (StringUtil.isEmptyString((String)fmt)) {
                    SimpleDateFormat format = (SimpleDateFormat)CtrlFormatUtilities.getTimeFormat();
                    if (format != null) {
                        fmt = format.toPattern();
                    } else {
                        format = (SimpleDateFormat)DateFormat.getTimeInstance();
                        fmt = format.toPattern();
                    }
                }
            } else if (fmt.equals("&datetime") && StringUtil.isEmptyString((String)(fmt = CtrlFormatUtilities.getDateTimeFormatString()))) {
                SimpleDateFormat format = (SimpleDateFormat)CtrlFormatUtilities.getDateTimeFormat();
                if (format != null) {
                    fmt = format.toPattern();
                } else {
                    format = (SimpleDateFormat)DateFormat.getDateTimeInstance();
                    fmt = format.toPattern();
                }
            }
        }
        return fmt;
    }

    static {
        Format format;
        String fmt = CtrlFormatUtilities.getIntegerFormatString();
        if (StringUtil.isEmptyString((String)fmt)) {
            format = (DecimalFormat)CtrlFormatUtilities.getDecimalFormat();
            if (format == null) {
                format = CtrlFormatUtilities.getDisplayNumberFormat();
            }
            if (format != null) {
                format = (DecimalFormat)((DecimalFormat)format).clone();
                ((DecimalFormat)format).setMaximumFractionDigits(0);
                ((DecimalFormat)format).setDecimalSeparatorAlwaysShown(false);
                ((NumberFormat)format).setParseIntegerOnly(true);
                fmt = ((DecimalFormat)format).toPattern();
            } else {
                format = (DecimalFormat)NumberFormat.getIntegerInstance();
                fmt = ((DecimalFormat)format).toPattern();
            }
            if (!(Formats.getFormat(fmt) instanceof AdapterFormat)) {
                Formats.addFormat(fmt, new AdapterFormat(format));
            }
        }
        if (StringUtil.isEmptyString((String)(fmt = CtrlFormatUtilities.getDecimalFormatString()))) {
            format = (DecimalFormat)CtrlFormatUtilities.getDecimalFormat();
            if (format == null) {
                format = CtrlFormatUtilities.getDisplayNumberFormat();
            }
            if (format != null) {
                fmt = ((DecimalFormat)format).toPattern();
            } else {
                format = (DecimalFormat)NumberFormat.getNumberInstance();
                fmt = ((DecimalFormat)format).toPattern();
            }
            if (!(Formats.getFormat(fmt) instanceof AdapterFormat)) {
                Formats.addFormat(fmt, new AdapterFormat(format));
            }
        }
        if (StringUtil.isEmptyString((String)(fmt = CtrlFormatUtilities.getCurrencyFormatString()))) {
            format = (DecimalFormat)CtrlFormatUtilities.getCurrencyFormat();
            if (format != null) {
                fmt = ((DecimalFormat)format).toPattern();
            } else {
                format = (DecimalFormat)NumberFormat.getCurrencyInstance();
                fmt = ((DecimalFormat)format).toPattern();
            }
            if (!(Formats.getFormat(fmt) instanceof AdapterFormat)) {
                Formats.addFormat(fmt, new AdapterFormat(format));
            }
        }
        if (StringUtil.isEmptyString((String)(fmt = CtrlFormatUtilities.getDateFormatString()))) {
            format = (SimpleDateFormat)CtrlFormatUtilities.getDateFormat();
            if (format != null) {
                fmt = ((SimpleDateFormat)format).toPattern();
            } else {
                format = (SimpleDateFormat)DateFormat.getDateInstance();
                fmt = ((SimpleDateFormat)format).toPattern();
            }
            if (!(Formats.getFormat(fmt) instanceof AdapterFormat)) {
                Formats.addFormat(fmt, new AdapterFormat(format));
            }
        }
        if (StringUtil.isEmptyString((String)(fmt = CtrlFormatUtilities.getTimeFormatString()))) {
            format = (SimpleDateFormat)CtrlFormatUtilities.getTimeFormat();
            if (format != null) {
                fmt = ((SimpleDateFormat)format).toPattern();
            } else {
                format = (SimpleDateFormat)DateFormat.getTimeInstance();
                fmt = ((SimpleDateFormat)format).toPattern();
            }
            if (!(Formats.getFormat(fmt) instanceof AdapterFormat)) {
                Formats.addFormat(fmt, new AdapterFormat(format));
            }
        }
        if (StringUtil.isEmptyString((String)(fmt = CtrlFormatUtilities.getDateTimeFormatString()))) {
            format = (SimpleDateFormat)CtrlFormatUtilities.getDateTimeFormat();
            if (format != null) {
                fmt = ((SimpleDateFormat)format).toPattern();
            } else {
                format = (SimpleDateFormat)DateFormat.getDateTimeInstance();
                fmt = ((SimpleDateFormat)format).toPattern();
            }
            if (!(Formats.getFormat(fmt) instanceof AdapterFormat)) {
                Formats.addFormat(fmt, new AdapterFormat(format));
            }
        }
    }
}

