/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.util.style;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.util.style.LineStyle;
import com.kingdee.bos.ctrl.kdf.util.style.Pattern;
import com.kingdee.bos.ctrl.kdf.util.style.PenStyle;
import com.kingdee.bos.ctrl.kdf.util.style.Rect;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import java.awt.Color;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.xpath.XPath;

public class StyleParser {
    private static final int Filter_V0 = 0;
    private static final int Filter_V1 = 1;
    private static final HashMap _filters = new HashMap();
    private static final HashMap _colors;

    private StyleParser() {
    }

    public static void writeStyles(Element eleStyles, Namespace ns, Iterator iterStyles) {
        eleStyles.setAttribute("version", "1.0");
        HashMap customPenStyles = new HashMap();
        while (iterStyles.hasNext()) {
            Map.Entry e = (Map.Entry)iterStyles.next();
            ShareStyleAttributes ssa = (ShareStyleAttributes)e.getValue();
            String id = e.getKey().toString();
            Element eleStyle = StyleParser.getStyleElement(ssa, id, ns);
            eleStyles.addContent((Content)eleStyle);
            if (!ssa.hasBordersAttributes()) continue;
            StyleParser.getCustomPenStyle(customPenStyles, ssa, Styles.Position.LEFT);
            StyleParser.getCustomPenStyle(customPenStyles, ssa, Styles.Position.TOP);
            StyleParser.getCustomPenStyle(customPenStyles, ssa, Styles.Position.RIGHT);
            StyleParser.getCustomPenStyle(customPenStyles, ssa, Styles.Position.BOTTOM);
            StyleParser.getCustomPenStyle(customPenStyles, ssa, Styles.Position.DIAGONALLEFT);
            StyleParser.getCustomPenStyle(customPenStyles, ssa, Styles.Position.DIAGONALRIGHT);
        }
        StyleParser.writeCustomPenStyle(eleStyles, ns, customPenStyles);
    }

    private static void getCustomPenStyle(HashMap customPenStyles, ShareStyleAttributes ssa, Styles.Position pos) {
        PenStyle ps = ssa.getBorderPenStyle(pos);
        if (ps != null && !ps.isSystem()) {
            customPenStyles.put(ps.getName(), ps);
        }
    }

    public static String colorToHex(Color color) {
        StringBuffer sb = new StringBuffer("#");
        String str = Integer.toHexString(color.getRed());
        if (str.length() < 2) {
            sb.append("0");
        }
        sb.append(str);
        str = Integer.toHexString(color.getGreen());
        if (str.length() < 2) {
            sb.append("0");
        }
        sb.append(str);
        str = Integer.toHexString(color.getBlue());
        if (str.length() < 2) {
            sb.append("0");
        }
        sb.append(str);
        if (color.getAlpha() != 255) {
            str = Integer.toHexString(color.getAlpha());
            if (str.length() < 2) {
                sb.append("0");
            }
            sb.append(str);
        }
        return sb.toString();
    }

    public static Element getStyleElement(ShareStyleAttributes ssa, String ssaName, Namespace ns) {
        String numberFormat;
        Element eleStyle = new Element("Style", ns);
        eleStyle.setAttribute("id", ssaName);
        StyleParser.writeXML_Font(ssa, eleStyle, ns);
        StyleParser.writeXML_Borders(ssa, eleStyle, ns);
        StyleParser.writeXML_Interior(ssa, eleStyle, ns);
        StyleParser.writeXML_Alignment(ssa, eleStyle, ns);
        StyleParser.writeXML_Protection(ssa, eleStyle, ns);
        if (ssa.hasAttributes(ShareStyleAttributes.NUMBER_FORMAT) && !StringUtil.isEmptyString((String)(numberFormat = ssa.getNumberFormat()))) {
            Element eleNF = new Element("NumberFormat", ns);
            eleStyle.addContent((Content)eleNF);
            eleNF.setText(numberFormat);
        }
        return eleStyle;
    }

    static void writeXML_Font(ShareStyleAttributes ssa, Element eleStyle, Namespace ns) {
        if (ssa.hasFontAttributes()) {
            Element eleFont = new Element("Font", ns);
            eleStyle.addContent((Content)eleFont);
            StyleParser.setXMLAttribute(ssa, ShareStyleAttributes.FONT_NAME, "fontName", eleFont);
            StyleParser.setXMLAttribute(ssa, ShareStyleAttributes.FONT_SIZE, "size", eleFont);
            StyleParser.setXMLColorAttribute(ssa, ShareStyleAttributes.FONT_COLOR, "color", eleFont);
            StyleParser.setXMLAttribute(ssa, ShareStyleAttributes.FONT_BOLD, "bold", eleFont);
            StyleParser.setXMLAttribute(ssa, ShareStyleAttributes.FONT_UNDERLINE, "underline", eleFont);
            StyleParser.setXMLAttribute(ssa, ShareStyleAttributes.FONT_ITALIC, "italic", eleFont);
            StyleParser.setXMLAttribute(ssa, ShareStyleAttributes.FONT_STRIKETHROUGH, "strikethrough", eleFont);
            StyleParser.setXMLAttribute(ssa, ShareStyleAttributes.FONT_WEIGHT, "weight", eleFont);
        }
    }

    static void writeXML_Border(ShareStyleAttributes ssa, Styles.Position pos, Element eleBorders, Namespace ns) {
        if (!ssa.hasBorderAttributes(pos)) {
            return;
        }
        Element eleBorder = new Element("Border", ns);
        eleBorders.addContent((Content)eleBorder);
        eleBorder.setAttribute("position", pos.getName());
        StyleParser.setXMLAttribute(ssa, ShareStyleAttributes.getBorderLineStyleIndex(pos), "lineStyle", eleBorder);
        LineStyle ls = ssa.getBorderLineStyle(pos);
        if (ls != LineStyle.NULL_LINE) {
            StyleParser.setXMLAttribute(ssa, ShareStyleAttributes.getBorderPenStyleIndex(pos), "penStyle", eleBorder);
            StyleParser.setXMLColorAttribute(ssa, ShareStyleAttributes.getBorderColorIndex(pos), "color", eleBorder);
        }
    }

    static void writeXML_Borders(ShareStyleAttributes ssa, Element eleStyle, Namespace ns) {
        if (!ssa.hasBordersAttributes()) {
            return;
        }
        Element eleBorders = new Element("Borders", ns);
        eleStyle.addContent((Content)eleBorders);
        StyleParser.writeXML_Border(ssa, Styles.Position.LEFT, eleBorders, ns);
        StyleParser.writeXML_Border(ssa, Styles.Position.TOP, eleBorders, ns);
        StyleParser.writeXML_Border(ssa, Styles.Position.RIGHT, eleBorders, ns);
        StyleParser.writeXML_Border(ssa, Styles.Position.BOTTOM, eleBorders, ns);
        StyleParser.writeXML_Border(ssa, Styles.Position.DIAGONALLEFT, eleBorders, ns);
        StyleParser.writeXML_Border(ssa, Styles.Position.DIAGONALRIGHT, eleBorders, ns);
    }

    static void writeXML_Interior(ShareStyleAttributes ssa, Element eleStyle, Namespace ns) {
        if (ssa.hasInteriorAttributes()) {
            Element eleInt = new Element("Interior", ns);
            eleStyle.addContent((Content)eleInt);
            StyleParser.setXMLColorAttribute(ssa, ShareStyleAttributes.BACKGROUND_COLOR, "color", eleInt);
            StyleParser.setXMLAttribute(ssa, ShareStyleAttributes.PATTERN, "pattern", eleInt);
            StyleParser.setXMLColorAttribute(ssa, ShareStyleAttributes.PATTERN_COLOR, "patternColor", eleInt);
        }
    }

    static void writeXML_Alignment(ShareStyleAttributes ssa, Element eleStyle, Namespace ns) {
        if (ssa.hasAlignmentAttributes()) {
            Element eleAlignment = new Element("Alignment", ns);
            eleStyle.addContent((Content)eleAlignment);
            StyleParser.setXMLAttribute(ssa, ShareStyleAttributes.HORIZONTAL_ALIGN, "horizontal", eleAlignment);
            StyleParser.setXMLAttribute(ssa, ShareStyleAttributes.VERTICAL_ALIGN, "vertical", eleAlignment);
            StyleParser.setXMLAttribute(ssa, ShareStyleAttributes.WRAP_TEXT, "wrapText", eleAlignment);
            StyleParser.setXMLAttribute(ssa, ShareStyleAttributes.ROTATION, "rotate", eleAlignment);
            StyleParser.setXMLAttribute(ssa, ShareStyleAttributes.SHRINK_TEXT, "shrink", eleAlignment);
            StyleParser.setXMLAttribute(ssa, ShareStyleAttributes.LINE_SPACING, "lineSpace", eleAlignment);
            StyleParser.setXMLAttribute(ssa, ShareStyleAttributes.PADDING, "padding", eleAlignment);
            StyleParser.setXMLAttribute(ssa, ShareStyleAttributes.AUTO_CLIP, "clip", eleAlignment);
        }
    }

    static void writeXML_Protection(ShareStyleAttributes ssa, Element eleStyle, Namespace ns) {
        if (ssa.hasProtectionAttributes()) {
            Element eleProtection = new Element("Protection", ns);
            eleStyle.addContent((Content)eleProtection);
            StyleParser.setXMLAttribute(ssa, ShareStyleAttributes.PROTECTION_HIDDED, "hidden", eleProtection);
            StyleParser.setXMLAttribute(ssa, ShareStyleAttributes.PROTECTION_LOCKED, "locked", eleProtection);
        }
    }

    static void setXMLAttribute(ShareStyleAttributes ssa, int index, String key, Element ele) {
        if (ssa.hasAttributes(index)) {
            Object obj = ssa.get(index);
            ele.setAttribute(key, obj.toString());
        }
    }

    static void setXMLColorAttribute(ShareStyleAttributes ssa, int index, String key, Element ele) {
        if (ssa.hasAttributes(index)) {
            Object obj = ssa.get(index);
            ele.setAttribute(key, StyleParser.colorToHex((Color)obj));
        }
    }

    public static void writeCustomPenStyle(Element eleStyles, Namespace ns, HashMap customPenStyles) {
        Iterator i = customPenStyles.entrySet().iterator();
        if (!i.hasNext()) {
            return;
        }
        Element penStyles = new Element("PenStyles", ns);
        eleStyles.addContent((Content)penStyles);
        while (i.hasNext()) {
            Map.Entry e = i.next();
            PenStyle ps = (PenStyle)e.getValue();
            Element penStyle = new Element("PenStyle", ns);
            penStyle.setAttribute("name", ps.getName());
            penStyle.setAttribute("dash", ps.getDashString());
            penStyles.addContent((Content)penStyle);
        }
    }

    public static StyleAttributes parseDefSA(Element eleStyle) {
        StyleAttributes sa = Styles.getDefaultSA();
        Namespace ns = eleStyle.getNamespace();
        try {
            String str;
            Element eleChild = eleStyle.getChild("Borders", ns);
            if (eleChild != null) {
                Iterator i = eleChild.getChildren("Border", ns).iterator();
                while (i.hasNext()) {
                    StyleParser.parseBorder((Element)i.next(), sa, ns);
                }
            }
            if ((eleChild = eleStyle.getChild("Font", ns)) != null) {
                StyleParser.parseFont(eleChild, sa, ns);
            }
            if ((eleChild = eleStyle.getChild("Protection", ns)) != null) {
                StyleParser.parseProtection(eleChild, sa, ns);
            }
            if ((eleChild = eleStyle.getChild("Interior", ns)) != null) {
                StyleParser.parseInterior(eleChild, sa, ns);
            }
            if ((eleChild = eleStyle.getChild("Alignment", ns)) != null) {
                StyleParser.parseAlignment(eleChild, sa, ns);
            }
            if ((eleChild = eleStyle.getChild("NumberFormat", ns)) != null && (str = eleChild.getText()) != null) {
                sa.setNumberFormat(str);
            }
        }
        catch (Exception err) {
            throw new RuntimeException("\u89e3\u6790Style\u9519\u8bef\uff1a", err);
        }
        return sa;
    }

    public static StyleAttributes parseSA(Element eleStyle) {
        StyleAttributes sa = Styles.getEmptySA();
        Namespace ns = eleStyle.getNamespace();
        try {
            String str;
            Element eleChild = eleStyle.getChild("Borders", ns);
            if (eleChild != null) {
                Iterator i = eleChild.getChildren("Border", ns).iterator();
                while (i.hasNext()) {
                    StyleParser.parseBorder((Element)i.next(), sa, ns);
                }
            }
            if ((eleChild = eleStyle.getChild("Font", ns)) != null) {
                StyleParser.parseFont(eleChild, sa, ns);
            }
            if ((eleChild = eleStyle.getChild("Protection", ns)) != null) {
                StyleParser.parseProtection(eleChild, sa, ns);
            }
            if ((eleChild = eleStyle.getChild("Interior", ns)) != null) {
                StyleParser.parseInterior(eleChild, sa, ns);
            }
            if ((eleChild = eleStyle.getChild("Alignment", ns)) != null) {
                StyleParser.parseAlignment(eleChild, sa, ns);
            }
            if ((eleChild = eleStyle.getChild("NumberFormat", ns)) != null && (str = eleChild.getText()) != null) {
                sa.setNumberFormat(str);
            }
        }
        catch (Exception err) {
            throw new RuntimeException("\u89e3\u6790Style\u9519\u8bef\uff1a", err);
        }
        return sa;
    }

    static void parseBorder(Element eleBorder, StyleAttributes sa, Namespace ns) {
        Styles.Position pos = Styles.Position.parse(eleBorder.getAttributeValue("position"));
        String value = eleBorder.getAttributeValue("color");
        if (value != null) {
            sa.setBorderColor(pos, StyleParser.stringToColor(value));
        }
        if ((value = eleBorder.getAttributeValue("penStyle")) != null) {
            sa.setBorderPenStyle(pos, PenStyle.getPenStyle(value));
        }
        if ((value = eleBorder.getAttributeValue("lineStyle")) != null) {
            sa.setBorderLineStyle(pos, LineStyle.getLineStyle(value));
        }
    }

    static void parseFont(Element eleFont, StyleAttributes sa, Namespace ns) {
        String value = eleFont.getAttributeValue("fontName");
        if (value != null) {
            sa.setFontName(value);
        }
        if ((value = eleFont.getAttributeValue("size")) != null) {
            sa.setFontSize(Integer.parseInt(value));
        }
        if ((value = eleFont.getAttributeValue("color")) != null) {
            sa.setFontColor(StyleParser.stringToColor(value));
        }
        if ((value = eleFont.getAttributeValue("bold")) != null) {
            sa.setBold(Boolean.valueOf(value));
        }
        if ((value = eleFont.getAttributeValue("italic")) != null) {
            sa.setItalic(Boolean.valueOf(value));
        }
        if ((value = eleFont.getAttributeValue("strikethrough")) != null) {
            sa.setStrikeThrough(Boolean.valueOf(value));
        }
        if ((value = eleFont.getAttributeValue("underline")) != null) {
            sa.setUnderline(Boolean.valueOf(value));
        }
        if ((value = eleFont.getAttributeValue("weight")) != null) {
            sa.setWeight(Float.parseFloat(value));
        }
    }

    static void parseProtection(Element eleProtection, StyleAttributes sa, Namespace ns) {
        String value = eleProtection.getAttributeValue("locked");
        if (value != null) {
            sa.setLocked(Boolean.valueOf(value));
        }
        if ((value = eleProtection.getAttributeValue("hidden")) != null) {
            sa.setHided(Boolean.valueOf(value));
        }
    }

    static void parseInterior(Element eleInterior, StyleAttributes sa, Namespace ns) {
        String value = eleInterior.getAttributeValue("color");
        if (value != null) {
            sa.setBackground(StyleParser.stringToColor(value));
        }
        if ((value = eleInterior.getAttributeValue("pattern")) != null) {
            sa.setPattern(Pattern.getPattern(value));
        }
        if ((value = eleInterior.getAttributeValue("patternColor")) != null) {
            sa.setPatternColor(StyleParser.stringToColor(value));
        }
    }

    static void parseAlignment(Element eleAlign, StyleAttributes sa, Namespace ns) {
        String value = eleAlign.getAttributeValue("rotate");
        if (value != null) {
            sa.setRotation(Integer.parseInt(value));
        }
        if ((value = eleAlign.getAttributeValue("horizontal")) != null) {
            sa.setHorizontalAlign(Styles.HorizontalAlignment.getAlignment(value));
        }
        if ((value = eleAlign.getAttributeValue("vertical")) != null) {
            sa.setVerticalAlign(Styles.VerticalAlignment.getAlignment(value));
        }
        if ((value = eleAlign.getAttributeValue("lineSpace")) != null) {
            sa.setLinespacing(Float.parseFloat(value));
        }
        if ((value = eleAlign.getAttributeValue("wrapText")) != null) {
            sa.setWrapText(Boolean.valueOf(value));
        }
        if ((value = eleAlign.getAttributeValue("shrink")) != null) {
            sa.setShrinkText(Boolean.valueOf(value));
        }
        if ((value = eleAlign.getAttributeValue("padding")) != null) {
            sa.setPadding(Rect.valueOf(value));
        }
        if ((value = eleAlign.getAttributeValue("clip")) != null) {
            sa.setClip(Boolean.valueOf(value));
        }
    }

    public static Color stringToColor(String str) {
        Object obj;
        Color color = null;
        color = str.length() == 0 ? Color.black : (str.startsWith("rgb(") ? StyleParser.parseRGB(str) : (str.charAt(0) == '#' ? StyleParser.hexToColor(str) : ((obj = _colors.get(str.toLowerCase())) != null ? (Color)obj : StyleParser.hexToColor(str))));
        return color;
    }

    public static final Color hexToColor(String strColor) {
        Color color = null;
        try {
            String strR = strColor.substring(1, 3);
            String strG = strColor.substring(3, 5);
            String strB = strColor.substring(5, 7);
            if (strColor.length() > 7) {
                String strA = strColor.substring(7, 9);
                color = new Color(Integer.parseInt(strR, 16), Integer.parseInt(strG, 16), Integer.parseInt(strB, 16), Integer.parseInt(strA, 16));
            } else {
                color = new Color(Integer.parseInt(strR, 16), Integer.parseInt(strG, 16), Integer.parseInt(strB, 16));
            }
        }
        catch (Exception err) {
            throw new IllegalArgumentException("\u8f93\u5165\u7684\u989c\u8272\u8868\u8fbe\u5f0f\u4e0d\u5408\u6cd5\uff0c\u6b63\u786e\u683c\u5f0f\u5982\uff1a#00ff99");
        }
        return color;
    }

    public static Color parseRGB(String string) {
        int[] index = new int[]{4};
        int red = StyleParser.getColorComponent(string, index);
        int green = StyleParser.getColorComponent(string, index);
        int blue = StyleParser.getColorComponent(string, index);
        return new Color(red, green, blue);
    }

    private static int getColorComponent(String string, int[] index) {
        char aChar;
        int length = string.length();
        while (index[0] < length && (aChar = string.charAt(index[0])) != '-' && !Character.isDigit(aChar) && aChar != '.') {
            index[0] = index[0] + 1;
        }
        int start = index[0];
        if (start < length && string.charAt(index[0]) == '-') {
            index[0] = index[0] + 1;
        }
        while (index[0] < length && Character.isDigit(string.charAt(index[0]))) {
            index[0] = index[0] + 1;
        }
        if (index[0] < length && string.charAt(index[0]) == '.') {
            index[0] = index[0] + 1;
            while (index[0] < length && Character.isDigit(string.charAt(index[0]))) {
                index[0] = index[0] + 1;
            }
        }
        if (start != index[0]) {
            try {
                float value = Float.parseFloat(string.substring(start, index[0]));
                if (index[0] < length && string.charAt(index[0]) == '%') {
                    index[0] = index[0] + 1;
                    value = value * 255.0f / 100.0f;
                }
                return Math.min(255, Math.max(0, (int)value));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    public static void upgrade(Element eleStyles) {
        if (eleStyles == null) {
            return;
        }
        String version = eleStyles.getAttributeValue("version");
        Object obj = version == null ? null : _filters.get(Float.valueOf(version));
        int upgradeFrom = obj == null ? 0 : (Integer)obj;
        switch (upgradeFrom) {
            case 0: {
                new StyleFilterV0().upgrade(eleStyles);
            }
        }
    }

    static {
        _filters.put(new Float(1.0), new Integer(1));
        _colors = new HashMap();
        _colors.put("black", Color.BLACK);
        _colors.put("silver", new Color(192, 192, 192));
        _colors.put("gray", Color.GRAY);
        _colors.put("white", Color.WHITE);
        _colors.put("maroon", new Color(128, 0, 0));
        _colors.put("red", Color.RED);
        _colors.put("purple", new Color(128, 0, 128));
        _colors.put("fuchsia", new Color(255, 0, 255));
        _colors.put("green", Color.GREEN);
        _colors.put("lime", new Color(0, 255, 0));
        _colors.put("olive", new Color(128, 128, 0));
        _colors.put("yellow", Color.YELLOW);
        _colors.put("navy", new Color(0, 0, 128));
        _colors.put("blue", Color.BLUE);
        _colors.put("teal", new Color(0, 128, 128));
        _colors.put("aqua", new Color(0, 255, 255));
    }

    static class StyleFilterV0 {
        StyleFilterV0() {
        }

        public void upgrade(Element eleStyles) {
            List styles = eleStyles.getChildren();
            int size = styles.size();
            for (int i = 0; i < size; ++i) {
                String value;
                Element eleInterior;
                Namespace ns;
                Element eleStyle = (Element)styles.get(i);
                Element eleBorders = eleStyle.getChild("Borders", ns = eleStyle.getNamespace());
                if (eleBorders != null) {
                    List borders = eleBorders.getChildren("Border", ns);
                    for (Element eleBorder : borders) {
                        this.upgradeBorder(eleStyles, eleBorder, ns);
                    }
                }
                if ((eleInterior = eleStyle.getChild("Interior", ns)) == null || StringUtil.isEmptyString((String)(value = eleInterior.getAttributeValue("pattern")))) continue;
                Pattern ptn = Pattern.getPattern(Integer.parseInt(value));
                eleInterior.setAttribute("pattern", ptn.getName());
            }
        }

        private void upgradeBorder(Element eleStyles, Element eleBorder, Namespace ns) {
            LineStyle ls = null;
            String value = eleBorder.getAttributeValue("lineStyle");
            if (value != null) {
                PenStyle ps = null;
                int lineStyle = Integer.parseInt(value);
                if (lineStyle == -1) {
                    String pattern = eleBorder.getChildText("LinePattern", ns);
                    if (pattern != null) {
                        String[] strArray = pattern.split(" ");
                        float[] floatArray = new float[strArray.length];
                        for (int i = 0; i < strArray.length; ++i) {
                            floatArray[i] = Float.parseFloat(strArray[i]);
                        }
                        ps = PenStyle.createPenStyle(null, floatArray, false);
                        if (!ps.isSystem()) {
                            this.addToPenStyles(eleStyles, ps, ns);
                        }
                    }
                } else {
                    switch (lineStyle) {
                        case 0: {
                            ls = LineStyle.NULL_LINE;
                            break;
                        }
                        case 1: {
                            ps = PenStyle.PS_SOLID;
                            break;
                        }
                        case 2: {
                            ps = PenStyle.PS_CONTINUOUS;
                            break;
                        }
                        case 3: {
                            ps = PenStyle.PS_DOT;
                            break;
                        }
                        case 4: {
                            ps = PenStyle.PS_DASHDOTDOT;
                            break;
                        }
                        case 5: {
                            ps = PenStyle.PS_DASHDOT;
                            break;
                        }
                        default: {
                            ls = LineStyle.NULL_LINE;
                        }
                    }
                }
                eleBorder.removeAttribute("lineStyle");
                if (ps != null) {
                    eleBorder.setAttribute("penStyle", ps.getName());
                }
            }
            if (ls == null && (value = eleBorder.getAttributeValue("width")) != null) {
                int width = Integer.parseInt(value);
                ls = LineStyle.getLineStyle(width);
                eleBorder.removeAttribute("width");
            }
            if (ls != null) {
                eleBorder.setAttribute("lineStyle", ls.getName());
            }
        }

        private void addToPenStyles(Element eleStyles, PenStyle ps, Namespace ns) {
            Element elePenStyles = eleStyles.getChild("PenStyles");
            if (elePenStyles == null) {
                elePenStyles = new Element("PenStyles");
                eleStyles.addContent((Content)elePenStyles);
            }
            Element elePenStyle = null;
            try {
                String xpath = "//PenStyle[@id=\"" + ps.getName() + "\"]";
                XPath formPath = XPath.newInstance((String)xpath);
                elePenStyle = (Element)formPath.selectSingleNode((Object)elePenStyles);
            }
            catch (JDOMException err) {
                err.printStackTrace();
            }
            if (elePenStyle == null) {
                elePenStyle = new Element("PenStyle", ns);
                elePenStyle.setAttribute("Name", ps.getName());
                float[] aDash = ps.getDash();
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < aDash.length; ++i) {
                    sb.append(aDash[i]);
                    sb.append(' ');
                }
                elePenStyle.setAttribute("Dash", sb.toString());
                elePenStyles.addContent((Content)elePenStyle);
            }
        }
    }
}

