/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.res.tool.java.stat;

import com.kingdee.bos.ctrl.res.tool.java.comment.CommentParser;
import com.kingdee.bos.ctrl.res.tool.java.comment.Token;
import com.kingdee.bos.ctrl.res.tool.java.parser.syntaxtree.NodeToken;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;

public class JavaFileStatInfo
implements Comparable {
    private String PK;
    private String CL;
    private String createDate;
    private String author;
    private int size;
    private int line;
    private List innerClassList = new ArrayList();
    private List commentList = new ArrayList();
    private List CNCodeList = new ArrayList();
    private List varWarningList = new ArrayList();
    private List methodWarningList = new ArrayList();
    private List pkClassWarningList = new ArrayList();
    private List otherWarningList = new ArrayList();
    private int methodCount = 0;
    private int varCount = 0;

    public int getMethodCount() {
        return this.methodCount;
    }

    public void incMethodCount() {
        ++this.methodCount;
    }

    public int getVarCount() {
        return this.varCount;
    }

    public void incVarCount() {
        ++this.varCount;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("\n\n\u2605\u5305:\t").append(this.PK).append("\r\n").append("\u7c7b:\t").append(this.CL).append("\r\n").append("\u5185\u90e8\u7c7b:\t").append(this.innerClassList).append("\r\n").append("\u521b\u5efa\u65f6\u95f4:\t").append(this.createDate == null ? "-" : this.createDate).append("\r\n").append("\u4f5c\u8005:\t").append(this.author == null ? "-" : this.author).append("\r\n").append("\u884c\u6570:\t").append(this.line).append("\r\n").append("\u5b57\u8282:\t").append(this.size).append("\r\n").append("\u65b9\u6cd5\u6570:\t").append(this.methodCount).append("\r\n").append("\u53d8\u91cf\u6570:\t").append(this.varCount).append("\r\n").append("\u6ce8\u91ca\u5757:\t").append(this.getListFormatString(this.commentList, false)).append("\r\n").append("\u6ce8\u91ca\u6bd4\u4f8b:\t").append(this.countCommentLinePercent()).append("\r\n").append("\u5305\u7c7b\u8b66\u544a:\t").append(this.getListFormatString(this.pkClassWarningList, true)).append("\r\n").append("\u53d8\u91cf\u8b66\u544a:\t").append(this.getListFormatString(this.varWarningList, true)).append("\r\n").append("\u65b9\u6cd5\u8b66\u544a:\t").append(this.getListFormatString(this.methodWarningList, true)).append("\r\n").append("\u4e2d\u6587\u7f16\u7801:\t").append(this.getListFormatString(this.CNCodeList, true)).append("\r\n").append("\u5176\u5b83\u8b66\u544a:\t").append(this.getListFormatString(this.otherWarningList, true)).append("\r\n");
        return s.toString();
    }

    public static String getExcelHeaderString() {
        StringBuffer s = new StringBuffer();
        s.append("\n\n\u2605\u5305\t").append("\u7c7b\t").append("\u5185\u90e8\u7c7b\t").append("\u521b\u5efa\u65f6\u95f4\t").append("\u4f5c\u8005\t").append("\u884c\u6570\t").append("\u5b57\u8282\t").append("\u65b9\u6cd5\u6570\t").append("\u53d8\u91cf\u6570\t").append("\u6ce8\u91ca\u5757\t").append("\u6ce8\u91ca\u6bd4\u4f8b\t").append("\u5305\u7c7b\u8b66\u544a\t").append("\u53d8\u91cf\u8b66\u544a\t").append("\u65b9\u6cd5\u8b66\u544a\t").append("\u4e2d\u6587\u7f16\u7801\t").append("\u5176\u5b83\u8b66\u544a\t").append("\u8be6\u7ec6\u4fe1\u606f\t");
        return s.toString();
    }

    public String toExcelBodyString() {
        StringBuffer s = new StringBuffer();
        s.append(this.PK).append("\t").append(this.CL).append("\t").append(this.innerClassList).append("\t").append(this.createDate == null ? "-" : this.createDate).append("\t").append(this.author == null ? "-" : this.author).append("\t").append(this.line).append("\t").append(this.size).append("\t").append(this.methodCount).append("\t").append(this.varCount).append("\t").append(this.getListFormatString(this.commentList, false)).append("\t").append(this.countCommentLinePercent()).append("\t").append(this.getListFormatString(this.pkClassWarningList, false)).append("\t").append(this.getListFormatString(this.varWarningList, false)).append("\t").append(this.getListFormatString(this.methodWarningList, false)).append("\t").append(this.getListFormatString(this.CNCodeList, false)).append("\t").append(this.getListFormatString(this.otherWarningList, false)).append("\t").append(this.toExcelBodyDetailString()).append("\t");
        return s.toString();
    }

    private String toExcelBodyDetailString() {
        StringBuffer s = new StringBuffer().append(this.getListFormatString(this.pkClassWarningList, true)).append("\t").append(this.getListFormatString(this.varWarningList, true)).append("\t").append(this.getListFormatString(this.methodWarningList, true)).append("\t").append(this.getListFormatString(this.CNCodeList, true)).append("\t").append(this.getListFormatString(this.otherWarningList, true)).append("\t");
        return "\"" + s.toString().replaceAll("\"", "\"\"").replaceAll("\r\n\t", "    ") + "\"";
    }

    private String countCommentLinePercent() {
        DecimalFormat d = (DecimalFormat)DecimalFormat.getInstance();
        d.applyPattern("0.00%");
        return d.format(this.getCommentLinePercent());
    }

    public float getCommentLinePercent() {
        int c = 1;
        int n = this.commentList.size();
        for (int i = 0; i < n; ++i) {
            String s = (String)this.commentList.get(i);
            int k = s.length();
            for (int j = 0; j < k; ++j) {
                if ('\n' != s.charAt(j)) continue;
                ++c;
            }
        }
        float f = this.line == 0 ? 0.0f : (float)c / ((float)this.line * 1.0f);
        return f;
    }

    public void addInnerClass(String cl) {
        this.innerClassList.add(cl);
    }

    public List getInnerClassList() {
        return this.innerClassList;
    }

    public String getListFormatString(List list, boolean withDetail) {
        StringBuffer s = new StringBuffer();
        s.append(list.size());
        if (withDetail) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                s.append("\r\n\t#").append(i + 1).append(' ').append(list.get(i));
            }
        }
        return s.toString();
    }

    public void doParseInfo() throws Exception {
        List wordList = null;
        int n = this.commentList.size();
        for (int i = 0; i < n; ++i) {
            if (this.author != null && this.createDate != null) continue;
            CommentParser cp = new CommentParser((String)this.commentList.get(i));
            wordList = cp.parse();
            this.parseAuthorCreateDate(wordList);
        }
    }

    private void parseAuthorCreateDate(List ws) {
        String dateFormat = "(\\d{4}\\-\\d+\\-\\d+)|(\\d{4}\\.\\d+\\.\\d+)";
        int n = ws.size();
        for (int i = 0; i < n; ++i) {
            String w = ((Token)ws.get((int)i)).image;
            if (this.createDate == null && w.matches("(\\d{4}\\-\\d+\\-\\d+)|(\\d{4}\\.\\d+\\.\\d+)")) {
                this.createDate = w;
                continue;
            }
            if (this.author != null || !"@author".equals(w) || i >= n) continue;
            this.author = ((Token)ws.get((int)(++i))).image;
        }
    }

    public List getCommentList() {
        return this.commentList;
    }

    public List getCNCodeList() {
        return this.CNCodeList;
    }

    public List getVarWarningList() {
        return this.varWarningList;
    }

    public List getMethodWarningList() {
        return this.methodWarningList;
    }

    public List getPKClassWarningList() {
        return this.pkClassWarningList;
    }

    public List getOtherWarningList() {
        return this.otherWarningList;
    }

    public void addCommentList(String tip, NodeToken n) {
        this.addToList(this.commentList, tip, n);
    }

    public void addCNCodeList(String tip, NodeToken n) {
        this.addToList(this.CNCodeList, tip, n);
    }

    public void addVarWarningList(String tip, NodeToken n) {
        this.addToList(this.varWarningList, tip, n);
    }

    public void addMethodWarningList(String tip, NodeToken n) {
        this.addToList(this.methodWarningList, tip, n);
    }

    public void addPKClassWarningList(String tip, NodeToken n) {
        this.addToList(this.pkClassWarningList, tip, n);
    }

    public void addOtherWarningList(String tip, NodeToken n) {
        this.addToList(this.otherWarningList, tip, n);
    }

    private void addToList(List list, String tip, NodeToken n) {
        if (n == null) {
            list.add(tip);
        } else {
            String s = tip + ": (" + n.beginLine + "," + n.beginColumn + ") " + n.tokenImage;
            list.add(s);
        }
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(String createDate) {
        this.createDate = createDate;
    }

    public int getLine() {
        return this.line;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public String getCL() {
        return this.CL;
    }

    public void setCL(String cl) {
        this.CL = cl;
    }

    public String getPK() {
        return this.PK;
    }

    public void setPK(String pk) {
        this.PK = pk;
    }

    public int compareTo(Object o) {
        int re = 0;
        JavaFileStatInfo info = (JavaFileStatInfo)o;
        if (this.PK != null && info.getPK() != null) {
            re = this.PK.compareTo(info.getPK());
        }
        if (re == 0 && this.CL != null && info.getCL() != null) {
            re = this.CL.compareTo(info.getCL());
        }
        return re;
    }
}

