/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.res.tool.java.stat;

import com.kingdee.bos.ctrl.res.tool.java.stat.JavaFileStatInfo;
import java.text.DecimalFormat;

public class JavaFileStatInfoSummary {
    private int fileCount = 0;
    private int lineCount = 0;
    private int charCount = 0;
    private int methodCount = 0;
    private int varCount = 0;
    private int commonCount = 0;
    private double totalCommonPercent = 0.0;

    public void stat(JavaFileStatInfo info) {
        ++this.fileCount;
        this.lineCount += info.getLine();
        this.charCount += info.getSize();
        this.methodCount += info.getMethodCount();
        this.varCount += info.getVarCount();
        this.commonCount += info.getCommentList().size();
        this.totalCommonPercent += (double)info.getCommentLinePercent();
    }

    public int getCharCount() {
        return this.charCount;
    }

    public int getCommonCount() {
        return this.commonCount;
    }

    public int getFileCount() {
        return this.fileCount;
    }

    public int getLineCount() {
        return this.lineCount;
    }

    public int getMethodCount() {
        return this.methodCount;
    }

    public String getAvgCommonPercent() {
        DecimalFormat d = (DecimalFormat)DecimalFormat.getInstance();
        d.applyPattern("0.00%");
        return this.fileCount == 0 ? "" : d.format(this.totalCommonPercent / (double)this.fileCount);
    }

    public double getTotalCommonPercent() {
        return this.totalCommonPercent;
    }

    public String getSummaryInfo() {
        StringBuffer s = new StringBuffer().append("\u6587\u4ef6\u6570\uff1a").append(this.fileCount).append("  ").append("\u603b\u884c\u6570\uff1a").append(this.lineCount).append("  ").append("\u6ce8\u91ca\u6bd4\u4f8b\uff1a").append(this.getAvgCommonPercent());
        return s.toString();
    }
}

