/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.res.tool.webmine.zip;

import com.kingdee.bos.ctrl.common.util.StreamUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class XbrlZipper {
    private void applyShortName(Element root) {
        List children;
        int i;
        int n;
        root.setName(ShortName.useShortName(root.getName(), "N"));
        List attrs = root.getAttributes();
        if (attrs != null) {
            n = attrs.size();
            for (i = 0; i < n; ++i) {
                Attribute attr = (Attribute)attrs.get(i);
                attr.setName(ShortName.useShortName(attr.getName(), "N"));
                attr.setValue(this.mergeShortContent(attr.getValue()));
            }
        }
        if ((children = root.getChildren()) != null) {
            n = children.size();
            for (i = 0; i < n; ++i) {
                this.applyShortName((Element)children.get(i));
            }
        }
    }

    private String mergeShortContent(String s) {
        return ShortName.useShortName(s, "C");
    }

    private void applyDefine(Document doc) {
        Element def = new Element("Define");
        def.setAttribute("conflictPrefix", "_");
        doc.getRootElement().getChildren().add(0, def);
        Map map = ShortName.getMap();
        for (String key : map.keySet()) {
            ShortName sn = (ShortName)map.get(key);
            Element e = new Element(sn.shortName);
            e.setAttribute("V", sn.name);
            def.addContent("\r\n\t\t");
            def.addContent((Content)e);
        }
    }

    public String zipXmlString(String xmlString) throws Exception {
        SAXBuilder sb = new SAXBuilder();
        sb.setValidation(false);
        Document doc = sb.build((InputStream)new ByteArrayInputStream(xmlString.getBytes()));
        ShortName.reset();
        this.applyShortName(doc.getRootElement());
        this.applyDefine(doc);
        XMLOutputter out = new XMLOutputter();
        Format format = out.getFormat();
        format.setEncoding("GBK");
        out.setFormat(format);
        return out.outputString(doc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String zipXmlFile(String xmlFile) throws Exception {
        StringBuilder sb = new StringBuilder();
        FileInputStream in = null;
        InputStreamReader r = null;
        BufferedReader br = null;
        try {
            String line;
            in = new FileInputStream(xmlFile);
            r = new InputStreamReader((InputStream)in, "UTF-8");
            br = new BufferedReader(r);
            while ((line = br.readLine()) != null) {
                sb.append(line).append("\r\n");
            }
        }
        catch (Throwable throwable) {
            StreamUtil.closeReader(br);
            StreamUtil.closeReader(r);
            StreamUtil.closeStream((InputStream)in);
            throw throwable;
        }
        StreamUtil.closeReader((Reader)br);
        StreamUtil.closeReader((Reader)r);
        StreamUtil.closeStream((InputStream)in);
        return this.zipXmlString(sb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveFile(String fileName, String value) throws Exception {
        FileWriter fw = null;
        try {
            fw = new FileWriter(fileName);
            fw.write(value);
            fw.flush();
        }
        catch (Throwable throwable) {
            StreamUtil.closeCloseable(fw);
            throw throwable;
        }
        StreamUtil.closeCloseable((Closeable)fw);
    }

    public static void main(String[] args) throws Exception {
        XbrlZipper zip = new XbrlZipper();
        String s = zip.zipXmlFile("C:\\111.xml");
        System.err.println(s.length());
        zip.saveFile("c:\\111_zip.xml", s.toString());
    }

    static class ShortName {
        public static final String TYPE_NAME = "N";
        public static final String TYPE_CONTENT = "C";
        private static Map shortMap = new HashMap();
        private static String seq = "#";
        String shortName;
        String name;
        String type;

        public static void reset() {
            shortMap.clear();
            seq = "#";
        }

        private static String createShortName() {
            int i;
            char[] chs = seq.toCharArray();
            char ch = chs[i = chs.length - 1];
            if (ch == '#') {
                chs[i] = 97;
            } else if (ch == 'z') {
                chs[i] = 65;
            } else if (ch == 'Z') {
                chs[i] = 97;
                chs = ShortName.inc(chs, 1);
            } else {
                chs[i] = (char)(ch + '\u0001');
            }
            seq = new String(chs);
            return seq;
        }

        private static char[] inc(char[] chs, int incIndex) {
            StringBuffer s = new StringBuffer();
            int n = chs.length;
            if (n == incIndex) {
                s.append("a").append(chs);
            } else {
                char ch = chs[incIndex];
                if (ch == 'Z') {
                    chs[incIndex] = 97;
                    s.append("a").append(chs);
                } else if (ch == 'z') {
                    chs[incIndex] = 65;
                } else {
                    chs[incIndex] = (char)(ch + '\u0001');
                    s.append(chs);
                }
            }
            return s.toString().toCharArray();
        }

        public static Map getMap() {
            return shortMap;
        }

        public static String useShortName(String name, String type) {
            ShortName sn = (ShortName)shortMap.get(name + "_" + type);
            if (sn == null) {
                sn = new ShortName(name, type);
                shortMap.put(name + "_" + type, sn);
            }
            return sn.shortName;
        }

        ShortName(String name, String type) {
            this.name = name;
            this.shortName = ShortName.createShortName();
            this.type = type;
        }
    }
}

