/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.data.meta.ui;

import com.kingdee.bos.ctrl.bizshare.ConnectException;
import com.kingdee.bos.ctrl.common.CtrlUIEnv;
import com.kingdee.bos.ctrl.common.layout.table.Cell;
import com.kingdee.bos.ctrl.common.layout.table.Table;
import com.kingdee.bos.ctrl.common.ui.TypicalDialog;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.ui.tree.TreeUI;
import com.kingdee.bos.ctrl.common.ui.tree.TreeUINode;
import com.kingdee.bos.ctrl.common.util.DBUtil;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.xml.XmlUtil;
import com.kingdee.bos.ctrl.data.framework.connection.DBConnection;
import com.kingdee.bos.ctrl.data.framework.connection.ui.DBConnDialog;
import com.kingdee.bos.ctrl.data.framework.connection.ui.DBConnPanel;
import com.kingdee.bos.ctrl.data.meta.MetaClass;
import com.kingdee.bos.ctrl.data.meta.MetaField;
import com.kingdee.bos.ctrl.data.meta.MetaLibrary;
import com.kingdee.bos.ctrl.data.meta.MetaManager;
import com.kingdee.bos.ctrl.data.meta.MetaPackage;
import com.kingdee.bos.ctrl.data.meta.MetaResource;
import com.kingdee.bos.ctrl.data.meta.io.Bmd2Meta;
import com.kingdee.bos.ctrl.data.meta.io.DB2Meta;
import com.kingdee.bos.ctrl.data.meta.io.Kdm2Meta;
import com.kingdee.bos.ctrl.data.meta.io.Kdr2Meta;
import com.kingdee.bos.ctrl.data.meta.io.Meta2Xml;
import com.kingdee.bos.ctrl.data.meta.io.Xml2Meta;
import com.kingdee.bos.ctrl.data.meta.ui.MetaTreeCtrl;
import com.kingdee.bos.ctrl.data.modal.DefObj;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.apache.log4j.Logger;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class MetaTransTool
extends TypicalDialog
implements TreeSelectionListener {
    private static final Logger log = LogUtil.getPackageLogger(MetaTransTool.class);
    private MetaTreeCtrl mtc;
    private KDTextArea txtInfo;
    private KDButton btnLoadKdr;
    private KDButton btnLoadKdm;
    private KDButton btnLoadDBMeta;
    private KDButton btnLoadBosMeta;
    private KDButton btnLoadXml;
    private KDButton btnSaveXml;
    private String lastKdm = "d:/temp/test.kdm";
    private String lastKdr = "d:/temp/test.kdr";
    private String lastBosMeta = "W:/_workspace/kdrsbos/output/meta/";
    private String lastDBServerUrl = "192.168.19.240:1433";
    private String lastDBName = "kdrsdb";
    private String lastDBUser = "sa";
    private String lastDBPassword = "";
    private String lastXml = "d:/temp/test.rsm";
    private String lastSaveDir;
    private static final String RSM_FILE_FILTER = MetaResource.getString((String)"res_14");

    public MetaTransTool() {
    }

    public MetaTransTool(Dialog owner) {
        super(owner);
    }

    public MetaTransTool(Frame owner) {
        super(owner);
    }

    protected void todoInit() {
        MetaManager mng = new MetaManager();
        mng.setName("MetaManager");
        mng.setAlias(MetaResource.getString((String)"res_4"));
        this.mtc = new MetaTreeCtrl((DefObj)mng);
        this.mtc.initTreeUI(new TreeUI());
        this.txtInfo = new KDTextArea();
        this.btnLoadKdr = new KDButton(MetaResource.getString((String)"res_5"));
        this.btnLoadKdm = new KDButton(MetaResource.getString((String)"res_6"));
        this.btnLoadDBMeta = new KDButton(MetaResource.getString((String)"res_7"));
        this.btnLoadBosMeta = new KDButton(MetaResource.getString((String)"res_8"));
        this.btnLoadXml = new KDButton(MetaResource.getString((String)"res_9"));
        this.btnSaveXml = new KDButton(MetaResource.getString((String)"res_10"));
    }

    protected void todoAddControls(Container parent, Cell thisCell) {
        Table tab = thisCell.split(2, 2);
        tab.colStyle(0).setPriX(1);
        tab.rowStyle(0).setPriY(1);
        parent.add((Component)this.mtc.getTreeUI(), tab.cell(0, 0));
        this.mtc.getTreeUI().getTree().addTreeSelectionListener((TreeSelectionListener)this);
        parent.add((Component)this.txtInfo, tab.cell(0, 1));
        Table btns = tab.cell(1, 1).split(4, 2);
        parent.add((Component)this.btnLoadKdr, btns.cell(0, 0));
        parent.add((Component)this.btnLoadKdm, btns.cell(1, 0));
        parent.add((Component)this.btnLoadDBMeta, btns.cell(2, 0));
        parent.add((Component)this.btnLoadBosMeta, btns.cell(3, 0));
        parent.add((Component)this.btnLoadXml, btns.cell(0, 1));
        parent.add((Component)this.btnSaveXml, btns.cell(1, 1));
        this.btnLoadKdr.addActionListener(this.actionListner);
        this.btnLoadKdm.addActionListener(this.actionListner);
        this.btnLoadDBMeta.addActionListener(this.actionListner);
        this.btnLoadBosMeta.addActionListener(this.actionListner);
        this.btnLoadXml.addActionListener(this.actionListner);
        this.btnSaveXml.addActionListener(this.actionListner);
    }

    protected void todoActionPerformed(ActionEvent e) {
        Object src = e.getSource();
        MetaLibrary lib = null;
        if (src == this.btnLoadKdr) {
            lib = this.loadKdr();
        } else if (src == this.btnLoadKdm) {
            lib = this.loadKdm();
        } else if (src == this.btnLoadDBMeta) {
            lib = this.loadDBMeta();
        } else if (src == this.btnLoadBosMeta) {
            lib = this.loadBmd();
        } else if (src == this.btnLoadXml) {
            lib = this.loadXml();
        } else if (src == this.btnSaveXml) {
            this.saveXml();
            return;
        }
        if (lib != null) {
            MetaManager mng = (MetaManager)this.mtc.getTopNode().getUserObject();
            mng.addLibaray(lib);
            this.mtc.getTreeUI().refreshNode(this.mtc.getTopNode());
        }
    }

    protected void todoKeyAction(int keyCode) {
    }

    public MetaLibrary loadKdm() {
        Element xmlRoot;
        File f = WindowUtil.chooseOpenFile((Component)((Object)this), (String)this.lastKdm, (String[])new String[]{MetaResource.getString((String)"res_11")});
        if (f == null) {
            return null;
        }
        this.lastKdm = f.getAbsolutePath();
        try {
            xmlRoot = XmlUtil.loadXmlFile((String)this.lastKdm);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        catch (JDOMException e) {
            e.printStackTrace();
            return null;
        }
        XmlUtil.printElement((Element)xmlRoot);
        return Kdm2Meta.parseDBMeta((Element)xmlRoot);
    }

    public MetaLibrary loadKdr() {
        Element xmlRoot;
        File f = WindowUtil.chooseOpenFile((Component)((Object)this), (String)this.lastKdr, (String[])new String[]{MetaResource.getString((String)"res_12")});
        if (f == null) {
            return null;
        }
        this.lastKdr = f.getAbsolutePath();
        try {
            xmlRoot = XmlUtil.loadXmlFile((String)this.lastKdr);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        catch (JDOMException e) {
            e.printStackTrace();
            return null;
        }
        XmlUtil.printElement((Element)xmlRoot);
        Kdr2Meta kdr = new Kdr2Meta();
        return kdr.transform(xmlRoot);
    }

    public MetaLibrary loadDBMeta() {
        DBConnDialog dlg = (DBConnDialog)((Object)WindowUtil.createWindow(DBConnDialog.class, (Component)((Object)this)));
        DBConnPanel cp = dlg.getConnPanel();
        cp.setServiceUrl(this.lastDBServerUrl);
        cp.setDatabase(this.lastDBName);
        cp.setUser(this.lastDBUser);
        cp.setPassword(this.lastDBPassword);
        if (dlg.showDialog()) {
            this.lastDBServerUrl = cp.getServiceUrl();
            this.lastDBName = cp.getDatabase();
            this.lastDBUser = cp.getUser();
            this.lastDBPassword = cp.getPassword();
            DBConnection dbConn = cp.makeDBConnection();
            try {
                dbConn.open();
            }
            catch (ConnectException ex) {
                log.error((Object)ex, (Throwable)ex);
                return null;
            }
            Connection conn = dbConn.getConnection();
            DB2Meta dbs = new DB2Meta();
            MetaLibrary lib = dbs.parseDataBase(conn, this.lastDBName);
            DBUtil.closeDBConn((Connection)conn);
            return lib;
        }
        return null;
    }

    public MetaLibrary loadBmd() {
        File f = WindowUtil.chooseOpenDirectory((Component)((Object)this), (String)this.lastBosMeta, (String[])new String[]{MetaResource.getString((String)"res_13")});
        if (f == null) {
            return null;
        }
        this.lastBosMeta = f.getAbsolutePath();
        return Bmd2Meta.lazyLoad((String)this.lastBosMeta);
    }

    public MetaLibrary loadXml() {
        Element xmlRoot;
        File f = WindowUtil.chooseOpenFile((Component)((Object)this), (String)this.lastXml, (String[])new String[]{RSM_FILE_FILTER});
        if (f == null) {
            return null;
        }
        this.lastXml = f.getAbsolutePath();
        try {
            xmlRoot = XmlUtil.loadXmlFile((String)this.lastXml);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        catch (JDOMException e) {
            e.printStackTrace();
            return null;
        }
        XmlUtil.printElement((Element)xmlRoot);
        Xml2Meta loader = new Xml2Meta();
        return loader.transform(xmlRoot);
    }

    public void saveXml() {
        TreeUINode node = (TreeUINode)this.mtc.getTreeUI().getTree().getSelectionPath().getLastPathComponent();
        Object obj = node.getUserObject();
        if (!(obj instanceof MetaLibrary)) {
            return;
        }
        MetaLibrary lib = (MetaLibrary)obj;
        File f = WindowUtil.chooseSaveFile((Component)((Object)this), (String)(this.lastSaveDir + File.separator + lib.getName()), (String[])new String[]{RSM_FILE_FILTER});
        if (f == null) {
            return;
        }
        this.lastSaveDir = f.getParent();
        String path = f.getAbsolutePath();
        if (-1 == f.getName().indexOf(".")) {
            path = path + ".rsm";
        }
        Meta2Xml maker = new Meta2Xml();
        Element xmlLib = maker.transform(lib);
        try {
            XmlUtil.saveXmlFile((String)path, (Element)xmlLib);
        }
        catch (IOException e) {
            e.printStackTrace();
            WindowUtil.msgboxError((Object)MetaResource.getString((String)"res_15"), (String)MetaResource.getString((String)"res_10"), (Component)((Object)this));
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        TreeUINode node = (TreeUINode)e.getPath().getLastPathComponent();
        Object obj = node.getUserObject();
        StringBuffer sb = new StringBuffer();
        if (obj instanceof MetaField) {
            MetaField fld = (MetaField)obj;
            sb.append(MetaResource.getString((String)"res_16"));
            this.makeMetaObjInfo((DefObj)fld, sb);
            sb.append(MetaResource.getString((String)"res_17"));
            sb.append(fld.getType().getName());
            sb.append(MetaResource.getString((String)"res_18"));
            sb.append(fld.getExpr());
        } else if (obj instanceof MetaClass) {
            MetaClass cls = (MetaClass)obj;
            sb.append(MetaResource.getString((String)"res_19"));
            this.makeMetaObjInfo((DefObj)cls, sb);
            sb.append(MetaResource.getString((String)"res_20"));
            sb.append(cls.getType());
            sb.append(MetaResource.getString((String)"res_18"));
            sb.append(cls.getExpr());
        } else if (obj instanceof MetaPackage) {
            MetaPackage mp = (MetaPackage)obj;
            sb.append(MetaResource.getString((String)"res_21"));
            this.makeMetaObjInfo((DefObj)mp, sb);
        } else if (obj instanceof MetaLibrary) {
            MetaLibrary lib = (MetaLibrary)obj;
            sb.append(MetaResource.getString((String)"res_22"));
            this.makeMetaObjInfo((DefObj)lib, sb);
        }
        this.txtInfo.setText(sb.toString());
    }

    private void makeMetaObjInfo(DefObj mo, StringBuffer sb) {
        sb.append(MetaResource.getString((String)"res_23"));
        sb.append(mo.getName());
        sb.append(MetaResource.getString((String)"res_24"));
        sb.append(mo.getAlias());
        sb.append(MetaResource.getString((String)"res_25"));
        sb.append(mo.getDesc());
    }

    public static void main(String[] args) {
        CtrlUIEnv.setKingdeeLAF();
        MetaTransTool dlg = new MetaTransTool();
        dlg.setSize(800, 600);
        dlg.showDialog();
    }
}

