/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.data.engine.rows.impl;

import com.kingdee.bos.ctrl.common.DataType;
import com.kingdee.bos.ctrl.data.engine.rows.IRow;
import com.kingdee.bos.ctrl.data.engine.rows.IRowMetaData;
import com.kingdee.bos.ctrl.data.engine.rows.IRows;
import com.kingdee.bos.ctrl.data.engine.rows.RowsException;
import com.kingdee.bos.ctrl.data.engine.rows.impl.FileCachedRowList;
import com.kingdee.bos.ctrl.data.engine.rows.impl.IRowList;
import com.kingdee.bos.ctrl.data.engine.rows.impl.Row;
import com.kingdee.bos.ctrl.data.engine.rows.impl.SimpleRowsMetaData;
import com.kingdee.bos.ctrl.data.modal.DataConvertHelper;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;

public class SimpleRows
implements IRows {
    private Row row;
    private SimpleRowsMetaData meta;
    private IRowList rowList;
    private int curRow;
    private boolean closed;
    private boolean cursorDirection;
    private boolean lastValueNull;
    private static final Byte BYTE_ZERO = new Byte(0);
    private static final Byte BYTE_ONE = new Byte(1);
    private static final Short SHORT_ZERO = new Short(0);
    private static final Short SHORT_ONE = new Short(1);
    private static final Integer INTEGER_ZERO = new Integer(0);
    private static final Integer INTEGER_ONE = new Integer(1);
    private static final Long LONG_ZERO = new Long(0L);
    private static final Long LONG_ONE = new Long(1L);
    private static final Float FLOAT_ZERO = new Float(0.0f);
    private static final Float FLOAT_ONE = new Float(1.0f);
    private static final Double DOUBLE_ZERO = new Double(0.0);
    private static final Double DOUBLE_ONE = new Double(1.0);
    private static final BigDecimal BIGDECIMAL_ZERO = new BigDecimal(0.0);
    private static final BigDecimal BIGDECIMAL_ONE = new BigDecimal(1.0);
    private static final UnsupportedOperationException UNSUPPORT_EXCEPTION = new UnsupportedOperationException();

    public SimpleRows() throws RowsException {
        this(new SimpleRowsMetaData());
    }

    public SimpleRows(SimpleRowsMetaData meta) throws RowsException {
        this(meta, null);
    }

    public SimpleRows(ResultSet rs) throws RowsException {
        this(new SimpleRowsMetaData(rs), rs);
    }

    private SimpleRows(SimpleRowsMetaData meta, ResultSet rs) throws RowsException {
        this.meta = meta;
        this.rowList = new FileCachedRowList("c:\\test.bin", -1, this.meta, rs);
        this.closed = false;
        this.curRow = -1;
        this.cursorDirection = true;
        this.lastValueNull = true;
    }

    private final void checkColumnIndex(int i) throws RowsException {
        if (i < 1 || i > this.meta.getColumnCount()) {
            throw new RowsException("Invalid column index");
        }
    }

    private final void checkStatus(boolean checkCursor) throws RowsException {
        if (this.closed) {
            throw new RowsException("Rowset was closed.");
        }
        if (checkCursor && (this.isAfterLast() || this.isBeforeFirst())) {
            throw new RowsException("Invalid cursor position");
        }
    }

    private final int colNameToIndex(String columnName) throws RowsException {
        int idx = this.getMetaData().find(columnName);
        if (idx == -1) {
            throw new RowsException("Not found specified column.'" + columnName + "'");
        }
        return idx;
    }

    private final void ensureCurrentRow() throws RowsException {
        if (this.row == null) {
            this.row = this.rowList.getRow(this.curRow);
        }
    }

    @Override
    public IRow getRowObject() throws RowsException {
        this.ensureCurrentRow();
        return this.row;
    }

    @Override
    public void swapRow(int row1, int row2) throws RowsException {
        this.checkStatus(false);
        if (row1 < 0) {
            row1 = this.curRow;
        }
        if (row1 >= this.rowList.count() || row2 < 0 || row2 >= this.rowList.count()) {
            throw new RowsException("Bad row for swap, row1=" + row1 + ",row2=" + row2);
        }
        if (row1 == row2) {
            return;
        }
        int currentRow = this.curRow;
        this.setRow(row1);
        IRow rowObject1 = this.getRowObject();
        this.setRow(row2);
        IRow rowObject2 = this.getRowObject();
        this.setRow(currentRow);
        int colsCount = this.meta.getColumnCount();
        for (int i = 1; i < colsCount + 1; ++i) {
            Object temp = rowObject1.getValue(i);
            rowObject1.setValue(i, rowObject2.getValue(i));
            rowObject2.setValue(i, temp);
        }
    }

    @Override
    public int addRow() throws RowsException {
        this.checkStatus(false);
        if (this.curRow == -2) {
            throw new RowsException("Invalid cursor position");
        }
        this.row = new Row(this.meta);
        this.rowList.addRow(++this.curRow, this.row);
        return this.curRow;
    }

    @Override
    public int insertRow() throws RowsException {
        this.checkStatus(false);
        if (this.curRow == -1) {
            throw new RowsException("Invalid cursor position");
        }
        this.row = new Row(this.meta);
        this.rowList.addRow(this.curRow, this.row);
        return this.curRow;
    }

    @Override
    public void destroy() throws RowsException {
        if (!this.closed) {
            this.rowList.destroy();
            this.row = null;
        }
        this.closed = true;
    }

    @Override
    public void deleteRow() throws RowsException {
        this.checkStatus(true);
        this.rowList.deleteRow(this.curRow);
        this.row = null;
        if (this.rowList.count() == 0) {
            this.curRow = -1;
        } else if (this.rowList.count() == this.curRow) {
            this.curRow = -2;
        }
    }

    @Override
    public void deleteRows() throws RowsException {
        this.checkStatus(false);
        if (this.cursorDirection) {
            this.rowList.deleteRows(this.curRow, this.rowList.count() - this.curRow);
        } else {
            this.rowList.deleteRows(0, this.curRow + 1);
        }
        int rowCount = this.rowList.count();
        if (rowCount == 0) {
            this.curRow = -1;
        } else if (rowCount == this.curRow) {
            this.curRow = -2;
        }
    }

    @Override
    public void afterLast() throws RowsException {
        this.checkStatus(false);
        if (this.rowList.count() != 0) {
            this.curRow = -2;
            this.row = null;
        }
    }

    @Override
    public void beforeFirst() throws RowsException {
        this.checkStatus(false);
        if (this.rowList.count() != 0) {
            this.curRow = -1;
            this.row = null;
        }
    }

    @Override
    public boolean isAfterLast() throws RowsException {
        this.checkStatus(false);
        return this.curRow == -2 && this.rowList.count() != 0;
    }

    @Override
    public boolean isBeforeFirst() throws RowsException {
        this.checkStatus(false);
        return this.curRow == -1 && this.rowList.count() != 0;
    }

    @Override
    public boolean next() throws RowsException {
        this.checkStatus(false);
        this.row = null;
        if (this.cursorDirection) {
            if (this.curRow == -2) {
                return false;
            }
            if (this.curRow++ == this.rowList.count() - 1) {
                this.curRow = -2;
            }
        } else {
            if (this.curRow == -1) {
                return false;
            }
            if (this.curRow == -2) {
                this.curRow = this.rowList.count() - 1;
            } else if (this.curRow-- == 0) {
                this.curRow = -1;
            }
        }
        return this.curRow >= 0 && this.curRow < this.rowList.count();
    }

    @Override
    public boolean previous() throws RowsException {
        this.checkStatus(false);
        this.cursorDirection = !this.cursorDirection;
        boolean b = this.next();
        this.cursorDirection = !this.cursorDirection;
        return b;
    }

    @Override
    public boolean setRow(int newRow) throws RowsException {
        this.checkStatus(false);
        if (newRow < 0 || newRow >= this.rowList.count()) {
            return false;
        }
        if (newRow != this.curRow) {
            this.row = null;
            this.curRow = newRow;
        }
        return true;
    }

    @Override
    public int getRow() throws RowsException {
        this.checkStatus(false);
        return this.curRow;
    }

    @Override
    public boolean isValidRow() throws RowsException {
        return this.rowList.count() > 0 && this.curRow > 0;
    }

    @Override
    public boolean getFetchDirection() throws RowsException {
        this.checkStatus(false);
        return this.cursorDirection;
    }

    @Override
    public boolean setFetchDirection(boolean b) throws RowsException {
        this.checkStatus(false);
        boolean old = this.cursorDirection;
        this.cursorDirection = b;
        return old;
    }

    @Override
    public int getRowCount() throws RowsException {
        this.checkStatus(false);
        return this.rowList.count();
    }

    @Override
    public boolean wasNull() throws RowsException {
        return this.lastValueNull;
    }

    @Override
    public void addColumn(int index, String name, DataType colType, HashMap extProps) throws RowsException {
        this.checkStatus(false);
        try {
            this.colNameToIndex(name);
            throw new RowsException("The specified column '" + name + "' was already exist.");
        }
        catch (RowsException ex) {
            this.rowList.addColumn(index, name, colType, extProps);
            return;
        }
    }

    @Override
    public void deleteColumn(int index) throws RowsException {
        this.checkStatus(false);
        this.rowList.deleteColumn(index);
    }

    @Override
    public IRowMetaData getMetaData() throws RowsException {
        this.checkStatus(false);
        return this.meta;
    }

    @Override
    public Blob getBlob(int column) throws RowsException {
        throw UNSUPPORT_EXCEPTION;
    }

    @Override
    public Blob getBlob(String column) throws RowsException {
        throw UNSUPPORT_EXCEPTION;
    }

    @Override
    public Clob getClob(int column) throws RowsException {
        throw UNSUPPORT_EXCEPTION;
    }

    @Override
    public Clob getClob(String column) throws RowsException {
        throw UNSUPPORT_EXCEPTION;
    }

    @Override
    public InputStream getInputStream(int column) throws RowsException {
        throw UNSUPPORT_EXCEPTION;
    }

    @Override
    public InputStream getInputStream(String column) throws RowsException {
        throw UNSUPPORT_EXCEPTION;
    }

    @Override
    public void setBlob(int column, Blob clob) throws RowsException {
        throw UNSUPPORT_EXCEPTION;
    }

    @Override
    public void setBlob(String column, Blob clob) throws RowsException {
        throw UNSUPPORT_EXCEPTION;
    }

    @Override
    public void setClob(int column, Clob clob) throws RowsException {
        throw UNSUPPORT_EXCEPTION;
    }

    @Override
    public void setClob(String column, Clob clob) throws RowsException {
        throw UNSUPPORT_EXCEPTION;
    }

    @Override
    public void setInputStream(int column, InputStream in, int length) throws RowsException {
        throw UNSUPPORT_EXCEPTION;
    }

    @Override
    public void setInputStream(String column, InputStream in, int length) throws RowsException {
        throw UNSUPPORT_EXCEPTION;
    }

    @Override
    public String getString(int column) throws RowsException {
        this.prepareAccess(column);
        return (String)this.getValue(column, DataType.STRING, true);
    }

    @Override
    public String getString(String column) throws RowsException {
        return this.getString(this.colNameToIndex(column));
    }

    @Override
    public void setString(int column, String s) throws RowsException {
        this.prepareAccess(column);
        this.setValue(column, s, DataType.STRING, true);
    }

    @Override
    public void setString(String column, String s) throws RowsException {
        this.setString(this.colNameToIndex(column), s);
    }

    @Override
    public boolean getBoolean(int column) throws RowsException {
        this.prepareAccess(column);
        return (Boolean)this.getValue(column, DataType.BOOLEAN, true);
    }

    @Override
    public boolean getBoolean(String column) throws RowsException {
        return this.getBoolean(this.colNameToIndex(column));
    }

    @Override
    public void setBoolean(int column, boolean i) throws RowsException {
        this.prepareAccess(column);
        this.setValue(column, i, DataType.BOOLEAN, true);
    }

    @Override
    public void setBoolean(String column, boolean i) throws RowsException {
        this.setBoolean(this.colNameToIndex(column), i);
    }

    @Override
    public byte getByte(int column) throws RowsException {
        this.prepareAccess(column);
        return ((Number)this.getValue(column, DataType.BYTE, true)).byteValue();
    }

    @Override
    public byte getByte(String column) throws RowsException {
        return this.getByte(this.colNameToIndex(column));
    }

    @Override
    public void setByte(int column, byte i) throws RowsException {
        this.prepareAccess(column);
        this.setValue(column, new Byte(i), DataType.BYTE, true);
    }

    @Override
    public void setByte(String column, byte i) throws RowsException {
        this.setByte(this.colNameToIndex(column), i);
    }

    @Override
    public short getShort(int column) throws RowsException {
        this.prepareAccess(column);
        return ((Number)this.getValue(column, DataType.SHORT, true)).shortValue();
    }

    @Override
    public short getShort(String column) throws RowsException {
        return this.getShort(this.colNameToIndex(column));
    }

    @Override
    public void setShort(int column, short i) throws RowsException {
        this.prepareAccess(column);
        this.setValue(column, new Short(i), DataType.SHORT, true);
    }

    @Override
    public void setShort(String column, short i) throws RowsException {
        this.setShort(this.colNameToIndex(column), i);
    }

    @Override
    public int getInt(int column) throws RowsException {
        this.prepareAccess(column);
        return ((Number)this.getValue(column, DataType.INTEGER, true)).intValue();
    }

    @Override
    public int getInt(String column) throws RowsException {
        return this.getInt(this.colNameToIndex(column));
    }

    @Override
    public void setInt(int column, int i) throws RowsException {
        this.prepareAccess(column);
        this.setValue(column, new Integer(i), DataType.INTEGER, true);
    }

    @Override
    public void setInt(String column, int i) throws RowsException {
        this.setInt(this.colNameToIndex(column), i);
    }

    @Override
    public long getLong(int column) throws RowsException {
        this.prepareAccess(column);
        return ((Number)this.getValue(column, DataType.LONG, true)).longValue();
    }

    @Override
    public long getLong(String column) throws RowsException {
        return this.getLong(this.colNameToIndex(column));
    }

    @Override
    public void setLong(int column, long i) throws RowsException {
        this.prepareAccess(column);
        this.setValue(column, new Long(i), DataType.LONG, true);
    }

    @Override
    public void setLong(String column, long i) throws RowsException {
        this.setLong(this.colNameToIndex(column), i);
    }

    @Override
    public float getFloat(int column) throws RowsException {
        this.prepareAccess(column);
        return ((Number)this.getValue(column, DataType.FLOAT, true)).floatValue();
    }

    @Override
    public float getFloat(String column) throws RowsException {
        return this.getFloat(this.colNameToIndex(column));
    }

    @Override
    public void setFloat(int column, float i) throws RowsException {
        this.prepareAccess(column);
        this.setValue(column, new Float(i), DataType.FLOAT, true);
    }

    @Override
    public void setFloat(String column, float i) throws RowsException {
        this.setFloat(this.colNameToIndex(column), i);
    }

    @Override
    public double getDouble(int column) throws RowsException {
        this.prepareAccess(column);
        return ((Number)this.getValue(column, DataType.DOUBLE, true)).doubleValue();
    }

    @Override
    public double getDouble(String column) throws RowsException {
        return this.getDouble(this.colNameToIndex(column));
    }

    @Override
    public void setDouble(int column, double i) throws RowsException {
        this.prepareAccess(column);
        this.setValue(column, new Double(i), DataType.DOUBLE, true);
    }

    @Override
    public void setDouble(String column, double i) throws RowsException {
        this.setDouble(this.colNameToIndex(column), i);
    }

    @Override
    public Object getObject(int column) throws RowsException {
        this.prepareAccess(column);
        DataType defType = this.getMetaData().getColumnType(column);
        Object obj = this.getValue(column, defType, false);
        if (obj == null) {
            return obj;
        }
        DataType actualType = DataConvertHelper.getDataType(obj);
        if (defType == actualType) {
            return obj;
        }
        if (defType == DataType.BYTE) {
            return new Byte(((Number)obj).byteValue());
        }
        if (defType == DataType.SHORT) {
            return new Short(((Number)obj).shortValue());
        }
        if (defType == DataType.INTEGER) {
            return new Integer(((Number)obj).intValue());
        }
        if (defType == DataType.LONG) {
            return new Long(((Number)obj).longValue());
        }
        if (defType == DataType.FLOAT) {
            return new Float(((Number)obj).floatValue());
        }
        if (defType == DataType.DOUBLE) {
            return new Double(((Number)obj).floatValue());
        }
        if (defType == DataType.DECIMAL) {
            return new BigDecimal(((Number)obj).floatValue());
        }
        return SimpleRows.convertData(obj, actualType, defType);
    }

    @Override
    public Object getObject(String column) throws RowsException {
        return this.getObject(this.colNameToIndex(column));
    }

    @Override
    public void setObject(int column, Object obj) throws RowsException {
        DataType dt;
        this.prepareAccess(column);
        DataType dataType = dt = obj != null ? DataConvertHelper.getDataType(obj) : this.meta.getColumnType(column);
        if (dt == null) {
            throw new RowsException("Value can not be converted to requested type.");
        }
        if (dt == DataType.DATETIME) {
            if (obj instanceof Time) {
                this.setTime(column, (Time)obj);
            } else if (obj instanceof Date) {
                this.setDate(column, (Date)obj);
            } else {
                this.setTimestamp(column, (Timestamp)obj);
            }
        } else {
            this.setValue(column, obj, dt, false);
        }
    }

    @Override
    public void setObject(String column, Object i) throws RowsException {
        this.setObject(this.colNameToIndex(column), i);
    }

    @Override
    public BigDecimal getBigDecimal(int column) throws RowsException {
        this.prepareAccess(column);
        Number number = (Number)this.getValue(column, DataType.DECIMAL, true);
        if (number instanceof BigDecimal) {
            return (BigDecimal)number;
        }
        BigDecimal bg = new BigDecimal(number.doubleValue());
        this.row.setValue(column, bg);
        return bg;
    }

    @Override
    public BigDecimal getBigDecimal(int column, int scale) throws RowsException {
        return null;
    }

    @Override
    public BigDecimal getBigDecimal(String column) throws RowsException {
        return this.getBigDecimal(this.colNameToIndex(column));
    }

    @Override
    public BigDecimal getBigDecimal(String column, int scale) throws RowsException {
        return this.getBigDecimal(this.colNameToIndex(column), scale);
    }

    @Override
    public void setBigDecimal(int column, BigDecimal i) throws RowsException {
        this.prepareAccess(column);
        this.setValue(column, i, DataType.DECIMAL, true);
    }

    @Override
    public void setBigDecimal(String column, BigDecimal i) throws RowsException {
        this.setBigDecimal(this.colNameToIndex(column), i);
    }

    @Override
    public Date getDate(int column, Calendar calendar) throws RowsException {
        this.prepareAccess(column);
        Timestamp obj = (Timestamp)this.getValue(column, DataType.DATETIME, true);
        if (obj != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(obj);
            calendar.set(1, cal.get(1));
            calendar.set(2, cal.get(2));
            calendar.set(5, cal.get(5));
            return new Date(calendar.getTime().getTime());
        }
        return null;
    }

    @Override
    public Date getDate(int column) throws RowsException {
        return this.getDate(column, Calendar.getInstance());
    }

    @Override
    public Date getDate(String column, Calendar cal) throws RowsException {
        return this.getDate(this.colNameToIndex(column), cal);
    }

    @Override
    public Date getDate(String column) throws RowsException {
        return this.getDate(this.colNameToIndex(column));
    }

    @Override
    public void setDate(int column, Date d) throws RowsException {
        this.prepareAccess(column);
        this.setValue(column, new Timestamp(d.getTime()), DataType.DATETIME, true);
    }

    @Override
    public void setDate(String column, Date d) throws RowsException {
        this.setDate(this.colNameToIndex(column), d);
    }

    @Override
    public Time getTime(int column, Calendar calendar) throws RowsException {
        this.prepareAccess(column);
        Timestamp obj = (Timestamp)this.getValue(column, DataType.DATETIME, true);
        if (obj != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(obj);
            calendar.set(11, cal.get(11));
            calendar.set(12, cal.get(12));
            calendar.set(13, cal.get(13));
            return new Time(calendar.getTime().getTime());
        }
        return null;
    }

    @Override
    public Time getTime(int column) throws RowsException {
        return this.getTime(column, Calendar.getInstance());
    }

    @Override
    public Time getTime(String column, Calendar cal) throws RowsException {
        return this.getTime(this.colNameToIndex(column), cal);
    }

    @Override
    public Time getTime(String column) throws RowsException {
        return this.getTime(this.colNameToIndex(column));
    }

    @Override
    public void setTime(int column, Time d) throws RowsException {
        this.prepareAccess(column);
        this.setValue(column, new Timestamp(d.getTime()), DataType.DATETIME, true);
    }

    @Override
    public void setTime(String column, Time d) throws RowsException {
        this.setTime(this.colNameToIndex(column), d);
    }

    @Override
    public Timestamp getTimestamp(int column, Calendar calendar) throws RowsException {
        this.prepareAccess(column);
        Timestamp obj = (Timestamp)this.getValue(column, DataType.DATETIME, true);
        if (obj != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(obj);
            calendar.set(1, cal.get(1));
            calendar.set(2, cal.get(2));
            calendar.set(5, cal.get(5));
            calendar.set(11, cal.get(11));
            calendar.set(12, cal.get(12));
            calendar.set(13, cal.get(13));
            return new Timestamp(calendar.getTime().getTime());
        }
        return null;
    }

    @Override
    public Timestamp getTimestamp(int column) throws RowsException {
        return this.getTimestamp(column, Calendar.getInstance());
    }

    @Override
    public Timestamp getTimestamp(String column, Calendar cal) throws RowsException {
        return this.getTimestamp(this.colNameToIndex(column), cal);
    }

    @Override
    public Timestamp getTimestamp(String column) throws RowsException {
        return this.getTimestamp(this.colNameToIndex(column));
    }

    @Override
    public void setTimestamp(int column, Timestamp d) throws RowsException {
        this.prepareAccess(column);
        this.setValue(column, new Timestamp(d.getTime()), DataType.DATETIME, true);
    }

    @Override
    public void setTimestamp(String column, Timestamp d) throws RowsException {
        this.setTimestamp(this.colNameToIndex(column), d);
    }

    @Override
    public byte[] getBytes(int column) throws RowsException {
        this.prepareAccess(column);
        return (byte[])this.getValue(column, DataType.BINARY, true);
    }

    @Override
    public byte[] getBytes(String column) throws RowsException {
        return this.getBytes(this.colNameToIndex(column));
    }

    @Override
    public void setBytes(int column, byte[] bs) throws RowsException {
        this.prepareAccess(column);
        this.setValue(column, bs, DataType.BINARY, true);
    }

    @Override
    public void setBytes(String column, byte[] bs) throws RowsException {
        this.setBytes(this.colNameToIndex(column), bs);
    }

    private final Object getValue(int column, DataType targetType, boolean convertNullValue) throws RowsException {
        Object data = this.row.getValue(column);
        boolean bl = this.lastValueNull = data == null;
        if (convertNullValue || !this.lastValueNull) {
            return SimpleRows.convertData(data, this.meta.getColumnType(column), targetType);
        }
        return data;
    }

    private final void setValue(int column, Object data, DataType dataType, boolean convertNullValue) throws RowsException {
        if (convertNullValue || data != null) {
            this.row.setValue(column, SimpleRows.convertData(data, dataType, this.meta.getColumnType(column)));
        } else {
            this.row.setValue(column, null);
        }
    }

    private static final Object convertData(Object data, DataType originalType, DataType targetType) throws RowsException {
        try {
            return DataConvertHelper.convertData(data, originalType, targetType);
        }
        catch (DataConvertHelper.DataConvertException e) {
            return new RowsException(e.getMessage());
        }
    }

    private final void prepareAccess(int column) throws RowsException {
        this.checkStatus(true);
        this.checkColumnIndex(column);
        this.ensureCurrentRow();
    }
}

