/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.data.framework.connection;

import com.kingdee.bos.ctrl.bizshare.IConnection;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.data.framework.connection.BosConnection;
import com.kingdee.bos.ctrl.data.framework.connection.CommonConnection;
import com.kingdee.bos.ctrl.data.framework.connection.DBConnection;
import com.kingdee.bos.ctrl.data.framework.connection.DSConfig;
import com.kingdee.bos.ctrl.data.framework.connection.DataSourceType;
import com.kingdee.bos.ctrl.data.modal.IDefObj;
import com.kingdee.bos.ctrl.data.modal.io.Def2Xml;
import com.kingdee.bos.ctrl.data.modal.io.Xml2Def;
import java.util.Locale;
import org.jdom2.Content;
import org.jdom2.Element;

public class DSConfigIO {
    public static final String T_DATA_SOURCE = "DataSource";
    public static final String A_TYPE = "type";
    public static final String T_BOS_CONNECTION = "BOSConnection";
    public static final String A_SERVICE_URL = "serviceUrl";
    public static final String A_SOLUTION = "solution";
    public static final String A_AIS = "ais";
    public static final String A_USER = "user";
    public static final String A_PASSWORD = "password";
    public static final String A_LOCALE = "locale";
    public static final String T_DB_CONNECTION = "DBConnection";
    public static final String A_DB_NAME = "dbName";
    public static final String A_DB_TYPE = "dbType";
    public static final String T_OLAP_CONNECTION = "OlapConnection";

    public static Element makeDataSource(DSConfig ds) {
        Element xmlDS = new Element(T_DATA_SOURCE);
        Def2Xml.makeDefObj((IDefObj)ds, (Element)xmlDS);
        DataSourceType dsType = ds.getDSType();
        xmlDS.setAttribute(A_TYPE, dsType.getName());
        IConnection conn = ds.getConnection();
        if (conn != null) {
            if (DataSourceType.DB == dsType) {
                xmlDS.addContent((Content)DSConfigIO.makeDBConn((DBConnection)ds.getConnection()));
            } else if (DataSourceType.BOS == dsType) {
                xmlDS.addContent((Content)DSConfigIO.makeBOSConn((BosConnection)ds.getConnection()));
            } else {
                xmlDS.addContent((Content)DSConfigIO.makeCommonConn((CommonConnection)ds.getConnection()));
            }
        }
        return xmlDS;
    }

    public static Element makeCommonConn(CommonConnection conn) {
        return conn.getXml();
    }

    public static Element makeBOSConn(BosConnection conn) {
        Element xmlConn = new Element(T_BOS_CONNECTION);
        DSConfigIO.setBOSConnAttr(xmlConn, conn);
        return xmlConn;
    }

    public static void replaceBOSConnAttr(Element xmlDS, BosConnection conn) {
        Element xmlConn = xmlDS.getChild(T_BOS_CONNECTION);
        if (xmlConn == null) {
            xmlConn = new Element(T_BOS_CONNECTION);
            xmlDS.addContent((Content)xmlConn);
        }
        DSConfigIO.setBOSConnAttr(xmlConn, conn);
    }

    private static void setBOSConnAttr(Element xmlConn, BosConnection conn) {
        xmlConn.setAttribute(A_SERVICE_URL, conn.getServiceUrl());
        xmlConn.setAttribute(A_SOLUTION, conn.getSolution());
        xmlConn.setAttribute(A_AIS, conn.getAis());
        xmlConn.setAttribute(A_USER, conn.getUser());
        xmlConn.setAttribute(A_PASSWORD, conn.getPassword());
        xmlConn.setAttribute(A_LOCALE, DSConfigIO.encodeLocale(conn.getLocale()));
    }

    public static Element makeDBConn(DBConnection conn) {
        Element xmlConn = new Element(T_DB_CONNECTION);
        DSConfigIO.setDBConnAttr(xmlConn, conn);
        return xmlConn;
    }

    public static void replaceDBConnAttr(Element xmlDS, DBConnection conn) {
        Element xmlConn = xmlDS.getChild(T_DB_CONNECTION);
        if (xmlConn == null) {
            xmlConn = new Element(T_DB_CONNECTION);
            xmlDS.addContent((Content)xmlConn);
        }
        DSConfigIO.setDBConnAttr(xmlConn, conn);
    }

    private static void setDBConnAttr(Element xmlConn, DBConnection conn) {
        xmlConn.setAttribute(A_SERVICE_URL, conn.getServiceUrl());
        xmlConn.setAttribute(A_DB_TYPE, conn.getDBType());
        xmlConn.setAttribute(A_DB_NAME, conn.getDBName());
        xmlConn.setAttribute(A_USER, conn.getUser());
        xmlConn.setAttribute(A_PASSWORD, conn.getPassword());
    }

    public static DSConfig parseDataSource(Element xmlDS) {
        DSConfig ds = new DSConfig();
        Xml2Def.parseDefObj((IDefObj)ds, (Element)xmlDS);
        DataSourceType dsType = DataSourceType.fromName(xmlDS.getAttributeValue(A_TYPE));
        ds.setDSType(dsType);
        if (DataSourceType.DB == dsType) {
            ds.setConnection((IConnection)DSConfigIO.parseDBConn(xmlDS.getChild(T_DB_CONNECTION)));
        } else if (DataSourceType.BOS == dsType) {
            ds.setConnection((IConnection)DSConfigIO.parseBOSConn(xmlDS.getChild(T_BOS_CONNECTION)));
        } else if (DataSourceType.OLAP == dsType) {
            ds.setConnection((IConnection)DSConfigIO.parseCommonConn(xmlDS.getChild(T_OLAP_CONNECTION)));
        }
        return ds;
    }

    public static Locale decodeLocale(String s) {
        int i = s.indexOf("_");
        if (i == -1) {
            return new Locale(s);
        }
        return new Locale(s.substring(0, i), s.substring(i + 1));
    }

    public static String encodeLocale(Locale l) {
        if (StringUtil.isEmptyString((String)l.getCountry())) {
            return l.getLanguage();
        }
        return l.getLanguage() + "_" + l.getCountry();
    }

    public static BosConnection parseBOSConn(Element xmlConn) {
        if (xmlConn == null) {
            return null;
        }
        String svcUrl = xmlConn.getAttributeValue(A_SERVICE_URL);
        String solution = xmlConn.getAttributeValue(A_SOLUTION);
        String ais = xmlConn.getAttributeValue(A_AIS);
        String user = xmlConn.getAttributeValue(A_USER);
        String psw = xmlConn.getAttributeValue(A_PASSWORD);
        String l = xmlConn.getAttributeValue(A_LOCALE);
        return new BosConnection(svcUrl, solution, ais, user, psw, DSConfigIO.decodeLocale(l));
    }

    public static CommonConnection parseCommonConn(Element xmlConn) {
        if (xmlConn == null) {
            return null;
        }
        return new CommonConnection(xmlConn);
    }

    public static DBConnection parseDBConn(Element xmlConn) {
        if (xmlConn == null) {
            return null;
        }
        String svcUrl = xmlConn.getAttributeValue(A_SERVICE_URL);
        String dbType = xmlConn.getAttributeValue(A_DB_TYPE);
        String dbName = xmlConn.getAttributeValue(A_DB_NAME);
        String user = xmlConn.getAttributeValue(A_USER);
        String psw = xmlConn.getAttributeValue(A_PASSWORD);
        return new DBConnection(dbType, svcUrl, dbName, user, psw);
    }
}

