/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.data.framework.datasource;

import com.kingdee.bos.ctrl.bizshare.ConnectException;
import com.kingdee.bos.ctrl.common.FullPath;
import com.kingdee.bos.ctrl.data.DataDefType;
import com.kingdee.bos.ctrl.data.framework.bos.BosExecutor;
import com.kingdee.bos.ctrl.data.framework.connection.BosConnection;
import com.kingdee.bos.ctrl.data.framework.connection.DataSourceType;
import com.kingdee.bos.ctrl.data.framework.datasource.ADataSource;
import com.kingdee.bos.ctrl.data.framework.datasource.DataSourceException;
import com.kingdee.bos.ctrl.data.framework.datasource.IDataSource;
import com.kingdee.bos.ctrl.data.invoke.IDataExecutor;
import com.kingdee.bos.ctrl.data.modal.query.IQuery;
import com.kingdee.bos.ctrl.data.modal.query.QueryType;
import java.sql.ResultSet;
import java.util.HashMap;

public class BmdDataSource
extends ADataSource
implements IDataSource {
    private BosConnection conn;
    private BosExecutor executor;

    public BmdDataSource(BosConnection conn) {
        this.conn = conn;
    }

    private final void checkConnection() throws DataSourceException {
        if (this.conn.isClosed()) {
            try {
                this.conn.open();
            }
            catch (ConnectException ex) {
                throw new DataSourceException("Couldn't connect to the specified datasource:'" + this.getName() + "'");
            }
        }
    }

    private final BosExecutor getExecutor() {
        if (this.executor == null) {
            this.executor = BosExecutor.getRemoteInstance();
        }
        return this.executor;
    }

    @Override
    public Object execute(String category, Object object, HashMap args, IDataExecutor externalExec) throws Exception {
        if (object instanceof IQuery) {
            IQuery xquery = (IQuery)object;
            QueryType type = xquery.getQueryType();
            this.checkType(QueryType.BOS_QUERY == type || QueryType.BOS_ENTITY == type);
            this.checkConnection();
            try {
                if (QueryType.BOS_QUERY == type) {
                    FullPath fp = new FullPath();
                    String pk = xquery.getContent();
                    fp.setPathx(pk, DataDefType.BOS_QUERY.getName());
                    return (ResultSet)this.getExecutor().execute(null, fp, null, null);
                }
                if (QueryType.BOS_ENTITY == type) {
                    FullPath fp = new FullPath();
                    String pk = xquery.getContent();
                    fp.setPathx(pk, DataDefType.BOS_ENTITY.getName());
                    return (ResultSet)this.getExecutor().execute(null, fp, null, null);
                }
            }
            catch (Exception ex) {
                throw new DataSourceException(ex);
            }
        }
        this.checkType(false);
        return null;
    }

    @Override
    public DataSourceType getDSType() {
        return DataSourceType.BOS;
    }
}

