/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.data.modal.query.io;

import com.kingdee.bos.ctrl.common.FullPath;
import com.kingdee.bos.ctrl.data.DataDefType;
import com.kingdee.bos.ctrl.data.meta.MetaClass;
import com.kingdee.bos.ctrl.data.meta.MetaField;
import com.kingdee.bos.ctrl.data.modal.IDefObj;
import com.kingdee.bos.ctrl.data.modal.INameSpace;
import com.kingdee.bos.ctrl.data.modal.StringNameSpace;
import com.kingdee.bos.ctrl.data.modal.query.BasicQuery;
import com.kingdee.bos.ctrl.data.modal.query.Column;
import com.kingdee.bos.ctrl.data.modal.query.IQuery;
import com.kingdee.bos.ctrl.data.modal.query.IQueryObjList;
import com.kingdee.bos.ctrl.data.modal.query.ITable;
import com.kingdee.bos.ctrl.data.modal.query.QueryType;
import com.kingdee.bos.ctrl.data.modal.query.Table;
import java.util.Iterator;

public class Meta2Query {
    public IQuery transform(MetaClass mc) {
        String category = mc.getType();
        if (DataDefType.BOS_QUERY.getName().equals(category)) {
            return Meta2Query.makeBosQueryDef(mc);
        }
        if (DataDefType.DB_TABLE.getName().equals(category) || DataDefType.DB_VIEW.getName().equals(category)) {
            return Meta2Query.makeDBTableDef(mc);
        }
        if (DataDefType.BOS_ENTITY.getName().equals(category)) {
            return Meta2Query.makeBosEntityDef(mc);
        }
        return null;
    }

    public static IQuery toQuery(MetaClass mc) {
        return new Meta2Query().transform(mc);
    }

    public static IQuery makeBosQueryDef(MetaClass cls) {
        IQuery query = BasicQuery.createQuery(QueryType.BOS_QUERY);
        Meta2Query.makeBasicQuery((BasicQuery)query, cls);
        query.setContent(cls.getExpr());
        return query;
    }

    public static IQuery makeBosEntityDef(MetaClass cls) {
        IQuery query = BasicQuery.createQuery(QueryType.BOS_ENTITY);
        Meta2Query.makeBasicQuery((BasicQuery)query, cls);
        return query;
    }

    public static IQuery makeDBTableDef(MetaClass cls) {
        IQuery query = BasicQuery.createQuery(QueryType.SQL_WIZARD);
        Meta2Query.makeBasicQuery((BasicQuery)query, cls);
        return query;
    }

    public static void makeBasicQuery(BasicQuery qd, MetaClass cls) {
        qd.copy((IDefObj)cls);
        if (cls.getNameSpace() != null) {
            qd.setNameSpace((INameSpace)new StringNameSpace(cls.getNameSpace().getString()));
        }
        Table tab = Meta2Query.makeTable(cls);
        if (qd.getTables() != null) {
            qd.getTables().add(tab);
        }
        Meta2Query.makeColumns(tab, cls.getFields().iterator(), qd.getColumns());
    }

    public static Table makeTable(MetaClass cls) {
        Table tab = new Table();
        tab.copy((IDefObj)cls);
        tab.setName(FullPath.cutCategory((String)cls.getName()));
        tab.setExpr(cls.getFullName());
        return tab;
    }

    public static void makeColumns(ITable tab, Iterator itrFld, IQueryObjList qoList) {
        while (itrFld.hasNext()) {
            Column col = Meta2Query.makeColumn(tab, (MetaField)itrFld.next());
            qoList.add((Object)col);
        }
    }

    public static Column makeColumn(ITable tab, MetaField fld) {
        Column col = new Column();
        col.copy((IDefObj)fld);
        col.setDataType(fld.getType());
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        sb.append(tab.getName());
        sb.append("].[");
        sb.append(fld.getName());
        sb.append("]");
        col.setExpr(sb.toString());
        return col;
    }
}

