/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.data.modal.query.io;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.data.modal.IDefObj;
import com.kingdee.bos.ctrl.data.modal.io.Def2Xml;
import com.kingdee.bos.ctrl.data.modal.io.Ext2Xml;
import com.kingdee.bos.ctrl.data.modal.query.Column;
import com.kingdee.bos.ctrl.data.modal.query.Condition;
import com.kingdee.bos.ctrl.data.modal.query.IQuery;
import com.kingdee.bos.ctrl.data.modal.query.IQueryObjList;
import com.kingdee.bos.ctrl.data.modal.query.ITable;
import com.kingdee.bos.ctrl.data.modal.query.Join;
import com.kingdee.bos.ctrl.data.modal.query.Order;
import com.kingdee.bos.ctrl.data.modal.query.Table;
import java.util.Iterator;
import org.jdom2.CDATA;
import org.jdom2.Content;
import org.jdom2.Element;

public class Query2Xml {
    public static final String T_QUERY = "Query";
    public static final String T_COLUMNS = "Columns";
    public static final String T_COLUMN = "Column";
    public static final String T_TABLES = "Tables";
    public static final String T_TABLE = "Table";
    public static final String T_JOINS = "Joins";
    public static final String T_JOIN = "Join";
    public static final String T_CONDITION = "Condition";
    public static final String T_ORDERS = "Orders";
    public static final String T_ORDER = "Order";
    public static final String T_FILTER = "Filter";
    public static final String T_CONTENT = "Content";
    public static final String A_DISTINCT = "distinct";
    public static final String A_LEFT_TABLE = "leftTable";
    public static final String A_JOIN_TYPE = "joinType";
    public static final String A_RIGHT_TABLE = "rightTable";
    public static final String A_ORDER_TYPE = "orderType";
    public static final String V_VERSION = "1.0";
    public static final String V_ASC = "asc";
    public static final String V_DESC = "desc";

    public static Element toXml(IQuery obj) {
        Element e = new Element(T_QUERY);
        if (obj != null) {
            Def2Xml.makeDefObj((IDefObj)obj, (Element)e);
            e.setAttribute("version", V_VERSION);
            if (obj.getQueryType() != null) {
                e.setAttribute("type", obj.getQueryType().getName());
            }
            if (obj.isDistinct()) {
                e.setAttribute(A_DISTINCT, Boolean.toString(obj.isDistinct()));
            }
            e.addContent((Content)Query2Xml.makeColumns(obj.getColumns()));
            e.addContent((Content)Query2Xml.makeTables(obj.getTables()));
            e.addContent((Content)Query2Xml.makeJoins(obj.getJoins()));
            e.addContent((Content)Query2Xml.makeOrders(obj.getOrders()));
            e.addContent((Content)Query2Xml.makeFilter(obj.getFilter()));
            e.addContent((Content)Query2Xml.makeContent(obj.getContent()));
        }
        return e;
    }

    public static void makeQueryExt(IQuery qry, Element xmlQry, Ext2Xml ext2xml) {
        if (qry.getQueryType().getCapital().equalsIgnoreCase("sql")) {
            Iterator xmlItr = xmlQry.getChild(T_TABLES).getChildren().iterator();
            Iterator objItr = qry.getTables().iterator();
            while (objItr.hasNext()) {
                ITable tbl = (ITable)objItr.next();
                Element tblXmlNode = (Element)xmlItr.next();
                ext2xml.makeExtObj(tbl.getExtObj(), tblXmlNode);
                if (!(tbl instanceof IQuery)) continue;
                Query2Xml.makeQueryExt((IQuery)((Object)tbl), tblXmlNode, ext2xml);
            }
            xmlItr = xmlQry.getChild(T_JOINS).getChildren(T_JOIN).iterator();
            objItr = qry.getJoins().iterator();
            while (objItr.hasNext()) {
                ext2xml.makeExtObj(((Join)((Object)objItr.next())).getCondition().getExtObj(), (Element)((Element)xmlItr.next()).getChildren().get(0));
            }
            ext2xml.makeExtObj(qry.getFilter().getExtObj(), xmlQry.getChild(T_FILTER));
        }
    }

    public static Element makeColumns(IQueryObjList cols) {
        Element xmlCols = new Element(T_COLUMNS);
        if (cols != null) {
            int len = cols.size();
            for (int i = 0; i < len; ++i) {
                xmlCols.addContent((Content)Query2Xml.makeColumn((Column)((Object)cols.get(i))));
            }
        }
        return xmlCols;
    }

    public static Element makeColumn(Column col) {
        Element xmlCol = new Element(T_COLUMN);
        if (col != null) {
            String s;
            Def2Xml.makeDefObj((IDefObj)col, (Element)xmlCol);
            if (col.getDataType() != null) {
                xmlCol.setAttribute("dataType", col.getDataType().getName());
            }
            if (!StringUtil.isEmptyString((String)(s = col.getExpr()))) {
                xmlCol.setAttribute("expr", s);
            }
        }
        return xmlCol;
    }

    public static Element makeTables(IQueryObjList tbls) {
        Element xmlTbls = new Element(T_TABLES);
        if (tbls != null) {
            int len = tbls.size();
            for (int i = 0; i < len; ++i) {
                xmlTbls.addContent((Content)Query2Xml.makeTable((ITable)tbls.get(i)));
            }
        }
        return xmlTbls;
    }

    public static Element makeTable(ITable tbl) {
        Element xmlTbl = null;
        if (tbl instanceof Table) {
            xmlTbl = new Element(T_TABLE);
            Def2Xml.makeDefObj((IDefObj)tbl, (Element)xmlTbl);
            String s = tbl.getExpr();
            if (s != null) {
                xmlTbl.setAttribute("expr", s);
            }
        } else if (tbl instanceof IQuery) {
            xmlTbl = Query2Xml.toXml((IQuery)((Object)tbl));
        }
        return xmlTbl;
    }

    public static Element makeJoins(IQueryObjList joins) {
        Element xmlJoins = new Element(T_JOINS);
        if (joins != null) {
            int len = joins.size();
            for (int i = 0; i < len; ++i) {
                xmlJoins.addContent((Content)Query2Xml.makeJoin((Join)((Object)joins.get(i))));
            }
        }
        return xmlJoins;
    }

    public static Element makeJoin(Join join) {
        Element xmlJoin = new Element(T_JOIN);
        if (join != null) {
            xmlJoin.setAttribute(A_LEFT_TABLE, join.getLeftTable());
            xmlJoin.setAttribute(A_JOIN_TYPE, join.getJoinType().getName());
            xmlJoin.setAttribute(A_RIGHT_TABLE, join.getRightTable());
            xmlJoin.addContent((Content)Query2Xml.makeCondition(join.getCondition()));
        }
        return xmlJoin;
    }

    public static Element makeCondition(Condition condition) {
        Element xmlCondition = new Element(T_CONDITION);
        if (condition != null) {
            xmlCondition.addContent((Content)new CDATA(condition.getExpr()));
        }
        return xmlCondition;
    }

    public static Element makeOrders(IQueryObjList ords) {
        Element xmlOrds = new Element(T_ORDERS);
        if (ords != null) {
            int len = ords.size();
            for (int i = 0; i < len; ++i) {
                xmlOrds.addContent((Content)Query2Xml.makeOrder((Order)((Object)ords.get(i))));
            }
        }
        return xmlOrds;
    }

    public static Element makeOrder(Order ord) {
        Element xmlOrd = new Element(T_ORDER);
        if (ord != null) {
            Def2Xml.makeDefObj((IDefObj)ord, (Element)xmlOrd);
            String s = ord.getExpr();
            if (s != null) {
                xmlOrd.setAttribute("expr", s);
            }
            xmlOrd.setAttribute(A_ORDER_TYPE, ord.isAscending() ? V_ASC : V_DESC);
        }
        return xmlOrd;
    }

    public static Element makeFilter(Condition flt) {
        Element xml = new Element(T_FILTER);
        if (flt != null) {
            xml.addContent((Content)new CDATA(flt.getExpr()));
        }
        return xml;
    }

    public static Element makeContent(String content) {
        Element xml = new Element(T_CONTENT);
        xml.addContent((Content)new CDATA(content));
        return xml;
    }
}

