/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.data.process.dataset.crosstab;

import com.kingdee.bos.ctrl.data.process.dataset.crosstab.BasicRotateAcross;
import com.kingdee.bos.ctrl.data.process.dataset.crosstab.CrosstabInfo;
import com.kingdee.bos.ctrl.data.process.dataset.crosstab.HeaderAxis;
import com.kingdee.bos.ctrl.data.process.dataset.crosstab.HeaderMember;
import com.kingdee.bos.olap.Axis;
import com.kingdee.bos.olap.Cell;
import com.kingdee.bos.olap.Cube;
import com.kingdee.bos.olap.Dimension;
import com.kingdee.bos.olap.Member;
import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.Position;
import com.kingdee.bos.olap.Query;
import com.kingdee.bos.olap.Result;
import com.kingdee.bos.olap.collection.IMemberList;
import com.kingdee.bos.olap.dbsource.ResultSetTable;
import com.kingdee.bos.olap.dbsource.Table;
import com.kingdee.bos.olap.def.CubeDef;
import com.kingdee.bos.olap.def.CubeDimensionDef;
import com.kingdee.bos.olap.def.HierarchyDef;
import com.kingdee.bos.olap.def.LevelDef;
import com.kingdee.bos.olap.def.MeasureDef;
import com.kingdee.bos.olap.def.ParameterDef;
import com.kingdee.bos.olap.def.PropertyDef;
import com.kingdee.bos.olap.def.SchemaDef;
import com.kingdee.bos.olap.def.SharedDimensionDef;
import com.kingdee.bos.olap.mem.CubeData;
import com.kingdee.bos.olap.mem.OLAPDatabase;
import com.kingdee.bos.olap.mem.OLAPEngine;
import com.kingdee.bos.olap.mem.impl.ResultImpl;
import com.kingdee.bos.olap.query.BasicMemberSet;
import com.kingdee.bos.olap.query.CrossJoin;
import com.kingdee.bos.olap.query.MemberSet;
import com.kingdee.bos.olap.query.OLAPQuery;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;

public class SimpleRotateAcross
extends BasicRotateAcross {
    private static String TOTAL_FIELD_suffix = "_total_suffix_0728";
    private String tableName = "s..t..";

    @Override
    public CrosstabInfo calcCrosstab(ResultSet rowset0, int[] horizontal_defs, String[] xDisplayNames, String[] xColsOrders, int[] vertical_defs, String[] yDisplayNames, String[] yColsOrders, int[] columns, String[] columnNames, String[] aggregates, boolean putToHorizontal, boolean totalAllX, boolean totalAllY) throws SQLException {
        int i;
        if (horizontal_defs == null || horizontal_defs.length == 0) {
            throw new IllegalArgumentException();
        }
        if (vertical_defs == null || vertical_defs.length == 0) {
            throw new IllegalArgumentException();
        }
        if (columns == null || columns.length == 0) {
            throw new IllegalArgumentException();
        }
        if (aggregates == null || aggregates.length == 0) {
            throw new IllegalArgumentException();
        }
        if (xColsOrders == null || xColsOrders.length == 0) {
            throw new IllegalArgumentException();
        }
        if (yColsOrders == null || yColsOrders.length == 0) {
            throw new IllegalArgumentException();
        }
        ResultSetMetaData rsmd = rowset0.getMetaData();
        ArrayList<String> list = new ArrayList<String>();
        ArrayList<String> listOrders = new ArrayList<String>();
        String[] leftDims = new String[vertical_defs.length];
        String[] topDims = new String[horizontal_defs.length];
        for (i = 0; i < vertical_defs.length; ++i) {
            leftDims[i] = rsmd.getColumnName(vertical_defs[i]);
            list.add(leftDims[i]);
            listOrders.add(yColsOrders[i]);
        }
        for (i = 0; i < horizontal_defs.length; ++i) {
            topDims[i] = rsmd.getColumnName(horizontal_defs[i]);
            list.add(topDims[i]);
            listOrders.add(xColsOrders[i]);
        }
        String[] dimnames = new String[list.size()];
        String[] orders = new String[listOrders.size()];
        list.toArray(dimnames);
        listOrders.toArray(orders);
        String[] measurenames = new String[columns.length];
        for (int i2 = 0; i2 < columns.length; ++i2) {
            measurenames[i2] = rsmd.getColumnName(columns[i2]);
        }
        try {
            SchemaDef schema = this.makeSchema(rsmd, dimnames, orders, measurenames, aggregates, this.tableName);
            Table table = this.makeTable(rowset0);
            CubeData cd = this.makeCubeData(schema, table);
            Cube cube = cd.cube;
            BasicMemberSet leftSet = new BasicMemberSet(this.collectMembers(cube.getDimension(leftDims[0]), yColsOrders[0]));
            for (int i3 = 1; i3 < leftDims.length; ++i3) {
                leftSet = new CrossJoin((MemberSet)leftSet, (MemberSet)new BasicMemberSet(this.collectMembers(cube.getDimension(leftDims[i3]), yColsOrders[i3])));
            }
            leftSet = this.trimMemberSet((MemberSet)leftSet);
            if (measurenames.length > 1 && !putToHorizontal) {
                leftSet = new CrossJoin((MemberSet)leftSet, (MemberSet)new BasicMemberSet(cube.getMeasures()));
            }
            BasicMemberSet topSet = new BasicMemberSet(this.collectMembers(cube.getDimension(topDims[0]), xColsOrders[0]));
            for (int i4 = 1; i4 < topDims.length; ++i4) {
                topSet = new CrossJoin((MemberSet)topSet, (MemberSet)new BasicMemberSet(this.collectMembers(cube.getDimension(topDims[i4]), xColsOrders[i4])));
            }
            topSet = this.trimMemberSet((MemberSet)topSet);
            if (measurenames.length > 1 && putToHorizontal) {
                topSet = new CrossJoin((MemberSet)topSet, (MemberSet)new BasicMemberSet(cube.getMeasures()));
            }
            MemberSet[] sets = new MemberSet[]{topSet, leftSet};
            OLAPQuery query = new OLAPQuery(cube, sets, null);
            ResultImpl result = new ResultImpl(cd, (Query)query);
            return this.generateCrosstab((Result)result);
        }
        catch (OLAPException e) {
            if (e.getCause() instanceof SQLException) {
                throw (SQLException)e.getCause();
            }
            throw new SQLException(e.getMessage());
        }
    }

    private CrosstabInfo generateCrosstab(Result result) throws OLAPException {
        int i;
        Axis[] axes = result.getAxes();
        Axis hAxis = axes[0];
        Axis vAxis = axes[1];
        Position[] ps = hAxis.positions();
        String[] hFieldNames = null;
        String[] vFieldNames = null;
        HeaderMember[] horizonal_hm = new HeaderMember[ps.length];
        for (int i2 = 0; i2 < ps.length; ++i2) {
            Member[] ms = ps[i2].members();
            if (i2 == 0) {
                hFieldNames = new String[ms.length];
            }
            String[] fields = new String[ms.length];
            for (int j = 0; j < ms.length; ++j) {
                Dimension dim;
                fields[j] = ms[j].getName();
                if (i2 != 0 || (dim = ms[j].getDimension()).isMeasureDimension()) continue;
                hFieldNames[j] = dim.getName();
            }
            horizonal_hm[i2] = new HeaderMember(fields);
        }
        ps = vAxis.positions();
        HeaderMember[] vertical_hm = new HeaderMember[ps.length];
        for (int i3 = 0; i3 < ps.length; ++i3) {
            Member[] ms = ps[i3].members();
            if (i3 == 0) {
                vFieldNames = new String[ms.length];
            }
            String[] fields = new String[ms.length];
            for (int j = 0; j < ms.length; ++j) {
                Dimension dim;
                fields[j] = ms[j].getName();
                if (i3 != 0 || (dim = ms[j].getDimension()).isMeasureDimension()) continue;
                vFieldNames[j] = dim.getName();
            }
            vertical_hm[i3] = new HeaderMember(fields);
        }
        Object[][] values = new Object[horizonal_hm.length][vertical_hm.length];
        for (i = 0; i < horizonal_hm.length; ++i) {
            for (int j = 0; j < vertical_hm.length; ++j) {
                Cell cell = result.getCell(i, j);
                values[i][j] = cell.getValue();
            }
        }
        if (hFieldNames != null) {
            for (i = 0; i < hFieldNames.length; ++i) {
                if (hFieldNames[i] == null) continue;
                hFieldNames[i] = this.xColsDisplay[i];
            }
        } else {
            hFieldNames = this.xColsDisplay;
        }
        if (vFieldNames != null) {
            for (i = 0; i < vFieldNames.length; ++i) {
                if (vFieldNames[i] == null) continue;
                vFieldNames[i] = this.yColsDisplay[i];
            }
        } else {
            vFieldNames = this.yColsDisplay;
        }
        if (this.crossCols.length > 1) {
            if (this.putTotalColsToX) {
                for (i = 0; i < horizonal_hm.length; ++i) {
                    String[] fields = horizonal_hm[i].fields;
                    fields[fields.length - 1] = (String)this.colsDisplayMap.get(fields[fields.length - 1]);
                }
            } else {
                for (i = 0; i < vertical_hm.length; ++i) {
                    String[] fields = vertical_hm[i].fields;
                    fields[fields.length - 1] = (String)this.colsDisplayMap.get(fields[fields.length - 1]);
                }
            }
        }
        HeaderMember[][] hmss = new HeaderMember[][]{horizonal_hm, vertical_hm};
        for (int i4 = 0; i4 < hmss.length; ++i4) {
            HeaderMember[] hms = hmss[i4];
            for (int j = 0; j < hms.length; ++j) {
                String[] fields = hms[j].fields;
                String lastTitle = "";
                for (int t = 0; t < fields.length; ++t) {
                    if (fields[t] == null) continue;
                    boolean isTotalField = fields[t].endsWith(TOTAL_FIELD_suffix);
                    if (isTotalField) {
                        int index = fields[t].lastIndexOf(TOTAL_FIELD_suffix);
                        String field = fields[t].substring(0, index);
                        if ((field = (String)this.colsDisplayMap.get(field)) == null) {
                            isTotalField = false;
                        }
                    }
                    if (!isTotalField) {
                        lastTitle = fields[t];
                        continue;
                    }
                    fields[t] = lastTitle + "\u5408\u8ba1";
                }
            }
        }
        HeaderAxis hHeaderAxis = new HeaderAxis(hFieldNames, horizonal_hm);
        HeaderAxis vHeaderAxis = new HeaderAxis(vFieldNames, vertical_hm);
        return new CrosstabInfo(hHeaderAxis, vHeaderAxis, values);
    }

    private MemberSet trimMemberSet(MemberSet set) {
        Position[] ps = set.positions();
        ArrayList<Position> list = new ArrayList<Position>();
        for (int i = 0; i < ps.length; ++i) {
            Member[] ms = ps[i].members();
            boolean a = false;
            boolean b = false;
            boolean c = false;
            for (int j = 0; j < ms.length; ++j) {
                if (!ms[j].isAll()) continue;
                if (!a) {
                    a = true;
                    if (j != ms.length - 1) continue;
                    c = true;
                    continue;
                }
                b = true;
                break;
            }
            if (a && !b && !c) continue;
            list.add(ps[i]);
        }
        return new BasicMemberSet(list.toArray(new Position[0]));
    }

    private Member[] collectMembers(Dimension dim, String order) {
        Member all = (Member)dim.getHierarchies()[0].getMembers().getFirst();
        IMemberList list = all.getChildMembers();
        Member[] ms = (Member[])list.toArray((Object[])new Member[0]);
        Member[] ms2 = new Member[ms.length + 1];
        System.arraycopy(ms, 0, ms2, 0, ms.length);
        ms2[ms.length] = all;
        return ms2;
    }

    private CubeData makeCubeData(SchemaDef schema, Table table) throws OLAPException {
        HashMap<String, Table> param = new HashMap<String, Table>();
        param.put(this.tableName, table);
        try {
            OLAPDatabase database = OLAPEngine.buildWithoutCheck((SchemaDef)schema, param);
            return database.getCubeData(database.schema.getCubes()[0]);
        }
        catch (SQLException e) {
            throw new OLAPException((Throwable)e);
        }
    }

    private Table makeTable(ResultSet rowset0) throws SQLException {
        return new ResultSetTable(rowset0);
    }

    private SchemaDef makeSchema(ResultSetMetaData rsmd, String[] dimColumnNames, String[] orders, String[] measureColumnNames, String[] aggs, String tableName) {
        SchemaDef schemaDef = new SchemaDef();
        schemaDef.name = "Kingdee OLAP";
        CubeDef cubeDef = new CubeDef();
        schemaDef.cubes = new CubeDef[1];
        schemaDef.cubes[0] = cubeDef;
        schemaDef.dimensions = new SharedDimensionDef[0];
        cubeDef.table = tableName;
        cubeDef.name = "Kingdee Cube";
        ParameterDef paraDef = new ParameterDef();
        paraDef.type = "Table";
        paraDef.name = tableName;
        schemaDef.parameters = new ParameterDef[1];
        schemaDef.parameters[0] = paraDef;
        CubeDimensionDef[] dims = new CubeDimensionDef[dimColumnNames.length];
        cubeDef.dimensions = dims;
        for (int j = 0; j < dimColumnNames.length; ++j) {
            CubeDimensionDef cubeDimDef = new CubeDimensionDef();
            HierarchyDef hierarchyDef = new HierarchyDef();
            cubeDimDef.hierarchies = new HierarchyDef[1];
            cubeDimDef.hierarchies[0] = hierarchyDef;
            hierarchyDef.name = cubeDimDef.name = dimColumnNames[j];
            hierarchyDef.hasAll = true;
            hierarchyDef.allMemberName = dimColumnNames[j] + TOTAL_FIELD_suffix;
            LevelDef levelDef = new LevelDef();
            levelDef.name = hierarchyDef.name;
            levelDef.column = hierarchyDef.name;
            if (orders[j] != null && orders[j].length() > 0) {
                levelDef.orderBy = levelDef.name;
                levelDef.orderMethod = orders[j];
            }
            levelDef.properties = new PropertyDef[0];
            hierarchyDef.levels = new LevelDef[1];
            hierarchyDef.levels[0] = levelDef;
            dims[j] = cubeDimDef;
        }
        MeasureDef[] measures = new MeasureDef[measureColumnNames.length];
        for (int i = 0; i < measureColumnNames.length; ++i) {
            MeasureDef olapMeasureDef = new MeasureDef();
            olapMeasureDef.aggregator = aggs[i];
            olapMeasureDef.column = olapMeasureDef.name = measureColumnNames[i];
            measures[i] = olapMeasureDef;
        }
        cubeDef.measures = measures;
        return schemaDef;
    }
}

