/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.data.process.dataset.group;

import java.io.Serializable;
import java.util.ArrayList;

public class GroupNode
implements Serializable {
    protected ArrayList subGroups;
    protected GroupNode parent;
    protected Object groupValue;
    protected transient Object[] totals;
    private int records;
    protected String groupPath;

    public GroupNode(Object data) {
        this.groupValue = data;
        this.records = -1;
    }

    public final int getLevel() {
        int level = 0;
        for (GroupNode p = this.parent; p != null; p = p.getParent()) {
            ++level;
        }
        return level;
    }

    public String toString() {
        String s = this.getParent() != null ? this.getParent().toString() + "-" + this.groupValue : "ROOT";
        return s;
    }

    public final int getRecords() {
        if (this.records != -1) {
            return this.records;
        }
        this.records = 0;
        if (this.subGroups != null) {
            for (int i = 0; i < this.subGroups.size(); ++i) {
                this.records += ((GroupNode)this.subGroups.get(i)).getRecords();
            }
        }
        return this.records;
    }

    public int getFirstRecord() {
        GroupNode brother;
        GroupNode parent = this.getParent();
        int from = parent.getFirstRecord();
        ArrayList brothers = parent.getSubGroups();
        for (int i = 0; i < brothers.size() && (brother = (GroupNode)brothers.get(i)) != this; ++i) {
            from += brother.getRecords();
        }
        return from;
    }

    public static final int[] getLastedGroupTag(GroupNode lastedGroup, int levels) {
        int[] tags = new int[levels + 1];
        for (int level = levels; level >= 1; --level) {
            ArrayList brothers = lastedGroup.getParent().getSubGroups();
            tags[level] = brothers.indexOf(lastedGroup) + 1;
            lastedGroup = lastedGroup.parent;
        }
        return tags;
    }

    public GroupNode createSubGroup(Object o) {
        GroupNode child = new GroupNode(o);
        if (this.subGroups == null) {
            this.subGroups = new ArrayList();
        }
        this.subGroups.add(child);
        child.parent = this;
        return child;
    }

    public final ArrayList getSubGroups() {
        return this.subGroups;
    }

    public final GroupNode getParent() {
        return this.parent;
    }

    public final void setData(Object data) {
        this.groupValue = data;
    }

    public final Object getData() {
        return this.groupValue;
    }

    public void addMemeber() {
        this.records = this.records == -1 ? 1 : ++this.records;
    }

    public Object[] getTotalResult() {
        return this.totals;
    }

    public void setTotalResult(Object[] totals) {
        this.totals = totals;
    }

    public String getGroupPath() {
        return this.groupPath;
    }

    public void setGroupPath(String groupPath) {
        this.groupPath = groupPath;
    }
}

