/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.data.process.dataset.group.resultset;

import com.kingdee.bos.ctrl.data.engine.resultset.IPersistent;
import com.kingdee.bos.ctrl.data.engine.resultset.IRowNode;
import com.kingdee.bos.ctrl.data.engine.resultset.SimpleRowNode;
import java.sql.ResultSet;

public class GroupTotalDetailsNode
extends SimpleRowNode
implements IRowNode {
    private boolean firstFecth = true;
    private boolean dataInvalid = true;
    private int leftRows;
    private int rowFrom;
    private String groupTagStr;
    private ResultSet persistentRS;

    public GroupTotalDetailsNode(ResultSet persistentRS, int rowFrom, String groupTagStr) {
        this(persistentRS, rowFrom, 0, groupTagStr);
    }

    public GroupTotalDetailsNode(ResultSet persistentRS, int rowFrom, int totalCount, String groupTagStr) {
        if (!IPersistent.class.isInstance(persistentRS)) {
            throw new UnsupportedOperationException();
        }
        this.persistentRS = persistentRS;
        this.rowFrom = rowFrom;
        this.leftRows = totalCount;
        this.groupTagStr = groupTagStr;
    }

    @Override
    public Object[] getRowData() {
        if (!this.dataInvalid) {
            return super.getRowData();
        }
        try {
            int colCount;
            this.ensureFirstFetch();
            if (this.rowData == null) {
                colCount = this.persistentRS.getMetaData().getColumnCount();
                this.rowData = new Object[colCount + (this.groupTagStr != null ? 1 : 0)];
                if (this.groupTagStr != null) {
                    this.rowData[colCount] = this.groupTagStr;
                }
            } else {
                colCount = this.rowData.length - (this.groupTagStr != null ? 1 : 0);
            }
            for (int i = 0; i < colCount; ++i) {
                this.rowData[i] = this.persistentRS.getObject(i + 1);
            }
            this.dataInvalid = false;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
        return this.rowData;
    }

    @Override
    public IRowNode nextRow() {
        try {
            this.ensureFirstFetch();
            this.dataInvalid = true;
            if (this.leftRows == 0) {
                return super.nextRow();
            }
            --this.leftRows;
            if (!this.persistentRS.next()) {
                return null;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
        return this;
    }

    public void addRows() {
        ++this.leftRows;
    }

    private final void ensureFirstFetch() throws Exception {
        if (this.firstFecth) {
            this.persistentRS.absolute(this.rowFrom);
            this.firstFecth = false;
            --this.leftRows;
        }
    }
}

