/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.base;

import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.transformation.step.BaseStep;
import java.util.LinkedList;

public class RowSet {
    public static final int ERR_NO_ERROR = 0;
    public static final int ERR_ROW_IS_BUSY = 1;
    private LinkedList set = new LinkedList();
    private boolean done = false;
    public int read_pointer;
    public int write_pointer;
    public int size_rowset = 0;
    public int empty_calls = 0;
    public int full_calls = 0;
    private String originStepName;
    private int originStepCopy;
    private String destinationStepName;
    private int destinationStepCopy;
    private BaseStep thread_from;
    private BaseStep thread_to;
    private int maxsize;

    public RowSet(int maxsize) {
        this.maxsize = maxsize;
    }

    public synchronized void putRow(Row r) {
        this.set.addLast(r);
        ++this.size_rowset;
    }

    public synchronized Row getRow() {
        Row r = (Row)this.set.getFirst();
        this.set.removeFirst();
        --this.size_rowset;
        return r;
    }

    public synchronized boolean isEmpty() {
        ++this.empty_calls;
        return this.size_rowset == 0;
    }

    public synchronized boolean isFull() {
        ++this.full_calls;
        return this.size_rowset >= this.maxsize;
    }

    public synchronized void setDone() {
        this.done = true;
    }

    public synchronized boolean isDone() {
        return this.done;
    }

    public String getOriginStepName() {
        return this.originStepName;
    }

    public int getOriginStepCopy() {
        return this.originStepCopy;
    }

    public String getDestinationStepName() {
        return this.destinationStepName;
    }

    public int getDestinationStepCopy() {
        return this.destinationStepCopy;
    }

    public String getName() {
        return this.toString();
    }

    public synchronized int size() {
        return this.set.size();
    }

    public void setThreadNameFromToCopy(String from, int from_copy, String to, int to_copy) {
        this.originStepName = from;
        this.originStepCopy = from_copy;
        this.destinationStepName = to;
        this.destinationStepCopy = to_copy;
    }

    public void setThreadFromTo(BaseStep from, BaseStep to) {
        this.thread_from = from;
        this.thread_to = to;
    }

    public boolean waitFrom() {
        try {
            this.thread_from.waiting = true;
            this.thread_from.wait();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean waitTo() {
        try {
            this.thread_to.waiting = true;
            this.thread_to.wait();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean notifyFrom() {
        if (!this.thread_from.waiting) {
            return true;
        }
        try {
            this.thread_from.notifyAll();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean notifyTo() {
        if (!this.thread_to.waiting) {
            return true;
        }
        try {
            this.thread_to.notifyAll();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean setPriorityFrom(int prior) {
        if (this.thread_from == null || this.thread_from.getPriority() == prior || !this.thread_from.isAlive()) {
            return true;
        }
        try {
            this.thread_from.setPriority(prior);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean setPriorityTo(int prior) {
        if (this.thread_to == null || this.thread_to.getPriority() == prior || !this.thread_to.isAlive()) {
            return true;
        }
        try {
            this.thread_to.setPriority(prior);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean waitingThreadFrom() {
        return this.thread_from.waiting;
    }

    public boolean waitingThreadTo() {
        return this.thread_to.waiting;
    }

    public String toString() {
        return this.originStepName + "." + this.originStepCopy + " - " + this.destinationStepName + "." + this.destinationStepCopy;
    }
}

