/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.database;

import com.kingdee.bos.ctrl.etl.base.Result;
import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.cache.DBCache;
import com.kingdee.bos.ctrl.etl.cache.DBCacheEntry;
import com.kingdee.bos.ctrl.etl.database.DatabaseMeta;
import com.kingdee.bos.ctrl.etl.exception.ETLDatabaseBatchException;
import com.kingdee.bos.ctrl.etl.exception.ETLDatabaseException;
import com.kingdee.bos.ctrl.etl.transformation.TransMeta;
import com.kingdee.bos.ctrl.etl.util.Const;
import com.kingdee.bos.ctrl.etl.util.Counter;
import com.kingdee.bos.ctrl.etl.util.Counters;
import com.kingdee.bos.ctrl.etl.util.IProgressMonitor;
import com.kingdee.bos.ctrl.etl.util.LogWriter;
import com.kingdee.bos.ctrl.etl.value.Value;
import java.io.Reader;
import java.io.StringReader;
import java.sql.BatchUpdateException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Locale;

public class Database {
    private DatabaseMeta databaseMeta;
    private int rowlimit;
    private int commitsize;
    private Connection connection;
    private Statement sel_stmt;
    private PreparedStatement pstmt;
    private PreparedStatement prepStatementLookup;
    private PreparedStatement prepStatementUpdate;
    private PreparedStatement prepStatementInsert;
    private PreparedStatement pstmt_pun;
    private PreparedStatement pstmt_dup;
    private PreparedStatement pstmt_seq;
    private CallableStatement cstmt;
    private ResultSetMetaData rsmd;
    private DatabaseMetaData dbmd;
    private Row rowinfo;
    private int written;
    private LogWriter log = LogWriter.getInstance();
    private int batchCounter;
    private long testCounter = 0L;

    public Database(DatabaseMeta inf) {
        this.databaseMeta = inf;
        this.pstmt = null;
        this.rsmd = null;
        this.rowinfo = null;
        this.dbmd = null;
        this.rowlimit = 0;
        this.written = 0;
        this.log.logDetailed(this.toString(), "New database connection defined");
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setQueryLimit(int rows) {
        this.rowlimit = rows;
    }

    public PreparedStatement getPrepStatementInsert() {
        return this.prepStatementInsert;
    }

    public PreparedStatement getPrepStatementLookup() {
        return this.prepStatementLookup;
    }

    public PreparedStatement getPrepStatementUpdate() {
        return this.prepStatementUpdate;
    }

    public void connect() throws ETLDatabaseException {
        try {
            if (this.databaseMeta == null) {
                throw new ETLDatabaseException("No valid database connection defined!");
            }
            this.connection = this.databaseMeta.connect();
            this.log.logDetailed(this.toString(), "Connected to database.");
        }
        catch (Exception e) {
            throw new ETLDatabaseException("Error occured while trying to connect to the database", e);
        }
    }

    public void disconnect() {
        try {
            if (this.connection == null) {
                return;
            }
            if (this.connection.isClosed()) {
                return;
            }
            if (!this.isAutoCommit()) {
                this.commit();
            }
            if (this.pstmt != null) {
                this.pstmt.close();
                this.pstmt = null;
            }
            if (this.prepStatementLookup != null) {
                this.prepStatementLookup.close();
                this.prepStatementLookup = null;
            }
            if (this.prepStatementInsert != null) {
                this.prepStatementInsert.close();
                this.prepStatementInsert = null;
            }
            if (this.prepStatementUpdate != null) {
                this.prepStatementUpdate.close();
                this.prepStatementUpdate = null;
            }
            if (this.pstmt_seq != null) {
                this.pstmt_seq.close();
                this.pstmt_seq = null;
            }
            if (this.connection != null) {
                this.databaseMeta.close(this.connection);
                this.connection = null;
            }
            this.log.logDetailed(this.toString(), "Connection to database closed!");
        }
        catch (SQLException ex) {
            this.log.logError(this.toString(), "Error disconnecting from database:" + Const.CR + ex.getMessage());
        }
        catch (ETLDatabaseException dbe) {
            this.log.logError(this.toString(), "Error disconnecting from database:" + Const.CR + dbe.getMessage());
        }
    }

    public void cancelQuery() throws ETLDatabaseException {
        try {
            if (this.pstmt != null) {
                this.pstmt.cancel();
            }
            if (this.sel_stmt != null) {
                this.sel_stmt.cancel();
            }
            this.log.logDetailed(this.toString(), "Open query canceled!");
        }
        catch (SQLException ex) {
            throw new ETLDatabaseException("Error cancelling query", ex);
        }
    }

    public void setCommit(int commsize) {
        this.commitsize = commsize;
        String onOff = this.commitsize <= 0 ? "on" : "off";
        try {
            this.connection.setAutoCommit(this.commitsize <= 0);
            this.log.logDetailed(this.toString(), "Auto commit " + onOff);
        }
        catch (Exception e) {
            this.log.logError(this.toString(), "Can't turn auto commit " + onOff);
        }
    }

    public void commit() throws ETLDatabaseException {
        block4: {
            try {
                if (this.getDatabaseMetaData().supportsTransactions()) {
                    this.connection.commit();
                } else {
                    this.log.logDetailed(this.toString(), "No commit possible on database connection [" + this.toString() + "]");
                }
            }
            catch (Exception e) {
                if (!this.databaseMeta.supportsEmptyTransactions()) break block4;
                throw new ETLDatabaseException("Error comitting connection", e);
            }
        }
    }

    public void rollback() throws ETLDatabaseException {
        try {
            if (this.getDatabaseMetaData().supportsTransactions()) {
                this.connection.rollback();
            } else {
                this.log.logDetailed(this.toString(), "No rollback possible on database connection [" + this.toString() + "]");
            }
        }
        catch (SQLException e) {
            throw new ETLDatabaseException("Error performing rollback on connection", e);
        }
    }

    public void prepareInsert(Row r, String table) throws ETLDatabaseException {
        if (r.size() == 0) {
            throw new ETLDatabaseException("No fields in row, can't insert!");
        }
        String ins = this.getInsertStatement(table, r);
        this.log.logDetailed(this.toString(), "Preparing statement: " + Const.CR + ins);
        this.prepStatementInsert = this.prepareSQL(ins);
    }

    public PreparedStatement prepareSQL(String sql) throws ETLDatabaseException {
        try {
            return this.connection.prepareStatement(this.databaseMeta.stripCR(sql));
        }
        catch (SQLException ex) {
            throw new ETLDatabaseException("Couldn't prepare statement:" + Const.CR + sql, ex);
        }
    }

    public void closeLookup() throws ETLDatabaseException {
        this.closePreparedStatement(this.pstmt);
    }

    public void closePreparedStatement(PreparedStatement ps) throws ETLDatabaseException {
        if (ps != null) {
            try {
                ps.close();
            }
            catch (SQLException e) {
                throw new ETLDatabaseException("Error closing prepared statement", e);
            }
        }
    }

    public void closeInsert() throws ETLDatabaseException {
        if (this.prepStatementInsert != null) {
            try {
                this.prepStatementInsert.close();
                this.prepStatementInsert = null;
            }
            catch (SQLException e) {
                throw new ETLDatabaseException("Error closing insert prepared statement.", e);
            }
        }
    }

    public void closeUpdate() throws ETLDatabaseException {
        if (this.prepStatementUpdate != null) {
            try {
                this.prepStatementUpdate.close();
            }
            catch (SQLException e) {
                throw new ETLDatabaseException("Error closing update prepared statement.", e);
            }
        }
    }

    public void setValues(Row r) throws ETLDatabaseException {
        this.setValues(r, this.pstmt);
    }

    public void setValuesInsert(Row r) throws ETLDatabaseException {
        this.setValues(r, this.prepStatementInsert);
    }

    public void setValuesUpdate(Row r) throws ETLDatabaseException {
        this.setValues(r, this.prepStatementUpdate);
    }

    public void setValuesLookup(Row r) throws ETLDatabaseException {
        this.setValues(r, this.prepStatementLookup);
    }

    public void setProcValues(Row r, int[] argnrs, String[] argdir, boolean result) throws ETLDatabaseException {
        int pos = result ? 2 : 1;
        for (int i = 0; i < argnrs.length; ++i) {
            if (!argdir[i].equalsIgnoreCase("IN")) continue;
            Value v = r.getValue(argnrs[i]);
            this.setValue(this.cstmt, v, pos);
            ++pos;
        }
    }

    public void setValue(PreparedStatement ps, Value v, int pos) throws ETLDatabaseException {
        String debug = "";
        try {
            switch (v.getType()) {
                case 6: {
                    debug = "BigNumber";
                    if (!v.isNull()) {
                        ps.setBigDecimal(pos, v.getBigNumber());
                        break;
                    }
                    ps.setNull(pos, 3);
                    break;
                }
                case 1: {
                    debug = "Number";
                    if (!v.isNull()) {
                        double num = v.getNumber();
                        if (this.databaseMeta.supportsFloatRoundingOnUpdate() && v.getPrecision() >= 0) {
                            num = Const.round(num, v.getPrecision());
                        }
                        ps.setDouble(pos, num);
                        break;
                    }
                    ps.setNull(pos, 8);
                    break;
                }
                case 5: {
                    debug = "Integer";
                    if (!v.isNull()) {
                        if (this.databaseMeta.supportsSetLong()) {
                            ps.setLong(pos, Math.round(v.getNumber()));
                            break;
                        }
                        if (this.databaseMeta.supportsFloatRoundingOnUpdate() && v.getPrecision() >= 0) {
                            ps.setDouble(pos, v.getNumber());
                            break;
                        }
                        ps.setDouble(pos, Const.round(v.getNumber(), v.getPrecision()));
                        break;
                    }
                    ps.setNull(pos, -5);
                    break;
                }
                case 2: {
                    debug = "String";
                    if (v.getLength() < 9999999) {
                        if (!v.isNull() && v.getString() != null) {
                            ps.setString(pos, v.getString());
                            break;
                        }
                        ps.setNull(pos, 12);
                        break;
                    }
                    if (!v.isNull()) {
                        int maxlen = this.databaseMeta.getMaxTextFieldLength();
                        int len = v.getStringLength();
                        int begin = len - maxlen;
                        if (begin < 0) {
                            begin = 0;
                        }
                        String logging = v.getString().substring(begin);
                        if (this.databaseMeta.supportsSetCharacterStream()) {
                            StringReader sr = new StringReader(logging);
                            ps.setCharacterStream(pos, (Reader)sr, logging.length());
                            break;
                        }
                        ps.setString(pos, logging);
                        break;
                    }
                    ps.setNull(pos, 12);
                    break;
                }
                case 3: {
                    debug = "Date";
                    if (!v.isNull() && v.getDate() != null) {
                        long dat = v.getDate().getTime();
                        if (v.getPrecision() == 1 || !this.databaseMeta.supportsTimeStampToDateConversion()) {
                            Date ddate = new Date(dat);
                            ps.setDate(pos, ddate);
                            break;
                        }
                        Timestamp sdate = new Timestamp(dat);
                        ps.setTimestamp(pos, sdate);
                        break;
                    }
                    if (v.getPrecision() == 1 || !this.databaseMeta.supportsTimeStampToDateConversion()) {
                        ps.setNull(pos, 91);
                        break;
                    }
                    ps.setNull(pos, 92);
                    break;
                }
                case 4: {
                    debug = "Boolean";
                    if (this.databaseMeta.supportsBooleanDataType()) {
                        if (!v.isNull()) {
                            ps.setBoolean(pos, v.getBoolean());
                            break;
                        }
                        ps.setNull(pos, 16);
                        break;
                    }
                    if (!v.isNull()) {
                        ps.setString(pos, v.getBoolean() ? "Y" : "N");
                        break;
                    }
                    ps.setNull(pos, 1);
                    break;
                }
                default: {
                    debug = "default";
                }
            }
        }
        catch (SQLException ex) {
            throw new ETLDatabaseException("Error setting value #" + pos + " [" + v.toString() + "] on prepared statement (" + debug + ")" + Const.CR + ex.toString(), ex);
        }
        catch (Exception e) {
            throw new ETLDatabaseException("Error setting value #" + pos + " [" + (v == null ? "NULL" : v.toString()) + "] on prepared statement (" + debug + ")" + Const.CR + e.toString(), e);
        }
    }

    public void setValues(Row r, PreparedStatement ps) throws ETLDatabaseException {
        for (int i = 0; i < r.size(); ++i) {
            Value v = r.getValue(i);
            try {
                this.setValue(ps, v, i + 1);
                continue;
            }
            catch (ETLDatabaseException e) {
                throw new ETLDatabaseException("offending row : " + r, e);
            }
        }
    }

    public void setDimValues(Row r, Value dateval) throws ETLDatabaseException {
        this.setDimValues(r, dateval, this.prepStatementLookup);
    }

    public void setDimValues(Row r, Value dateval, PreparedStatement ps) throws ETLDatabaseException {
        long dat;
        for (int i = 0; i < r.size(); ++i) {
            Value v = r.getValue(i);
            try {
                this.setValue(ps, v, i + 1);
                continue;
            }
            catch (ETLDatabaseException e) {
                throw new ETLDatabaseException("Unable to set value #" + i + " on dimension using row :" + r, e);
            }
        }
        if (dateval != null && dateval.getDate() != null && !dateval.isNull()) {
            dat = dateval.getDate().getTime();
        } else {
            Calendar cal = Calendar.getInstance();
            dat = cal.getTime().getTime();
        }
        Timestamp sdate = new Timestamp(dat);
        try {
            ps.setTimestamp(r.size() + 1, sdate);
            ps.setTimestamp(r.size() + 2, sdate);
        }
        catch (SQLException ex) {
            throw new ETLDatabaseException("Unable to set timestamp on fromdate or todate", ex);
        }
    }

    public void dimUpdate(Row row, String table, String[] fieldlookup, int[] fieldnrs, String returnkey, Value dimkey) throws ETLDatabaseException {
        int i;
        if (this.pstmt_dup == null) {
            String sql = "UPDATE " + table + Const.CR + "SET ";
            for (i = 0; i < fieldlookup.length; ++i) {
                sql = i > 0 ? sql + ", " : sql + "  ";
                sql = sql + fieldlookup[i] + " = ?" + Const.CR;
            }
            sql = sql + "WHERE  " + returnkey + " = ?";
            try {
                this.log.logDebug(this.toString(), "Preparing statement: [" + sql + "]");
                this.pstmt_dup = this.connection.prepareStatement(this.databaseMeta.stripCR(sql));
            }
            catch (SQLException ex) {
                throw new ETLDatabaseException("Coudln't prepare statement :" + Const.CR + sql, ex);
            }
        }
        Row rupd = new Row();
        for (i = 0; i < fieldnrs.length; ++i) {
            rupd.addValue(row.getValue(fieldnrs[i]));
        }
        rupd.addValue(dimkey);
        this.setValues(rupd, this.pstmt_dup);
        this.insertRow(this.pstmt_dup);
    }

    public void dimInsert(Row row, String table, boolean newentry, String keyfield, boolean autoinc, Value technicalKey, String versionfield, Value val_version, String datefrom, Value val_datfrom, String dateto, Value val_datto, String[] fieldlookup, int[] fieldnrs, String[] key, String[] keylookup, int[] keynrs) throws ETLDatabaseException {
        int i;
        if (this.prepStatementInsert == null && this.prepStatementUpdate == null) {
            String sql = "INSERT INTO " + table + "( ";
            if (!autoinc) {
                sql = sql + keyfield + ", ";
            }
            sql = sql + versionfield + ", " + datefrom + ", " + dateto;
            for (i = 0; i < keylookup.length; ++i) {
                sql = sql + ", " + keylookup[i];
            }
            for (i = 0; i < fieldlookup.length; ++i) {
                sql = sql + ", " + fieldlookup[i];
            }
            sql = sql + ") VALUES(";
            if (!autoinc) {
                sql = sql + "?, ";
            }
            sql = sql + "?, ?, ?";
            for (i = 0; i < keynrs.length; ++i) {
                sql = sql + ", ?";
            }
            for (i = 0; i < fieldnrs.length; ++i) {
                sql = sql + ", ?";
            }
            sql = sql + " )";
            try {
                if (keyfield == null) {
                    this.log.logDetailed(this.toString(), "SQL w/ return keys=[" + sql + "]");
                    this.prepStatementInsert = this.connection.prepareStatement(this.databaseMeta.stripCR(sql), 1);
                } else {
                    this.log.logDetailed(this.toString(), "SQL=[" + sql + "]");
                    this.prepStatementInsert = this.connection.prepareStatement(this.databaseMeta.stripCR(sql));
                }
            }
            catch (SQLException ex) {
                throw new ETLDatabaseException("Unable to prepare dimension insert :" + Const.CR + sql, ex);
            }
            String sql_upd = "UPDATE " + table + Const.CR + "SET " + dateto + " = ?" + Const.CR;
            sql_upd = sql_upd + "WHERE ";
            for (i = 0; i < keylookup.length; ++i) {
                if (i > 0) {
                    sql_upd = sql_upd + "AND   ";
                }
                sql_upd = sql_upd + keylookup[i] + " = ?" + Const.CR;
            }
            sql_upd = sql_upd + "AND   " + versionfield + " = ? ";
            try {
                this.log.logDetailed(this.toString(), "Preparing update: " + Const.CR + sql + Const.CR);
                this.prepStatementUpdate = this.connection.prepareStatement(this.databaseMeta.stripCR(sql_upd));
            }
            catch (SQLException ex) {
                throw new ETLDatabaseException("Unable to prepare dimension update :" + Const.CR + sql, ex);
            }
        }
        Row rins = new Row();
        if (!autoinc) {
            rins.addValue(technicalKey);
        }
        if (!newentry) {
            Value val_new_version = new Value(val_version);
            val_new_version.setValue(val_new_version.getNumber() + 1.0);
            rins.addValue(val_new_version);
        } else {
            rins.addValue(val_version);
        }
        rins.addValue(val_datfrom);
        rins.addValue(val_datto);
        for (i = 0; i < keynrs.length; ++i) {
            rins.addValue(row.getValue(keynrs[i]));
        }
        for (i = 0; i < fieldnrs.length; ++i) {
            Value val = row.getValue(fieldnrs[i]);
            rins.addValue(val);
        }
        this.log.logDebug(this.toString(), "rins, size=" + rins.size() + ", values=" + rins.toString());
        this.setValues(rins, this.prepStatementInsert);
        this.insertRow(this.prepStatementInsert);
        this.log.logDebug(this.toString(), "Row inserted!");
        if (keyfield == null) {
            try {
                ResultSet keys = this.prepStatementInsert.getGeneratedKeys();
                if (!keys.next()) {
                    throw new ETLDatabaseException("Unable to retrieve technical key value from auto-increment field : " + keyfield + ", no fields in resultset.");
                }
                technicalKey.setValue(keys.getLong(1));
                keys.close();
            }
            catch (SQLException ex) {
                throw new ETLDatabaseException("Unable to retrieve technical key value from auto-increment field : " + keyfield, ex);
            }
        }
        if (!newentry) {
            Row rupd = new Row();
            rupd.addValue(val_datfrom);
            for (i = 0; i < keynrs.length; ++i) {
                rupd.addValue(row.getValue(keynrs[i]));
            }
            rupd.addValue(val_version);
            this.log.logRowlevel(this.toString(), "UPDATE using rupd=" + rupd.toString());
            this.setValues(rupd, this.prepStatementUpdate);
            this.log.logDebug(this.toString(), "Values set for update (" + rupd.size() + ")");
            this.insertRow(this.prepStatementUpdate);
            this.log.logDebug(this.toString(), "Row updated!");
        }
    }

    public void combiInsert(Row row, String table, String keyfield, boolean autoinc, Value val_key, String[] keylookup, int[] keynrs, boolean crc, String crcfield, Value val_crc) throws ETLDatabaseException {
        int i;
        if (this.prepStatementInsert == null) {
            String sql = "INSERT INTO " + table + "( ";
            boolean comma = false;
            if (!autoinc) {
                sql = sql + keyfield;
                comma = true;
            } else if (this.databaseMeta.needsPlaceHolder()) {
                sql = sql + "0";
                comma = true;
            }
            if (crc) {
                if (comma) {
                    sql = sql + ", ";
                }
                sql = sql + crcfield;
                comma = true;
            }
            for (i = 0; i < keylookup.length; ++i) {
                if (comma) {
                    sql = sql + ", ";
                }
                sql = sql + keylookup[i];
                comma = true;
            }
            sql = sql + ") VALUES (";
            comma = false;
            if (keyfield != null) {
                sql = sql + "?";
                comma = true;
            }
            if (crc) {
                if (comma) {
                    sql = sql + ",";
                }
                sql = sql + "?";
                comma = true;
            }
            for (i = 0; i < keylookup.length; ++i) {
                if (comma) {
                    sql = sql + ",";
                } else {
                    comma = true;
                }
                sql = sql + "?";
            }
            sql = sql + " )";
            try {
                if (keyfield == null) {
                    this.log.logDetailed(this.toString(), "SQL with return keys: " + sql);
                    this.prepStatementInsert = this.connection.prepareStatement(this.databaseMeta.stripCR(sql), 1);
                } else {
                    this.log.logDetailed(this.toString(), "SQL without return keys: " + sql);
                    this.prepStatementInsert = this.connection.prepareStatement(this.databaseMeta.stripCR(sql));
                }
            }
            catch (SQLException ex) {
                throw new ETLDatabaseException("Unable to prepare combi insert statement : " + Const.CR + sql, ex);
            }
            catch (Exception ex) {
                throw new ETLDatabaseException("Unable to prepare combi insert statement : " + Const.CR + sql, ex);
            }
        }
        Row rins = new Row();
        if (!autoinc) {
            rins.addValue(val_key);
        }
        if (crc) {
            rins.addValue(val_crc);
        }
        for (i = 0; i < keynrs.length; ++i) {
            rins.addValue(row.getValue(keynrs[i]));
        }
        this.setValues(rins, this.prepStatementInsert);
        this.insertRow(this.prepStatementInsert);
        if (keyfield == null) {
            try {
                ResultSet keys = this.pstmt.getGeneratedKeys();
                if (!keys.next()) {
                    throw new ETLDatabaseException("Unable to retrieve auto-increment of combi insert key : " + keyfield + ", no fields in resultset");
                }
                val_key.setValue(keys.getDouble(1));
                keys.close();
            }
            catch (SQLException ex) {
                throw new ETLDatabaseException("Unable to retrieve auto-increment of combi insert key : " + keyfield, ex);
            }
        }
    }

    public Value getNextSequenceValue(String seq, String keyfield) throws ETLDatabaseException {
        Value retval = null;
        try {
            ResultSet rs;
            if (this.pstmt_seq == null) {
                this.pstmt_seq = this.connection.prepareStatement(this.databaseMeta.getSeqNextvalSQL(this.databaseMeta.stripCR(seq)));
            }
            if ((rs = this.pstmt_seq.executeQuery()).next()) {
                long next = rs.getLong(1);
                retval = new Value(keyfield, next);
                retval.setLength(9, 0);
            }
            rs.close();
        }
        catch (SQLException ex) {
            throw new ETLDatabaseException("Unable to get next value for sequence : " + seq, ex);
        }
        return retval;
    }

    public void insertRow(String tableName, Row fields) throws ETLDatabaseException {
        this.prepareInsert(fields, tableName);
        this.setValuesInsert(fields);
        this.insertRow();
        this.closeInsert();
    }

    public String getInsertStatement(String tableName, Row fields) {
        int i;
        String ins = "";
        ins = ins + "INSERT INTO " + tableName + "(";
        for (i = 0; i < fields.size(); ++i) {
            if (i > 0) {
                ins = ins + ", ";
            }
            String name = fields.getValue(i).getName();
            ins = ins + this.databaseMeta.quoteField(name);
        }
        ins = ins + ") VALUES (";
        for (i = 0; i < fields.size(); ++i) {
            if (i > 0) {
                ins = ins + ", ";
            }
            ins = ins + " ?";
        }
        ins = ins + ")";
        return ins;
    }

    public void insertRow() throws ETLDatabaseException {
        this.insertRow(this.prepStatementInsert);
    }

    public void insertRow(boolean batch) throws ETLDatabaseException {
        this.insertRow(this.prepStatementInsert, batch);
    }

    public void updateRow() throws ETLDatabaseException {
        this.insertRow(this.prepStatementUpdate);
    }

    public void insertRow(PreparedStatement ps) throws ETLDatabaseException {
        this.insertRow(ps, false);
    }

    public void setBatchCounter(int batchCounter) {
        this.batchCounter = batchCounter;
    }

    public int getBatchCounter() {
        return this.batchCounter;
    }

    public void insertRow(PreparedStatement ps, boolean batch) throws ETLDatabaseException {
        String debug = "insertRow start";
        try {
            boolean useBatchInsert;
            boolean bl = useBatchInsert = batch && this.getDatabaseMetaData().supportsBatchUpdates() && this.databaseMeta.supportsBatchUpdates();
            if (!this.isAutoCommit()) {
                if (useBatchInsert) {
                    debug = "insertRow add batch";
                    ++this.batchCounter;
                    ps.addBatch();
                    ++this.testCounter;
                } else {
                    debug = "insertRow exec update";
                    ps.executeUpdate();
                }
            } else {
                ps.executeUpdate();
            }
            ++this.written;
            if (!this.isAutoCommit() && this.written % this.commitsize == 0) {
                if (useBatchInsert) {
                    debug = "insertRow executeBatch commit";
                    ps.executeBatch();
                    this.commit();
                    ps.clearBatch();
                    this.batchCounter = 0;
                } else {
                    debug = "insertRow normal commit";
                    this.commit();
                }
            }
        }
        catch (BatchUpdateException ex) {
            ETLDatabaseBatchException kdbe = new ETLDatabaseBatchException("Error updating batch", ex);
            kdbe.setUpdateCounts(ex.getUpdateCounts());
            throw kdbe;
        }
        catch (SQLException ex) {
            throw new ETLDatabaseException("Error inserting row", ex);
        }
        catch (Exception e) {
            throw new ETLDatabaseException("Unexpected error inserting row in part [" + debug + "]", e);
        }
    }

    public void clearInsertBatch() throws ETLDatabaseException {
        this.clearBatch(this.prepStatementInsert);
    }

    public void clearBatch(PreparedStatement preparedStatement) throws ETLDatabaseException {
        try {
            preparedStatement.clearBatch();
        }
        catch (SQLException e) {
            throw new ETLDatabaseException("Unable to clear batch for prepared statement", e);
        }
    }

    public void insertFinished(boolean batch) throws ETLDatabaseException {
        this.insertFinished(this.prepStatementInsert, batch);
        this.prepStatementInsert = null;
    }

    public void insertFinished(PreparedStatement ps, boolean batch) throws ETLDatabaseException {
        try {
            if (ps != null) {
                if (!this.isAutoCommit()) {
                    if (batch && this.getDatabaseMetaData().supportsBatchUpdates() && this.batchCounter > 0) {
                        ps.executeBatch();
                        this.commit();
                    } else {
                        this.commit();
                    }
                }
                ps.close();
            }
        }
        catch (SQLException ex) {
            throw new ETLDatabaseException("Unable to commit connection after having inserted rows.", ex);
        }
    }

    public Result execStatement(String sql) throws ETLDatabaseException {
        return this.execStatement(sql, null);
    }

    public Result execStatement(String sql, Row params) throws ETLDatabaseException {
        Result result = new Result();
        try {
            int count;
            boolean resultSet;
            if (params != null) {
                PreparedStatement prep_stmt = this.connection.prepareStatement(this.databaseMeta.stripCR(sql));
                this.setValues(params, prep_stmt);
                resultSet = prep_stmt.execute();
                count = prep_stmt.getUpdateCount();
                prep_stmt.close();
            } else {
                Statement stmt = this.connection.createStatement();
                resultSet = stmt.execute(this.databaseMeta.stripCR(sql));
                count = stmt.getUpdateCount();
                stmt.close();
            }
            if (!resultSet && count > 0) {
                if (sql.toUpperCase(Locale.ENGLISH).startsWith("INSERT")) {
                    result.setNrLinesOutput(count);
                }
                if (sql.toUpperCase(Locale.ENGLISH).startsWith("UPDATE")) {
                    result.setNrLinesUpdated(count);
                }
                if (sql.toUpperCase(Locale.ENGLISH).startsWith("DELETE")) {
                    result.setNrLinesDeleted(count);
                }
            }
        }
        catch (SQLException ex) {
            throw new ETLDatabaseException("Couldn't execute SQL: " + sql + Const.CR, ex);
        }
        catch (Exception e) {
            throw new ETLDatabaseException("Unexpected error executing SQL: " + Const.CR, e);
        }
        return result;
    }

    public Result execStatements(String script) throws ETLDatabaseException {
        Result result = new Result();
        String all = script;
        int from = 0;
        int to = 0;
        int length = all.length();
        int nrstats = 0;
        while (to < length) {
            int c = all.charAt(to);
            if (c == 34) {
                ++to;
                c = 32;
                while (to < length && c != 34) {
                    c = all.charAt(to);
                    ++to;
                }
            } else if (c == 39) {
                ++to;
                c = 32;
                while (to < length && c != 39) {
                    c = all.charAt(to);
                    ++to;
                }
            } else if (all.substring(to).startsWith("--")) {
                ++to;
                while (to < length && c != 10 && c != 13) {
                    c = all.charAt(to);
                    ++to;
                }
            }
            if (c == 59 || to >= length - 1) {
                String stat;
                if (to >= length - 1) {
                    ++to;
                }
                if (!Const.onlySpaces(stat = all.substring(from, to))) {
                    String sql = Const.trim(stat);
                    if (sql.toUpperCase(Locale.ENGLISH).startsWith("SELECT")) {
                        this.log.logDetailed(this.toString(), "launch SELECT statement: " + Const.CR + sql);
                        ++nrstats;
                        ResultSet rs = this.openQuery(sql);
                        if (rs != null) {
                            Row r = this.getRow(rs);
                            while (r != null) {
                                result.setNrLinesRead(result.getNrLinesRead() + 1L);
                                this.log.logDetailed(this.toString(), r.toString());
                                r = this.getRow(rs);
                            }
                        } else {
                            this.log.logDebug(this.toString(), "Error executing query: " + Const.CR + sql);
                        }
                    } else {
                        this.log.logDetailed(this.toString(), "launch DDL statement: " + Const.CR + sql);
                        ++nrstats;
                        Result res = this.execStatement(sql);
                        result.add(res);
                    }
                }
                from = ++to;
                continue;
            }
            ++to;
        }
        this.log.logDetailed(this.toString(), nrstats + " statement" + (nrstats == 1 ? "" : "s") + " executed");
        return result;
    }

    public ResultSet openQuery(String sql) throws ETLDatabaseException {
        return this.openQuery(sql, null);
    }

    public ResultSet openQuery(String sql, Row params) throws ETLDatabaseException {
        return this.openQuery(sql, params, 1000);
    }

    public ResultSet openQuery(String sql, Row params, int fetch_mode) throws ETLDatabaseException {
        ResultSet res;
        String debug = "Start";
        try {
            if (params != null) {
                debug = "P create prepared statement (con==null? " + (this.connection == null) + ")";
                this.pstmt = this.connection.prepareStatement(this.databaseMeta.stripCR(sql), 1003, 1007);
                debug = "P Set values";
                this.setValues(params);
                if (this.databaseMeta.isFetchSizeSupported() && this.pstmt.getMaxRows() > 0) {
                    debug = "P Set fetchsize";
                    int fs = 100 <= this.pstmt.getMaxRows() ? this.pstmt.getMaxRows() : 100;
                    this.pstmt.setFetchSize(fs);
                    debug = "P Set fetch direction";
                    this.pstmt.setFetchDirection(fetch_mode);
                }
                debug = "P Set max rows";
                if (this.rowlimit > 0) {
                    this.pstmt.setMaxRows(this.rowlimit);
                }
                debug = "exec query";
                res = this.pstmt.executeQuery();
            } else {
                debug = "create statement";
                this.sel_stmt = this.connection.createStatement();
                if (this.databaseMeta.isFetchSizeSupported() && this.sel_stmt.getMaxRows() > 0) {
                    debug = "Set fetchsize";
                    int fs = 100 <= this.sel_stmt.getMaxRows() ? this.sel_stmt.getMaxRows() : 100;
                    this.sel_stmt.setFetchSize(fs);
                    debug = "Set fetch direction";
                    this.sel_stmt.setFetchDirection(1000);
                }
                debug = "Set max rows";
                if (this.rowlimit > 0) {
                    this.sel_stmt.setMaxRows(this.rowlimit);
                }
                debug = "exec query";
                res = this.sel_stmt.executeQuery(this.databaseMeta.stripCR(sql));
            }
            debug = "get metadata";
            this.rsmd = res.getMetaData();
            this.rowinfo = this.getRowInfo();
        }
        catch (SQLException ex) {
            this.log.logError(this.toString(), "ERROR executing [" + sql + "]");
            this.log.logError(this.toString(), "ERROR in part: [" + debug + "]");
            this.printSQLException(ex);
            throw new ETLDatabaseException("An error occurred executing SQL: " + Const.CR + sql, ex);
        }
        catch (Exception e) {
            this.log.logError(this.toString(), "ERROR executing query: " + e.toString());
            this.log.logError(this.toString(), "ERROR in part: " + debug);
            throw new ETLDatabaseException("An error occurred executing SQL in part [" + debug + "]:" + Const.CR + sql, e);
        }
        return res;
    }

    public ResultSet openQuery(PreparedStatement ps, Row params) throws ETLDatabaseException {
        ResultSet res;
        String debug = "Start";
        try {
            debug = "OQ Set values";
            this.setValues(params, ps);
            if (this.databaseMeta.isFetchSizeSupported() && ps.getMaxRows() > 0) {
                debug = "OQ Set fetchsize";
                int fs = 100 <= ps.getMaxRows() ? ps.getMaxRows() : 100;
                ps.setFetchSize(fs);
                debug = "OQ Set fetch direction";
                ps.setFetchDirection(1000);
            }
            debug = "OQ Set max rows";
            if (this.rowlimit > 0) {
                ps.setMaxRows(this.rowlimit);
            }
            debug = "OQ exec query";
            res = ps.executeQuery();
            debug = "OQ get metadata";
            this.rsmd = res.getMetaData();
            debug = "OQ getRowInfo()";
            this.rowinfo = this.getRowInfo();
        }
        catch (SQLException ex) {
            throw new ETLDatabaseException("ERROR executing query in part[" + debug + "]", ex);
        }
        catch (Exception e) {
            throw new ETLDatabaseException("ERROR executing query in part[" + debug + "]", e);
        }
        return res;
    }

    public Row getTableFields(String tablename) throws ETLDatabaseException {
        return this.getQueryFields(this.databaseMeta.getSQLQueryFields(tablename), false);
    }

    public Row getQueryFields(String sql, boolean param) throws ETLDatabaseException {
        return this.getQueryFields(sql, param, null);
    }

    public boolean checkTableExists(String tablename) throws ETLDatabaseException {
        try {
            this.log.logDebug(this.toString(), "Checking if table [" + tablename + "] exists!");
            if (this.databaseMeta.getDatabaseType() == 64) {
                String sql = "select * from SysObjects where name = '" + tablename + "'";
                ResultSet rs = this.openQuery(sql);
                return rs.next();
            }
            if (this.getDatabaseMetaData() != null) {
                ResultSet alltables = this.getDatabaseMetaData().getTables(null, null, "%", new String[]{"TABLE", "VIEW", "SYNONYM"});
                boolean found = false;
                if (alltables != null) {
                    while (alltables.next() && !found) {
                        String schemaName = alltables.getString("TABLE_SCHEM");
                        String name = alltables.getString("TABLE_NAME");
                        if (!tablename.equalsIgnoreCase(name) && (schemaName == null || !tablename.equalsIgnoreCase(this.databaseMeta.getSchemaTableCombination(schemaName, name)))) continue;
                        this.log.logDebug(this.toString(), "table [" + tablename + "] was found!");
                        found = true;
                    }
                    alltables.close();
                    return found;
                }
                throw new ETLDatabaseException("Unable to read table-names from the database meta-data.");
            }
            throw new ETLDatabaseException("Unable to get database meta-data from the database.");
        }
        catch (Exception e) {
            throw new ETLDatabaseException("Unable to check if table [" + tablename + "] exists on connection [" + this.databaseMeta.getName() + "]", e);
        }
    }

    public boolean checkSequenceExists(String sequenceName) throws ETLDatabaseException {
        boolean retval = false;
        if (!this.databaseMeta.supportsSequences()) {
            return retval;
        }
        try {
            String sql = this.databaseMeta.getSQLSequenceExists(sequenceName);
            ResultSet res = this.openQuery(sql);
            if (res != null) {
                Row row = this.getRow(res);
                if (row != null) {
                    retval = true;
                }
                this.closeQuery(res);
            }
        }
        catch (Exception e) {
            throw new ETLDatabaseException("Unexpected error checking whether or not sequence [" + sequenceName + "] exists", e);
        }
        return retval;
    }

    public boolean checkIndexExists(String tablename, String[] idx_fields) throws ETLDatabaseException {
        if (!this.checkTableExists(tablename)) {
            return false;
        }
        this.log.logDebug(this.toString(), "CheckIndexExists() tablename = " + tablename + " type = " + this.databaseMeta.getDatabaseTypeDesc());
        boolean[] exists = new boolean[idx_fields.length];
        for (int i = 0; i < exists.length; ++i) {
            exists[i] = false;
        }
        try {
            switch (this.databaseMeta.getDatabaseType()) {
                case 2: {
                    int idx;
                    String column;
                    String sql = "select i.name table_name, c.name column_name ";
                    sql = sql + "from     sysindexes i, sysindexkeys k, syscolumns c ";
                    sql = sql + "where    i.name = '" + tablename + "' ";
                    sql = sql + "AND      i.id = k.id ";
                    sql = sql + "AND      i.id = c.id ";
                    sql = sql + "AND      k.colid = c.colid ";
                    ResultSet res = this.openQuery(sql);
                    if (res != null) {
                        Row row = this.getRow(res);
                        while (row != null) {
                            column = row.getString("column_name", "");
                            idx = Const.indexOfString(column, idx_fields);
                            if (idx >= 0) {
                                exists[idx] = true;
                            }
                            row = this.getRow(res);
                        }
                        this.closeQuery(res);
                        break;
                    }
                    return false;
                }
                case 4: {
                    int idx;
                    String column;
                    String sql = "SELECT * FROM USER_IND_COLUMNS WHERE TABLE_NAME = '" + tablename.toUpperCase() + "'";
                    ResultSet res = this.openQuery(sql);
                    if (res != null) {
                        Row row = this.getRow(res);
                        while (row != null) {
                            column = row.getString("COLUMN_NAME", "");
                            idx = Const.indexOfString(column, idx_fields);
                            if (idx >= 0) {
                                exists[idx] = true;
                            }
                            row = this.getRow(res);
                        }
                        this.closeQuery(res);
                        break;
                    }
                    return false;
                }
                default: {
                    ResultSet indexList = this.getDatabaseMetaData().getIndexInfo(null, null, tablename, false, true);
                    while (indexList.next()) {
                        String column = indexList.getString("COLUMN_NAME");
                        int idx = Const.indexOfString(column, idx_fields);
                        if (idx < 0) continue;
                        exists[idx] = true;
                    }
                    indexList.close();
                }
            }
            boolean all = true;
            for (int i = 0; i < exists.length && all; ++i) {
                if (exists[i]) continue;
                all = false;
            }
            return all;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ETLDatabaseException("Unable to determine if indexes exists on table [" + tablename + "]", e);
        }
    }

    public String getCreateIndexStatement(String tablename, String indexname, String[] idx_fields, boolean tk, boolean unique, boolean bitmap, boolean semi_colon) {
        String cr_index = "";
        cr_index = cr_index + "CREATE ";
        if (unique) {
            cr_index = cr_index + "UNIQUE ";
        }
        if (bitmap && this.databaseMeta.supportsBitmapIndex()) {
            cr_index = cr_index + "BITMAP ";
        }
        cr_index = cr_index + "INDEX " + indexname + Const.CR + " ";
        cr_index = cr_index + "ON " + tablename + Const.CR;
        cr_index = cr_index + "( " + Const.CR;
        for (int i = 0; i < idx_fields.length; ++i) {
            cr_index = i > 0 ? cr_index + ", " : cr_index + "  ";
            cr_index = cr_index + idx_fields[i] + Const.CR;
        }
        cr_index = cr_index + ")" + Const.CR;
        if (this.databaseMeta.getDatabaseType() == 4 && this.databaseMeta.getIndexTablespace() != null && this.databaseMeta.getIndexTablespace().length() > 0) {
            cr_index = cr_index + "TABLESPACE " + this.databaseMeta.getIndexTablespace();
        }
        if (semi_colon) {
            cr_index = cr_index + ";" + Const.CR;
        }
        return cr_index;
    }

    public String getCreateSequenceStatement(String sequence, long start_at, long increment_by, long max_value, boolean semi_colon) {
        String cr_seq = "";
        if (sequence == null || sequence.length() == 0) {
            return cr_seq;
        }
        if (this.databaseMeta.supportsSequences()) {
            cr_seq = cr_seq + "CREATE SEQUENCE " + sequence + " " + Const.CR;
            cr_seq = cr_seq + "START WITH " + start_at + " " + Const.CR;
            cr_seq = cr_seq + "INCREMENT BY " + increment_by + " " + Const.CR;
            if (max_value > 0L) {
                cr_seq = cr_seq + "MAXVALUE " + max_value + Const.CR;
            }
            if (semi_colon) {
                cr_seq = cr_seq + ";" + Const.CR;
            }
        }
        return cr_seq;
    }

    public Row getQueryFields(String sql, boolean param, Row inform) throws ETLDatabaseException {
        Row fields;
        DBCache dbcache = DBCache.getInstance();
        DBCacheEntry entry = null;
        if (dbcache != null && (fields = dbcache.get(entry = new DBCacheEntry(this.databaseMeta.getName(), sql))) != null) {
            return fields;
        }
        if (this.connection == null) {
            return null;
        }
        String debug = "";
        try {
            if (inform == null) {
                debug = "inform==null";
                this.sel_stmt = this.connection.createStatement(1003, 1007);
                debug = "isFetchSizeSupported()";
                if (this.databaseMeta.isFetchSizeSupported() && this.sel_stmt.getMaxRows() >= 1) {
                    debug = "Set fetchsize";
                    this.sel_stmt.setFetchSize(1);
                }
                debug = "Set max rows to 1";
                this.sel_stmt.setMaxRows(1);
                debug = "exec query";
                ResultSet r = this.sel_stmt.executeQuery(this.databaseMeta.stripCR(sql));
                debug = "get metadata";
                this.rsmd = r.getMetaData();
                fields = this.getRowInfo();
                debug = "close resultset";
                r.close();
                debug = "close statement";
                this.sel_stmt.close();
                this.sel_stmt = null;
            } else {
                debug = "prepareStatement";
                PreparedStatement ps = this.connection.prepareStatement(this.databaseMeta.stripCR(sql));
                if (param) {
                    Row par = inform;
                    debug = "getParameterMetaData()";
                    if (par == null) {
                        par = this.getParameterMetaData(ps);
                    }
                    debug = "getParameterMetaData()";
                    if (par == null) {
                        par = this.getParameterMetaData(sql, inform);
                    }
                    this.setValues(par, ps);
                }
                debug = "executeQuery()";
                ResultSet r = ps.executeQuery();
                debug = "getMetaData";
                this.rsmd = ps.getMetaData();
                debug = "getRowInfo";
                fields = this.getRowInfo(this.rsmd);
                debug = "close resultset";
                r.close();
                debug = "close preparedStatement";
                ps.close();
            }
        }
        catch (SQLException ex) {
            throw new ETLDatabaseException("Couldn't get field info from [" + sql + "]" + Const.CR + "Location: " + debug, ex);
        }
        catch (Exception e) {
            throw new ETLDatabaseException("Couldn't get field info in part [" + debug + "]", e);
        }
        if (dbcache != null && entry != null && fields != null) {
            dbcache.put(entry, fields);
        }
        return fields;
    }

    public void closeQuery(ResultSet res) throws ETLDatabaseException {
        try {
            if (res != null) {
                res.close();
            }
            if (this.sel_stmt != null) {
                this.sel_stmt.close();
                this.sel_stmt = null;
            }
            if (this.pstmt != null) {
                this.pstmt.close();
                this.pstmt = null;
            }
        }
        catch (SQLException ex) {
            throw new ETLDatabaseException("Couldn't close query: resultset or prepared statements", ex);
        }
    }

    private Row getRowInfo(ResultSetMetaData rm) throws ETLDatabaseException {
        if (rm == null) {
            return null;
        }
        this.rowinfo = new Row();
        try {
            int nrcols = rm.getColumnCount();
            for (int i = 1; i <= nrcols; ++i) {
                String name = new String(rm.getColumnName(i));
                int type = rm.getColumnType(i);
                int valtype = 0;
                int length = rm.getPrecision(i);
                int precision = rm.getScale(i);
                switch (type) {
                    case -1: 
                    case 1: 
                    case 12: {
                        valtype = 2;
                        length = rm.getColumnDisplaySize(i);
                        break;
                    }
                    case 2005: {
                        valtype = 2;
                        length = 9999999;
                        break;
                    }
                    case -5: {
                        valtype = 5;
                        precision = 0;
                        length = 15;
                        break;
                    }
                    case 4: {
                        valtype = 5;
                        precision = 0;
                        length = 9;
                        break;
                    }
                    case 5: {
                        valtype = 5;
                        precision = 0;
                        length = 4;
                        break;
                    }
                    case -6: {
                        valtype = 5;
                        precision = 0;
                        length = 2;
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 6: 
                    case 7: 
                    case 8: {
                        valtype = 1;
                        if (length >= 126) {
                            length = -1;
                        }
                        if (precision >= 126) {
                            precision = -1;
                        }
                        if (precision == 0 && length < 18 && length > 0) {
                            valtype = 5;
                        }
                        if (length > 18 || precision > 18) {
                            valtype = 6;
                        }
                        if (this.databaseMeta.getDatabaseType() != 4 || precision > 0 || length > 0) break;
                        valtype = 6;
                        length = -1;
                        precision = -1;
                        break;
                    }
                    case 91: 
                    case 92: 
                    case 93: {
                        valtype = 3;
                        break;
                    }
                    case 16: {
                        valtype = 4;
                        break;
                    }
                    default: {
                        valtype = 2;
                    }
                }
                Value v = new Value(name, valtype);
                v.setLength(length, precision);
                this.rowinfo.addValue(v);
            }
            return this.rowinfo;
        }
        catch (SQLException ex) {
            throw new ETLDatabaseException("Error getting row information from database: ", ex);
        }
    }

    private Row getRowInfo() throws ETLDatabaseException {
        return this.getRowInfo(this.rsmd);
    }

    public boolean absolute(ResultSet rs, int position) throws ETLDatabaseException {
        try {
            return rs.absolute(position);
        }
        catch (SQLException e) {
            throw new ETLDatabaseException("Unable to move resultset to position " + position, e);
        }
    }

    public boolean relative(ResultSet rs, int rows) throws ETLDatabaseException {
        try {
            return rs.relative(rows);
        }
        catch (SQLException e) {
            throw new ETLDatabaseException("Unable to move the resultset forward " + rows + " rows", e);
        }
    }

    public void afterLast(ResultSet rs) throws ETLDatabaseException {
        try {
            rs.afterLast();
        }
        catch (SQLException e) {
            throw new ETLDatabaseException("Unable to move resultset to after the last position", e);
        }
    }

    public void first(ResultSet rs) throws ETLDatabaseException {
        try {
            rs.first();
        }
        catch (SQLException e) {
            throw new ETLDatabaseException("Unable to move resultset to the first position", e);
        }
    }

    public Row getRow(ResultSet rs) throws ETLDatabaseException {
        try {
            Row row;
            int nrcols = this.rsmd.getColumnCount();
            if (rs.next()) {
                row = new Row();
                for (int i = 0; i < nrcols; ++i) {
                    Value val = new Value(this.rowinfo.getValue(i));
                    switch (val.getType()) {
                        case 4: {
                            val.setValue(rs.getBoolean(i + 1));
                            break;
                        }
                        case 1: {
                            val.setValue(rs.getDouble(i + 1));
                            break;
                        }
                        case 6: {
                            val.setValue(rs.getBigDecimal(i + 1));
                            break;
                        }
                        case 5: {
                            val.setValue(rs.getLong(i + 1));
                            break;
                        }
                        case 2: {
                            val.setValue(rs.getString(i + 1));
                            break;
                        }
                        case 3: {
                            if (this.databaseMeta.supportsTimeStampToDateConversion()) {
                                val.setValue(rs.getTimestamp(i + 1));
                                break;
                            }
                            val.setValue(rs.getDate(i + 1));
                            break;
                        }
                    }
                    if (rs.wasNull()) {
                        val.setNull();
                    }
                    row.addValue(val);
                }
            } else {
                row = null;
            }
            return row;
        }
        catch (SQLException ex) {
            throw new ETLDatabaseException("Couldn't get row from result set", ex);
        }
    }

    public void printSQLException(SQLException ex) {
        this.log.logError(this.toString(), "==> SQLException: ");
        while (ex != null) {
            this.log.logError(this.toString(), "Message:   " + ex.getMessage());
            this.log.logError(this.toString(), "SQLState:  " + ex.getSQLState());
            this.log.logError(this.toString(), "ErrorCode: " + ex.getErrorCode());
            ex = ex.getNextException();
            this.log.logError(this.toString(), "");
        }
    }

    public void setLookup(String table, String[] codes, String[] condition, String[] gets, String[] rename, String orderby) throws ETLDatabaseException {
        int i;
        String sql = "SELECT ";
        for (i = 0; i < gets.length; ++i) {
            if (i != 0) {
                sql = sql + ", ";
            }
            sql = sql + gets[i];
            if (rename == null || rename[i] == null || gets[i].equalsIgnoreCase(rename[i])) continue;
            sql = sql + " AS " + rename[i];
        }
        sql = sql + " FROM " + table + " WHERE ";
        for (i = 0; i < codes.length; ++i) {
            if (i != 0) {
                sql = sql + " AND ";
            }
            sql = sql + codes[i];
            sql = "BETWEEN".equalsIgnoreCase(condition[i]) ? sql + " BETWEEN ? AND ? " : ("IS NULL".equalsIgnoreCase(condition[i]) || "IS NOT NULL".equalsIgnoreCase(condition[i]) ? sql + " " + condition[i] + " " : sql + " " + condition[i] + " ? ");
        }
        if (orderby != null && orderby.length() != 0) {
            sql = sql + " ORDER BY " + orderby;
        }
        try {
            this.log.logDetailed(this.toString(), "Setting preparedStatement to [" + sql + "]");
            this.prepStatementLookup = this.connection.prepareStatement(this.databaseMeta.stripCR(sql));
            this.prepStatementLookup.setMaxRows(1);
        }
        catch (SQLException ex) {
            throw new ETLDatabaseException("Unable to prepare statement for update [" + sql + "]", ex);
        }
    }

    public boolean prepareUpdate(String table, String[] codes, String[] condition, String[] sets) {
        int i;
        String sql = "UPDATE " + table + Const.CR + "SET ";
        for (i = 0; i < sets.length; ++i) {
            if (i != 0) {
                sql = sql + ",   ";
            }
            sql = sql + this.databaseMeta.quoteField(sets[i]);
            sql = sql + " = ?" + Const.CR;
        }
        sql = sql + "WHERE ";
        for (i = 0; i < codes.length; ++i) {
            if (i != 0) {
                sql = sql + "AND   ";
            }
            sql = sql + codes[i];
            sql = "BETWEEN".equalsIgnoreCase(condition[i]) ? sql + " BETWEEN ? AND ? " : ("IS NULL".equalsIgnoreCase(condition[i]) || "IS NOT NULL".equalsIgnoreCase(condition[i]) ? sql + " " + condition[i] + " " : sql + " " + condition[i] + " ? ");
        }
        try {
            this.log.logDetailed(this.toString(), "Setting update preparedStatement to [" + sql + "]");
            this.prepStatementUpdate = this.connection.prepareStatement(this.databaseMeta.stripCR(sql));
        }
        catch (SQLException ex) {
            this.printSQLException(ex);
            return false;
        }
        return true;
    }

    public void setProcLookup(String proc, String[] arg, String[] argdir, int[] argtype, String returnvalue, int returntype) throws ETLDatabaseException {
        int i;
        int pos = 0;
        String sql = "{ ";
        if (returnvalue != null && returnvalue.length() != 0) {
            sql = sql + "? = ";
        }
        sql = sql + "call " + proc + " ";
        if (arg.length > 0) {
            sql = sql + "(";
        }
        for (i = 0; i < arg.length; ++i) {
            if (i != 0) {
                sql = sql + ", ";
            }
            sql = sql + " ?";
        }
        if (arg.length > 0) {
            sql = sql + ")";
        }
        sql = sql + "}";
        try {
            this.log.logDetailed(this.toString(), "DBA setting callableStatement to [" + sql + "]");
            this.cstmt = this.connection.prepareCall(sql);
            pos = 1;
            if (returnvalue != null) {
                switch (returntype) {
                    case 1: {
                        this.cstmt.registerOutParameter(pos, 8);
                        break;
                    }
                    case 6: {
                        this.cstmt.registerOutParameter(pos, 3);
                        break;
                    }
                    case 5: {
                        this.cstmt.registerOutParameter(pos, -5);
                        break;
                    }
                    case 2: {
                        this.cstmt.registerOutParameter(pos, 12);
                        break;
                    }
                    case 3: {
                        this.cstmt.registerOutParameter(pos, 93);
                        break;
                    }
                    case 4: {
                        this.cstmt.registerOutParameter(pos, 16);
                        break;
                    }
                }
                ++pos;
            }
            block19: for (i = 0; i < arg.length; ++i) {
                if (!argdir[i].equalsIgnoreCase("OUT") && !argdir[i].equalsIgnoreCase("INOUT")) continue;
                switch (argtype[i]) {
                    case 1: {
                        this.cstmt.registerOutParameter(i + pos, 8);
                        continue block19;
                    }
                    case 6: {
                        this.cstmt.registerOutParameter(i + pos, 3);
                        continue block19;
                    }
                    case 5: {
                        this.cstmt.registerOutParameter(i + pos, -5);
                        continue block19;
                    }
                    case 2: {
                        this.cstmt.registerOutParameter(i + pos, 12);
                        continue block19;
                    }
                    case 3: {
                        this.cstmt.registerOutParameter(i + pos, 93);
                        continue block19;
                    }
                    case 4: {
                        this.cstmt.registerOutParameter(i + pos, 16);
                        continue block19;
                    }
                }
            }
        }
        catch (SQLException ex) {
            throw new ETLDatabaseException("Unable to prepare database procedure call", ex);
        }
    }

    public boolean setDimLookup(String table, String[] keys, String tk, String version, String[] extra, String[] extraRename, String datefrom, String dateto) throws ETLDatabaseException {
        int i;
        String sql = "SELECT " + tk + ", " + version;
        if (extra != null) {
            for (i = 0; i < extra.length; ++i) {
                if (extra[i] == null || extra[i].length() == 0) continue;
                sql = sql + ", " + extra[i];
                if (extraRename[i] == null || extraRename[i].length() <= 0 || extra[i].equals(extraRename[i])) continue;
                sql = sql + " AS " + extraRename[i];
            }
        }
        sql = sql + " FROM " + table + " WHERE ";
        for (i = 0; i < keys.length; ++i) {
            if (i != 0) {
                sql = sql + " AND ";
            }
            sql = sql + keys[i] + " = ? ";
        }
        sql = sql + " AND ? >= " + datefrom + " AND ? < " + dateto;
        try {
            this.log.logDetailed(this.toString(), "Dimension Lookup setting preparedStatement to [" + sql + "]");
            this.prepStatementLookup = this.connection.prepareStatement(this.databaseMeta.stripCR(sql));
            this.prepStatementLookup.setMaxRows(1);
            this.log.logDetailed(this.toString(), "Finished preparing dimension lookup statement.");
        }
        catch (SQLException ex) {
            throw new ETLDatabaseException("Unable to prepare dimension lookup", ex);
        }
        return true;
    }

    public void setCombiLookup(String table, String[] keys, String retval, boolean crc, String crcfield) throws ETLDatabaseException {
        String sql = "SELECT " + retval + Const.CR + "FROM " + table + Const.CR + "WHERE ";
        boolean comma = false;
        if (crc) {
            sql = sql + crcfield + " = ? " + Const.CR;
            comma = true;
        } else {
            sql = sql + "( ( ";
        }
        for (int i = 0; i < keys.length; ++i) {
            if (comma) {
                sql = sql + " AND ( ( ";
            } else {
                comma = true;
            }
            sql = sql + keys[i] + " = ? ) OR ( " + keys[i] + " IS NULL AND ? IS NULL ) )" + Const.CR;
        }
        try {
            this.log.logDebug(this.toString(), "preparing combi-lookup statement:" + Const.CR + sql);
            this.prepStatementLookup = this.connection.prepareStatement(this.databaseMeta.stripCR(sql));
            this.prepStatementLookup.setMaxRows(1);
        }
        catch (SQLException ex) {
            throw new ETLDatabaseException("Unable to prepare combi-lookup statement", ex);
        }
    }

    public Row callProcedure(String[] arg, String[] argdir, int[] argtype, String resultname, int resulttype) throws ETLDatabaseException {
        try {
            this.cstmt.execute();
            Row ret = new Row();
            int pos = 1;
            if (resultname != null && resultname.length() != 0) {
                Value v = new Value(resultname, 0);
                switch (resulttype) {
                    case 4: {
                        v.setValue(this.cstmt.getBoolean(pos));
                        break;
                    }
                    case 1: {
                        v.setValue(this.cstmt.getDouble(pos));
                        break;
                    }
                    case 6: {
                        v.setValue(this.cstmt.getBigDecimal(pos));
                        break;
                    }
                    case 5: {
                        v.setValue(this.cstmt.getLong(pos));
                        break;
                    }
                    case 2: {
                        v.setValue(this.cstmt.getString(pos));
                        break;
                    }
                    case 3: {
                        v.setValue(this.cstmt.getTimestamp(pos));
                    }
                }
                ret.addValue(v);
                ++pos;
            }
            for (int i = 0; i < arg.length; ++i) {
                if (!argdir[i].equalsIgnoreCase("OUT") && !argdir[i].equalsIgnoreCase("INOUT")) continue;
                Value v = new Value(arg[i], 0);
                switch (argtype[i]) {
                    case 4: {
                        v.setValue(this.cstmt.getBoolean(pos + i));
                        break;
                    }
                    case 1: {
                        v.setValue(this.cstmt.getDouble(pos + i));
                        break;
                    }
                    case 6: {
                        v.setValue(this.cstmt.getBigDecimal(pos + i));
                        break;
                    }
                    case 5: {
                        v.setValue(this.cstmt.getLong(pos + i));
                        break;
                    }
                    case 2: {
                        v.setValue(this.cstmt.getString(pos + i));
                        break;
                    }
                    case 3: {
                        v.setValue(this.cstmt.getTimestamp(pos + i));
                    }
                }
                ret.addValue(v);
            }
            return ret;
        }
        catch (SQLException ex) {
            throw new ETLDatabaseException("Unable to call procedure", ex);
        }
    }

    public Row getLookup() throws ETLDatabaseException {
        return this.getLookup(this.prepStatementLookup);
    }

    public Row getLookup(PreparedStatement ps) throws ETLDatabaseException {
        String debug = "start";
        try {
            debug = "pstmt.executeQuery()";
            ResultSet res = ps.executeQuery();
            debug = "res.getMetaData";
            this.rsmd = res.getMetaData();
            debug = "getRowInfo()";
            this.rowinfo = this.getRowInfo();
            debug = "getRow(res)";
            Row ret = this.getRow(res);
            debug = "res.close()";
            res.close();
            return ret;
        }
        catch (SQLException ex) {
            throw new ETLDatabaseException("Error looking up row in database (" + debug + ")", ex);
        }
    }

    public DatabaseMetaData getDatabaseMetaData() throws ETLDatabaseException {
        try {
            if (this.dbmd == null) {
                this.dbmd = this.connection.getMetaData();
            }
        }
        catch (Exception e) {
            throw new ETLDatabaseException("Unable to get database metadata from this database connection", e);
        }
        return this.dbmd;
    }

    public String getDDL(String tablename, Row fields) throws ETLDatabaseException {
        return this.getDDL(tablename, fields, null, false, null, true);
    }

    public String getDDL(String tablename, Row fields, String tk, boolean use_autoinc, String pk) throws ETLDatabaseException {
        return this.getDDL(tablename, fields, tk, use_autoinc, pk, true);
    }

    public String getDDL(String tablename, Row fields, String tk, boolean use_autoinc, String pk, boolean semicolon) throws ETLDatabaseException {
        this.databaseMeta.replaceReservedWords(fields);
        String retval = this.checkTableExists(tablename) ? this.getAlterTableStatement(tablename, fields, tk, use_autoinc, pk, semicolon) : this.getCreateTableStatement(tablename, fields, tk, use_autoinc, pk, semicolon);
        return retval;
    }

    public String getCreateTableStatement(String tablename, Row fields, String tk, boolean use_autoinc, String pk, boolean semicolon) {
        String retval = "CREATE TABLE " + tablename + Const.CR;
        retval = retval + "(" + Const.CR;
        for (int i = 0; i < fields.size(); ++i) {
            retval = i > 0 ? retval + ", " : retval + "  ";
            Value v = fields.getValue(i);
            retval = retval + this.databaseMeta.getFieldDefinition(v, tk, pk, use_autoinc);
        }
        if (tk != null && this.databaseMeta.getDatabaseType() == 32) {
            retval = retval + ", PRIMARY KEY (" + tk + ")" + Const.CR;
        }
        if (pk != null && this.databaseMeta.getDatabaseType() == 4) {
            retval = retval + ", PRIMARY KEY (" + pk + ")" + Const.CR;
        }
        retval = retval + ")" + Const.CR;
        if (this.databaseMeta.getDatabaseType() == 4 && this.databaseMeta.getIndexTablespace() != null && this.databaseMeta.getIndexTablespace().length() > 0) {
            retval = retval + "TABLESPACE " + this.databaseMeta.getDataTablespace();
        }
        if (semicolon) {
            retval = retval + ";";
        }
        retval = retval + Const.CR;
        return retval;
    }

    public String getAlterTableStatement(String tablename, Row fields, String tk, boolean use_autoinc, String pk, boolean semicolon) throws ETLDatabaseException {
        int i;
        Value v;
        int i2;
        Value v2;
        int i3;
        String retval = "";
        Row tabFields = this.getTableFields(tablename);
        Row missing = new Row();
        for (i3 = 0; i3 < fields.size(); ++i3) {
            v2 = fields.getValue(i3);
            if (tabFields.searchValue(v2.getName()) != null) continue;
            missing.addValue(v2);
        }
        if (missing.size() != 0) {
            for (i3 = 0; i3 < missing.size(); ++i3) {
                v2 = missing.getValue(i3);
                retval = retval + this.databaseMeta.getAddColumnStatement(tablename, v2, tk, use_autoinc, pk, true);
            }
        }
        Row surplus = new Row();
        for (i2 = 0; i2 < tabFields.size(); ++i2) {
            v = tabFields.getValue(i2);
            if (fields.searchValue(v.getName()) != null) continue;
            surplus.addValue(v);
        }
        if (surplus.size() != 0) {
            for (i2 = 0; i2 < surplus.size(); ++i2) {
                v = surplus.getValue(i2);
                retval = retval + this.databaseMeta.getDropColumnStatement(tablename, v, tk, use_autoinc, pk, true);
            }
        }
        Row modify = new Row();
        for (i = 0; i < fields.size(); ++i) {
            Value desiredField = fields.getValue(i);
            Value currentField = tabFields.searchValue(desiredField.getName());
            if (currentField == null) continue;
            boolean mod = false;
            mod |= currentField.getLength() < desiredField.getLength() && desiredField.getLength() > 0;
            mod |= currentField.getPrecision() < desiredField.getPrecision() && desiredField.getPrecision() > 0;
            if (!(mod |= currentField.getType() != desiredField.getType() && currentField.isNumber() ^ desiredField.isNumeric())) continue;
            modify.addValue(desiredField);
        }
        if (modify.size() > 0) {
            for (i = 0; i < modify.size(); ++i) {
                Value v3 = modify.getValue(i);
                retval = retval + this.databaseMeta.getModifyColumnStatement(tablename, v3, tk, use_autoinc, pk, true);
            }
        }
        return retval;
    }

    public void checkDimZero(String tablename, String tk, String version, boolean use_autoinc) throws ETLDatabaseException {
        int start_tk = this.databaseMeta.getNotFoundTK(use_autoinc);
        String sql = "SELECT count(*) FROM " + tablename + " WHERE " + tk + " = " + start_tk;
        ResultSet rs = this.openQuery(sql, null);
        Row r = this.getRow(rs);
        Value count = r.getValue(0);
        if (count.getNumber() == 0.0) {
            try {
                String isql;
                Statement st = this.connection.createStatement();
                if (!this.databaseMeta.supportsAutoinc() || !use_autoinc) {
                    isql = "insert into " + tablename + "(" + tk + ", " + version + ") values (0, 1)";
                } else {
                    switch (this.databaseMeta.getDatabaseType()) {
                        case 4: 
                        case 32: {
                            isql = "insert into " + tablename + "(" + tk + ", " + version + ") values (0, 1)";
                            break;
                        }
                        case 2: 
                        case 8: {
                            isql = "insert into " + tablename + "(" + version + ") values (1)";
                            break;
                        }
                        default: {
                            isql = "insert into " + tablename + "(" + tk + ", " + version + ") values (0, 1)";
                        }
                    }
                }
                st.executeUpdate(this.databaseMeta.stripCR(isql));
            }
            catch (SQLException e) {
                throw new ETLDatabaseException("Error inserting 'unknown' row in dimension [" + tablename + "] : " + sql, e);
            }
        }
    }

    public Value checkSequence(String seqname) throws ETLDatabaseException {
        String sql = null;
        if (this.databaseMeta.supportsSequences()) {
            sql = this.databaseMeta.getSQLCurrentSequenceValue(seqname);
            ResultSet rs = this.openQuery(sql, null);
            Row r = this.getRow(rs);
            if (r != null) {
                Value last = r.getValue(0);
                return last;
            }
            return null;
        }
        throw new ETLDatabaseException("Sequences are only available for Oracle databases.");
    }

    public void truncateTable(String tablename) throws ETLDatabaseException {
        this.execStatement(this.databaseMeta.getTruncateTableStatement(tablename));
    }

    public Row getOneRow(String sql) throws ETLDatabaseException {
        ResultSet rs = this.openQuery(sql, null);
        if (rs != null) {
            Row r = this.getRow(rs);
            try {
                rs.close();
            }
            catch (Exception e) {
                throw new ETLDatabaseException("Unable to close resultset", e);
            }
            if (this.pstmt != null) {
                try {
                    this.pstmt.close();
                }
                catch (Exception e) {
                    throw new ETLDatabaseException("Unable to close prepared statement pstmt", e);
                }
                this.pstmt = null;
            }
            if (this.sel_stmt != null) {
                try {
                    this.sel_stmt.close();
                }
                catch (Exception e) {
                    throw new ETLDatabaseException("Unable to close prepared statement sel_stmt", e);
                }
                this.sel_stmt = null;
            }
            return r;
        }
        throw new ETLDatabaseException("error opening resultset for query: " + sql);
    }

    public Row getOneRow(String sql, Row param) throws ETLDatabaseException {
        ResultSet rs = this.openQuery(sql, param);
        if (rs != null) {
            Row r = this.getRow(rs);
            try {
                rs.close();
            }
            catch (Exception e) {
                throw new ETLDatabaseException("Unable to close resultset", e);
            }
            if (this.pstmt != null) {
                try {
                    this.pstmt.close();
                }
                catch (Exception e) {
                    throw new ETLDatabaseException("Unable to close prepared statement pstmt", e);
                }
                this.pstmt = null;
            }
            if (this.sel_stmt != null) {
                try {
                    this.sel_stmt.close();
                }
                catch (Exception e) {
                    throw new ETLDatabaseException("Unable to close prepared statement sel_stmt", e);
                }
                this.sel_stmt = null;
            }
            return r;
        }
        return null;
    }

    public Row getParameterMetaData(PreparedStatement ps) {
        Row par = new Row();
        try {
            ParameterMetaData pmd = ps.getParameterMetaData();
            for (int i = 1; i < pmd.getParameterCount(); ++i) {
                Value val;
                String name = "par" + i;
                int sqltype = pmd.getParameterType(i);
                int length = pmd.getPrecision(i);
                int precision = pmd.getScale(i);
                switch (sqltype) {
                    case 1: 
                    case 12: {
                        val = new Value(name, 2);
                        break;
                    }
                    case -6: 
                    case -5: 
                    case 2: 
                    case 4: 
                    case 5: {
                        val = new Value(name, 5);
                        break;
                    }
                    case 3: 
                    case 6: 
                    case 7: 
                    case 8: {
                        val = new Value(name, 1);
                        break;
                    }
                    case 91: 
                    case 92: 
                    case 93: {
                        val = new Value(name, 3);
                        break;
                    }
                    case 16: {
                        val = new Value(name, 4);
                        break;
                    }
                    default: {
                        val = new Value(name, 0);
                    }
                }
                if (val.isNumeric() && (length > 18 || precision > 18)) {
                    val = new Value(name, 6);
                }
                val.setNull();
                par.addValue(val);
            }
        }
        catch (AbstractMethodError e) {
            return null;
        }
        catch (SQLException e) {
            return null;
        }
        catch (Exception e) {
            return null;
        }
        return par;
    }

    public int countParameters(String sql) {
        int q = 0;
        boolean quote_opened = false;
        boolean dquote_opened = false;
        block5: for (int x = 0; x < sql.length(); ++x) {
            char c = sql.charAt(x);
            switch (c) {
                case '\'': {
                    quote_opened = !quote_opened;
                    continue block5;
                }
                case '\"': {
                    dquote_opened = !dquote_opened;
                    continue block5;
                }
                case '?': {
                    if (quote_opened || dquote_opened) continue block5;
                    ++q;
                }
            }
        }
        return q;
    }

    public Row getParameterMetaData(String sql, Row inform) {
        int q = this.countParameters(sql);
        Row par = new Row();
        if (inform != null && q == inform.size()) {
            for (int i = 0; i < q; ++i) {
                Value inf = inform.getValue(i);
                Value v = new Value(inf);
                par.addValue(v);
            }
        } else {
            for (int i = 0; i < q; ++i) {
                Value v = new Value("name" + i, 1);
                v.setValue(0.0);
                par.addValue(v);
            }
        }
        return par;
    }

    public static final Row getTransLogrecordFields(boolean use_batchid, boolean use_logfield) {
        Value v;
        Row r = new Row();
        if (use_batchid) {
            v = new Value("ID_BATCH", 5);
            v.setLength(8, 0);
            r.addValue(v);
        }
        v = new Value("TRANSNAME", 2);
        v.setLength(50);
        r.addValue(v);
        v = new Value("STATUS", 2);
        v.setLength(15);
        r.addValue(v);
        v = new Value("LINES_READ", 5);
        v.setLength(10, 0);
        r.addValue(v);
        v = new Value("LINES_WRITTEN", 5);
        v.setLength(10, 0);
        r.addValue(v);
        v = new Value("LINES_UPDATED", 5);
        v.setLength(10, 0);
        r.addValue(v);
        v = new Value("LINES_INPUT", 5);
        v.setLength(10, 0);
        r.addValue(v);
        v = new Value("LINES_OUTPUT", 5);
        v.setLength(10, 0);
        r.addValue(v);
        v = new Value("ERRORS", 5);
        v.setLength(10, 0);
        r.addValue(v);
        v = new Value("STARTDATE", 3);
        r.addValue(v);
        v = new Value("ENDDATE", 3);
        r.addValue(v);
        v = new Value("LOGDATE", 3);
        r.addValue(v);
        v = new Value("DEPDATE", 3);
        r.addValue(v);
        if (use_logfield) {
            v = new Value("LOG_FIELD", 2);
            v.setLength(9999999, 0);
            r.addValue(v);
        }
        return r;
    }

    public static final Row getJobLogrecordFields(boolean use_jobid, boolean use_logfield) {
        Value v;
        Row r = new Row();
        if (use_jobid) {
            v = new Value("ID_JOB", 2);
            v.setLength(50);
            r.addValue(v);
        }
        v = new Value("JOBNAME", 2);
        v.setLength(50);
        r.addValue(v);
        v = new Value("STATUS", 2);
        v.setLength(15);
        r.addValue(v);
        v = new Value("LINES_READ", 5);
        v.setLength(10, 0);
        r.addValue(v);
        v = new Value("LINES_WRITTEN", 5);
        v.setLength(10, 0);
        r.addValue(v);
        v = new Value("LINES_UPDATED", 5);
        v.setLength(10, 0);
        r.addValue(v);
        v = new Value("LINES_INPUT", 5);
        v.setLength(10, 0);
        r.addValue(v);
        v = new Value("LINES_OUTPUT", 5);
        v.setLength(10, 0);
        r.addValue(v);
        v = new Value("ERRORS", 5);
        v.setLength(10, 0);
        r.addValue(v);
        v = new Value("STARTDATE", 3);
        r.addValue(v);
        v = new Value("ENDDATE", 3);
        r.addValue(v);
        v = new Value("LOGDATE", 3);
        r.addValue(v);
        v = new Value("DEPDATE", 3);
        r.addValue(v);
        if (use_logfield) {
            v = new Value("LOG_FIELD", 2);
            v.setLength(9999999, 0);
            r.addValue(v);
        }
        return r;
    }

    public void writeLogRecord(String logtable, boolean use_id, long id, boolean job, String name, String status, long read, long written, long updated, long input, long output, long errors, java.util.Date startdate, java.util.Date enddate, java.util.Date logdate, java.util.Date depdate, String log_string) throws ETLDatabaseException {
        int parms;
        String sql = "INSERT INTO " + logtable + " ( ";
        if (job) {
            if (use_id) {
                sql = sql + "ID_JOB, JOBNAME";
                parms = 13;
            } else {
                sql = sql + "JOBNAME";
                parms = 12;
            }
        } else if (use_id) {
            sql = sql + "ID_BATCH, TRANSNAME";
            parms = 13;
        } else {
            sql = sql + "TRANSNAME";
            parms = 12;
        }
        sql = sql + ", STATUS, LINES_READ, LINES_WRITTEN, LINES_UPDATED, LINES_INPUT, LINES_OUTPUT, ERRORS, STARTDATE, ENDDATE, LOGDATE, DEPDATE";
        if (log_string != null && log_string.length() > 0) {
            sql = sql + ", LOG_FIELD";
        }
        sql = sql + ") VALUES(";
        for (int i = 0; i < parms; ++i) {
            sql = i == 0 ? sql + "?" : sql + ", ?";
        }
        if (log_string != null && log_string.length() > 0) {
            sql = sql + ", ?";
        }
        sql = sql + ")";
        try {
            this.pstmt = this.connection.prepareStatement(this.databaseMeta.stripCR(sql));
            Row r = new Row();
            if (job) {
                if (use_id) {
                    r.addValue(new Value("ID_BATCH", id));
                }
                r.addValue(new Value("TRANSNAME", name));
            } else {
                if (use_id) {
                    r.addValue(new Value("ID_JOB", id));
                }
                r.addValue(new Value("JOBNAME", name));
            }
            r.addValue(new Value("STATUS", status));
            r.addValue(new Value("LINES_READ", read));
            r.addValue(new Value("LINES_WRITTEN", written));
            r.addValue(new Value("LINES_UPDATED", updated));
            r.addValue(new Value("LINES_INPUT", input));
            r.addValue(new Value("LINES_OUTPUT", output));
            r.addValue(new Value("ERRORS", errors));
            r.addValue(new Value("STARTDATE", startdate));
            r.addValue(new Value("ENDDATE", enddate));
            r.addValue(new Value("LOGDATE", logdate));
            r.addValue(new Value("DEPDATE", depdate));
            if (log_string != null && log_string.length() > 0) {
                Value large = new Value("LOG_FIELD", log_string);
                large.setLength(9999999);
                r.addValue(large);
            }
            this.setValues(r);
            this.pstmt.executeUpdate();
            this.pstmt.close();
            this.pstmt = null;
        }
        catch (SQLException ex) {
            throw new ETLDatabaseException("Unable to write log record to log table " + logtable, ex);
        }
    }

    public Row getLastLogDate(String logtable, String name, boolean job, String status) throws ETLDatabaseException {
        Row row = null;
        String jobtrans = job ? "JOBNAME" : "TRANSNAME";
        String sql = "";
        sql = sql + " SELECT ENDDATE, DEPDATE, STARTDATE";
        sql = sql + " FROM " + logtable;
        sql = sql + " WHERE  ERRORS    = 0";
        sql = sql + " AND    STATUS    = 'end'";
        sql = sql + " AND    " + jobtrans + " = ?";
        sql = sql + " ORDER BY LOGDATE DESC, ENDDATE DESC";
        try {
            this.pstmt = this.connection.prepareStatement(this.databaseMeta.stripCR(sql));
            Row r = new Row();
            r.addValue(new Value("TRANSNAME", name));
            this.setValues(r);
            ResultSet res = this.pstmt.executeQuery();
            if (res != null) {
                this.rsmd = res.getMetaData();
                this.rowinfo = this.getRowInfo();
                row = this.getRow(res);
                res.close();
            }
            this.pstmt.close();
            this.pstmt = null;
        }
        catch (SQLException ex) {
            throw new ETLDatabaseException("Unable to obtain last logdate from table " + logtable, ex);
        }
        return row;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void getNextValue(TransMeta transMeta, String table, Value val_key) throws ETLDatabaseException {
        String lookup = table + "." + val_key.getName();
        Counter counter = (Counter)transMeta.getCounters().get(lookup);
        if (counter == null) {
            Row r = this.getOneRow("SELECT MAX(" + val_key.getName() + ") FROM " + table);
            if (r == null) throw new ETLDatabaseException("Couldn't find maximum key value from table " + table);
            counter = new Counter(r.getValue(0).getInteger() + 1L, 1L);
            val_key.setValue(counter.next());
            transMeta.getCounters().put(lookup, counter);
            return;
        } else {
            val_key.setValue(counter.next());
        }
    }

    public String toString() {
        if (this.databaseMeta != null) {
            return this.databaseMeta.getName();
        }
        return "-";
    }

    public boolean isSystemTable(String table_name) {
        if (this.databaseMeta.getDatabaseType() == 2) {
            if (table_name.startsWith("sys")) {
                return true;
            }
            if (table_name.equals("dtproperties")) {
                return true;
            }
        }
        return false;
    }

    public ArrayList getRows(String sql, int limit) throws ETLDatabaseException {
        return this.getRows(sql, limit, null);
    }

    public ArrayList getRows(String sql, int limit, IProgressMonitor monitor) throws ETLDatabaseException {
        ResultSet rset;
        int i = 0;
        boolean stop = false;
        ArrayList<Row> result = new ArrayList<Row>();
        if (monitor != null) {
            monitor.setTaskName("Opening query...");
        }
        if ((rset = this.openQuery(sql)) != null) {
            if (monitor != null && limit > 0) {
                monitor.beginTask("Reading rows...", limit);
            }
            while (!(limit > 0 && i >= limit || stop)) {
                Row row = this.getRow(rset);
                if (row != null) {
                    result.add(row);
                    ++i;
                } else {
                    stop = true;
                }
                if (monitor == null || limit <= 0) continue;
                monitor.worked(1);
            }
            this.closeQuery(rset);
            if (monitor != null) {
                monitor.done();
            }
        }
        return result;
    }

    public ArrayList getFirstRows(String table_name, int limit) throws ETLDatabaseException {
        return this.getFirstRows(table_name, limit, null);
    }

    public ArrayList getFirstRows(String table_name, int limit, IProgressMonitor monitor) throws ETLDatabaseException {
        String sql = "SELECT * FROM " + table_name;
        if (limit > 0) {
            sql = sql + this.databaseMeta.getLimitClause(limit);
        }
        return this.getRows(sql, limit, monitor);
    }

    public Row getReturnRow() {
        return this.rowinfo;
    }

    public String[] getTableTypes() throws ETLDatabaseException {
        try {
            ArrayList<String> types = new ArrayList<String>();
            ResultSet rstt = this.getDatabaseMetaData().getTableTypes();
            while (rstt.next()) {
                String ttype = rstt.getString("TABLE_TYPE");
                types.add(ttype);
            }
            return types.toArray(new String[types.size()]);
        }
        catch (SQLException e) {
            throw new ETLDatabaseException("Unable to get table types from database!", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getTablenames() throws ETLDatabaseException {
        String schemaname = null;
        if (this.databaseMeta.useSchemaNameForTableList()) {
            schemaname = this.databaseMeta.getUsername().toUpperCase();
        }
        ArrayList<String> names = new ArrayList<String>();
        ResultSet alltables = null;
        try {
            alltables = this.getDatabaseMetaData().getTables(null, schemaname, null, this.databaseMeta.getTableTypes());
            while (alltables.next()) {
                String table = alltables.getString("TABLE_NAME");
                this.log.logRowlevel(this.toString(), "got table from meta-data: " + table);
                names.add(table);
            }
        }
        catch (SQLException e) {
            this.log.logError(this.toString(), "Error getting tablenames from schema [" + schemaname + "]");
        }
        finally {
            try {
                if (alltables != null) {
                    alltables.close();
                }
            }
            catch (SQLException e) {
                throw new ETLDatabaseException("Error closing resultset after getting views from schema [" + schemaname + "]", e);
            }
        }
        this.log.logDetailed(this.toString(), "read :" + names.size() + " table names from db meta-data.");
        return names.toArray(new String[names.size()]);
    }

    public String[] getViews() throws ETLDatabaseException {
        if (!this.databaseMeta.supportsViews()) {
            return new String[0];
        }
        String schemaname = null;
        if (this.databaseMeta.useSchemaNameForTableList()) {
            schemaname = this.databaseMeta.getUsername().toUpperCase();
        }
        ArrayList<String> names = new ArrayList<String>();
        ResultSet alltables = null;
        try {
            alltables = this.dbmd.getTables(null, schemaname, null, this.databaseMeta.getViewTypes());
            while (alltables.next()) {
                String table = alltables.getString("TABLE_NAME");
                this.log.logRowlevel(this.toString(), "got view from meta-data: " + table);
                names.add(table);
            }
        }
        catch (SQLException e) {
            throw new ETLDatabaseException("Error getting views from schema [" + schemaname + "]", e);
        }
        finally {
            try {
                if (alltables != null) {
                    alltables.close();
                }
            }
            catch (SQLException e) {
                throw new ETLDatabaseException("Error closing resultset after getting views from schema [" + schemaname + "]", e);
            }
        }
        this.log.logDetailed(this.toString(), "read :" + names.size() + " views from db meta-data.");
        return names.toArray(new String[names.size()]);
    }

    public String[] getSynonyms() throws ETLDatabaseException {
        if (!this.databaseMeta.supportsSynonyms()) {
            return new String[0];
        }
        String schemaname = null;
        if (this.databaseMeta.useSchemaNameForTableList()) {
            schemaname = this.databaseMeta.getUsername().toUpperCase();
        }
        ArrayList<String> names = new ArrayList<String>();
        ResultSet alltables = null;
        try {
            alltables = this.dbmd.getTables(null, schemaname, null, this.databaseMeta.getSynonymTypes());
            while (alltables.next()) {
                String table = alltables.getString("TABLE_NAME");
                this.log.logRowlevel(this.toString(), "got view from meta-data: " + table);
                names.add(table);
            }
        }
        catch (SQLException e) {
            throw new ETLDatabaseException("Error getting synonyms from schema [" + schemaname + "]", e);
        }
        finally {
            try {
                if (alltables != null) {
                    alltables.close();
                }
            }
            catch (SQLException e) {
                throw new ETLDatabaseException("Error closing resultset after getting synonyms from schema [" + schemaname + "]", e);
            }
        }
        this.log.logDetailed(this.toString(), "read :" + names.size() + " views from db meta-data.");
        return names.toArray(new String[names.size()]);
    }

    public String[] getProcedures() throws ETLDatabaseException {
        String sql = this.databaseMeta.getSQLListOfProcedures();
        if (sql != null) {
            ArrayList procs = this.getRows(sql, 1000);
            String[] str = new String[procs.size()];
            for (int i = 0; i < procs.size(); ++i) {
                str[i] = ((Row)procs.get(i)).getValue(0).getString();
            }
            return str;
        }
        return null;
    }

    public boolean isAutoCommit() {
        return this.commitsize <= 0;
    }

    public DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }

    public void lockTables(String[] tableNames) throws ETLDatabaseException {
        String sql = this.databaseMeta.getSQLLockTables(tableNames);
        if (sql != null) {
            this.execStatements(sql);
        }
    }

    public void unlockTables(String[] tableNames) throws ETLDatabaseException {
        String sql = this.databaseMeta.getSQLUnlockTables(tableNames);
        if (sql != null) {
            this.execStatement(sql);
        }
    }

    public long getNextID(String tableName, String fieldName) throws ETLDatabaseException {
        String counterName = tableName + "." + fieldName;
        Counter counter = Counters.getInstance().getCounter(counterName);
        if (counter == null) {
            long id = this.getNextTableID(tableName, fieldName);
            counter = new Counter(id);
            Counters.getInstance().setCounter(counterName, counter);
            return counter.next();
        }
        return counter.next();
    }

    private long getNextTableID(String tablename, String idfield) throws ETLDatabaseException {
        long retval = -1L;
        Row r = this.getOneRow("SELECT max(" + idfield + ") FROM " + tablename);
        if (r != null) {
            Value id = r.getValue(0);
            if (id.isNull()) {
                this.log.logDebug(this.toString(), "no max(" + idfield + ") found in table " + tablename);
                retval = 1L;
            } else {
                this.log.logDebug(this.toString(), "max(" + idfield + ") found in table " + tablename + " --> " + id.getInteger() + " number: " + id.getNumber());
                retval = id.getInteger() + 10000L;
            }
        }
        return retval;
    }

    public long getNextJobAuditID() throws ETLDatabaseException {
        return this.getNextID("T_ETL_JobAudit", "ID_JobAudit");
    }

    public long getNextJobErrorLogID() throws ETLDatabaseException {
        return this.getNextID("T_ETL_JobErrorLog", "ID_JobErrorLog");
    }

    public void dimPunchThrough(Row row, String table, int[] fieldupdate, String[] fieldlookup, int[] fieldnrs, String[] key, String[] keylookup, int[] keynrs) throws ETLDatabaseException {
        int i;
        if (this.pstmt_pun == null) {
            String sql_upd = "UPDATE " + table + Const.CR;
            sql_upd = sql_upd + "SET ";
            boolean first = true;
            for (i = 0; i < fieldlookup.length; ++i) {
                if (fieldupdate[i] != 2) continue;
                sql_upd = !first ? sql_upd + ", " : sql_upd + "  ";
                first = false;
                sql_upd = sql_upd + fieldlookup[i] + " = ?" + Const.CR;
            }
            sql_upd = sql_upd + "WHERE ";
            for (i = 0; i < keylookup.length; ++i) {
                if (i > 0) {
                    sql_upd = sql_upd + "AND   ";
                }
                sql_upd = sql_upd + keylookup[i] + " = ?" + Const.CR;
            }
            try {
                this.pstmt_pun = this.connection.prepareStatement(this.databaseMeta.stripCR(sql_upd));
            }
            catch (SQLException ex) {
                throw new ETLDatabaseException("Unable to prepare dimension punchThrough update statement : " + Const.CR + sql_upd, ex);
            }
        }
        Row rupd = new Row();
        for (i = 0; i < fieldlookup.length; ++i) {
            if (fieldupdate[i] != 2) continue;
            rupd.addValue(row.getValue(fieldnrs[i]));
        }
        for (i = 0; i < keynrs.length; ++i) {
            rupd.addValue(row.getValue(keynrs[i]));
        }
        this.setValues(rupd, this.pstmt_pun);
        this.insertRow(this.pstmt_pun);
    }
}

