/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.job;

import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.exception.ETLXMLException;
import com.kingdee.bos.ctrl.etl.job.Job;
import com.kingdee.bos.ctrl.etl.job.JobMeta;
import com.kingdee.bos.ctrl.etl.repository.Repository;
import com.kingdee.bos.ctrl.etl.repository.RepositoryDirectory;
import com.kingdee.bos.ctrl.etl.transformation.StepLoader;
import com.kingdee.bos.ctrl.etl.util.LogWriter;
import java.sql.Connection;

public class JobFactory {
    public static Job createJob(String xmlFilename, Connection ctxConnection) throws ETLXMLException {
        LogWriter log = LogWriter.getInstance();
        StepLoader steploader = StepLoader.getInstance();
        JobMeta jobinfo = new JobMeta(log, xmlFilename, ctxConnection);
        Job job = new Job(log, steploader, null, jobinfo);
        return job;
    }

    public static Job createJob(Repository rep, String jobname, RepositoryDirectory repdir) throws ETLException {
        LogWriter log = LogWriter.getInstance();
        StepLoader steploader = StepLoader.getInstance();
        JobMeta jobinfo = new JobMeta(log, rep, jobname, repdir);
        Job job = new Job(log, steploader, rep, jobinfo);
        return job;
    }

    public static Job createJob(Repository rep, long id_job) throws ETLException {
        LogWriter log = LogWriter.getInstance();
        StepLoader steploader = StepLoader.getInstance();
        String jobname = rep.getJobName(id_job);
        RepositoryDirectory repdir = rep.getJobRepDir(id_job);
        JobMeta jobinfo = new JobMeta(log, rep, jobname, repdir);
        Job job = new Job(log, steploader, rep, jobinfo);
        return job;
    }
}

