/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.job;

import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.exception.ETLDatabaseException;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.exception.ETLXMLException;
import com.kingdee.bos.ctrl.etl.job.JobMeta;
import com.kingdee.bos.ctrl.etl.job.entry.JobEntryCopy;
import com.kingdee.bos.ctrl.etl.repository.Repository;
import com.kingdee.bos.ctrl.etl.util.Const;
import com.kingdee.bos.ctrl.etl.util.Util;
import com.kingdee.bos.ctrl.etl.util.XMLHandler;
import com.kingdee.bos.ctrl.etl.util.XMLInterface;
import java.util.List;
import org.w3c.dom.Node;

public class JobHopMeta
implements Cloneable,
XMLInterface {
    public JobEntryCopy from_entry;
    public JobEntryCopy to_entry;
    private boolean enabled;
    private boolean split;
    private boolean evaluation;
    private boolean unconditional;
    private boolean changed;
    private long id;

    public JobHopMeta() {
        this((JobEntryCopy)null, (JobEntryCopy)null);
    }

    public JobHopMeta(JobEntryCopy from, JobEntryCopy to) {
        this.from_entry = from;
        this.to_entry = to;
        this.enabled = true;
        this.split = false;
        this.evaluation = true;
        this.unconditional = false;
        this.id = -1L;
        if (from.isStart()) {
            this.setUnconditional();
        }
    }

    public JobHopMeta(Node hopnode, JobMeta job) throws ETLXMLException {
        try {
            String from_name = XMLHandler.getTagValue(hopnode, "from");
            String to_name = XMLHandler.getTagValue(hopnode, "to");
            String sfrom_nr = XMLHandler.getTagValue(hopnode, "from_nr");
            String sto_nr = XMLHandler.getTagValue(hopnode, "to_nr");
            String senabled = XMLHandler.getTagValue(hopnode, "enabled");
            String sevaluation = XMLHandler.getTagValue(hopnode, "evaluation");
            String sunconditional = XMLHandler.getTagValue(hopnode, "unconditional");
            int from_nr = Const.toInt(sfrom_nr, 0);
            int to_nr = Const.toInt(sto_nr, 0);
            this.from_entry = job.findJobEntry(from_name, from_nr);
            this.to_entry = job.findJobEntry(to_name, to_nr);
            this.enabled = senabled == null ? true : "Y".equalsIgnoreCase(senabled);
            this.evaluation = sevaluation == null ? true : "Y".equalsIgnoreCase(sevaluation);
            this.unconditional = "Y".equalsIgnoreCase(sunconditional);
        }
        catch (Exception e) {
            throw new ETLXMLException("Unable to load job hop info from XML node", e);
        }
    }

    @Override
    public String getXML() {
        String retval = "";
        retval = retval + "    <hop>" + Const.CR;
        retval = retval + "      " + XMLHandler.addTagValue("from", this.from_entry.getName());
        retval = retval + "      " + XMLHandler.addTagValue("to", this.to_entry.getName());
        retval = retval + "      " + XMLHandler.addTagValue("from_nr", this.from_entry.getNr());
        retval = retval + "      " + XMLHandler.addTagValue("to_nr", this.to_entry.getNr());
        retval = retval + "      " + XMLHandler.addTagValue("enabled", this.enabled);
        retval = retval + "      " + XMLHandler.addTagValue("evaluation", this.evaluation);
        retval = retval + "      " + XMLHandler.addTagValue("unconditional", this.unconditional);
        retval = retval + "      </hop>" + Const.CR;
        return retval;
    }

    public JobHopMeta(Repository rep, long id_job_hop, JobMeta job, List jobcopies) throws ETLException {
        try {
            Row r = rep.getJobHop(id_job_hop);
            if (r != null) {
                long id_jobentry_copy_from = r.getInteger("ID_JobEntryCopyFrom", -1L);
                long id_jobentry_copy_to = r.getInteger("ID_JobEntryCopyTo", -1L);
                this.enabled = r.getBoolean("Enabled", true);
                this.evaluation = r.getBoolean("Evaluation", true);
                this.unconditional = r.getBoolean("UnConditional", !this.evaluation);
                this.from_entry = Util.findJobEntryCopy(jobcopies, id_jobentry_copy_from);
                this.to_entry = Util.findJobEntryCopy(jobcopies, id_jobentry_copy_to);
            }
        }
        catch (ETLDatabaseException dbe) {
            throw new ETLException("Unable to load job hop with id_job_hop=" + id_job_hop, dbe);
        }
    }

    public void saveRep(Repository rep, long id_job) throws ETLException {
        try {
            long id_jobentry_from = -1L;
            long id_jobentry_to = -1L;
            id_jobentry_from = this.from_entry == null ? -1L : this.from_entry.getID();
            id_jobentry_to = this.to_entry == null ? -1L : this.to_entry.getID();
            this.setID(rep.insertJobHop(id_job, id_jobentry_from, id_jobentry_to, this.enabled, this.evaluation, this.unconditional));
        }
        catch (ETLDatabaseException dbe) {
            throw new ETLException("Unable to save job hop with id_job = " + id_job, dbe);
        }
    }

    public void setID(long id) {
        this.id = id;
    }

    public long getID() {
        return this.id;
    }

    public Object clone() {
        try {
            Object retval = super.clone();
            return retval;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public void setChanged() {
        this.setChanged(true);
    }

    public void setChanged(boolean ch) {
        this.changed = ch;
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public void setEnabled() {
        this.setEnabled(true);
    }

    public void setEnabled(boolean en) {
        this.enabled = en;
        this.setChanged();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean getEvaluation() {
        return this.evaluation;
    }

    public void setEvaluation() {
        this.setEvaluation(true);
    }

    public void setEvaluation(boolean e) {
        this.evaluation = e;
    }

    public void setUnconditional() {
        if (!this.unconditional) {
            this.setChanged();
        }
        this.unconditional = true;
    }

    public void setConditional() {
        if (this.unconditional) {
            this.setChanged();
        }
        this.unconditional = false;
    }

    public boolean isUnconditional() {
        return this.unconditional;
    }

    public void setSplit(boolean split) {
        if (this.split != split) {
            this.setChanged();
        }
        this.split = split;
    }

    public boolean isSplit() {
        return this.split;
    }

    public String getDescription() {
        if (this.isUnconditional()) {
            return "Execute the next job entry unconditonally";
        }
        if (this.getEvaluation()) {
            return "Execute the next job entry if the previous one ran flawless.";
        }
        return "Execute the next job entry if the previous one failed.";
    }

    public String toString() {
        return this.getDescription();
    }
}

