/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.job;

import com.kingdee.bos.ctrl.etl.base.NotePadMeta;
import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.cache.DBCache;
import com.kingdee.bos.ctrl.etl.database.DatabaseMeta;
import com.kingdee.bos.ctrl.etl.exception.ETLDatabaseException;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.exception.ETLXMLException;
import com.kingdee.bos.ctrl.etl.job.JobHopMeta;
import com.kingdee.bos.ctrl.etl.job.JobLog;
import com.kingdee.bos.ctrl.etl.job.entry.JobEntryCopy;
import com.kingdee.bos.ctrl.etl.job.entry.JobEntryInterface;
import com.kingdee.bos.ctrl.etl.job.entry.eval.JobEntryEval_Javascript;
import com.kingdee.bos.ctrl.etl.job.entry.special.JobEntrySpecial;
import com.kingdee.bos.ctrl.etl.repository.Repository;
import com.kingdee.bos.ctrl.etl.repository.RepositoryDirectory;
import com.kingdee.bos.ctrl.etl.util.Const;
import com.kingdee.bos.ctrl.etl.util.IProgressMonitor;
import com.kingdee.bos.ctrl.etl.util.LogWriter;
import com.kingdee.bos.ctrl.etl.util.Point;
import com.kingdee.bos.ctrl.etl.util.XMLHandler;
import com.kingdee.bos.ctrl.etl.util.XMLInterface;
import com.kingdee.bos.ctrl.etl.value.Value;
import java.awt.Rectangle;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class JobMeta
implements Cloneable,
XMLInterface {
    public LogWriter log;
    private long id;
    private JobLog joblog;
    private String name;
    private String description;
    private String modifiedUser;
    private String modifiedDate;
    private String filename;
    private String scheduleName;
    public List jobentries;
    public List jobcopies;
    public List jobhops;
    public List notes;
    public List databases;
    private RepositoryDirectory directory;
    public String[] arguments;
    private boolean changed;
    private boolean changed_entries;
    private boolean changed_hops;
    private boolean changed_notes;
    private DatabaseMeta logconnection;
    public String logAuditTable;
    public String logErrorTable;
    public DBCache dbcache;
    private List undo;
    private int max_undo;
    public static final int TYPE_UNDO_CHANGE = 1;
    public static final int TYPE_UNDO_NEW = 2;
    public static final int TYPE_UNDO_DELETE = 3;
    public static final int TYPE_UNDO_POSITION = 4;
    public static final String STRING_SPECIAL_START = "START";
    public static final String STRING_SPECIAL_DUMMY = "DUMMY";
    public boolean[] max;
    public Rectangle[] size;
    public String created_user;
    public String modified_user;
    public Value created_date;
    public Value modified_date;

    public JobMeta(LogWriter l) {
        this.joblog = null;
        this.name = "";
        this.description = "";
        this.modifiedUser = "";
        this.modifiedDate = "";
        this.scheduleName = "";
        this.max = new boolean[1];
        this.size = new Rectangle[1];
        this.log = l;
        this.clear();
    }

    public long getID() {
        return this.id;
    }

    public void setID(long id) {
        this.id = id;
    }

    public void clear() {
        this.name = null;
        this.jobcopies = new ArrayList();
        this.jobentries = new ArrayList();
        this.jobhops = new ArrayList();
        this.notes = new ArrayList();
        this.databases = new ArrayList();
        this.logconnection = null;
        this.logErrorTable = null;
        this.logAuditTable = null;
        this.arguments = null;
        this.max_undo = 100;
        this.dbcache = DBCache.getInstance();
        this.undo = new ArrayList();
        this.addDefaults();
        this.setChanged(false);
        this.modified_user = "-";
        this.modified_date = null;
        this.directory = new RepositoryDirectory();
    }

    public void addDefaults() {
        this.addStart();
        this.addDummy();
        this.addOK();
        this.addError();
        this.clearChanged();
    }

    private void addStart() {
        JobEntrySpecial je = new JobEntrySpecial(STRING_SPECIAL_START, true, false);
        JobEntryCopy jge = new JobEntryCopy(this.log);
        jge.setID(-1L);
        jge.setEntry(je);
        jge.setLocation(50, 50);
        jge.setDrawn(false);
        jge.setDescription("A job starts to process here.");
        this.addJobEntry(jge);
    }

    private void addDummy() {
        JobEntrySpecial dummy = new JobEntrySpecial(STRING_SPECIAL_DUMMY, false, true);
        JobEntryCopy dummyge = new JobEntryCopy(this.log);
        dummyge.setID(-1L);
        dummyge.setEntry(dummy);
        dummyge.setLocation(50, 50);
        dummyge.setDrawn(false);
        dummyge.setDescription("A dummy entry.");
        this.addJobEntry(dummyge);
    }

    public void addOK() {
        JobEntryEval_Javascript ok = new JobEntryEval_Javascript("OK", "errors == 0");
        JobEntryCopy jgok = new JobEntryCopy(this.log);
        jgok.setEntry(ok);
        jgok.setLocation(0, 0);
        jgok.setDrawn(false);
        jgok.setDescription("This comparisson is true when no errors have occured.");
        this.addJobEntry(jgok);
    }

    public void addError() {
        JobEntryEval_Javascript err = new JobEntryEval_Javascript("ERROR", "errors != 0");
        JobEntryCopy jgerr = new JobEntryCopy(this.log);
        jgerr.setEntry(err);
        jgerr.setLocation(0, 0);
        jgerr.setDrawn(false);
        jgerr.setDescription("This comparisson is true when one or more errors have occured.");
        this.addJobEntry(jgerr);
    }

    public JobEntryCopy getStart() {
        for (int i = 0; i < this.nrJobEntries(); ++i) {
            JobEntryCopy cge = this.getJobEntry(i);
            if (!cge.isStart()) continue;
            return cge;
        }
        return null;
    }

    public JobEntryCopy getDummy() {
        for (int i = 0; i < this.nrJobEntries(); ++i) {
            JobEntryCopy cge = this.getJobEntry(i);
            if (!cge.isDummy()) continue;
            return cge;
        }
        return null;
    }

    public boolean equals(Object obj) {
        return this.name.equalsIgnoreCase(((JobMeta)obj).name);
    }

    public Object clone() {
        try {
            Object retval = super.clone();
            return retval;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getModifiedUser() {
        return this.modifiedUser;
    }

    public String getModifiedDate() {
        return this.modifiedDate;
    }

    public void setName(String name) {
        this.name = name;
    }

    public RepositoryDirectory getDirectory() {
        return this.directory;
    }

    public void setDirectory(RepositoryDirectory directory) {
        this.directory = directory;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public DatabaseMeta getLogConnection() {
        return this.logconnection;
    }

    public void setLogConnection(DatabaseMeta ci) {
        this.logconnection = ci;
    }

    public void setChanged() {
        this.setChanged(true);
    }

    public void setChanged(boolean ch) {
        this.changed = ch;
    }

    public void clearChanged() {
        int i;
        this.changed_entries = false;
        this.changed_hops = false;
        this.changed_notes = false;
        for (i = 0; i < this.nrJobEntries(); ++i) {
            JobEntryCopy entry = this.getJobEntry(i);
            entry.setChanged(false);
        }
        for (i = 0; i < this.nrJobHops(); ++i) {
            JobHopMeta hop = this.getJobHop(i);
            hop.setChanged(false);
        }
        this.changed = false;
    }

    public boolean hasChanged() {
        int i;
        if (this.changed || this.changed_notes || this.changed_entries || this.changed_hops) {
            return true;
        }
        for (i = 0; i < this.nrJobEntries(); ++i) {
            JobEntryCopy entry = this.getJobEntry(i);
            if (!entry.hasChanged()) continue;
            return true;
        }
        for (i = 0; i < this.nrJobHops(); ++i) {
            JobHopMeta hop = this.getJobHop(i);
            if (!hop.hasChanged()) continue;
            return true;
        }
        return false;
    }

    private void saveRepJob(Repository rep) throws ETLException {
        try {
            rep.insertJob2(this.getID(), this.directory.getID(), this.getName(), this.getDescription(), 0L, this.logAuditTable, this.logErrorTable, this.modified_user, null);
        }
        catch (ETLDatabaseException dbe) {
            throw new ETLException("Unable to save job info to repository", dbe);
        }
    }

    public boolean showReplaceWarning(Repository rep) {
        if (this.getID() < 0L) {
            try {
                if (rep.getJobID(this.getName(), this.directory.getID()) > 0L) {
                    return true;
                }
            }
            catch (ETLDatabaseException dbe) {
                return true;
            }
        }
        return false;
    }

    @Override
    public String getXML() {
        int i;
        DatabaseMeta ci = this.getLogConnection();
        String retval = new String();
        retval = retval + "<job>" + Const.CR;
        retval = retval + "  " + XMLHandler.addTagValue("name", this.getName());
        retval = retval + "  " + XMLHandler.addTagValue("directory", this.directory.getPath());
        for (i = 0; i < this.nrDatabases(); ++i) {
            DatabaseMeta dbinfo = this.getDatabase(i);
            retval = retval + dbinfo.getXML();
        }
        retval = retval + "  " + XMLHandler.addTagValue("logconnection", ci == null ? "" : ci.getName());
        retval = retval + "  " + XMLHandler.addTagValue("logaudittable", this.logAuditTable);
        retval = retval + "  " + XMLHandler.addTagValue("logerrortable", this.logErrorTable);
        retval = retval + "  <entries>" + Const.CR;
        for (i = 0; i < this.nrJobEntries(); ++i) {
            JobEntryCopy jge = this.getJobEntry(i);
            retval = retval + jge.getXML();
        }
        retval = retval + "    </entries>" + Const.CR;
        retval = retval + "  <hops>" + Const.CR;
        for (i = 0; i < this.nrJobHops(); ++i) {
            JobHopMeta hi = this.getJobHop(i);
            retval = retval + hi.getXML();
        }
        retval = retval + "    </hops>" + Const.CR;
        retval = retval + "  <notepads>" + Const.CR;
        for (i = 0; i < this.nrNotes(); ++i) {
            NotePadMeta ni = this.getNote(i);
            retval = retval + ni.getXML();
        }
        retval = retval + "    </notepads>" + Const.CR;
        retval = retval + "  </job>" + Const.CR;
        return retval;
    }

    public JobMeta(LogWriter log, String fname, Connection ctxConnection) throws ETLXMLException {
        this.joblog = null;
        this.name = "";
        this.description = "";
        this.modifiedUser = "";
        this.modifiedDate = "";
        this.scheduleName = "";
        this.max = new boolean[1];
        this.size = new Rectangle[1];
        this.log = log;
        try {
            Document doc = XMLHandler.loadXMLFile(fname);
            if (doc == null) {
                throw new ETLXMLException("Error reading/validating information from XML file: " + fname);
            }
            this.clear();
            this.setFilename(fname);
            Node jobnode = XMLHandler.getSubNode(doc, "job");
            this.loadXML(jobnode, ctxConnection);
        }
        catch (Exception e) {
            throw new ETLXMLException("Unable to load the job from XML file [" + fname + "]", e);
        }
    }

    public JobMeta(LogWriter log, Node jobnode, Connection ctxConnection) throws ETLXMLException {
        this.joblog = null;
        this.name = "";
        this.description = "";
        this.modifiedUser = "";
        this.modifiedDate = "";
        this.scheduleName = "";
        this.max = new boolean[1];
        this.size = new Rectangle[1];
        this.log = log;
        this.loadXML(jobnode, ctxConnection);
    }

    public void loadXML(Node jobnode, Connection ctxConnection) throws ETLXMLException {
        try {
            this.name = XMLHandler.getTagValue(jobnode, "name");
            this.description = XMLHandler.getTagValue(jobnode, "description");
            this.modifiedUser = XMLHandler.getTagValue(jobnode, "modifiedUser");
            this.modifiedDate = XMLHandler.getTagValue(jobnode, "modifiedDate");
            int nr = XMLHandler.countNodes(jobnode, "connection");
            for (int i = 0; i < nr; ++i) {
                Node dbnode = XMLHandler.getSubNodeByNr(jobnode, "connection", i);
                DatabaseMeta dbinf = new DatabaseMeta(dbnode);
                this.addDatabase(dbinf);
            }
            if (ctxConnection != null) {
                DatabaseMeta dbinf = new DatabaseMeta(ctxConnection);
                this.addDatabase(dbinf);
            }
            this.logAuditTable = XMLHandler.getTagValue(jobnode, "logaudittable");
            if (this.logAuditTable != null) {
                String logcon = XMLHandler.getTagValue(jobnode, "logconnection");
                if (logcon == null) {
                    logcon = "";
                }
                this.logconnection = this.findDatabase(logcon);
                this.logErrorTable = XMLHandler.getTagValue(jobnode, "logerrortable");
                this.joblog = new JobLog(this, this.logconnection, this.logAuditTable, this.logErrorTable);
            }
            Node entriesnode = XMLHandler.getSubNode(jobnode, "entries");
            int tr = XMLHandler.countNodes(entriesnode, "entry");
            for (int i = 0; i < tr; ++i) {
                Node entrynode = XMLHandler.getSubNodeByNr(entriesnode, "entry", i);
                JobEntryCopy je = new JobEntryCopy(entrynode, this.databases, null, ctxConnection);
                JobEntryCopy prev = this.findJobEntry(je.getName(), 0);
                if (prev != null) {
                    int idx;
                    if (je.getNr() == 0) {
                        idx = this.indexOfJobEntry(prev);
                        this.removeJobEntry(idx);
                    } else if (je.getNr() > 0) {
                        je.setEntry(prev.getEntry());
                        prev = this.findJobEntry(je.getName(), je.getNr());
                        if (prev != null) {
                            idx = this.indexOfJobEntry(prev);
                            this.removeJobEntry(idx);
                        }
                    }
                }
                this.addJobEntry(je);
            }
            Node hopsnode = XMLHandler.getSubNode(jobnode, "hops");
            int ho = XMLHandler.countNodes(hopsnode, "hop");
            for (int i = 0; i < ho; ++i) {
                Node hopnode = XMLHandler.getSubNodeByNr(hopsnode, "hop", i);
                JobHopMeta hi = new JobHopMeta(hopnode, this);
                this.jobhops.add(hi);
            }
            Node notepadsnode = XMLHandler.getSubNode(jobnode, "notepads");
            int nrnotes = XMLHandler.countNodes(notepadsnode, "notepad");
            for (int i = 0; i < nrnotes; ++i) {
                Node notepadnode = XMLHandler.getSubNodeByNr(notepadsnode, "notepad", i);
                NotePadMeta ni = new NotePadMeta(notepadnode);
                this.notes.add(ni);
            }
            if (this.findJobEntry(STRING_SPECIAL_START, 0) == null) {
                this.addStart();
            }
            if (this.findJobEntry(STRING_SPECIAL_DUMMY, 0) == null) {
                this.addDummy();
            }
        }
        catch (Exception e) {
            throw new ETLXMLException("Unable to load job info from XML node", e);
        }
    }

    public void readDatabases(Repository rep) {
        try {
            long[] dbids = rep.getDatabaseIDs();
            for (int i = 0; i < dbids.length; ++i) {
                DatabaseMeta ci = new DatabaseMeta(rep, dbids[i]);
                if (this.indexOfDatabase(ci) >= 0) continue;
                this.addDatabase(ci);
                ci.setChanged(false);
            }
        }
        catch (ETLDatabaseException dbe) {
            this.log.logError(this.toString(), "Error reading databases from repository:" + Const.CR + dbe.getMessage());
        }
        catch (ETLException ke) {
            this.log.logError(this.toString(), "Error reading databases from repository:" + Const.CR + ke.getMessage());
        }
        this.setChanged(false);
    }

    public DatabaseMeta findDatabase(String name) {
        for (int i = 0; i < this.nrDatabases(); ++i) {
            DatabaseMeta ci = this.getDatabase(i);
            if (!ci.getName().equalsIgnoreCase(name)) continue;
            return ci;
        }
        return null;
    }

    public void saveRep(Repository rep) throws ETLException {
        this.saveRep(rep, null);
    }

    public void saveRep(Repository rep, IProgressMonitor monitor) throws ETLException {
        try {
            int i;
            int nrWorks = 2 + this.nrDatabases() + this.nrNotes() + this.nrJobEntries() + this.nrJobHops();
            if (monitor != null) {
                monitor.beginTask("Saving transformation " + this.directory + Const.FILE_SEPARATOR + this.getName(), nrWorks);
            }
            if (monitor != null) {
                monitor.subTask("Handling previous version of job...");
            }
            this.setID(rep.getJobID(this.getName(), this.directory.getID()));
            if (this.getID() <= 0L) {
                this.setID(rep.getNextJobID());
            } else {
                rep.delAllFromJob(this.getID());
            }
            if (monitor != null) {
                monitor.worked(1);
            }
            if (monitor != null) {
                monitor.subTask("Saving job details...");
            }
            this.log.logDetailed(this.toString(), "Saving job info to repository...");
            this.saveRepJob(rep);
            if (monitor != null) {
                monitor.worked(1);
            }
            this.log.logDetailed(this.toString(), "Saving notes to repository...");
            for (i = 0; i < this.nrNotes(); ++i) {
                if (monitor != null) {
                    monitor.subTask("Saving note #" + (i + 1) + "/" + this.nrNotes());
                }
                NotePadMeta ni = this.getNote(i);
                ni.saveRep(rep, this.getID());
                if (ni.getID() > 0L) {
                    rep.insertJobNote(this.getID(), ni.getID());
                }
                if (monitor == null) continue;
                monitor.worked(1);
            }
            this.log.logDetailed(this.toString(), "Saving " + this.nrJobEntries() + " ChefGraphEntries to repository...");
            for (i = 0; i < this.nrJobEntries(); ++i) {
                if (monitor != null) {
                    monitor.subTask("Saving job entry #" + (i + 1) + "/" + this.nrJobEntries());
                }
                JobEntryCopy cge = this.getJobEntry(i);
                cge.saveRep(rep, this.getID());
                if (monitor == null) continue;
                monitor.worked(1);
            }
            this.log.logDetailed(this.toString(), "Saving job hops to repository...");
            for (i = 0; i < this.nrJobHops(); ++i) {
                if (monitor != null) {
                    monitor.subTask("Saving job hop #" + (i + 1) + "/" + this.nrJobHops());
                }
                JobHopMeta hi = this.getJobHop(i);
                hi.saveRep(rep, this.getID());
                if (monitor == null) continue;
                monitor.worked(1);
            }
            rep.commit();
            this.clearChanged();
            if (monitor != null) {
                monitor.done();
            }
        }
        catch (ETLDatabaseException dbe) {
            rep.rollback();
            throw new ETLException("Unable to save Job in repository, database rollback performed.", dbe);
        }
    }

    public JobMeta(LogWriter log, Repository rep, String jobname, RepositoryDirectory repdir) throws ETLException {
        this(log, rep, jobname, repdir, null);
    }

    public JobMeta(LogWriter log, Repository rep, String jobname, RepositoryDirectory repdir, IProgressMonitor monitor) throws ETLException {
        block24: {
            this.joblog = null;
            this.name = "";
            this.description = "";
            this.modifiedUser = "";
            this.modifiedDate = "";
            this.scheduleName = "";
            this.max = new boolean[1];
            this.size = new Rectangle[1];
            this.log = log;
            try {
                this.clear();
                this.directory = repdir;
                this.setID(rep.getJobID(jobname, repdir.getID()));
                if (this.getID() > 0L) {
                    int i;
                    long[] noteids = rep.getJobNoteIDs(this.getID());
                    long[] jecids = rep.getJobEntryCopyIDs(this.getID());
                    long[] hopid = rep.getJobHopIDs(this.getID());
                    int nrWork = 2 + noteids.length + jecids.length + hopid.length;
                    if (monitor != null) {
                        monitor.beginTask("Loading job " + repdir + Const.FILE_SEPARATOR + jobname, nrWork);
                    }
                    if (monitor != null) {
                        monitor.subTask("Reading the available database from the repository");
                    }
                    this.readDatabases(rep);
                    if (monitor != null) {
                        monitor.worked(1);
                    }
                    if (monitor != null) {
                        monitor.subTask("Reading the job information");
                    }
                    Row jobrow = rep.getJob(this.getID());
                    this.name = jobrow.searchValue("Name").getString();
                    this.description = jobrow.searchValue("description").getString();
                    this.logAuditTable = jobrow.searchValue("TableNameAuditLog").getString();
                    this.logErrorTable = jobrow.searchValue("TableNameErrorLog").getString();
                    this.modifiedUser = jobrow.searchValue("ModifiedUser").getString();
                    this.modifiedDate = jobrow.searchValue("ModifiedDate").getString();
                    long id_logdb = jobrow.searchValue("ID_DBLog").getInteger();
                    if (id_logdb > 0L) {
                        this.logconnection = new DatabaseMeta(rep, id_logdb);
                    } else if (id_logdb == 0L) {
                        this.logconnection = Const.findDatabase(this.databases, 0L);
                    }
                    if (!this.logAuditTable.equalsIgnoreCase("")) {
                        this.joblog = new JobLog(this, this.logconnection, this.logAuditTable, this.logErrorTable);
                    }
                    if (monitor != null) {
                        monitor.worked(1);
                    }
                    log.logDetailed(this.toString(), "Loading " + noteids.length + " notes");
                    for (i = 0; i < noteids.length; ++i) {
                        NotePadMeta ni;
                        if (monitor != null) {
                            monitor.subTask("Reading note #" + (i + 1) + "/" + noteids.length);
                        }
                        if (this.indexOfNote(ni = new NotePadMeta(log, rep, noteids[i])) < 0) {
                            this.addNote(ni);
                        }
                        if (monitor == null) continue;
                        monitor.worked(1);
                    }
                    log.logDetailed(this.toString(), "Loading " + jecids.length + " job entries");
                    for (i = 0; i < jecids.length; ++i) {
                        JobEntryCopy jec;
                        int idx;
                        if (monitor != null) {
                            monitor.subTask("Reading job entry #" + (i + 1) + "/" + jecids.length);
                        }
                        if ((idx = this.indexOfJobEntry(jec = new JobEntryCopy(log, rep, this.getID(), jecids[i], this.jobentries, this.databases))) < 0) {
                            if (jec.getName() != null && jec.getName().length() > 0) {
                                this.addJobEntry(jec);
                            }
                        } else {
                            this.setJobEntry(idx, jec);
                        }
                        if (monitor == null) continue;
                        monitor.worked(1);
                    }
                    log.logDetailed(this.toString(), "Loading " + hopid.length + " job hops");
                    for (i = 0; i < hopid.length; ++i) {
                        if (monitor != null) {
                            monitor.subTask("Reading job hop #" + (i + 1) + "/" + jecids.length);
                        }
                        JobHopMeta hi = new JobHopMeta(rep, hopid[i], this, this.jobcopies);
                        this.jobhops.add(hi);
                        if (monitor == null) continue;
                        monitor.worked(1);
                    }
                    this.clearChanged();
                    if (monitor != null) {
                        monitor.subTask("Finishing load");
                    }
                    if (monitor != null) {
                        monitor.done();
                    }
                    break block24;
                }
                throw new ETLException("Can't find job : " + jobname);
            }
            catch (ETLException dbe) {
                throw new ETLException("An error occurred reading job [" + jobname + "] from the repository", dbe);
            }
        }
    }

    public JobEntryCopy getChefGraphEntry(int x, int y, int iconsize) {
        int s = this.nrJobEntries();
        for (int i = s - 1; i >= 0; --i) {
            JobEntryCopy je = this.getJobEntry(i);
            Point p = je.getLocation();
            if (p == null || x < p.x || x > p.x + iconsize || y < p.y || y > p.y + iconsize) continue;
            return je;
        }
        return null;
    }

    public int nrJobEntries() {
        return this.jobcopies.size();
    }

    public int nrJobHops() {
        return this.jobhops.size();
    }

    public int nrNotes() {
        return this.notes.size();
    }

    public int nrDatabases() {
        return this.databases.size();
    }

    public JobHopMeta getJobHop(int i) {
        return (JobHopMeta)this.jobhops.get(i);
    }

    public JobEntryCopy getJobEntry(int i) {
        return (JobEntryCopy)this.jobcopies.get(i);
    }

    public NotePadMeta getNote(int i) {
        return (NotePadMeta)this.notes.get(i);
    }

    public DatabaseMeta getDatabase(int i) {
        return (DatabaseMeta)this.databases.get(i);
    }

    public void addJobEntry(JobEntryCopy je) {
        this.jobcopies.add(je);
        this.setChanged();
    }

    public void addJobHop(JobHopMeta hi) {
        this.jobhops.add(hi);
        this.setChanged();
    }

    public void addNote(NotePadMeta ni) {
        this.notes.add(ni);
        this.setChanged();
    }

    public void addDatabase(DatabaseMeta ci) {
        this.databases.add(ci);
        this.setChanged();
    }

    public void addJobEntry(int p, JobEntryCopy si) {
        this.jobcopies.add(p, si);
        this.changed_entries = true;
    }

    public void addJobHop(int p, JobHopMeta hi) {
        this.jobhops.add(p, hi);
        this.changed_hops = true;
    }

    public void addNote(int p, NotePadMeta ni) {
        this.notes.add(p, ni);
        this.changed_notes = true;
    }

    public void addDatabase(int p, DatabaseMeta ci) {
        this.databases.add(p, ci);
        this.setChanged();
    }

    public void removeJobEntry(int i) {
        this.jobcopies.remove(i);
        this.setChanged();
    }

    public void removeJobHop(int i) {
        this.jobhops.remove(i);
        this.setChanged();
    }

    public void removeNote(int i) {
        this.notes.remove(i);
        this.setChanged();
    }

    public void removeDatabase(int i) {
        if (i < 0 || i >= this.databases.size()) {
            return;
        }
        this.databases.remove(i);
        this.setChanged();
    }

    public int indexOfJobHop(JobHopMeta he) {
        return this.jobhops.indexOf(he);
    }

    public int indexOfNote(NotePadMeta ni) {
        return this.notes.indexOf(ni);
    }

    public int indexOfJobEntry(JobEntryCopy ge) {
        return this.jobcopies.indexOf(ge);
    }

    public int indexOfDatabase(DatabaseMeta di) {
        return this.databases.indexOf(di);
    }

    public void setJobEntry(int idx, JobEntryCopy jec) {
        this.jobcopies.set(idx, jec);
    }

    public JobEntryCopy findJobEntry(String name, int nr) {
        for (int i = 0; i < this.nrJobEntries(); ++i) {
            JobEntryCopy jec = this.getJobEntry(i);
            if (!jec.getName().equalsIgnoreCase(name) || jec.getNr() != nr) continue;
            return jec;
        }
        return null;
    }

    public JobEntryCopy findJobEntry(String full_name_nr) {
        for (int i = 0; i < this.nrJobEntries(); ++i) {
            JobEntryCopy jec = this.getJobEntry(i);
            JobEntryInterface je = jec.getEntry();
            if (!je.toString().equalsIgnoreCase(full_name_nr)) continue;
            return jec;
        }
        return null;
    }

    public JobHopMeta findJobHop(String name) {
        for (int i = 0; i < this.nrJobHops(); ++i) {
            JobHopMeta hi = this.getJobHop(i);
            if (!hi.toString().equalsIgnoreCase(name)) continue;
            return hi;
        }
        return null;
    }

    public JobHopMeta findJobHopFrom(JobEntryCopy jge) {
        for (int i = 0; i < this.nrJobHops(); ++i) {
            JobHopMeta hi = this.getJobHop(i);
            if (!hi.from_entry.equals(jge)) continue;
            return hi;
        }
        return null;
    }

    public JobHopMeta findJobHop(JobEntryCopy from, JobEntryCopy to) {
        for (int i = 0; i < this.nrJobHops(); ++i) {
            JobHopMeta hi = this.getJobHop(i);
            if (!hi.isEnabled() || hi == null || hi.from_entry == null || hi.to_entry == null || !hi.from_entry.equals(from) || !hi.to_entry.equals(to)) continue;
            return hi;
        }
        return null;
    }

    public JobHopMeta findJobHopTo(JobEntryCopy jge) {
        for (int i = 0; i < this.nrJobHops(); ++i) {
            JobHopMeta hi = this.getJobHop(i);
            if (hi == null || hi.to_entry == null || !hi.to_entry.equals(jge)) continue;
            return hi;
        }
        return null;
    }

    public int findNrPrevChefGraphEntries(JobEntryCopy from) {
        return this.findNrPrevChefGraphEntries(from, false);
    }

    public JobEntryCopy findPrevChefGraphEntry(JobEntryCopy to, int nr) {
        return this.findPrevChefGraphEntry(to, nr, false);
    }

    public int findNrPrevChefGraphEntries(JobEntryCopy to, boolean info) {
        int count = 0;
        for (int i = 0; i < this.nrJobHops(); ++i) {
            JobHopMeta hi = this.getJobHop(i);
            if (!hi.isEnabled() || !hi.to_entry.equals(to)) continue;
            ++count;
        }
        return count;
    }

    public JobEntryCopy findPrevChefGraphEntry(JobEntryCopy to, int nr, boolean info) {
        int count = 0;
        for (int i = 0; i < this.nrJobHops(); ++i) {
            JobHopMeta hi = this.getJobHop(i);
            if (!hi.isEnabled() || !hi.to_entry.equals(to)) continue;
            if (count == nr) {
                return hi.from_entry;
            }
            ++count;
        }
        return null;
    }

    public int findNrNextChefGraphEntries(JobEntryCopy from) {
        int count = 0;
        for (int i = 0; i < this.nrJobHops(); ++i) {
            JobHopMeta hi = this.getJobHop(i);
            if (!hi.isEnabled() || !hi.from_entry.equals(from)) continue;
            ++count;
        }
        return count;
    }

    public JobEntryCopy findNextChefGraphEntry(JobEntryCopy from, int cnt) {
        int count = 0;
        for (int i = 0; i < this.nrJobHops(); ++i) {
            JobHopMeta hi = this.getJobHop(i);
            if (!hi.isEnabled() || !hi.from_entry.equals(from)) continue;
            if (count == cnt) {
                return hi.to_entry;
            }
            ++count;
        }
        return null;
    }

    public boolean hasLoop(JobEntryCopy entry) {
        return this.hasLoop(entry, null);
    }

    public boolean hasLoop(JobEntryCopy entry, JobEntryCopy lookup) {
        return false;
    }

    public boolean isEntryUsedInHops(JobEntryCopy jge) {
        JobHopMeta fr = this.findJobHopFrom(jge);
        JobHopMeta to = this.findJobHopTo(jge);
        return fr != null || to != null;
    }

    public int countEntries(String name) {
        int count = 0;
        for (int i = 0; i < this.nrJobEntries(); ++i) {
            JobEntryCopy je = this.getJobEntry(i);
            if (!je.getName().equalsIgnoreCase(name)) continue;
            ++count;
        }
        return count;
    }

    public int generateJobEntryNameNr(String basename) {
        int nr = 1;
        JobEntryCopy e = this.findJobEntry(basename + " " + nr, 0);
        while (e != null) {
            e = this.findJobEntry(basename + " " + ++nr, 0);
        }
        return nr;
    }

    public int findUnusedNr(String name) {
        int nr = 1;
        JobEntryCopy je = this.findJobEntry(name, nr);
        while (je != null) {
            je = this.findJobEntry(name, ++nr);
        }
        return nr;
    }

    public int findMaxNr(String name) {
        int max = 0;
        for (int i = 0; i < this.nrJobEntries(); ++i) {
            JobEntryCopy je = this.getJobEntry(i);
            if (!je.getName().equalsIgnoreCase(name) || je.getNr() <= max) continue;
            max = je.getNr();
        }
        return max;
    }

    public String getAlternativeJobentryName(String entryname) {
        String newname = entryname;
        JobEntryCopy jec = this.findJobEntry(newname);
        int nr = 1;
        while (jec != null) {
            newname = entryname + " " + ++nr;
            jec = this.findJobEntry(newname);
        }
        return newname;
    }

    public JobEntryCopy[] getAllChefGraphEntries(String name) {
        int count = 0;
        for (int i = 0; i < this.nrJobEntries(); ++i) {
            JobEntryCopy je = this.getJobEntry(i);
            if (!je.getName().equalsIgnoreCase(name)) continue;
            ++count;
        }
        JobEntryCopy[] retval = new JobEntryCopy[count];
        count = 0;
        for (int i = 0; i < this.nrJobEntries(); ++i) {
            JobEntryCopy je = this.getJobEntry(i);
            if (!je.getName().equalsIgnoreCase(name)) continue;
            retval[count] = je;
            ++count;
        }
        return retval;
    }

    public JobHopMeta[] getAllJobHopsUsing(String name) {
        int count = 0;
        for (int i = 0; i < this.nrJobHops(); ++i) {
            JobHopMeta hi = this.getJobHop(i);
            if (!hi.from_entry.getName().equalsIgnoreCase(name) && !hi.to_entry.getName().equalsIgnoreCase(name)) continue;
            ++count;
        }
        JobHopMeta[] retval = new JobHopMeta[count];
        count = 0;
        for (int i = 0; i < this.nrJobHops(); ++i) {
            JobHopMeta hi = this.getJobHop(i);
            if (!hi.from_entry.getName().equalsIgnoreCase(name) && !hi.to_entry.getName().equalsIgnoreCase(name)) continue;
            retval[count] = hi;
            ++count;
        }
        return retval;
    }

    public NotePadMeta getNote(int x, int y) {
        int s = this.notes.size();
        for (int i = s - 1; i >= 0; --i) {
            NotePadMeta ni = (NotePadMeta)this.notes.get(i);
            Point loc = ni.getLocation();
            Point p = new Point(loc.x, loc.y);
            if (x < p.x || x > p.x + ni.width + 10 || y < p.y || y > p.y + ni.height + 10) continue;
            return ni;
        }
        return null;
    }

    public void selectAll() {
        for (int i = 0; i < this.nrJobEntries(); ++i) {
            JobEntryCopy ce = this.getJobEntry(i);
            ce.setSelected(true);
        }
    }

    public void unselectAll() {
        for (int i = 0; i < this.nrJobEntries(); ++i) {
            JobEntryCopy ce = this.getJobEntry(i);
            ce.setSelected(false);
        }
    }

    public void selectInRect(Rectangle rect) {
        for (int i = 0; i < this.nrJobEntries(); ++i) {
            JobEntryCopy je = this.getJobEntry(i);
            Point p = je.getLocation();
            if ((p.x < rect.x || p.x > rect.x + rect.width) && (p.x < rect.x + rect.width || p.x > rect.x) || (p.y < rect.y || p.y > rect.y + rect.height) && (p.y < rect.y + rect.height || p.y > rect.y)) continue;
            je.setSelected(true);
        }
    }

    public int getMaxUndo() {
        return this.max_undo;
    }

    public void setMaxUndo(int mu) {
        this.max_undo = mu;
        while (this.undo.size() > mu && this.undo.size() > 0) {
            this.undo.remove(0);
        }
    }

    public int getUndoSize() {
        if (this.undo == null) {
            return 0;
        }
        return this.undo.size();
    }

    public Point getMaximum() {
        Point loc;
        int i;
        int maxx = 0;
        int maxy = 0;
        for (i = 0; i < this.nrJobEntries(); ++i) {
            JobEntryCopy entry = this.getJobEntry(i);
            loc = entry.getLocation();
            if (loc.x > maxx) {
                maxx = loc.x;
            }
            if (loc.y <= maxy) continue;
            maxy = loc.y;
        }
        for (i = 0; i < this.nrNotes(); ++i) {
            NotePadMeta ni = this.getNote(i);
            loc = ni.getLocation();
            if (loc.x + ni.width > maxx) {
                maxx = loc.x + ni.width;
            }
            if (loc.y + ni.height <= maxy) continue;
            maxy = loc.y + ni.height;
        }
        return new Point(maxx + 100, maxy + 100);
    }

    public Point[] getSelectedLocations() {
        int sels = this.nrSelected();
        Point[] retval = new Point[sels];
        for (int i = 0; i < sels; ++i) {
            JobEntryCopy si = this.getSelected(i);
            Point p = si.getLocation();
            retval[i] = new Point(p.x, p.y);
        }
        return retval;
    }

    public JobEntryCopy[] getSelectedEntries() {
        int sels = this.nrSelected();
        if (sels == 0) {
            return null;
        }
        JobEntryCopy[] retval = new JobEntryCopy[sels];
        for (int i = 0; i < sels; ++i) {
            JobEntryCopy je;
            retval[i] = je = this.getSelected(i);
        }
        return retval;
    }

    public int nrSelected() {
        int count = 0;
        for (int i = 0; i < this.nrJobEntries(); ++i) {
            JobEntryCopy je = this.getJobEntry(i);
            if (!je.isSelected()) continue;
            ++count;
        }
        return count;
    }

    public JobEntryCopy getSelected(int nr) {
        int count = 0;
        for (int i = 0; i < this.nrJobEntries(); ++i) {
            JobEntryCopy je = this.getJobEntry(i);
            if (!je.isSelected()) continue;
            if (nr == count) {
                return je;
            }
            ++count;
        }
        return null;
    }

    public int[] getEntryIndexes(JobEntryCopy[] entries) {
        int[] retval = new int[entries.length];
        for (int i = 0; i < entries.length; ++i) {
            retval[i] = this.indexOfJobEntry(entries[i]);
        }
        return retval;
    }

    public JobEntryCopy findStart() {
        for (int i = 0; i < this.nrJobEntries(); ++i) {
            if (!this.getJobEntry(i).isStart()) continue;
            return this.getJobEntry(i);
        }
        return null;
    }

    public String toString() {
        if (this.getName() != null) {
            return this.getName();
        }
        return this.getClass().getName();
    }

    public String getScheduleName() {
        return this.scheduleName;
    }

    public void setScheduleName(String scheduleName) {
        this.scheduleName = scheduleName;
    }

    public JobLog getJoblog() {
        return this.joblog;
    }
}

