/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.job.entry.job;

import com.kingdee.bos.ctrl.etl.base.Result;
import com.kingdee.bos.ctrl.etl.exception.ETLJobException;
import com.kingdee.bos.ctrl.etl.job.Job;
import com.kingdee.bos.ctrl.etl.util.LogWriter;

public class JobEntryJobRunner
implements Runnable {
    private Job job;
    private Result result;
    private LogWriter log;
    private int entryNr;
    private boolean finished;

    public JobEntryJobRunner(Job job, Result result, int entryNr) {
        this.job = job;
        this.result = result;
        this.log = LogWriter.getInstance();
        this.entryNr = entryNr;
        this.finished = false;
    }

    @Override
    public void run() {
        try {
            this.result = this.job.execute(this.entryNr + 1, this.result);
        }
        catch (ETLJobException e) {
            this.log.logError(this.toString(), "An error occurred executing this job entry : " + e.getMessage());
            this.result.setNrErrors(1L);
        }
        this.finished = true;
    }

    public void setResult(Result result) {
        this.result = result;
    }

    public Result getResult() {
        return this.result;
    }

    public LogWriter getLog() {
        return this.log;
    }

    public void setLog(LogWriter log) {
        this.log = log;
    }

    public Job getJob() {
        return this.job;
    }

    public void setJob(Job job) {
        this.job = job;
    }

    public int getEntryNr() {
        return this.entryNr;
    }

    public void setEntryNr(int entryNr) {
        this.entryNr = entryNr;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void waitUntilFinished() {
        while (!this.isFinished()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

