/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.repository;

import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.exception.ETLDatabaseException;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.repository.PermissionMeta;
import com.kingdee.bos.ctrl.etl.repository.Repository;
import com.kingdee.bos.ctrl.etl.value.Value;
import java.util.ArrayList;

public class ProfileMeta {
    private long id;
    private String name;
    private String description;
    private ArrayList permissions;

    public ProfileMeta(String name, String description) {
        this.name = name;
        this.description = description;
        this.permissions = new ArrayList();
    }

    public ProfileMeta() {
        this.name = null;
        this.description = null;
        this.permissions = new ArrayList();
    }

    public ProfileMeta(Repository rep, long id_profile) throws ETLException {
        block4: {
            try {
                Row r = rep.getProfile(id_profile);
                if (r != null) {
                    this.setID(id_profile);
                    this.name = r.searchValue("Name").getString();
                    this.description = r.searchValue("Description").getString();
                    long[] pid = rep.getPermissionIDs(id_profile);
                    this.permissions = new ArrayList();
                    for (int i = 0; i < pid.length; ++i) {
                        PermissionMeta pi = new PermissionMeta(rep, pid[i]);
                        if (pi.getID() <= 0L) continue;
                        this.addPermission(pi);
                    }
                    break block4;
                }
                throw new ETLException("Unable to find profile with id=" + id_profile);
            }
            catch (ETLDatabaseException dbe) {
                throw new ETLException("Coudln't create profile with id=" + id_profile, dbe);
            }
        }
    }

    public boolean saveRep(Repository rep) throws ETLException {
        try {
            if (this.getID() <= 0L) {
                this.setID(rep.getProfileID(this.getName()));
            }
            if (this.getID() <= 0L) {
                this.setID(rep.getNextProfileID());
                rep.insertTableRow("T_ETL_Profile", this.fillTableRow());
                this.saveProfilePermissions(rep);
            } else {
                rep.updateTableRow("T_ETL_Profile", "ID_Profile", this.fillTableRow());
                rep.delProfilePermissions(this.getID());
                this.saveProfilePermissions(rep);
            }
        }
        catch (ETLDatabaseException dbe) {
            throw new ETLException("Unable to save profile to repository", dbe);
        }
        return true;
    }

    public Row fillTableRow() {
        Row r = new Row();
        r.addValue(new Value("ID_Profile", this.getID()));
        r.addValue(new Value("Name", this.name));
        r.addValue(new Value("Description", this.description));
        return r;
    }

    private void saveProfilePermissions(Repository rep) throws ETLException {
        try {
            for (int i = 0; i < this.nrPermissions(); ++i) {
                PermissionMeta pi = this.getPermission(i);
                long id_permission = rep.getPermissionID(pi.getTypeDesc());
                Row pr = new Row();
                pr.addValue(new Value("ID_Profile", this.getID()));
                pr.addValue(new Value("ID_Permission", id_permission));
                rep.insertTableRow("T_ETL_ProfilePermission", pr);
            }
        }
        catch (ETLDatabaseException dbe) {
            throw new ETLException("Error saving profile permissions.", dbe);
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void addPermission(PermissionMeta permission) {
        this.permissions.add(permission);
    }

    public void addPermission(int p, PermissionMeta permission) {
        this.permissions.add(p, permission);
    }

    public PermissionMeta getPermission(int i) {
        return (PermissionMeta)this.permissions.get(i);
    }

    public int nrPermissions() {
        if (this.permissions == null) {
            return 0;
        }
        return this.permissions.size();
    }

    public void removePermission(int i) {
        this.permissions.remove(i);
    }

    public void removeAllPermissions() {
        this.permissions.clear();
    }

    public int indexOfPermission(PermissionMeta permission) {
        return this.permissions.indexOf(permission);
    }

    public long getID() {
        return this.id;
    }

    public void setID(long id) {
        this.id = id;
    }

    public boolean isReadonly() {
        for (int i = 0; i < this.nrPermissions(); ++i) {
            PermissionMeta pi = this.getPermission(i);
            if (!pi.isReadonly()) continue;
            return true;
        }
        return false;
    }

    public boolean isAdministrator() {
        for (int i = 0; i < this.nrPermissions(); ++i) {
            PermissionMeta pi = this.getPermission(i);
            if (!pi.isAdministrator()) continue;
            return true;
        }
        return false;
    }

    public boolean useTransformations() {
        for (int i = 0; i < this.nrPermissions(); ++i) {
            PermissionMeta pi = this.getPermission(i);
            if (!pi.useTransformations()) continue;
            return true;
        }
        return false;
    }

    public boolean useJobs() {
        for (int i = 0; i < this.nrPermissions(); ++i) {
            PermissionMeta pi = this.getPermission(i);
            if (!pi.useJobs()) continue;
            return true;
        }
        return false;
    }

    public boolean useSchemas() {
        for (int i = 0; i < this.nrPermissions(); ++i) {
            PermissionMeta pi = this.getPermission(i);
            if (!pi.useSchemas()) continue;
            return true;
        }
        return false;
    }
}

