/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.repository;

import com.kingdee.bos.ctrl.etl.base.Condition;
import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.database.Database;
import com.kingdee.bos.ctrl.etl.database.DatabaseMeta;
import com.kingdee.bos.ctrl.etl.exception.ETLDatabaseException;
import com.kingdee.bos.ctrl.etl.exception.ETLDependencyException;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.job.JobMeta;
import com.kingdee.bos.ctrl.etl.job.entry.JobEntryInterface;
import com.kingdee.bos.ctrl.etl.repository.PermissionMeta;
import com.kingdee.bos.ctrl.etl.repository.RepositoryDirectory;
import com.kingdee.bos.ctrl.etl.repository.RepositoryMeta;
import com.kingdee.bos.ctrl.etl.repository.UserInfo;
import com.kingdee.bos.ctrl.etl.schedule.entry.ScheduleEntryInterface;
import com.kingdee.bos.ctrl.etl.transformation.StepLoader;
import com.kingdee.bos.ctrl.etl.transformation.StepPlugin;
import com.kingdee.bos.ctrl.etl.transformation.TransMeta;
import com.kingdee.bos.ctrl.etl.util.Const;
import com.kingdee.bos.ctrl.etl.util.Counters;
import com.kingdee.bos.ctrl.etl.util.Encr;
import com.kingdee.bos.ctrl.etl.util.IProgressMonitor;
import com.kingdee.bos.ctrl.etl.util.LogWriter;
import com.kingdee.bos.ctrl.etl.util.XMLHandler;
import com.kingdee.bos.ctrl.etl.value.Value;
import com.kingdee.bos.ctrl.kdf.util.CloseUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Hashtable;

public class Repository {
    private RepositoryMeta repinfo;
    public UserInfo userinfo;
    private RepositoryDirectory directoryTree;
    private Database database;
    public LogWriter log;
    private String locksource;
    private PreparedStatement psStepAttributesLookup;
    private PreparedStatement psStepAttributesInsert;
    private ArrayList stepAttributesBuffer;
    private PreparedStatement pstmt_entry_attributes;
    private PreparedStatement pstmt_schedule_attributes;
    private StepLoader steploader;
    private int majorVersion;
    private int minorVersion;
    private static final int REP_STRING_TEXT_LENGTH = 2000000;
    private static final int REP_STRING_DISCRIPT_LENGTH = 2000;
    private static final int REP_STRING_CODE_LENGTH = 255;
    private Connection ctxConnection = null;
    private final String[] repositoryTableNames = new String[]{"T_ETL_Condition", "T_ETL_DBConnectType", "T_ETL_DBType", "T_ETL_Database", "T_ETL_Directory", "T_ETL_Job", "T_ETL_JobEntry", "T_ETL_JobEntryAttribute", "T_ETL_JobEntryCopy", "T_ETL_JobEntryType", "T_ETL_JobHop", "T_ETL_Schedule", "T_ETL_ScheduleType", "T_ETL_ScheduleAttribute", "T_ETL_Step", "T_ETL_StepAttribute", "T_ETL_StepType", "T_ETL_StepDatabase", "T_ETL_TransHop", "T_ETL_Transformation", "T_ETL_TransStepCondition", "T_ETL_Value", "T_ETL_User", "T_ETL_Permission", "T_ETL_ProfilePermission"};

    public Repository(LogWriter log, RepositoryMeta repinfo, UserInfo userinfo) {
        this.repinfo = repinfo;
        this.log = log;
        this.userinfo = userinfo;
        this.steploader = StepLoader.getInstance();
        this.database = new Database(repinfo.getConnection());
        this.psStepAttributesLookup = null;
        this.psStepAttributesInsert = null;
        this.pstmt_entry_attributes = null;
        this.pstmt_schedule_attributes = null;
        this.majorVersion = 2;
        this.minorVersion = 1;
        this.directoryTree = null;
    }

    public static Repository createRepositorySchema(LogWriter log, Connection repCon, String repositoryName, String repositoryDescription) throws ETLDatabaseException {
        DatabaseMeta databaseMeta = new DatabaseMeta(repCon);
        RepositoryMeta repositoryMeta = new RepositoryMeta(repositoryName, repositoryDescription, databaseMeta);
        Repository repository = new Repository(log, repositoryMeta, null);
        repository.connect(true, false, repositoryName);
        repository.dropRepositorySchema();
        repository.createRepositorySchema(null, false);
        repository.disconnect();
        return repository;
    }

    public RepositoryMeta getRepositoryInfo() {
        return this.repinfo;
    }

    public UserInfo getUserInfo() {
        return this.userinfo;
    }

    public String getName() {
        if (this.repinfo == null) {
            return null;
        }
        return this.repinfo.getName();
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public String getVersion() {
        return this.majorVersion + "." + this.minorVersion;
    }

    public String getLocksource() {
        return this.locksource;
    }

    public boolean connect(String locksource) {
        return this.connect(false, true, locksource);
    }

    public boolean connect(boolean no_lookup, boolean readDirectory, String locksource) {
        if (this.repinfo.isLocked()) {
            this.log.logError(this.toString(), "Repository is locked by class " + locksource);
            return false;
        }
        boolean retval = true;
        try {
            this.database.connect();
            this.repinfo.setLock(true);
            this.locksource = locksource;
            if (!no_lookup) {
                try {
                    this.setLookupJobEntryAttribute();
                    this.setLookupStepAttribute();
                    this.setLookupScheduleAttribute();
                }
                catch (ETLDatabaseException dbe) {
                    this.log.logError(this.toString(), "Error setting lookup prep.statements: " + dbe.getMessage());
                }
            }
            if (readDirectory) {
                try {
                    this.directoryTree = new RepositoryDirectory(this);
                }
                catch (ETLException e) {
                    this.log.logError(this.toString(), "Unable to read the directory tree from the repository!" + Const.CR + e.getMessage());
                    this.directoryTree = new RepositoryDirectory();
                }
            } else {
                this.directoryTree = new RepositoryDirectory();
            }
        }
        catch (ETLException e) {
            retval = false;
            this.log.logError(this.toString(), "Error connecting to the repository!" + e.getMessage());
        }
        return retval;
    }

    public void disconnect() {
        try {
            this.closeStepAttributeLookupPreparedStatement();
            if (!this.database.isAutoCommit()) {
                this.commit();
            }
            this.repinfo.setLock(false);
            this.database.disconnect();
        }
        catch (ETLException dbe) {
            this.log.logError(this.toString(), "Error disconnecting from database : " + dbe.getMessage());
        }
    }

    public void setAutoCommit(boolean autocommit) {
        if (!autocommit) {
            this.database.setCommit(99999999);
        } else {
            this.database.setCommit(0);
        }
    }

    public void commit() throws ETLException {
        try {
            if (!this.database.isAutoCommit()) {
                this.database.commit();
            }
            Counters.getInstance().clear();
        }
        catch (ETLDatabaseException dbe) {
            throw new ETLException("Unable to commit repository connection", dbe);
        }
    }

    public void rollback() {
        try {
            this.database.rollback();
            Counters.getInstance().clear();
        }
        catch (ETLDatabaseException dbe) {
            this.log.logError(this.toString(), "Error rolling back repository.");
        }
    }

    public ArrayList getStepAttributesBuffer() {
        return this.stepAttributesBuffer;
    }

    public void setStepAttributesBuffer(ArrayList stepAttributesBuffer) {
        this.stepAttributesBuffer = stepAttributesBuffer;
    }

    public void fillStepAttributesBuffer(long id_transformation) throws ETLDatabaseException {
        String sql = "SELECT ID_Step, Code, Nr, ValueNum, ValueStr FROM T_ETL_StepAttribute WHERE ID_Transformation = " + id_transformation + " ORDER BY ID_Step, Code, Nr";
        this.stepAttributesBuffer = this.database.getRows(sql, -1);
        Collections.sort(this.stepAttributesBuffer);
    }

    private Row searchStepAttributeInBuffer(long id_step, String code, long nr) {
        int idx = this.searchStepAttributeIndexInBuffer(id_step, code, nr);
        if (idx < 0) {
            return null;
        }
        Row r = (Row)this.stepAttributesBuffer.get(idx);
        return r;
    }

    private int searchStepAttributeIndexInBuffer(long id_step, String code, long nr) {
        Row compare = new Row();
        compare.addValue(new Value("ID_Step", id_step));
        compare.addValue(new Value("Code", code));
        compare.addValue(new Value("Nr", nr));
        int index = Collections.binarySearch(this.stepAttributesBuffer, compare);
        if (index >= this.stepAttributesBuffer.size() || index < 0) {
            return -1;
        }
        Row look = (Row)this.stepAttributesBuffer.get(index);
        if (look.compare(compare, new int[]{0, 1, 2}, new boolean[]{true, true, true}) == 0) {
            return index;
        }
        return -1;
    }

    private int searchNrStepAttributes(long id_step, String code) {
        int idx = this.searchStepAttributeIndexInBuffer(id_step, code, 0L);
        if (idx < 0) {
            return 0;
        }
        int nr = 1;
        int offset = 1;
        if (idx + offset >= this.stepAttributesBuffer.size()) {
            return 1;
        }
        Row look = (Row)this.stepAttributesBuffer.get(idx + offset);
        long lookID = look.getValue(0).getInteger();
        String lookCode = look.getValue(1).getString();
        while (lookID == id_step && code.equalsIgnoreCase(lookCode)) {
            nr = (int)look.getValue(2).getInteger() + 1;
            if (idx + ++offset < this.stepAttributesBuffer.size()) {
                look = (Row)this.stepAttributesBuffer.get(idx + offset);
                lookID = look.getValue(0).getInteger();
                lookCode = look.getValue(1).getString();
                continue;
            }
            return nr;
        }
        return nr;
    }

    public long getJobID(String name, long id_directory) throws ETLDatabaseException {
        return this.getIDWithValue("T_ETL_Job", "ID_Job", "Name", name, "ID_Directory", id_directory);
    }

    public long getJobID(long id_schedule) throws ETLDatabaseException {
        return this.getIDWithValue("T_ETL_Schedule", "ID_Job", "ID_Schedule", id_schedule);
    }

    public long getScheduleID(String name, long id_directory) throws ETLDatabaseException {
        return this.getIDWithValue("T_ETL_Schedule", "ID_Schedule", "Name", name, "ID_Directory", id_directory);
    }

    public long getScheduleID(long id_job) throws ETLDatabaseException {
        return this.getIDWithValue("T_ETL_Schedule", "ID_Schedule", "ID_Job", id_job);
    }

    public String getScheduleName(long id_schedule) throws ETLDatabaseException {
        Row row = this.getSchedule(id_schedule);
        return row.getString("Name", "");
    }

    public RepositoryDirectory getScheduleRepDir(long id_schedule) throws ETLDatabaseException {
        Row row = this.getSchedule(id_schedule);
        long id_directory = row.getInteger("ID_Directory", -1L);
        return this.directoryTree.findDirectory(id_directory);
    }

    public long getTransformationID(String name, long id_directory) throws ETLDatabaseException {
        return this.getIDWithValue("T_ETL_Transformation", "ID_Transformation", "Name", name, "ID_Directory", id_directory);
    }

    public long getNoteID(String note) throws ETLDatabaseException {
        return this.getIDWithValue("T_ETL_Note", "ID_Note", "ValueStr", note);
    }

    public long getDatabaseID(String name) throws ETLDatabaseException {
        return this.getIDWithValue("T_ETL_Database", "ID_Database", "Name", name);
    }

    public long getDatabaseTypeID(String code) throws ETLDatabaseException {
        return this.getIDWithValue("T_ETL_DBType", "ID_DBType", "Code", code);
    }

    public long getDatabaseConTypeID(String code) throws ETLDatabaseException {
        return this.getIDWithValue("T_ETL_DBConnectType", "ID_DBConnectType", "Code", code);
    }

    public long getStepTypeID(String code) throws ETLDatabaseException {
        return this.getIDWithValue("T_ETL_StepType", "ID_StepType", "Code", code);
    }

    public long getJobEntryID(String name, long id_job) throws ETLDatabaseException {
        return this.getIDWithValue("T_ETL_JobEntry", "ID_JobEntry", "Name", name, "ID_Job", id_job);
    }

    public long getJobEntryTypeID(String code) throws ETLDatabaseException {
        return this.getIDWithValue("T_ETL_JobEntryType", "ID_JobEntryType", "Code", code);
    }

    public long getScheduleTypeID(String code) throws ETLDatabaseException {
        return this.getIDWithValue("T_ETL_ScheduleType", "ID_ScheduleType", "Code", code);
    }

    public long getStepID(String name, long id_transformation) throws ETLDatabaseException {
        return this.getIDWithValue("T_ETL_Step", "ID_Step", "Name", name, "ID_Transformation", id_transformation);
    }

    public long getUserID(String login) throws ETLDatabaseException {
        return this.getIDWithValue("T_ETL_User", "ID_User", "Login", login);
    }

    public long getProfileID(String profilename) throws ETLDatabaseException {
        return this.getIDWithValue("T_ETL_Profile", "ID_Profile", "Name", profilename);
    }

    public long getPermissionID(String code) throws ETLDatabaseException {
        return this.getIDWithValue("T_ETL_Permission", "ID_Permission", "Code", code);
    }

    public long getTransHopID(long id_transformation, long id_step_from, long id_step_to) throws ETLDatabaseException {
        String[] lookupkey = new String[]{"ID_Transformation", "ID_StepFrom", "ID_StepTo"};
        long[] key = new long[]{id_transformation, id_step_from, id_step_to};
        return this.getIDWithValue("T_ETL_TransHop", "ID_TransHop", lookupkey, key);
    }

    public long getJobHopID(long id_job, long id_jobentry_copy_from, long id_jobentry_copy_to) throws ETLDatabaseException {
        String[] lookupkey = new String[]{"ID_Job", "ID_JobEntryCopyFrom", "ID_JobEntryCopyTo"};
        long[] key = new long[]{id_job, id_jobentry_copy_from, id_jobentry_copy_to};
        return this.getIDWithValue("T_ETL_JobHop", "ID_JobHop", lookupkey, key);
    }

    public long getDependencyID(long id_transformation, long id_database, String tablename) throws ETLDatabaseException {
        String[] lookupkey = new String[]{"ID_Transformation", "ID_DATABASE"};
        long[] key = new long[]{id_transformation, id_database};
        return this.getIDWithValue("T_ETL_Dependency", "ID_Dependency", "TableName", tablename, lookupkey, key);
    }

    public long getRootDirectoryID() throws ETLDatabaseException {
        Row result = this.database.getOneRow("SELECT ID_Directory FROM T_ETL_Directory WHERE ID_DirectoryParent = 0");
        if (result != null && result.getValue(0).isInteger()) {
            return result.getValue(0).getInteger();
        }
        return -1L;
    }

    public int getNrSubDirectories(long id_directory) throws ETLDatabaseException {
        int retval = 0;
        String sql = "SELECT COUNT(*) FROM T_ETL_Directory WHERE ID_DirectoryParent = " + id_directory;
        Row r = this.database.getOneRow(sql);
        if (r != null) {
            retval = (int)r.getValue(0).getInteger();
        }
        return retval;
    }

    public long[] getSubDirectoryIDs(long id_directory) throws ETLDatabaseException {
        int nr = this.getNrSubDirectories(id_directory);
        long[] retval = new long[nr];
        String sql = "SELECT ID_Directory FROM T_ETL_Directory WHERE ID_DirectoryParent = " + id_directory + " ORDER BY DirectoryName";
        ResultSet rs = this.database.openQuery(sql);
        Row r = this.database.getRow(rs);
        int i = 0;
        while (r != null) {
            retval[i] = r.getValue(0).getInteger();
            r = this.database.getRow(rs);
            ++i;
        }
        this.database.closeQuery(rs);
        return retval;
    }

    private long getIDWithValue(String tablename, String idfield, String lookupfield, String value) throws ETLDatabaseException {
        Row par = new Row();
        par.addValue(new Value("value", value));
        Row result = this.database.getOneRow("SELECT " + idfield + " FROM " + tablename + " WHERE " + lookupfield + " = ?", par);
        if (result != null && result.getValue(0).isInteger()) {
            return result.getValue(0).getInteger();
        }
        return -1L;
    }

    private long getIDWithValue(String tablename, String idfield, String lookupfield, long value) throws ETLDatabaseException {
        Row par = new Row();
        par.addValue(new Value("value", value));
        Row result = this.database.getOneRow("SELECT " + idfield + " FROM " + tablename + " WHERE " + lookupfield + " = ?", par);
        if (result != null && result.getValue(0).isInteger()) {
            return result.getValue(0).getInteger();
        }
        return -1L;
    }

    private long getIDWithValue(String tablename, String idfield, String lookupfield, String value, String lookupkey, long key) throws ETLDatabaseException {
        Row par = new Row();
        par.addValue(new Value("value", value));
        par.addValue(new Value("key", key));
        Row result = this.database.getOneRow("SELECT " + idfield + " FROM " + tablename + " WHERE " + lookupfield + " = ? AND " + lookupkey + " = ?", par);
        if (result != null && result.getValue(0).isInteger()) {
            return result.getValue(0).getInteger();
        }
        return -1L;
    }

    private long getIDWithValue(String tablename, String idfield, String[] lookupkey, long[] key) throws ETLDatabaseException {
        Row par = new Row();
        String sql = "SELECT " + idfield + " FROM " + tablename + " ";
        for (int i = 0; i < lookupkey.length; ++i) {
            sql = i == 0 ? sql + "WHERE " : sql + "AND   ";
            par.addValue(new Value(lookupkey[i], key[i]));
            sql = sql + lookupkey[i] + " = ? ";
        }
        Row result = this.database.getOneRow(sql, par);
        if (result != null && result.getValue(0).isInteger()) {
            return result.getValue(0).getInteger();
        }
        return -1L;
    }

    private long getIDWithValue(String tablename, String idfield, String lookupfield, String value, String[] lookupkey, long[] key) throws ETLDatabaseException {
        Row par = new Row();
        par.addValue(new Value(lookupfield, value));
        String sql = "SELECT " + idfield + " FROM " + tablename + " WHERE " + lookupfield + " = ? ";
        for (int i = 0; i < lookupkey.length; ++i) {
            par.addValue(new Value(lookupkey[i], key[i]));
            sql = sql + "AND " + lookupkey[i] + " = ? ";
        }
        Row result = this.database.getOneRow(sql, par);
        if (result != null && result.getValue(0).isInteger()) {
            return result.getValue(0).getInteger();
        }
        return -1L;
    }

    public String getDatabaseTypeCode(long id_database_type) throws ETLDatabaseException {
        return this.getStringWithID("T_ETL_DBType", "ID_DBType", id_database_type, "Code");
    }

    public String getDatabaseConTypeCode(long id_database_contype) throws ETLDatabaseException {
        return this.getStringWithID("T_ETL_DBConnectType", "ID_DBConnectType", id_database_contype, "Code");
    }

    public String getStepTypeCode(long id_database_type) throws ETLDatabaseException {
        return this.getStringWithID("T_ETL_StepType", "ID_StepType", id_database_type, "Code");
    }

    private String getStringWithID(String tablename, String keyfield, long id, String fieldname) throws ETLDatabaseException {
        String sql = "SELECT " + fieldname + " FROM " + tablename + " WHERE " + keyfield + " = ?";
        Row par = new Row();
        par.addValue(new Value(keyfield, id));
        Row result = this.database.getOneRow(sql, par);
        if (result != null) {
            return result.getValue(0).getString();
        }
        return null;
    }

    public void moveTransformation(String transname, long id_directory_from, long id_directory_to) throws ETLDatabaseException {
        String sql = "UPDATE T_ETL_Transformation SET ID_Directory = ? WHERE Name = ? AND ID_Directory = ?";
        Row par = new Row();
        par.addValue(new Value("ID_Directory", id_directory_to));
        par.addValue(new Value("Name", transname));
        par.addValue(new Value("ID_Directory", id_directory_from));
        this.database.execStatement(sql, par);
    }

    public void moveJob(String jobname, long id_directory_from, long id_directory_to) throws ETLDatabaseException {
        String sql = "UPDATE T_ETL_Job SET ID_Directory = ? WHERE Name = ? AND ID_Directory = ?";
        Row par = new Row();
        par.addValue(new Value("ID_Directory", id_directory_to));
        par.addValue(new Value("Name", jobname));
        par.addValue(new Value("ID_Directory", id_directory_from));
        this.database.execStatement(sql, par);
    }

    public long getNextTransformationID() throws ETLDatabaseException {
        return this.getNextID("T_ETL_Transformation", "ID_Transformation");
    }

    public long getNextJobID() throws ETLDatabaseException {
        return this.getNextID("T_ETL_Job", "ID_Job");
    }

    public long getNextNoteID() throws ETLDatabaseException {
        return this.getNextID("T_ETL_Note", "ID_Note");
    }

    public long getNextDatabaseID() throws ETLDatabaseException {
        return this.getNextID("T_ETL_Database", "ID_Database");
    }

    public long getNextDatabaseTypeID() throws ETLDatabaseException {
        return this.getNextID("T_ETL_DBType", "ID_DBType");
    }

    public long getNextDatabaseConnectionTypeID() throws ETLDatabaseException {
        return this.getNextID("T_ETL_DBConnectType", "ID_DBConnectType");
    }

    public long getNextStepTypeID() throws ETLDatabaseException {
        return this.getNextID("T_ETL_StepType", "ID_StepType");
    }

    public long getNextStepID() throws ETLDatabaseException {
        return this.getNextID("T_ETL_Step", "ID_Step");
    }

    public long getNextJobEntryID() throws ETLDatabaseException {
        return this.getNextID("T_ETL_JobEntry", "ID_JobEntry");
    }

    public long getNextJobEntryTypeID() throws ETLDatabaseException {
        return this.getNextID("T_ETL_JobEntryType", "ID_JobEntryType");
    }

    public long getNextScheduleID() throws ETLDatabaseException {
        return this.getNextID("T_ETL_Schedule", "ID_Schedule");
    }

    public long getNextScheduleTypeID() throws ETLDatabaseException {
        return this.getNextID("T_ETL_ScheduleType", "ID_ScheduleType");
    }

    public long getNextJobEntryCopyID() throws ETLDatabaseException {
        return this.getNextID("T_ETL_JobEntryCopy", "ID_JobEntryCopy");
    }

    public long getNextStepAttributeID() throws ETLDatabaseException {
        return this.getNextID("T_ETL_StepAttribute", "ID_StepAttribute");
    }

    public long getNextTransHopID() throws ETLDatabaseException {
        return this.getNextID("T_ETL_TransHop", "ID_TransHop");
    }

    public long getNextJobHopID() throws ETLDatabaseException {
        return this.getNextID("T_ETL_JobHop", "ID_JobHop");
    }

    public long getNextDepencencyID() throws ETLDatabaseException {
        return this.getNextID("T_ETL_Dependency", "ID_Dependency");
    }

    public long getNextConditionID() throws ETLDatabaseException {
        return this.getNextID("T_ETL_Condition", "ID_Condition");
    }

    public long getNextValueID() throws ETLDatabaseException {
        return this.getNextID("T_ETL_Value", "ID_Value");
    }

    public long getNextUserID() throws ETLDatabaseException {
        return this.getNextID("T_ETL_User", "ID_User");
    }

    public long getNextProfileID() throws ETLDatabaseException {
        return this.getNextID("T_ETL_Profile", "ID_Profile");
    }

    public long getNextPermissionID() throws ETLDatabaseException {
        return this.getNextID("T_ETL_Permission", "ID_Permission");
    }

    public long getNextJobEntryAttributeID() throws ETLDatabaseException {
        return this.getNextID("T_ETL_JobEntryAttribute", "ID_JobEntryAttribute");
    }

    public long getNextScheduleAttributeID() throws ETLDatabaseException {
        return this.getNextID("T_ETL_ScheduleAttribute", "ID_ScheduleAttribute");
    }

    public long getNextID(String tableName, String fieldName) throws ETLDatabaseException {
        return this.database.getNextID(tableName, fieldName);
    }

    public void clearNextIDCounters() {
        Counters.getInstance().clear();
    }

    public long getNextDirectoryID() throws ETLDatabaseException {
        return this.getNextID("T_ETL_Directory", "ID_Directory");
    }

    public void insertTransformation(long id_transformation, String name, long id_step_read, long id_step_write, long id_step_input, long id_step_output, long id_step_update, String modified_user, Value modified_date, int size_rowset, long id_directory) throws ETLDatabaseException {
        Row table = new Row();
        table.addValue(new Value("ID_Transformation", id_transformation));
        table.addValue(new Value("Name", name));
        table.addValue(new Value("ID_StepRead", id_step_read));
        table.addValue(new Value("ID_StepWrite", id_step_write));
        table.addValue(new Value("ID_StepInput", id_step_input));
        table.addValue(new Value("ID_StepOutput", id_step_output));
        table.addValue(new Value("ID_StepUpdate", id_step_update));
        table.addValue(new Value("ModifiedUser", modified_user));
        table.addValue(new Value("ModifiedDate", modified_date));
        table.addValue(new Value("BufferRows", (long)size_rowset));
        table.addValue(new Value("ID_Directory", id_directory));
        this.database.prepareInsert(table, "T_ETL_Transformation");
        this.database.setValuesInsert(table);
        this.database.insertRow();
        this.database.closeInsert();
    }

    public void insertJob(long id_job, long id_directory, String name, String modified_user, Value modified_date) throws ETLDatabaseException {
        Row table = new Row();
        table.addValue(new Value("ID_Job", id_job));
        table.addValue(new Value("ID_Directory", id_directory));
        table.addValue(new Value("Name", name));
        table.addValue(new Value("ModifiedUser", modified_user));
        table.addValue(new Value("ModifiedDate", modified_date));
        this.database.prepareInsert(table, "T_ETL_Job");
        this.database.setValuesInsert(table);
        this.database.insertRow();
        this.log.logDebug(this.toString(), "Inserted new record into table T_ETL_Job with data : " + table);
        this.database.closeInsert();
    }

    public void insertJob2(long id_job, long id_directory, String name, String discription, long id_dblog, String tableAuditLog, String tableErrorLog, String modified_user, Value modified_date) throws ETLDatabaseException {
        Row table = new Row();
        table.addValue(new Value("ID_Job", id_job));
        table.addValue(new Value("ID_Directory", id_directory));
        table.addValue(new Value("Name", name));
        table.addValue(new Value("Description", discription));
        table.addValue(new Value("ID_DBLog", id_dblog));
        table.addValue(new Value("TableNameAuditLog", tableAuditLog));
        table.addValue(new Value("TableNameErrorLog", tableErrorLog));
        table.addValue(new Value("ModifiedUser", modified_user));
        if (modified_date == null) {
            table.addValue(new Value("ModifiedDate", new Date()));
        } else {
            table.addValue(new Value("ModifiedDate", modified_date));
        }
        this.database.prepareInsert(table, "T_ETL_Job");
        this.database.setValuesInsert(table);
        this.database.insertRow();
        this.log.logDebug(this.toString(), "Inserted new record into table T_ETL_Job with data : " + table);
        this.database.closeInsert();
    }

    public long insertNote(String note, long gui_location_x, long gui_location_y, long gui_location_width, long gui_location_height) throws ETLDatabaseException {
        long id = this.getNextNoteID();
        Row table = new Row();
        table.addValue(new Value("ID_Note", id));
        table.addValue(new Value("ValueStr", note));
        table.addValue(new Value("GUILocationX", gui_location_x));
        table.addValue(new Value("GUILocationY", gui_location_y));
        table.addValue(new Value("GUILocationWidth", gui_location_width));
        table.addValue(new Value("GUILocationHeight", gui_location_height));
        this.database.prepareInsert(table, "T_ETL_Note");
        this.database.setValuesInsert(table);
        this.database.insertRow();
        this.database.closeInsert();
        return id;
    }

    public void insertTransNote(long id_transformation, long id_note) throws ETLDatabaseException {
        Row table = new Row();
        table.addValue(new Value("ID_Transformation", id_transformation));
        table.addValue(new Value("ID_Note", id_note));
        this.database.prepareInsert(table, "T_ETL_TransNote");
        this.database.setValuesInsert(table);
        this.database.insertRow();
        this.database.closeInsert();
    }

    public void insertJobNote(long id_job, long id_note) throws ETLDatabaseException {
        Row table = new Row();
        table.addValue(new Value("ID_Job", id_job));
        table.addValue(new Value("ID_Note", id_note));
        this.database.prepareInsert(table, "T_ETL_JobNote");
        this.database.setValuesInsert(table);
        this.database.insertRow();
        this.database.closeInsert();
    }

    public long insertDatabase(String name, String type, String access, String host, String dbname, long port, String user, String pass) throws ETLDatabaseException {
        long id = this.getNextDatabaseID();
        long id_database_type = this.getDatabaseTypeID(type);
        if (id_database_type < 0L) {
            id_database_type = this.getNextDatabaseTypeID();
            String tablename = "T_ETL_DBType";
            Row table = new Row();
            table.addValue(new Value("ID_DBType", 5, 5, 0));
            table.addValue(new Value("Code", 2, 255, 0));
            table.addValue(new Value("Description", 2, 2000, 0));
            this.database.prepareInsert(table, tablename);
            table = new Row();
            table.addValue(new Value("ID_DBType", id_database_type));
            table.addValue(new Value("Code", type));
            table.addValue(new Value("Description", type));
            this.database.setValuesInsert(table);
            this.database.insertRow();
            this.database.closeInsert();
        }
        long id_database_contype = this.getDatabaseConTypeID(access);
        Row table = new Row();
        table.addValue(new Value("ID_Database", id));
        table.addValue(new Value("Name", name));
        table.addValue(new Value("ID_DBType", id_database_type));
        table.addValue(new Value("ID_DBConnectType", id_database_contype));
        table.addValue(new Value("HostName", host));
        table.addValue(new Value("DatabaseName", dbname));
        table.addValue(new Value("Port", port));
        table.addValue(new Value("Username", user));
        table.addValue(new Value("Password", "Encrypted " + Encr.encryptPassword(pass)));
        this.database.prepareInsert(table, "T_ETL_Database");
        this.database.setValuesInsert(table);
        this.database.insertRow();
        this.database.closeInsert();
        return id;
    }

    public long insertStep(long id_transformation, String name, String description, String steptype, boolean distribute, long copies, long gui_location_x, long gui_location_y, boolean gui_draw) throws ETLDatabaseException {
        long id = this.getNextStepID();
        long id_step_type = this.getStepTypeID(steptype);
        Row table = new Row();
        table.addValue(new Value("ID_Step", id));
        table.addValue(new Value("ID_Transformation", id_transformation));
        table.addValue(new Value("Name", name));
        table.addValue(new Value("Description", description));
        table.addValue(new Value("ID_StepType", id_step_type));
        table.addValue(new Value("Distribute", distribute));
        table.addValue(new Value("Copies", copies));
        table.addValue(new Value("GUILocationX", gui_location_x));
        table.addValue(new Value("GUILocationY", gui_location_y));
        table.addValue(new Value("GUIDraw", gui_draw));
        this.database.prepareInsert(table, "T_ETL_Step");
        this.database.setValuesInsert(table);
        this.database.insertRow();
        this.database.closeInsert();
        return id;
    }

    public long insertStepAttribute(long id_transformation, long id_step, long nr, String code, double value_num, String value_str) throws ETLDatabaseException {
        long id = this.getNextStepAttributeID();
        Row table = new Row();
        table.addValue(new Value("ID_StepAttribute", id));
        table.addValue(new Value("ID_Transformation", id_transformation));
        table.addValue(new Value("ID_Step", id_step));
        table.addValue(new Value("Nr", nr));
        table.addValue(new Value("Code", code));
        table.addValue(new Value("ValueNum", value_num));
        table.addValue(new Value("ValueStr", value_str));
        if (this.psStepAttributesInsert == null) {
            String sql = this.database.getInsertStatement("T_ETL_StepAttribute", table);
            this.psStepAttributesInsert = this.database.prepareSQL(sql);
        }
        this.database.setValues(table, this.psStepAttributesInsert);
        this.database.insertRow(this.psStepAttributesInsert, true);
        this.log.logDebug(this.toString(), "saved attribute [" + code + "]");
        return id;
    }

    public void insertStepDatabase(long id_transformation, long id_step, long id_database) throws ETLDatabaseException {
        Row check = this.getStepDatabase(id_step);
        if (check == null) {
            Row table = new Row();
            table.addValue(new Value("ID_Transformation", id_transformation));
            table.addValue(new Value("ID_STEP", id_step));
            table.addValue(new Value("ID_DATABASE", id_database));
            this.database.insertRow("T_ETL_StepDatabase", table);
        }
    }

    public long insertJobEntryAttribute(long id_job, long id_jobentry, long nr, String code, double value_num, String value_str) throws ETLDatabaseException {
        long id = this.getNextJobEntryAttributeID();
        Row table = new Row();
        table.addValue(new Value("ID_JobEntryAttribute", id));
        table.addValue(new Value("ID_Job", id_job));
        table.addValue(new Value("ID_JobEntry", id_jobentry));
        table.addValue(new Value("Nr", nr));
        table.addValue(new Value("Code", code));
        table.addValue(new Value("ValueNum", value_num));
        table.addValue(new Value("ValueStr", value_str));
        this.database.prepareInsert(table, "T_ETL_JobEntryAttribute");
        this.database.setValuesInsert(table);
        this.database.insertRow();
        this.database.closeInsert();
        return id;
    }

    public long insertScheduleAttribute(long id_schedule, String scheduleType, long nr, String code, double value_num, String value_str) throws ETLDatabaseException {
        long id = this.getNextScheduleAttributeID();
        long id_schedule_type = this.getScheduleTypeID(scheduleType);
        Row table = new Row();
        table.addValue(new Value("ID_ScheduleAttribute", id));
        table.addValue(new Value("ID_Schedule", id_schedule));
        table.addValue(new Value("ID_ScheduleType", id_schedule_type));
        table.addValue(new Value("Nr", nr));
        table.addValue(new Value("Code", code));
        table.addValue(new Value("ValueNum", value_num));
        table.addValue(new Value("ValueStr", value_str));
        this.database.prepareInsert(table, "T_ETL_ScheduleAttribute");
        this.database.setValuesInsert(table);
        this.database.insertRow();
        this.database.closeInsert();
        return id;
    }

    public long insertTransHop(long id_transformation, long id_step_from, long id_step_to, boolean enabled) throws ETLDatabaseException {
        long id = this.getNextTransHopID();
        Row table = new Row();
        table.addValue(new Value("ID_TransHop", id));
        table.addValue(new Value("ID_Transformation", id_transformation));
        table.addValue(new Value("ID_StepFrom", id_step_from));
        table.addValue(new Value("ID_StepTo", id_step_to));
        table.addValue(new Value("Enabled", enabled));
        this.database.prepareInsert(table, "T_ETL_TransHop");
        this.database.setValuesInsert(table);
        this.database.insertRow();
        this.database.closeInsert();
        return id;
    }

    public long insertJobHop(long id_job, long id_jobentry_copy_from, long id_jobentry_copy_to, boolean enabled, boolean evaluation, boolean unconditional) throws ETLDatabaseException {
        long id = this.getNextJobHopID();
        Row table = new Row();
        table.addValue(new Value("ID_JobHop", id));
        table.addValue(new Value("ID_Job", id_job));
        table.addValue(new Value("ID_JobEntryCopyFrom", id_jobentry_copy_from));
        table.addValue(new Value("ID_JobEntryCopyTo", id_jobentry_copy_to));
        table.addValue(new Value("Enabled", enabled));
        table.addValue(new Value("Evaluation", evaluation));
        table.addValue(new Value("UnConditional", unconditional));
        this.database.prepareInsert(table, "T_ETL_JobHop");
        this.database.setValuesInsert(table);
        this.database.insertRow();
        this.database.closeInsert();
        return id;
    }

    public long insertDependency(long id_transformation, long id_database, String tablename, String fieldname) throws ETLDatabaseException {
        long id = this.getNextDepencencyID();
        Row table = new Row();
        table.addValue(new Value("ID_Dependency", id));
        table.addValue(new Value("ID_Transformation", id_transformation));
        table.addValue(new Value("ID_DATABASE", id_database));
        table.addValue(new Value("TableName", tablename));
        table.addValue(new Value("FieldName", fieldname));
        this.database.prepareInsert(table, "T_ETL_Dependency");
        this.database.setValuesInsert(table);
        this.database.insertRow();
        this.database.closeInsert();
        return id;
    }

    public long insertCondition(long id_condition_parent, Condition condition) throws ETLDatabaseException {
        long id = this.getNextConditionID();
        String tablename = "T_ETL_Condition";
        Row table = new Row();
        table.addValue(new Value("ID_Condition", id));
        table.addValue(new Value("ID_ConditionParent", id_condition_parent));
        table.addValue(new Value("Negated", condition.isNegated()));
        table.addValue(new Value("Operator", condition.getOperatorDesc()));
        table.addValue(new Value("LeftName", condition.getLeftValuename()));
        table.addValue(new Value("ConditionFunction", condition.getFunctionDesc()));
        table.addValue(new Value("RightName", condition.getRightValuename()));
        long id_value = -1L;
        Value v = condition.getRightExact();
        if (v != null) {
            id_value = this.insertValue(v.getName(), v.getTypeDesc(), v.getString(), v.isNull(), condition.getRightExactID());
            condition.setRightExactID(id_value);
        }
        table.addValue(new Value("ID_ValueRight", id_value));
        this.database.prepareInsert(table, tablename);
        this.database.setValuesInsert(table);
        this.database.insertRow();
        this.database.closeInsert();
        return id;
    }

    public void insertTransStepCondition(long id_transformation, long id_step, long id_condition) throws ETLDatabaseException {
        String tablename = "T_ETL_TransStepCondition";
        Row table = new Row();
        table.addValue(new Value("ID_Transformation", id_transformation));
        table.addValue(new Value("ID_Step", id_step));
        table.addValue(new Value("ID_Condition", id_condition));
        this.database.prepareInsert(table, tablename);
        this.database.setValuesInsert(table);
        this.database.insertRow();
        this.database.closeInsert();
    }

    public long insertDirectory(long id_directory_parent, RepositoryDirectory dir) throws ETLDatabaseException {
        long id = this.getNextDirectoryID();
        String tablename = "T_ETL_Directory";
        Row table = new Row();
        table.addValue(new Value("ID_Directory", id));
        table.addValue(new Value("ID_DirectoryParent", id_directory_parent));
        table.addValue(new Value("DirectoryName", dir.getDirectoryName()));
        this.database.prepareInsert(table, tablename);
        this.database.setValuesInsert(table);
        this.database.insertRow();
        this.database.closeInsert();
        return id;
    }

    public void deleteDirectory(long id_directory) throws ETLDatabaseException {
        String sql = "DELETE FROM T_ETL_Directory WHERE ID_Directory = " + id_directory;
        this.database.execStatement(sql);
    }

    public void renameDirectory(long id_directory, String name) throws ETLDatabaseException {
        Row r = new Row();
        r.addValue(new Value("DirectoryName", name));
        String sql = "UPDATE T_ETL_Directory SET DirectoryName = ? WHERE ID_Directory = " + id_directory;
        this.log.logBasic(this.toString(), "sql = [" + sql + "]");
        this.log.logBasic(this.toString(), "row = [" + r + "]");
        this.database.execStatement(sql, r);
    }

    public long lookupValue(String name, String type, String value_str, boolean isnull) throws ETLDatabaseException {
        String tablename = "T_ETL_Value";
        Row table = new Row();
        table.addValue(new Value("Name", name));
        table.addValue(new Value("ValueType", type));
        table.addValue(new Value("ValueStr", value_str));
        table.addValue(new Value("IsNull", isnull));
        String sql = "SELECT ID_Value FROM " + tablename + " ";
        sql = sql + "WHERE Name       = ? ";
        sql = sql + "AND   ValueType = ? ";
        sql = sql + "AND   ValueStr  = ? ";
        sql = sql + "AND   IsNull    = ? ";
        Row result = this.database.getOneRow(sql, table);
        if (result != null && result.getValue(0).isInteger()) {
            return result.getValue(0).getInteger();
        }
        return -1L;
    }

    public long insertValue(String name, String type, String value_str, boolean isnull, long id_value_prev) throws ETLDatabaseException {
        long id_value = this.lookupValue(name, type, value_str, isnull);
        if (id_value < 0L) {
            id_value = this.getNextValueID();
            String tablename = "T_ETL_Value";
            Row table = new Row();
            table.addValue(new Value("ID_Value", id_value));
            table.addValue(new Value("Name", name));
            table.addValue(new Value("ValueType", type));
            table.addValue(new Value("ValueStr", value_str));
            table.addValue(new Value("IsNull", isnull));
            this.database.prepareInsert(table, tablename);
            this.database.setValuesInsert(table);
            this.database.insertRow();
            this.database.closeInsert();
        }
        return id_value;
    }

    public long insertJobEntry(long id_job, String name, String description, String jobentrytype) throws ETLDatabaseException {
        long id = this.getNextJobEntryID();
        long id_jobentry_type = this.getJobEntryTypeID(jobentrytype);
        this.log.logDebug(this.toString(), "ID_JobEntryType = " + id_jobentry_type + " for type = [" + jobentrytype + "]");
        Row table = new Row();
        table.addValue(new Value("ID_JobEntry", id));
        table.addValue(new Value("ID_Job", id_job));
        table.addValue(new Value("ID_JobEntryType", id_jobentry_type));
        table.addValue(new Value("Name", name));
        table.addValue(new Value("Description", description));
        this.database.prepareInsert(table, "T_ETL_JobEntry");
        this.database.setValuesInsert(table);
        this.database.insertRow();
        this.database.closeInsert();
        return id;
    }

    public long insertSchedule(String name, long id_directory, long id_job, String scheduleType, String modifiedUser, boolean usedFlag) throws ETLDatabaseException {
        long id = this.getNextScheduleID();
        long id_schedule_type = this.getScheduleTypeID(scheduleType);
        this.log.logDebug(this.toString(), "ID_ScheduleType = " + id_schedule_type + " for type = [" + scheduleType + "]");
        Row table = new Row();
        table.addValue(new Value("ID_Schedule", id));
        table.addValue(new Value("Name", name));
        table.addValue(new Value("ID_Directory", id_directory));
        table.addValue(new Value("ID_Job", id_job));
        table.addValue(new Value("ID_ScheduleType", id_schedule_type));
        table.addValue(new Value("ModifiedUser", modifiedUser));
        table.addValue(new Value("ModifiedDate", new Date()));
        table.addValue(new Value("UsedFlag", usedFlag));
        this.database.prepareInsert(table, "T_ETL_Schedule");
        this.database.setValuesInsert(table);
        this.database.insertRow();
        this.database.closeInsert();
        return id;
    }

    public long insertJobEntryCopy(long id_job, long id_jobentry, long id_jobentry_type, int nr, long gui_location_x, long gui_location_y, boolean gui_draw) throws ETLDatabaseException {
        long id = this.getNextJobEntryCopyID();
        Row table = new Row();
        table.addValue(new Value("ID_JobEntryCopy", id));
        table.addValue(new Value("ID_JobEntry", id_jobentry));
        table.addValue(new Value("ID_Job", id_job));
        table.addValue(new Value("ID_JobEntryType", id_jobentry_type));
        table.addValue(new Value("Nr", (long)nr));
        table.addValue(new Value("GUILocationX", gui_location_x));
        table.addValue(new Value("GUILocationY", gui_location_y));
        table.addValue(new Value("GUIDraw", gui_draw));
        this.database.prepareInsert(table, "T_ETL_JobEntryCopy");
        this.database.setValuesInsert(table);
        this.database.insertRow();
        this.database.closeInsert();
        return id;
    }

    public void insertTableRow(String tablename, Row values) throws ETLDatabaseException {
        this.database.prepareInsert(values, tablename);
        this.database.setValuesInsert(values);
        this.database.insertRow();
        this.database.closeInsert();
    }

    public void updateDatabase(long id_database, String name, String type, String access, String host, String dbname, long port, String user, String pass) throws ETLDatabaseException {
        long id_database_type = this.getDatabaseTypeID(type);
        long id_database_contype = this.getDatabaseConTypeID(access);
        Row table = new Row();
        table.addValue(new Value("Name", name));
        table.addValue(new Value("ID_DBType", id_database_type));
        table.addValue(new Value("ID_DBConnectType", id_database_contype));
        table.addValue(new Value("HostName", host));
        table.addValue(new Value("DababaseName", dbname));
        table.addValue(new Value("Port", port));
        table.addValue(new Value("Username", user));
        table.addValue(new Value("Password", "Encrypted " + Encr.encryptPassword(pass)));
        this.updateTableRow("T_ETL_Database", "ID_Database", table, id_database);
    }

    public void updateSchedule(long id_schedule, long id_job, String scheduleType, String user, boolean isUsed) throws ETLDatabaseException {
        long id_schedule_type = this.getScheduleTypeID(scheduleType);
        Row table = new Row();
        table.addValue(new Value("ID_Job", id_job));
        table.addValue(new Value("ID_ScheduleType", id_schedule_type));
        table.addValue(new Value("ModifiedUser", user));
        table.addValue(new Value("UsedFlag", isUsed));
        table.addValue(new Value("ModifiedDate", new Date()));
        this.updateTableRow("T_ETL_Schedule", "ID_Schedule", table, id_schedule);
    }

    public void updateTableRow(String tablename, String idfield, Row values, long id) throws ETLDatabaseException {
        String[] sets = new String[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            sets[i] = values.getValue(i).getName();
        }
        String[] codes = new String[]{idfield};
        String[] condition = new String[]{"="};
        this.database.prepareUpdate(tablename, codes, condition, sets);
        values.addValue(new Value(idfield, id));
        this.database.setValuesUpdate(values);
        this.database.updateRow();
        this.database.closeUpdate();
    }

    public void updateTableRow(String tablename, String idfield, Row values) throws ETLDatabaseException {
        long id = values.searchValue(idfield).getInteger();
        values.removeValue(idfield);
        String[] sets = new String[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            sets[i] = values.getValue(i).getName();
        }
        String[] codes = new String[]{idfield};
        String[] condition = new String[]{"="};
        this.database.prepareUpdate(tablename, codes, condition, sets);
        values.addValue(new Value(idfield, id));
        this.database.setValuesUpdate(values);
        this.database.updateRow();
    }

    public int getNrJobs() throws ETLDatabaseException {
        int retval = 0;
        String sql = "SELECT COUNT(*) FROM T_ETL_Job";
        Row r = this.database.getOneRow(sql);
        if (r != null) {
            retval = (int)r.getValue(0).getInteger();
        }
        return retval;
    }

    public int getNrSchedules() throws ETLDatabaseException {
        int retval = 0;
        String sql = "SELECT COUNT(*) FROM T_ETL_Schedule";
        Row r = this.database.getOneRow(sql);
        if (r != null) {
            retval = (int)r.getValue(0).getInteger();
        }
        return retval;
    }

    public int getNrTransformations(long id_directory) throws ETLDatabaseException {
        int retval = 0;
        String sql = "SELECT COUNT(*) FROM T_ETL_Transformation WHERE ID_Directory = " + id_directory;
        Row r = this.database.getOneRow(sql);
        if (r != null) {
            retval = (int)r.getValue(0).getInteger();
        }
        return retval;
    }

    public int getNrJobs(long id_directory) throws ETLDatabaseException {
        int retval = 0;
        String sql = "SELECT COUNT(*) FROM T_ETL_Job WHERE ID_Directory = " + id_directory;
        Row r = this.database.getOneRow(sql);
        if (r != null) {
            retval = (int)r.getValue(0).getInteger();
        }
        return retval;
    }

    public int getNrDirectories(long id_directory) throws ETLDatabaseException {
        int retval = 0;
        String sql = "SELECT COUNT(*) FROM T_ETL_Directory WHERE ID_DirectoryParent = " + id_directory;
        Row r = this.database.getOneRow(sql);
        if (r != null) {
            retval = (int)r.getValue(0).getInteger();
        }
        return retval;
    }

    public int getNrConditions(long id_transforamtion) throws ETLDatabaseException {
        int retval = 0;
        String sql = "SELECT COUNT(*) FROM T_ETL_TransStepCondition WHERE ID_Transformation = " + id_transforamtion;
        Row r = this.database.getOneRow(sql);
        if (r != null) {
            retval = (int)r.getValue(0).getInteger();
        }
        return retval;
    }

    public int getNrDatabases(long id_transforamtion) throws ETLDatabaseException {
        int retval = 0;
        String sql = "SELECT COUNT(*) FROM T_ETL_StepDatabase WHERE ID_Transformation = " + id_transforamtion;
        Row r = this.database.getOneRow(sql);
        if (r != null) {
            retval = (int)r.getValue(0).getInteger();
        }
        return retval;
    }

    public int getNrSubConditions(long id_condition) throws ETLDatabaseException {
        int retval = 0;
        String sql = "SELECT COUNT(*) FROM T_ETL_Condition WHERE ID_ConditionParent = " + id_condition;
        Row r = this.database.getOneRow(sql);
        if (r != null) {
            retval = (int)r.getValue(0).getInteger();
        }
        return retval;
    }

    public int getNrTransNotes(long id_transformation) throws ETLDatabaseException {
        int retval = 0;
        String sql = "SELECT COUNT(*) FROM T_ETL_TransNote WHERE ID_Transformation = " + id_transformation;
        Row r = this.database.getOneRow(sql);
        if (r != null) {
            retval = (int)r.getValue(0).getInteger();
        }
        return retval;
    }

    public int getNrJobNotes(long id_job) throws ETLDatabaseException {
        int retval = 0;
        String sql = "SELECT COUNT(*) FROM T_ETL_JobNote WHERE ID_Job = " + id_job;
        Row r = this.database.getOneRow(sql);
        if (r != null) {
            retval = (int)r.getValue(0).getInteger();
        }
        return retval;
    }

    public int getNrDatabases() throws ETLDatabaseException {
        int retval = 0;
        String sql = "SELECT COUNT(*) FROM T_ETL_Database";
        Row r = this.database.getOneRow(sql);
        if (r != null) {
            retval = (int)r.getValue(0).getInteger();
        }
        return retval;
    }

    public int getNrSteps(long id_transformation) throws ETLDatabaseException {
        int retval = 0;
        String sql = "SELECT COUNT(*) FROM T_ETL_Step WHERE ID_Transformation = " + id_transformation;
        Row r = this.database.getOneRow(sql);
        if (r != null) {
            retval = (int)r.getValue(0).getInteger();
        }
        return retval;
    }

    public int getNrStepDatabases(long id_database) throws ETLDatabaseException {
        int retval = 0;
        String sql = "SELECT COUNT(*) FROM T_ETL_StepDatabase WHERE ID_Database = " + id_database;
        Row r = this.database.getOneRow(sql);
        if (r != null) {
            retval = (int)r.getValue(0).getInteger();
        }
        return retval;
    }

    public int getNrStepAttributes(long id_step) throws ETLDatabaseException {
        int retval = 0;
        String sql = "SELECT COUNT(*) FROM T_ETL_StepAttribute WHERE ID_Step = " + id_step;
        Row r = this.database.getOneRow(sql);
        if (r != null) {
            retval = (int)r.getValue(0).getInteger();
        }
        return retval;
    }

    public int getNrTransHops(long id_transformation) throws ETLDatabaseException {
        int retval = 0;
        String sql = "SELECT COUNT(*) FROM T_ETL_TransHop WHERE ID_Transformation = " + id_transformation;
        Row r = this.database.getOneRow(sql);
        if (r != null) {
            retval = (int)r.getValue(0).getInteger();
        }
        return retval;
    }

    public int getNrJobHops(long id_job) throws ETLDatabaseException {
        int retval = 0;
        String sql = "SELECT COUNT(*) FROM T_ETL_JobHop WHERE ID_Job = " + id_job;
        Row r = this.database.getOneRow(sql);
        if (r != null) {
            retval = (int)r.getValue(0).getInteger();
        }
        return retval;
    }

    public int getNrTransDependencies(long id_transformation) throws ETLDatabaseException {
        int retval = 0;
        String sql = "SELECT COUNT(*) FROM T_ETL_Dependency WHERE ID_Transformation = " + id_transformation;
        Row r = this.database.getOneRow(sql);
        if (r != null) {
            retval = (int)r.getValue(0).getInteger();
        }
        return retval;
    }

    public int getNrJobEntries(long id_job) throws ETLDatabaseException {
        int retval = 0;
        String sql = "SELECT COUNT(*) FROM T_ETL_JobEntry WHERE ID_Job = " + id_job;
        Row r = this.database.getOneRow(sql);
        if (r != null) {
            retval = (int)r.getValue(0).getInteger();
        }
        return retval;
    }

    public int getNrJobEntryCopies(long id_job, long id_jobentry) throws ETLDatabaseException {
        int retval = 0;
        String sql = "SELECT COUNT(*) FROM T_ETL_JobEntryCopy WHERE ID_Job = " + id_job + " AND ID_JobEntry = " + id_jobentry;
        Row r = this.database.getOneRow(sql);
        if (r != null) {
            retval = (int)r.getValue(0).getInteger();
        }
        return retval;
    }

    public int getNrJobEntryCopies(long id_job) throws ETLDatabaseException {
        int retval = 0;
        String sql = "SELECT COUNT(*) FROM T_ETL_JobEntryCopy WHERE ID_Job = " + id_job;
        Row r = this.database.getOneRow(sql);
        if (r != null) {
            retval = (int)r.getValue(0).getInteger();
        }
        return retval;
    }

    public int getNrUsers() throws ETLDatabaseException {
        int retval = 0;
        String sql = "SELECT COUNT(*) FROM T_ETL_User";
        Row r = this.database.getOneRow(sql);
        if (r != null) {
            retval = (int)r.getValue(0).getInteger();
        }
        return retval;
    }

    public int getNrPermissions(long id_profile) throws ETLDatabaseException {
        int retval = 0;
        String sql = "SELECT COUNT(*) FROM T_ETL_ProfilePermission WHERE ID_Profile = " + id_profile;
        Row r = this.database.getOneRow(sql);
        if (r != null) {
            retval = (int)r.getValue(0).getInteger();
        }
        return retval;
    }

    public int getNrProfiles() throws ETLDatabaseException {
        int retval = 0;
        String sql = "SELECT COUNT(*) FROM T_ETL_Profile";
        Row r = this.database.getOneRow(sql);
        if (r != null) {
            retval = (int)r.getValue(0).getInteger();
        }
        return retval;
    }

    public String[] getTransformationNames(long id_directory) throws ETLDatabaseException {
        int nr = this.getNrTransformations(id_directory);
        String[] retval = new String[nr];
        String sql = "SELECT Name FROM T_ETL_Transformation WHERE ID_Directory = " + id_directory + " ORDER BY Name";
        ResultSet rs = this.database.openQuery(sql);
        if (rs != null) {
            Row r = this.database.getRow(rs);
            int i = 0;
            while (r != null) {
                retval[i] = r.getValue(0).getString();
                r = this.database.getRow(rs);
                ++i;
            }
            this.database.closeQuery(rs);
        }
        return Const.sortStrings(retval);
    }

    public String[] getJobNames(long id_directory) throws ETLDatabaseException {
        int nr = this.getNrJobs(id_directory);
        String[] retval = new String[nr];
        String sql = "SELECT Name FROM T_ETL_Job WHERE ID_Directory = " + id_directory + " ORDER BY Name";
        ResultSet rs = this.database.openQuery(sql);
        if (rs != null) {
            Row r = this.database.getRow(rs);
            int i = 0;
            while (r != null) {
                retval[i] = r.getValue(0).getString();
                r = this.database.getRow(rs);
                ++i;
            }
            this.database.closeQuery(rs);
        }
        return Const.sortStrings(retval);
    }

    public String[] getDirectoryNames(long id_directory) throws ETLDatabaseException {
        int nr = this.getNrDirectories(id_directory);
        String[] retval = new String[nr];
        String sql = "SELECT   DirectoryName FROM     T_ETL_Directory WHERE    ID_DirectoryParent = " + id_directory + " ORDER BY DirectoryName";
        ResultSet rs = this.database.openQuery(sql);
        if (rs != null) {
            Row r = this.database.getRow(rs);
            int i = 0;
            while (r != null) {
                retval[i] = r.getValue(0).getString();
                r = this.database.getRow(rs);
                ++i;
            }
            this.database.closeQuery(rs);
        }
        return Const.sortStrings(retval);
    }

    public String[] getJobNames() throws ETLDatabaseException {
        int nr = this.getNrJobs();
        String[] retval = new String[nr];
        String sql = "SELECT Name FROM T_ETL_Job ORDER BY Name";
        ResultSet rs = this.database.openQuery(sql);
        if (rs != null) {
            Row r = this.database.getRow(rs);
            int i = 0;
            while (r != null) {
                retval[i] = r.getValue(0).getString();
                r = this.database.getRow(rs);
                ++i;
            }
            this.database.closeQuery(rs);
        }
        return retval;
    }

    public long[] getJobIDs() throws ETLDatabaseException {
        int nr = this.getNrJobs();
        long[] retval = new long[nr];
        String sql = "SELECT ID_Job FROM T_ETL_Job ORDER BY ID_Job";
        ResultSet rs = this.database.openQuery(sql);
        if (rs != null) {
            Row r = this.database.getRow(rs);
            int i = 0;
            while (r != null) {
                retval[i] = r.getValue(0).getInteger();
                r = this.database.getRow(rs);
                ++i;
            }
            this.database.closeQuery(rs);
        }
        return retval;
    }

    public long[] getSubConditionIDs(long id_condition) throws ETLDatabaseException {
        int nr = this.getNrSubConditions(id_condition);
        long[] retval = new long[nr];
        String sql = "SELECT ID_Condition FROM T_ETL_Condition WHERE ID_ConditionParent = " + id_condition;
        ResultSet rs = this.database.openQuery(sql);
        Row r = this.database.getRow(rs);
        int i = 0;
        while (r != null) {
            retval[i] = r.getValue(0).getInteger();
            r = this.database.getRow(rs);
            ++i;
        }
        this.database.closeQuery(rs);
        return retval;
    }

    public long[] getTransNoteIDs(long id_transformation) throws ETLDatabaseException {
        int nr = this.getNrTransNotes(id_transformation);
        long[] retval = new long[nr];
        String sql = "SELECT ID_Note FROM T_ETL_TransNote WHERE ID_Transformation = " + id_transformation;
        ResultSet rs = this.database.openQuery(sql);
        Row r = this.database.getRow(rs);
        int i = 0;
        while (r != null) {
            retval[i] = r.getValue(0).getInteger();
            r = this.database.getRow(rs);
            ++i;
        }
        this.database.closeQuery(rs);
        return retval;
    }

    public long[] getConditionIDs(long id_transformation) throws ETLDatabaseException {
        int nr = this.getNrConditions(id_transformation);
        long[] retval = new long[nr];
        String sql = "SELECT ID_Condition FROM T_ETL_TransStepCondition WHERE ID_Transformation = " + id_transformation;
        ResultSet rs = this.database.openQuery(sql);
        Row r = this.database.getRow(rs);
        int i = 0;
        while (r != null) {
            retval[i] = r.getValue(0).getInteger();
            r = this.database.getRow(rs);
            ++i;
        }
        this.database.closeQuery(rs);
        return retval;
    }

    public long[] getDatabaseIDs(long id_transformation) throws ETLDatabaseException {
        int nr = this.getNrDatabases(id_transformation);
        long[] retval = new long[nr];
        String sql = "SELECT ID_Database FROM T_ETL_StepDatabase WHERE ID_Transformation = " + id_transformation;
        ResultSet rs = this.database.openQuery(sql);
        Row r = this.database.getRow(rs);
        int i = 0;
        while (r != null) {
            retval[i] = r.getValue(0).getInteger();
            r = this.database.getRow(rs);
            ++i;
        }
        this.database.closeQuery(rs);
        return retval;
    }

    public long[] getJobNoteIDs(long id_job) throws ETLDatabaseException {
        int nr = this.getNrJobNotes(id_job);
        long[] retval = new long[nr];
        String sql = "SELECT ID_Note FROM T_ETL_JobNote WHERE ID_Job = " + id_job;
        ResultSet rs = this.database.openQuery(sql);
        Row r = this.database.getRow(rs);
        int i = 0;
        while (r != null) {
            retval[i] = r.getValue(0).getInteger();
            r = this.database.getRow(rs);
            ++i;
        }
        this.database.closeQuery(rs);
        return retval;
    }

    public void addCtxConnection(Connection ctxConnection) {
        this.ctxConnection = ctxConnection;
    }

    public Connection getCtxConnection() {
        return this.ctxConnection;
    }

    public long[] getDatabaseIDs() throws ETLDatabaseException {
        int nr = this.getNrDatabases();
        long[] retval = null;
        int i = 0;
        if (this.getCtxConnection() != null) {
            retval = new long[nr + 1];
            retval[0] = 0L;
            ++i;
        } else {
            retval = new long[nr];
        }
        String sql = "SELECT ID_Database FROM T_ETL_Database";
        ResultSet rs = this.database.openQuery(sql);
        if (rs != null) {
            Row r = this.database.getRow(rs);
            while (r != null) {
                retval[i] = r.getValue(0).getInteger();
                r = this.database.getRow(rs);
                ++i;
            }
            this.database.closeQuery(rs);
        }
        return retval;
    }

    public String[] getDatabaseNames() throws ETLDatabaseException {
        int nr = this.getNrDatabases();
        String[] retval = new String[nr];
        String sql = "SELECT Name FROM T_ETL_Database ORDER BY Name";
        ResultSet rs = this.database.openQuery(sql);
        if (rs != null) {
            Row r = this.database.getRow(rs);
            int i = 0;
            while (r != null) {
                retval[i] = r.getValue(0).getString();
                r = this.database.getRow(rs);
                ++i;
            }
            this.database.closeQuery(rs);
        }
        return retval;
    }

    public long[] getStepIDs(long id_transformation) throws ETLDatabaseException {
        int nr = this.getNrSteps(id_transformation);
        long[] retval = new long[nr];
        String sql = "SELECT ID_Step FROM T_ETL_Step WHERE ID_Transformation = " + id_transformation;
        ResultSet rs = this.database.openQuery(sql);
        Row r = this.database.getRow(rs);
        int i = 0;
        while (r != null) {
            retval[i] = r.getValue(0).getInteger();
            r = this.database.getRow(rs);
            ++i;
        }
        this.database.closeQuery(rs);
        return retval;
    }

    public String[] getTransformationsUsingDatabase(long id_database) throws ETLDatabaseException {
        String sql = "SELECT DISTINCT ID_Transformation FROM T_ETL_StepDatabase WHERE ID_Database = " + id_database;
        ArrayList list = this.database.getRows(sql, 100);
        String[] transList = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            Row transRow;
            long id_transformation = ((Row)list.get(i)).getInteger("ID_Transformation", -1L);
            if (id_transformation <= 0L || (transRow = this.getTransformation(id_transformation)) == null) continue;
            String transName = transRow.getString("Name", "<name not found>");
            long id_directory = transRow.getInteger("ID_Directory", -1L);
            RepositoryDirectory dir = this.directoryTree.findDirectory(id_directory);
            transList[i] = dir.getPath() + Const.FILE_SEPARATOR + transName;
        }
        return transList;
    }

    public long[] getTransHopIDs(long id_transformation) throws ETLDatabaseException {
        int nr = this.getNrTransHops(id_transformation);
        long[] retval = new long[nr];
        String sql = "SELECT ID_TransHop FROM T_ETL_TransHop WHERE ID_Transformation = " + id_transformation;
        ResultSet rs = this.database.openQuery(sql);
        Row r = this.database.getRow(rs);
        int i = 0;
        while (r != null) {
            retval[i] = r.getValue(0).getInteger();
            r = this.database.getRow(rs);
            ++i;
        }
        this.database.closeQuery(rs);
        return retval;
    }

    public String getScheduleCronExpression(long id_schedule) throws ETLDatabaseException {
        String cronExpression = "";
        String sql = "SELECT CronExpression FROM T_ETL_Schedule WHERE ID_Schedule = " + id_schedule;
        ResultSet rs = this.database.openQuery(sql);
        Row r = this.database.getRow(rs);
        if (r != null) {
            cronExpression = r.getValue(0).getString();
        }
        return cronExpression;
    }

    public long[] getJobHopIDs(long id_job) throws ETLDatabaseException {
        int nr = this.getNrJobHops(id_job);
        long[] retval = new long[nr];
        String sql = "SELECT ID_JobHop FROM T_ETL_JobHop WHERE ID_Job = " + id_job;
        ResultSet rs = this.database.openQuery(sql);
        Row r = this.database.getRow(rs);
        int i = 0;
        while (r != null) {
            retval[i] = r.getValue(0).getInteger();
            r = this.database.getRow(rs);
            ++i;
        }
        this.database.closeQuery(rs);
        return retval;
    }

    public long[] getTransDependencyIDs(long id_transformation) throws ETLDatabaseException {
        int nr = this.getNrTransDependencies(id_transformation);
        long[] retval = new long[nr];
        String sql = "SELECT ID_Dependency FROM T_ETL_Dependency WHERE ID_Transformation = " + id_transformation;
        ResultSet rs = this.database.openQuery(sql);
        Row r = this.database.getRow(rs);
        int i = 0;
        while (r != null) {
            retval[i] = r.getValue(0).getInteger();
            r = this.database.getRow(rs);
            ++i;
        }
        this.database.closeQuery(rs);
        return retval;
    }

    public long[] getUserIDs() throws ETLDatabaseException {
        int nr = this.getNrUsers();
        long[] retval = new long[nr];
        String sql = "SELECT ID_User FROM T_ETL_User";
        ResultSet rs = this.database.openQuery(sql);
        if (rs != null) {
            Row r = this.database.getRow(rs);
            int i = 0;
            while (r != null) {
                retval[i] = r.getValue(0).getInteger();
                r = this.database.getRow(rs);
                ++i;
            }
            this.database.closeQuery(rs);
        }
        return retval;
    }

    public String[] getUserLogins() throws ETLDatabaseException {
        int nr = this.getNrUsers();
        String[] retval = new String[nr];
        String sql = "SELECT Login FROM T_ETL_User ORDER BY Login";
        ResultSet rs = this.database.openQuery(sql);
        if (rs != null) {
            Row r = this.database.getRow(rs);
            int i = 0;
            while (r != null) {
                retval[i] = r.getValue(0).getString();
                r = this.database.getRow(rs);
                ++i;
            }
            this.database.closeQuery(rs);
        }
        return retval;
    }

    public long[] getPermissionIDs(long id_profile) throws ETLDatabaseException {
        int nr = this.getNrPermissions(id_profile);
        long[] retval = new long[nr];
        String sql = "SELECT ID_Permission FROM T_ETL_ProfilePermission WHERE ID_Profile = " + id_profile;
        ResultSet rs = this.database.openQuery(sql);
        if (rs != null) {
            Row r = this.database.getRow(rs);
            int i = 0;
            while (r != null) {
                retval[i] = r.getValue(0).getInteger();
                r = this.database.getRow(rs);
                ++i;
            }
            this.database.closeQuery(rs);
        }
        return retval;
    }

    public long[] getJobEntryIDs(long id_job) throws ETLDatabaseException {
        int nr = this.getNrJobEntries(id_job);
        long[] retval = new long[nr];
        String sql = "SELECT ID_JobEntry FROM T_ETL_JobEntry WHERE ID_Job = " + id_job;
        ResultSet rs = this.database.openQuery(sql);
        Row r = this.database.getRow(rs);
        int i = 0;
        while (r != null) {
            retval[i] = r.getValue(0).getInteger();
            r = this.database.getRow(rs);
            ++i;
        }
        this.database.closeQuery(rs);
        return retval;
    }

    public long getScheduleTypeID(long id_schedule) throws ETLDatabaseException {
        return this.getIDWithValue("T_ETL_Schedule", "ID_ScheduleType", "ID_Schedule", String.valueOf(id_schedule));
    }

    public long[] getJobEntryCopyIDs(long id_job) throws ETLDatabaseException {
        int nr = this.getNrJobEntryCopies(id_job);
        long[] retval = new long[nr];
        String sql = "SELECT ID_JobEntryCopy FROM T_ETL_JobEntryCopy WHERE ID_Job = " + id_job;
        ResultSet rs = this.database.openQuery(sql);
        Row r = this.database.getRow(rs);
        int i = 0;
        while (r != null) {
            retval[i] = r.getValue(0).getInteger();
            r = this.database.getRow(rs);
            ++i;
        }
        this.database.closeQuery(rs);
        return retval;
    }

    public long[] getJobEntryCopyIDs(long id_job, long id_jobentry) throws ETLDatabaseException {
        int nr = this.getNrJobEntryCopies(id_job, id_jobentry);
        long[] retval = new long[nr];
        String sql = "SELECT ID_JobEntryCopy FROM T_ETL_JobEntryCopy WHERE ID_Job = " + id_job + " AND ID_JobEntry = " + id_jobentry;
        ResultSet rs = this.database.openQuery(sql);
        Row r = this.database.getRow(rs);
        int i = 0;
        while (r != null) {
            retval[i] = r.getValue(0).getInteger();
            r = this.database.getRow(rs);
            ++i;
        }
        this.database.closeQuery(rs);
        return retval;
    }

    public String[] getProfiles() throws ETLDatabaseException {
        int nr = this.getNrProfiles();
        String[] retval = new String[nr];
        String sql = "SELECT Name FROM T_ETL_Profile ORDER BY Name";
        ResultSet rs = this.database.openQuery(sql);
        if (rs != null) {
            Row r = this.database.getRow(rs);
            int i = 0;
            while (r != null) {
                retval[i] = r.getValue(0).getString();
                r = this.database.getRow(rs);
                ++i;
            }
            this.database.closeQuery(rs);
        }
        return retval;
    }

    public Row getNote(long id_note) throws ETLDatabaseException {
        return this.getOneRow("T_ETL_Note", "ID_Note", id_note);
    }

    public Row getDatabase(long id_database) throws ETLDatabaseException {
        return this.getOneRow("T_ETL_Database", "ID_Database", id_database);
    }

    public Row getCondition(long id_condition) throws ETLDatabaseException {
        return this.getOneRow("T_ETL_Condition", "ID_Condition", id_condition);
    }

    public Row getValue(long id_value) throws ETLDatabaseException {
        return this.getOneRow("T_ETL_Value", "ID_Value", id_value);
    }

    public Row getStep(long id_step) throws ETLDatabaseException {
        return this.getOneRow("T_ETL_Step", "ID_Step", id_step);
    }

    public Row getStepType(long id_step_type) throws ETLDatabaseException {
        return this.getOneRow("T_ETL_StepType", "ID_StepType", id_step_type);
    }

    public Row getStepAttribute(long id_step_attribute) throws ETLDatabaseException {
        return this.getOneRow("T_ETL_StepAttribute", "ID_StepAttribute", id_step_attribute);
    }

    public Row getStepDatabase(long id_step) throws ETLDatabaseException {
        return this.getOneRow("T_ETL_StepDatabase", "ID_Step", id_step);
    }

    public Row getTransHop(long id_trans_hop) throws ETLDatabaseException {
        return this.getOneRow("T_ETL_TransHop", "ID_TransHop", id_trans_hop);
    }

    public Row getSchedule(long id_schedule) throws ETLDatabaseException {
        return this.getOneRow("T_ETL_Schedule", "ID_Schedule", id_schedule);
    }

    public Row getJobHop(long id_job_hop) throws ETLDatabaseException {
        return this.getOneRow("T_ETL_JobHop", "ID_JobHop", id_job_hop);
    }

    public Row getTransDependency(long id_dependency) throws ETLDatabaseException {
        return this.getOneRow("T_ETL_Dependency", "ID_Dependency", id_dependency);
    }

    public Row getTransformation(long id_transformation) throws ETLDatabaseException {
        return this.getOneRow("T_ETL_Transformation", "ID_Transformation", id_transformation);
    }

    public Row getUser(long id_user) throws ETLDatabaseException {
        return this.getOneRow("T_ETL_User", "ID_User", id_user);
    }

    public Row getProfile(long id_profile) throws ETLDatabaseException {
        return this.getOneRow("T_ETL_Profile", "ID_Profile", id_profile);
    }

    public Row getPermission(long id_permission) throws ETLDatabaseException {
        return this.getOneRow("T_ETL_Permission", "ID_Permission", id_permission);
    }

    public Row getJob(long id_job) throws ETLDatabaseException {
        return this.getOneRow("T_ETL_Job", "ID_Job", id_job);
    }

    public long[] getAllJobIDs() throws ETLDatabaseException {
        int nr = this.getNrJobs();
        long[] retval = new long[nr];
        String sql = "SELECT ID_Job FROM T_ETL_Job";
        ResultSet rs = this.database.openQuery(sql);
        Row r = this.database.getRow(rs);
        int i = 0;
        while (r != null) {
            retval[i] = r.getValue(0).getInteger();
            r = this.database.getRow(rs);
            ++i;
        }
        this.database.closeQuery(rs);
        return retval;
    }

    public long[] getAllScheduleIDs() throws ETLDatabaseException {
        int nr = this.getNrSchedules();
        long[] retval = new long[nr];
        String sql = "SELECT ID_Schedule FROM T_ETL_Schedule";
        ResultSet rs = this.database.openQuery(sql);
        Row r = this.database.getRow(rs);
        int i = 0;
        while (r != null) {
            retval[i] = r.getValue(0).getInteger();
            r = this.database.getRow(rs);
            ++i;
        }
        this.database.closeQuery(rs);
        return retval;
    }

    public String getJobName(long id_job) throws ETLDatabaseException {
        Row row = this.getJob(id_job);
        return row.getString("Name", "");
    }

    public RepositoryDirectory getJobRepDir(long id_job) throws ETLDatabaseException {
        Row row = this.getJob(id_job);
        long id_directory = row.getInteger("ID_Directory", -1L);
        return this.directoryTree.findDirectory(id_directory);
    }

    public RepositoryDirectory getDirectoryByPath(String path) {
        return this.directoryTree.findDirectory(path);
    }

    public Row getJobEntry(long id_jobentry) throws ETLDatabaseException {
        return this.getOneRow("T_ETL_JobEntry", "ID_JobEntry", id_jobentry);
    }

    public Row getJobEntryCopy(long id_jobentry_copy) throws ETLDatabaseException {
        return this.getOneRow("T_ETL_JobEntryCopy", "ID_JobEntryCopy", id_jobentry_copy);
    }

    public Row getJobEntryType(long id_jobentry_type) throws ETLDatabaseException {
        return this.getOneRow("T_ETL_JobEntryType", "ID_JobEntryType", id_jobentry_type);
    }

    public Row getScheduleType(long id_schedule_type) throws ETLDatabaseException {
        return this.getOneRow("T_ETL_ScheduleType", "ID_ScheduleType", id_schedule_type);
    }

    public Row getDirectory(long id_directory) throws ETLDatabaseException {
        return this.getOneRow("T_ETL_Directory", "ID_Directory", id_directory);
    }

    private Row getOneRow(String tablename, String keyfield, long id) throws ETLDatabaseException {
        String sql = "SELECT * FROM " + tablename + " WHERE " + keyfield + " = " + id;
        return this.database.getOneRow(sql);
    }

    public long saveStepAttribute(long id_transformation, long id_step, String code, String value) throws ETLDatabaseException {
        return this.saveStepAttribute(code, 0L, id_transformation, id_step, 0.0, value);
    }

    public long saveStepAttribute(long id_transformation, long id_step, String code, double value) throws ETLDatabaseException {
        return this.saveStepAttribute(code, 0L, id_transformation, id_step, value, null);
    }

    public long saveStepAttribute(long id_transformation, long id_step, String code, boolean value) throws ETLDatabaseException {
        return this.saveStepAttribute(code, 0L, id_transformation, id_step, 0.0, value ? "Y" : "N");
    }

    public long saveStepAttribute(long id_transformation, long id_step, long nr, String code, String value) throws ETLDatabaseException {
        if (value == null || value.length() == 0) {
            return -1L;
        }
        return this.saveStepAttribute(code, nr, id_transformation, id_step, 0.0, value);
    }

    public long saveStepAttribute(long id_transformation, long id_step, long nr, String code, double value) throws ETLDatabaseException {
        return this.saveStepAttribute(code, nr, id_transformation, id_step, value, null);
    }

    public long saveStepAttribute(long id_transformation, long id_step, long nr, String code, boolean value) throws ETLDatabaseException {
        return this.saveStepAttribute(code, nr, id_transformation, id_step, 0.0, value ? "Y" : "N");
    }

    private long saveStepAttribute(String code, long nr, long id_transformation, long id_step, double value_num, String value_str) throws ETLDatabaseException {
        return this.insertStepAttribute(id_transformation, id_step, nr, code, value_num, value_str);
    }

    public void setLookupStepAttribute() throws ETLDatabaseException {
        String sql = "SELECT ValueStr, ValueNum FROM T_ETL_StepAttribute WHERE ID_Step = ?  AND Code = ?  AND Nr = ? ";
        this.psStepAttributesLookup = this.database.prepareSQL(sql);
    }

    public void closeStepAttributeLookupPreparedStatement() throws ETLDatabaseException {
        this.database.closePreparedStatement(this.psStepAttributesLookup);
        this.psStepAttributesLookup = null;
    }

    public void closeStepAttributeInsertPreparedStatement() throws ETLDatabaseException {
        if (this.psStepAttributesInsert != null) {
            this.database.insertFinished(this.psStepAttributesInsert, true);
            this.database.closePreparedStatement(this.psStepAttributesInsert);
            this.psStepAttributesInsert = null;
        }
    }

    private Row getStepAttributeRow(long id_step, int nr, String code) throws ETLDatabaseException {
        Row par = new Row();
        par.addValue(new Value("ID_Step", id_step));
        par.addValue(new Value("Code", code));
        par.addValue(new Value("Nr", (long)nr));
        this.database.setValues(par, this.psStepAttributesLookup);
        return this.database.getLookup(this.psStepAttributesLookup);
    }

    public long getStepAttributeInteger(long id_step, int nr, String code) throws ETLDatabaseException {
        Row r = null;
        r = this.stepAttributesBuffer != null ? this.searchStepAttributeInBuffer(id_step, code, nr) : this.getStepAttributeRow(id_step, nr, code);
        if (r == null) {
            return 0L;
        }
        return r.searchValue("ValueNum").getInteger();
    }

    public double getStepAttributeNumber(long id_step, int nr, String code) throws ETLDatabaseException {
        Row r = null;
        r = this.stepAttributesBuffer != null ? this.searchStepAttributeInBuffer(id_step, code, nr) : this.getStepAttributeRow(id_step, nr, code);
        if (r == null) {
            return 0.0;
        }
        return r.searchValue("ValueNum").getNumber();
    }

    public String getStepAttributeString(long id_step, int nr, String code) throws ETLDatabaseException {
        Row r = null;
        r = this.stepAttributesBuffer != null ? this.searchStepAttributeInBuffer(id_step, code, nr) : this.getStepAttributeRow(id_step, nr, code);
        if (r == null) {
            return null;
        }
        return r.searchValue("ValueStr").getString();
    }

    public boolean getStepAttributeBoolean(long id_step, int nr, String code, boolean def) throws ETLDatabaseException {
        Row r = null;
        r = this.stepAttributesBuffer != null ? this.searchStepAttributeInBuffer(id_step, code, nr) : this.getStepAttributeRow(id_step, nr, code);
        if (r == null) {
            return def;
        }
        Value v = r.searchValue("ValueStr");
        if (v == null) {
            return def;
        }
        return v.getBoolean();
    }

    public boolean getStepAttributeBoolean(long id_step, int nr, String code) throws ETLDatabaseException {
        Row r = null;
        r = this.stepAttributesBuffer != null ? this.searchStepAttributeInBuffer(id_step, code, nr) : this.getStepAttributeRow(id_step, nr, code);
        if (r == null) {
            return false;
        }
        return r.searchValue("ValueStr").getBoolean();
    }

    public double getStepAttributeNumber(long id_step, String code) throws ETLDatabaseException {
        return this.getStepAttributeNumber(id_step, 0, code);
    }

    public long getStepAttributeInteger(long id_step, String code) throws ETLDatabaseException {
        return this.getStepAttributeInteger(id_step, 0, code);
    }

    public String getStepAttributeString(long id_step, String code) throws ETLDatabaseException {
        return this.getStepAttributeString(id_step, 0, code);
    }

    public boolean getStepAttributeBoolean(long id_step, String code) throws ETLDatabaseException {
        return this.getStepAttributeBoolean(id_step, 0, code);
    }

    public void createRepositorySchema(IProgressMonitor monitor, boolean upgrade) throws ETLDatabaseException {
        String[] keyfield;
        String indexname;
        String[] desc;
        String[] code;
        int KEY = 9;
        this.log.logBasic(this.toString(), "Starting to create or modify the repository tables...");
        if (monitor != null) {
            monitor.beginTask((upgrade ? "Upgrading " : "Creating") + " the ETL repository...", 31);
        }
        Counters.getInstance().clear();
        this.setAutoCommit(true);
        boolean ok_database_type = true;
        Row table = new Row();
        String tablename = "T_ETL_DBType";
        if (monitor != null) {
            monitor.subTask("Checking table " + tablename);
        }
        table.addValue(new Value("ID_DBType", 5, KEY, 0));
        table.addValue(new Value("Code", 2, 255, 0));
        table.addValue(new Value("Description", 2, 2000, 0));
        String sql = this.database.getDDL(tablename, table, null, false, "ID_DBType", false);
        if (sql != null && sql.length() > 0) {
            try {
                this.log.logDetailed(this.toString(), "executing SQL statements: " + Const.CR + sql);
                this.database.execStatements(sql);
                this.log.logDetailed(this.toString(), "Created/altered table " + tablename);
            }
            catch (ETLDatabaseException dbe) {
                throw new ETLDatabaseException("Unable to create or modify table " + tablename, dbe);
            }
        } else {
            this.log.logDetailed(this.toString(), "Table " + tablename + " is OK.");
        }
        if (ok_database_type) {
            code = DatabaseMeta.getDBTypeDescList();
            desc = DatabaseMeta.getDBTypeDescLongList();
            this.database.prepareInsert(table, tablename);
            for (int i = 0; i < code.length; ++i) {
                Row lookup = null;
                if (upgrade) {
                    lookup = this.database.getOneRow("SELECT ID_DBType FROM " + tablename + " WHERE Code = '" + code[i] + "'");
                }
                if (lookup != null) continue;
                long nextid = this.getNextDatabaseTypeID();
                table = new Row();
                table.addValue(new Value("ID_DBType", nextid));
                table.addValue(new Value("Code", code[i]));
                table.addValue(new Value("Description", desc[i]));
                this.database.setValuesInsert(table);
                this.database.insertRow();
            }
            try {
                this.database.closeInsert();
                this.log.logDetailed(this.toString(), "Populated table " + tablename);
            }
            catch (ETLDatabaseException dbe) {
                throw new ETLDatabaseException("Unable to close insert after populating table " + tablename, dbe);
            }
        }
        if (monitor != null) {
            monitor.worked(1);
        }
        boolean ok_database_contype = true;
        table = new Row();
        tablename = "T_ETL_DBConnectType";
        if (monitor != null) {
            monitor.subTask("Checking table " + tablename);
        }
        table.addValue(new Value("ID_DBConnectType", 5, KEY, 0));
        table.addValue(new Value("Code", 2, 255, 0));
        table.addValue(new Value("Description", 2, 2000, 0));
        sql = this.database.getDDL(tablename, table, null, false, "ID_DBConnectType", false);
        if (sql != null && sql.length() > 0) {
            this.log.logDetailed(this.toString(), "executing SQL statements: " + Const.CR + sql);
            this.database.execStatements(sql);
            this.log.logDetailed(this.toString(), "Created or altered table " + tablename);
        } else {
            this.log.logDetailed(this.toString(), "Table " + tablename + " is OK.");
        }
        if (ok_database_contype) {
            code = DatabaseMeta.access_type_desc;
            desc = DatabaseMeta.db_access_desc_long;
            this.database.prepareInsert(table, tablename);
            for (int i = 0; i < code.length; ++i) {
                Row lookup = null;
                if (upgrade) {
                    lookup = this.database.getOneRow("SELECT ID_DBConnectType FROM " + tablename + " WHERE Code = '" + code[i] + "'");
                }
                if (lookup != null) continue;
                long nextid = this.getNextDatabaseConnectionTypeID();
                table = new Row();
                table.addValue(new Value("ID_DBConnectType", nextid));
                table.addValue(new Value("Code", code[i]));
                table.addValue(new Value("Description", desc[i]));
                this.database.setValuesInsert(table);
                this.database.insertRow();
            }
            try {
                this.database.closeInsert();
                this.log.logDetailed(this.toString(), "Populated table " + tablename);
            }
            catch (ETLDatabaseException dbe) {
                throw new ETLDatabaseException("Unable to close insert after populating table " + tablename, dbe);
            }
        }
        if (monitor != null) {
            monitor.worked(1);
        }
        table = new Row();
        tablename = "T_ETL_Note";
        if (monitor != null) {
            monitor.subTask("Checking table " + tablename);
        }
        table.addValue(new Value("ID_Note", 5, KEY, 0));
        table.addValue(new Value("ValueStr", 2, 2000, 0));
        table.addValue(new Value("GUILocationX", 5, 6, 0));
        table.addValue(new Value("GUILocationY", 5, 6, 0));
        table.addValue(new Value("GUILocationWidth", 5, 6, 0));
        table.addValue(new Value("GUILocationHeight", 5, 6, 0));
        sql = this.database.getDDL(tablename, table, null, false, "ID_Note", false);
        if (sql != null && sql.length() > 0) {
            this.log.logDetailed(this.toString(), "executing SQL statements: " + Const.CR + sql);
            this.database.execStatements(sql);
            this.log.logDetailed(this.toString(), "Created or altered table " + tablename);
        } else {
            this.log.logDetailed(this.toString(), "Table " + tablename + " is OK.");
        }
        if (monitor != null) {
            monitor.worked(1);
        }
        table = new Row();
        tablename = "T_ETL_Database";
        if (monitor != null) {
            monitor.subTask("Checking table " + tablename);
        }
        table.addValue(new Value("ID_Database", 5, KEY, 0));
        table.addValue(new Value("Name", 2, 255, 0));
        table.addValue(new Value("ID_DBType", 5, KEY, 0));
        table.addValue(new Value("ID_DBConnectType", 5, KEY, 0));
        table.addValue(new Value("HostName", 2, 255, 0));
        table.addValue(new Value("DababaseName", 2, 255, 0));
        table.addValue(new Value("Port", 5, 7, 0));
        table.addValue(new Value("Username", 2, 255, 0));
        table.addValue(new Value("Password", 2, 255, 0));
        sql = this.database.getDDL(tablename, table, null, false, "ID_Database", false);
        if (sql != null && sql.length() > 0) {
            this.log.logDetailed(this.toString(), "executing SQL statements: " + Const.CR + sql);
            this.database.execStatements(sql);
            this.log.logDetailed(this.toString(), "Created or altered table " + tablename);
        } else {
            this.log.logDetailed(this.toString(), "Table " + tablename + " is OK.");
        }
        if (monitor != null) {
            monitor.worked(1);
        }
        table = new Row();
        tablename = "T_ETL_Directory";
        if (monitor != null) {
            monitor.subTask("Checking table " + tablename);
        }
        table.addValue(new Value("ID_Directory", 5, KEY, 0));
        table.addValue(new Value("ID_DirectoryParent", 5, KEY, 0));
        table.addValue(new Value("DirectoryName", 2, 255, 0));
        sql = this.database.getDDL(tablename, table, null, false, "ID_Directory", false);
        if (sql != null && sql.length() > 0) {
            this.log.logDetailed(this.toString(), "executing SQL statements: " + Const.CR + sql);
            this.database.execStatements(sql);
            this.log.logDetailed(this.toString(), "Created or altered table " + tablename);
            try {
                indexname = "IDX_" + tablename.substring(2) + "_AK";
                keyfield = new String[]{"ID_DirectoryParent", "DirectoryName"};
                if (!this.database.checkIndexExists(tablename, keyfield)) {
                    sql = this.database.getCreateIndexStatement(tablename, indexname, keyfield, false, true, false, false);
                    this.log.logDetailed(this.toString(), "executing SQL statements: " + Const.CR + sql);
                    this.database.execStatements(sql);
                    this.log.logDetailed(this.toString(), "Created lookup index " + indexname + " on " + tablename);
                }
            }
            catch (ETLDatabaseException dbe) {}
        } else {
            this.log.logDetailed(this.toString(), "Table " + tablename + " is OK.");
        }
        if (monitor != null) {
            monitor.worked(1);
        }
        table = new Row();
        tablename = "T_ETL_Transformation";
        if (monitor != null) {
            monitor.subTask("Checking table " + tablename);
        }
        table.addValue(new Value("ID_Transformation", 5, KEY, 0));
        table.addValue(new Value("ID_Directory", 5, KEY, 0));
        table.addValue(new Value("Name", 2, 255, 0));
        table.addValue(new Value("ID_StepRead", 5, KEY, 0));
        table.addValue(new Value("ID_StepWrite", 5, KEY, 0));
        table.addValue(new Value("ID_StepInput", 5, KEY, 0));
        table.addValue(new Value("ID_StepOutput", 5, KEY, 0));
        table.addValue(new Value("ID_StepUpdate", 5, KEY, 0));
        table.addValue(new Value("ModifiedUser", 2, 255, 0));
        table.addValue(new Value("ModifiedDate", 3, 20, 0));
        table.addValue(new Value("BufferRows", 5, KEY, 0));
        sql = this.database.getDDL(tablename, table, null, false, "ID_Transformation", false);
        if (sql != null && sql.length() > 0) {
            this.log.logDetailed(this.toString(), "executing SQL statements: " + Const.CR + sql);
            this.database.execStatements(sql);
            this.log.logDetailed(this.toString(), "Created or altered table " + tablename);
        } else {
            this.log.logDetailed(this.toString(), "Table " + tablename + " is OK.");
        }
        this.database.execStatement("UPDATE " + tablename + " SET ID_Directory=0 WHERE ID_Directory IS NULL");
        if (monitor != null) {
            monitor.worked(1);
        }
        table = new Row();
        tablename = "T_ETL_Dependency";
        if (monitor != null) {
            monitor.subTask("Checking table " + tablename);
        }
        table.addValue(new Value("ID_Dependency", 5, KEY, 0));
        table.addValue(new Value("ID_Transformation", 5, KEY, 0));
        table.addValue(new Value("ID_Database", 5, KEY, 0));
        table.addValue(new Value("TableName", 2, 255, 0));
        table.addValue(new Value("FieldName", 2, 255, 0));
        sql = this.database.getDDL(tablename, table, null, false, "ID_Dependency", false);
        if (sql != null && sql.length() > 0) {
            this.log.logDetailed(this.toString(), "executing SQL statements: " + Const.CR + sql);
            this.database.execStatements(sql);
            this.log.logDetailed(this.toString(), "Created or altered table " + tablename);
        } else {
            this.log.logDetailed(this.toString(), "Table " + tablename + " is OK.");
        }
        if (monitor != null) {
            monitor.worked(1);
        }
        table = new Row();
        tablename = "T_ETL_TransHop";
        if (monitor != null) {
            monitor.subTask("Checking table " + tablename);
        }
        table.addValue(new Value("ID_TransHop", 5, KEY, 0));
        table.addValue(new Value("ID_Transformation", 5, KEY, 0));
        table.addValue(new Value("ID_StepFrom", 5, KEY, 0));
        table.addValue(new Value("ID_StepTo", 5, KEY, 0));
        table.addValue(new Value("Enabled", 4, 1, 0));
        sql = this.database.getDDL(tablename, table, null, false, "ID_TransHop", false);
        if (sql != null && sql.length() > 0) {
            this.log.logDetailed(this.toString(), "executing SQL statements: " + Const.CR + sql);
            this.database.execStatements(sql);
            this.log.logDetailed(this.toString(), "Created or altered table " + tablename);
        } else {
            this.log.logDetailed(this.toString(), "Table " + tablename + " is OK.");
        }
        if (monitor != null) {
            monitor.worked(1);
        }
        table = new Row();
        tablename = "T_ETL_TransStepCondition";
        if (monitor != null) {
            monitor.subTask("Checking table " + tablename);
        }
        table.addValue(new Value("ID_Transformation", 5, KEY, 0));
        table.addValue(new Value("ID_Step", 5, KEY, 0));
        table.addValue(new Value("ID_Condition", 5, KEY, 0));
        sql = this.database.getDDL(tablename, table, null, false, null, false);
        if (sql != null && sql.length() > 0) {
            this.log.logDetailed(this.toString(), "executing SQL statements: " + Const.CR + sql);
            this.database.execStatements(sql);
            this.log.logDetailed(this.toString(), "Created or altered table " + tablename);
        } else {
            this.log.logDetailed(this.toString(), "Table " + tablename + " is OK.");
        }
        if (monitor != null) {
            monitor.worked(1);
        }
        table = new Row();
        tablename = "T_ETL_Condition";
        if (monitor != null) {
            monitor.subTask("Checking table " + tablename);
        }
        table.addValue(new Value("ID_Condition", 5, KEY, 0));
        table.addValue(new Value("ID_ConditionParent", 5, KEY, 0));
        table.addValue(new Value("Negated", 4, 1, 0));
        table.addValue(new Value("Operator", 2, 255, 0));
        table.addValue(new Value("LeftName", 2, 255, 0));
        table.addValue(new Value("ConditionFunction", 2, 255, 0));
        table.addValue(new Value("RightName", 2, 255, 0));
        table.addValue(new Value("ID_ValueRight", 2, 255, 0));
        sql = this.database.getDDL(tablename, table, null, false, "ID_Condition", false);
        if (sql != null && sql.length() > 0) {
            this.log.logDetailed(this.toString(), "executing SQL statements: " + Const.CR + sql);
            this.database.execStatements(sql);
            this.log.logDetailed(this.toString(), "Created or altered table " + tablename);
        } else {
            this.log.logDetailed(this.toString(), "Table " + tablename + " is OK.");
        }
        if (monitor != null) {
            monitor.worked(1);
        }
        tablename = "T_ETL_Value";
        if (monitor != null) {
            monitor.subTask("Checking table " + tablename);
        }
        table = new Row();
        table.addValue(new Value("ID_Value", 5, KEY, 0));
        table.addValue(new Value("Name", 2, 255, 0));
        table.addValue(new Value("ValueType", 2, 255, 0));
        table.addValue(new Value("ValueStr", 2, 255, 0));
        table.addValue(new Value("IsNull", 4, 1, 0));
        sql = this.database.getDDL(tablename, table, null, false, "ID_Value", false);
        if (sql != null && sql.length() > 0) {
            this.log.logDetailed(this.toString(), "executing SQL statements: " + Const.CR + sql);
            this.database.execStatements(sql);
            this.log.logDetailed(this.toString(), "Created or altered table " + tablename);
        } else {
            this.log.logDetailed(this.toString(), "Table " + tablename + " is OK.");
        }
        if (monitor != null) {
            monitor.worked(1);
        }
        boolean ok_step_type = true;
        table = new Row();
        tablename = "T_ETL_StepType";
        if (monitor != null) {
            monitor.subTask("Checking table " + tablename);
        }
        table.addValue(new Value("ID_StepType", 5, KEY, 0));
        table.addValue(new Value("Code", 2, 255, 0));
        table.addValue(new Value("Description", 2, 2000, 0));
        table.addValue(new Value("HelpText", 2, 2000, 0));
        sql = this.database.getDDL(tablename, table, null, false, "ID_StepType", false);
        if (sql != null && sql.length() > 0) {
            this.log.logDetailed(this.toString(), "executing SQL statements: " + Const.CR + sql);
            this.database.execStatements(sql);
            this.log.logDetailed(this.toString(), "Created or altered table " + tablename);
        } else {
            this.log.logDetailed(this.toString(), "Table " + tablename + " is OK.");
        }
        if (ok_step_type) {
            this.updateStepTypes();
            this.log.logDetailed(this.toString(), "Populated table " + tablename);
        }
        if (monitor != null) {
            monitor.worked(1);
        }
        table = new Row();
        tablename = "T_ETL_Step";
        if (monitor != null) {
            monitor.subTask("Checking table " + tablename);
        }
        table.addValue(new Value("ID_Step", 5, KEY, 0));
        table.addValue(new Value("ID_Transformation", 5, KEY, 0));
        table.addValue(new Value("Name", 2, 255, 0));
        table.addValue(new Value("Description", 2, 2000, 0));
        table.addValue(new Value("ID_StepType", 5, KEY, 0));
        table.addValue(new Value("Distribute", 4, 1, 0));
        table.addValue(new Value("Copies", 5, 3, 0));
        table.addValue(new Value("GUILocationX", 5, 6, 0));
        table.addValue(new Value("GUILocationY", 5, 6, 0));
        table.addValue(new Value("GUIDraw", 4, 1, 0));
        sql = this.database.getDDL(tablename, table, null, false, "ID_Step", false);
        if (sql != null && sql.length() > 0) {
            this.log.logDetailed(this.toString(), "executing SQL statements: " + Const.CR + sql);
            this.database.execStatements(sql);
            this.log.logDetailed(this.toString(), "Created or altered table " + tablename);
        } else {
            this.log.logDetailed(this.toString(), "Table " + tablename + " is OK.");
        }
        if (monitor != null) {
            monitor.worked(1);
        }
        tablename = "T_ETL_StepAttribute";
        if (monitor != null) {
            monitor.subTask("Checking table " + tablename);
        }
        table = new Row();
        table.addValue(new Value("ID_StepAttribute", 5, KEY, 0));
        table.addValue(new Value("ID_Transformation", 5, KEY, 0));
        table.addValue(new Value("ID_Step", 5, KEY, 0));
        table.addValue(new Value("Nr", 5, 6, 0));
        table.addValue(new Value("Code", 2, 255, 0));
        table.addValue(new Value("ValueNum", 1, 13, 2));
        table.addValue(new Value("ValueStr", 2, 2000, 0));
        sql = this.database.getDDL(tablename, table, null, false, "ID_StepAttribute", false);
        if (sql != null && sql.length() > 0) {
            this.log.logDetailed(this.toString(), "executing SQL statements: " + Const.CR + sql);
            this.database.execStatements(sql);
            this.log.logDetailed(this.toString(), "Created or altered table " + tablename);
            try {
                indexname = "IDX_" + tablename.substring(2) + "_LOOKUP";
                keyfield = new String[]{"ID_Step", "Code", "Nr"};
                if (!this.database.checkIndexExists(tablename, keyfield)) {
                    sql = this.database.getCreateIndexStatement(tablename, indexname, keyfield, false, true, false, false);
                    this.log.logDetailed(this.toString(), "executing SQL statements: " + Const.CR + sql);
                    this.database.execStatements(sql);
                    this.log.logDetailed(this.toString(), "Created lookup index " + indexname + " on " + tablename);
                }
            }
            catch (ETLDatabaseException lookup) {}
        } else {
            this.log.logDetailed(this.toString(), "Table " + tablename + " is OK.");
        }
        if (monitor != null) {
            monitor.worked(1);
        }
        tablename = "T_ETL_StepDatabase";
        if (monitor != null) {
            monitor.subTask("Checking table " + tablename);
        }
        table = new Row();
        table.addValue(new Value("ID_Transformation", 5, KEY, 0));
        table.addValue(new Value("ID_Step", 5, KEY, 0));
        table.addValue(new Value("ID_Database", 5, KEY, 0));
        sql = this.database.getDDL(tablename, table, null, false, null, false);
        if (sql != null && sql.length() > 0) {
            this.log.logDetailed(this.toString(), "executing SQL statements: " + Const.CR + sql);
            this.database.execStatements(sql);
            this.log.logDetailed(this.toString(), "Created or altered table " + tablename);
            try {
                indexname = "IDX_" + tablename.substring(2) + "_LU1";
                keyfield = new String[]{"ID_Transformation"};
                if (!this.database.checkIndexExists(tablename, keyfield)) {
                    sql = this.database.getCreateIndexStatement(tablename, indexname, keyfield, false, false, false, false);
                    this.log.logDetailed(this.toString(), "executing SQL statements: " + Const.CR + sql);
                    this.database.execStatements(sql);
                    this.log.logDetailed(this.toString(), "Created lookup index " + indexname + " on " + tablename);
                }
            }
            catch (ETLDatabaseException lookup) {
                // empty catch block
            }
            try {
                indexname = "IDX_" + tablename.substring(2) + "_LU2";
                keyfield = new String[]{"ID_Database"};
                if (!this.database.checkIndexExists(tablename, keyfield)) {
                    sql = this.database.getCreateIndexStatement(tablename, indexname, keyfield, false, false, false, false);
                    this.log.logDetailed(this.toString(), "executing SQL statements: " + Const.CR + sql);
                    this.database.execStatements(sql);
                    this.log.logDetailed(this.toString(), "Created lookup index " + indexname + " on " + tablename);
                }
            }
            catch (ETLDatabaseException lookup) {}
        } else {
            this.log.logDetailed(this.toString(), "Table " + tablename + " is OK.");
        }
        if (monitor != null) {
            monitor.worked(1);
        }
        table = new Row();
        tablename = "T_ETL_TransNote";
        if (monitor != null) {
            monitor.subTask("Checking table " + tablename);
        }
        table.addValue(new Value("ID_Transformation", 5, KEY, 0));
        table.addValue(new Value("ID_Note", 5, KEY, 0));
        sql = this.database.getDDL(tablename, table, null, false, null, false);
        if (sql != null && sql.length() > 0) {
            this.log.logDetailed(this.toString(), "executing SQL statements: " + Const.CR + sql);
            this.database.execStatements(sql);
            this.log.logDetailed(this.toString(), "Created or altered table " + tablename);
        } else {
            this.log.logDetailed(this.toString(), "Table " + tablename + " is OK.");
        }
        if (monitor != null) {
            monitor.worked(1);
        }
        table = new Row();
        tablename = "T_ETL_Job";
        if (monitor != null) {
            monitor.subTask("Checking table " + tablename);
        }
        table.addValue(new Value("ID_Job", 5, KEY, 0));
        table.addValue(new Value("ID_Directory", 5, KEY, 0));
        table.addValue(new Value("Name", 2, 255, 0));
        table.addValue(new Value("Description", 2, 2000, 0));
        table.addValue(new Value("ID_DBLog", 5, KEY, 0));
        table.addValue(new Value("TableNameAuditLog", 2, 255, 0));
        table.addValue(new Value("TableNameErrorLog", 2, 255, 0));
        table.addValue(new Value("ModifiedUser", 2, 255, 0));
        table.addValue(new Value("ModifiedDate", 2, 255, 0));
        sql = this.database.getDDL(tablename, table, null, false, "ID_Job", false);
        if (sql != null && sql.length() > 0) {
            this.log.logDetailed(this.toString(), "executing SQL statements: " + Const.CR + sql);
            this.database.execStatements(sql);
            this.log.logDetailed(this.toString(), "Created or altered table " + tablename);
        } else {
            this.log.logDetailed(this.toString(), "Table " + tablename + " is OK.");
        }
        if (monitor != null) {
            monitor.worked(1);
        }
        table = new Row();
        tablename = "T_ETL_Schedule";
        if (monitor != null) {
            monitor.subTask("Checking table " + tablename);
        }
        table.addValue(new Value("ID_Schedule", 5, KEY, 0));
        table.addValue(new Value("Name", 2, 255, 0));
        table.addValue(new Value("ID_Directory", 5, KEY, 0));
        table.addValue(new Value("ID_Job", 5, KEY, 0));
        table.addValue(new Value("ID_ScheduleType", 5, KEY, 0));
        table.addValue(new Value("ModifiedUser", 2, 255, 0));
        table.addValue(new Value("ModifiedDate", 2, 255, 0));
        table.addValue(new Value("UsedFlag", 4, 1, 0));
        sql = this.database.getDDL(tablename, table, null, false, "ID_Schedule", false);
        if (sql != null && sql.length() > 0) {
            this.log.logDetailed(this.toString(), "executing SQL statements: " + Const.CR + sql);
            this.database.execStatements(sql);
            this.log.logDetailed(this.toString(), "Created or altered table " + tablename);
        } else {
            this.log.logDetailed(this.toString(), "Table " + tablename + " is OK.");
        }
        if (monitor != null) {
            monitor.worked(1);
        }
        boolean ok_scheduleEntry_type = true;
        table = new Row();
        tablename = "T_ETL_ScheduleType";
        if (monitor != null) {
            monitor.subTask("Checking table " + tablename);
        }
        table.addValue(new Value("ID_ScheduleType", 5, KEY, 0));
        table.addValue(new Value("Code", 2, 255, 0));
        table.addValue(new Value("Description", 2, 2000, 0));
        sql = this.database.getDDL(tablename, table, null, false, "ID_ScheduleType", false);
        if (sql != null && sql.length() > 0) {
            this.log.logDetailed(this.toString(), "executing SQL statements: " + Const.CR + sql);
            this.database.execStatements(sql);
            this.log.logDetailed(this.toString(), "Created or altered table " + tablename);
        } else {
            this.log.logDetailed(this.toString(), "Table " + tablename + " is OK.");
        }
        if (ok_scheduleEntry_type) {
            this.updateScheduleTypes();
            this.log.logDetailed(this.toString(), "Populated table " + tablename);
        }
        if (monitor != null) {
            monitor.worked(1);
        }
        table = new Row();
        tablename = "T_ETL_ScheduleAttribute";
        if (monitor != null) {
            monitor.subTask("Checking table " + tablename);
        }
        table.addValue(new Value("ID_ScheduleAttribute", 5, KEY, 0));
        table.addValue(new Value("ID_Schedule", 5, KEY, 0));
        table.addValue(new Value("ID_ScheduleType", 5, KEY, 0));
        table.addValue(new Value("Nr", 5, 6, 0));
        table.addValue(new Value("Code", 2, 255, 0));
        table.addValue(new Value("ValueNum", 1, 13, 2));
        table.addValue(new Value("ValueStr", 2, 2000, 0));
        sql = this.database.getDDL(tablename, table, null, false, "ID_ScheduleAttribute", false);
        if (sql != null && sql.length() > 0) {
            this.log.logDetailed(this.toString(), "executing SQL statements: " + Const.CR + sql);
            this.database.execStatements(sql);
            this.log.logDetailed(this.toString(), "Created or altered table " + tablename);
            try {
                indexname = "IDX_" + tablename.substring(2) + "_LOOKUP";
                keyfield = new String[]{"ID_ScheduleAttribute", "Code", "Nr"};
                if (!this.database.checkIndexExists(tablename, keyfield)) {
                    sql = this.database.getCreateIndexStatement(tablename, indexname, keyfield, false, true, false, false);
                    this.log.logDetailed(this.toString(), "executing SQL statements: " + Const.CR + sql);
                    this.database.execStatements(sql);
                    this.log.logDetailed(this.toString(), "Created lookup index " + indexname + " on " + tablename);
                }
            }
            catch (ETLDatabaseException nextid) {}
        } else {
            this.log.logDetailed(this.toString(), "Table " + tablename + " is OK.");
        }
        if (monitor != null) {
            monitor.worked(1);
        }
        boolean ok_jobentry_type = true;
        table = new Row();
        tablename = "T_ETL_JobEntryType";
        if (monitor != null) {
            monitor.subTask("Checking table " + tablename);
        }
        table.addValue(new Value("ID_JobEntryType", 5, KEY, 0));
        table.addValue(new Value("Code", 2, 255, 0));
        table.addValue(new Value("Description", 2, 2000, 0));
        sql = this.database.getDDL(tablename, table, null, false, "ID_JobEntryType", false);
        if (sql != null && sql.length() > 0) {
            this.log.logDetailed(this.toString(), "executing SQL statements: " + Const.CR + sql);
            this.database.execStatements(sql);
            this.log.logDetailed(this.toString(), "Created or altered table " + tablename);
        } else {
            this.log.logDetailed(this.toString(), "Table " + tablename + " is OK.");
        }
        if (ok_jobentry_type) {
            this.updateJobEntryTypes();
            this.log.logDetailed(this.toString(), "Populated table " + tablename);
        }
        if (monitor != null) {
            monitor.worked(1);
        }
        table = new Row();
        tablename = "T_ETL_JobEntry";
        if (monitor != null) {
            monitor.subTask("Checking table " + tablename);
        }
        table.addValue(new Value("ID_JobEntry", 5, KEY, 0));
        table.addValue(new Value("ID_Job", 5, KEY, 0));
        table.addValue(new Value("ID_JobEntryType", 5, KEY, 0));
        table.addValue(new Value("Name", 2, 255, 0));
        table.addValue(new Value("Description", 2, 2000, 0));
        sql = this.database.getDDL(tablename, table, null, false, "ID_JobEntry", false);
        if (sql != null && sql.length() > 0) {
            this.log.logDetailed(this.toString(), "executing SQL statements: " + Const.CR + sql);
            this.database.execStatements(sql);
            this.log.logDetailed(this.toString(), "Created or altered table " + tablename);
        } else {
            this.log.logDetailed(this.toString(), "Table " + tablename + " is OK.");
        }
        if (monitor != null) {
            monitor.worked(1);
        }
        table = new Row();
        tablename = "T_ETL_JobEntryCopy";
        if (monitor != null) {
            monitor.subTask("Checking table " + tablename);
        }
        table.addValue(new Value("ID_JobEntryCopy", 5, KEY, 0));
        table.addValue(new Value("ID_JobEntry", 5, KEY, 0));
        table.addValue(new Value("ID_Job", 5, KEY, 0));
        table.addValue(new Value("ID_JobEntryType", 5, KEY, 0));
        table.addValue(new Value("Nr", 5, 4, 0));
        table.addValue(new Value("GUILocationX", 5, 6, 0));
        table.addValue(new Value("GUILocationY", 5, 6, 0));
        table.addValue(new Value("GUIDraw", 4, 1, 0));
        sql = this.database.getDDL(tablename, table, null, false, "ID_JobEntryCopy", false);
        if (sql != null && sql.length() > 0) {
            this.log.logDetailed(this.toString(), "executing SQL statements: " + Const.CR + sql);
            this.database.execStatements(sql);
            this.log.logDetailed(this.toString(), "Created or altered table " + tablename);
        } else {
            this.log.logDetailed(this.toString(), "Table " + tablename + " is OK.");
        }
        if (monitor != null) {
            monitor.worked(1);
        }
        table = new Row();
        tablename = "T_ETL_JobEntryAttribute";
        if (monitor != null) {
            monitor.subTask("Checking table " + tablename);
        }
        table.addValue(new Value("ID_JobEntryAttribute", 5, KEY, 0));
        table.addValue(new Value("ID_Job", 5, KEY, 0));
        table.addValue(new Value("ID_JobEntry", 5, KEY, 0));
        table.addValue(new Value("Nr", 5, 6, 0));
        table.addValue(new Value("Code", 2, 255, 0));
        table.addValue(new Value("ValueNum", 1, 13, 2));
        table.addValue(new Value("ValueStr", 2, 2000, 0));
        sql = this.database.getDDL(tablename, table, null, false, "ID_JobEntryAttribute", false);
        if (sql != null && sql.length() > 0) {
            this.log.logDetailed(this.toString(), "executing SQL statements: " + Const.CR + sql);
            this.database.execStatements(sql);
            this.log.logDetailed(this.toString(), "Created or altered table " + tablename);
            try {
                indexname = "IDX_" + tablename.substring(2) + "_LOOKUP";
                keyfield = new String[]{"ID_JobEntryAttribute", "Code", "Nr"};
                if (!this.database.checkIndexExists(tablename, keyfield)) {
                    sql = this.database.getCreateIndexStatement(tablename, indexname, keyfield, false, true, false, false);
                    this.log.logDetailed(this.toString(), "executing SQL statements: " + Const.CR + sql);
                    this.database.execStatements(sql);
                    this.log.logDetailed(this.toString(), "Created lookup index " + indexname + " on " + tablename);
                }
            }
            catch (ETLDatabaseException eTLDatabaseException) {}
        } else {
            this.log.logDetailed(this.toString(), "Table " + tablename + " is OK.");
        }
        if (monitor != null) {
            monitor.worked(1);
        }
        table = new Row();
        tablename = "T_ETL_JobHop";
        if (monitor != null) {
            monitor.subTask("Checking table " + tablename);
        }
        table.addValue(new Value("ID_JobHop", 5, KEY, 0));
        table.addValue(new Value("ID_Job", 5, KEY, 0));
        table.addValue(new Value("ID_JobEntryCopyFrom", 5, KEY, 0));
        table.addValue(new Value("ID_JobEntryCopyTo", 5, KEY, 0));
        table.addValue(new Value("Enabled", 4, 1, 0));
        table.addValue(new Value("Evaluation", 4, 1, 0));
        table.addValue(new Value("UnConditional", 4, 1, 0));
        sql = this.database.getDDL(tablename, table, null, false, "ID_JobHop", false);
        if (sql != null && sql.length() > 0) {
            this.log.logDetailed(this.toString(), "executing SQL statements: " + Const.CR + sql);
            this.database.execStatements(sql);
            this.log.logDetailed(this.toString(), "Created or altered table " + tablename);
        } else {
            this.log.logDetailed(this.toString(), "Table " + tablename + " is OK.");
        }
        if (monitor != null) {
            monitor.worked(1);
        }
        table = new Row();
        tablename = "T_ETL_JobNote";
        if (monitor != null) {
            monitor.subTask("Checking table " + tablename);
        }
        table.addValue(new Value("ID_Job", 5, KEY, 0));
        table.addValue(new Value("ID_Note", 5, KEY, 0));
        sql = this.database.getDDL(tablename, table, null, false, null, false);
        if (sql != null && sql.length() > 0) {
            this.log.logDetailed(this.toString(), "executing SQL statements: " + Const.CR + sql);
            this.database.execStatements(sql);
            this.log.logDetailed(this.toString(), "Created or altered table " + tablename);
        } else {
            this.log.logDetailed(this.toString(), "Table " + tablename + " is OK.");
        }
        if (monitor != null) {
            monitor.worked(1);
        }
        Hashtable<String, Long> profiles = new Hashtable<String, Long>();
        boolean ok_profile = true;
        tablename = "T_ETL_Profile";
        if (monitor != null) {
            monitor.subTask("Checking table " + tablename);
        }
        table = new Row();
        table.addValue(new Value("ID_Profile", 5, KEY, 0));
        table.addValue(new Value("Name", 2, 255, 0));
        table.addValue(new Value("Description", 2, 2000, 0));
        sql = this.database.getDDL(tablename, table, null, false, "ID_Profile", false);
        if (sql != null && sql.length() > 0) {
            this.log.logDetailed(this.toString(), "executing SQL statements: " + Const.CR + sql);
            this.database.execStatements(sql);
            this.log.logDetailed(this.toString(), "Created or altered table " + tablename);
        } else {
            this.log.logDetailed(this.toString(), "Table " + tablename + " is OK.");
        }
        if (ok_profile) {
            code = new String[]{"Administrator", "User", "Read-only"};
            desc = new String[]{"Administrator profile, manage users", "Normal user, all tools", "Read-only users"};
            this.database.prepareInsert(table, tablename);
            for (int i = 0; i < code.length; ++i) {
                Row lookup = null;
                if (upgrade) {
                    lookup = this.database.getOneRow("SELECT ID_Profile FROM " + tablename + " WHERE Name = '" + code[i] + "'");
                }
                if (lookup != null) continue;
                long nextid = this.getNextProfileID();
                table = new Row();
                table.addValue(new Value("ID_Profile", nextid));
                table.addValue(new Value("Name", code[i]));
                table.addValue(new Value("Description", desc[i]));
                this.database.setValuesInsert(table);
                this.database.insertRow();
                this.log.logDetailed(this.toString(), "Inserted new row into table " + tablename + " : " + table);
                profiles.put(code[i], new Long(nextid));
            }
            try {
                this.database.closeInsert();
                this.log.logDetailed(this.toString(), "Populated table " + tablename);
            }
            catch (ETLDatabaseException dbe) {
                throw new ETLDatabaseException("Unable to close insert after populating table " + tablename, dbe);
            }
        }
        if (monitor != null) {
            monitor.worked(1);
        }
        Hashtable<String, Long> users = new Hashtable<String, Long>();
        boolean ok_user = true;
        table = new Row();
        tablename = "T_ETL_User";
        if (monitor != null) {
            monitor.subTask("Checking table " + tablename);
        }
        table.addValue(new Value("ID_User", 5, KEY, 0));
        table.addValue(new Value("ID_Profile", 5, KEY, 0));
        table.addValue(new Value("Login", 2, 255, 0));
        table.addValue(new Value("Password", 2, 255, 0));
        table.addValue(new Value("Name", 2, 255, 0));
        table.addValue(new Value("Description", 2, 255, 0));
        table.addValue(new Value("Enabled", 4, 1, 0));
        sql = this.database.getDDL(tablename, table, null, false, "ID_User", false);
        if (sql != null && sql.length() > 0) {
            this.log.logDetailed(this.toString(), "executing SQL statements: " + Const.CR + sql);
            this.database.execStatements(sql);
            this.log.logDetailed(this.toString(), "Created or altered table " + tablename);
        } else {
            this.log.logDetailed(this.toString(), "Table " + tablename + " is OK.");
        }
        if (ok_user) {
            String[] user = new String[]{"admin", "guest"};
            String[] pass = new String[]{"admin", "guest"};
            code = new String[]{"Administrator", "Guest account"};
            desc = new String[]{"User manager", "Read-only guest account"};
            String[] prof = new String[]{"Administrator", "Read-only"};
            this.database.prepareInsert(table, tablename);
            for (int i = 0; i < user.length; ++i) {
                Row lookup = null;
                if (upgrade) {
                    lookup = this.database.getOneRow("SELECT ID_User FROM " + tablename + " WHERE Login = '" + user[i] + "'");
                }
                if (lookup != null) continue;
                long nextid = this.getNextUserID();
                String password = Encr.encryptPassword(pass[i]);
                Long profileID = (Long)profiles.get(prof[i]);
                long id_profile = -1L;
                if (profileID != null) {
                    id_profile = profileID;
                }
                table = new Row();
                table.addValue(new Value("ID_User", nextid));
                table.addValue(new Value("ID_Profile", id_profile));
                table.addValue(new Value("Login", user[i]));
                table.addValue(new Value("Password", password));
                table.addValue(new Value("Name", code[i]));
                table.addValue(new Value("Description", desc[i]));
                table.addValue(new Value("Enabled", true));
                this.database.setValuesInsert(table);
                this.database.insertRow();
                users.put(user[i], new Long(nextid));
            }
            try {
                this.database.closeInsert();
                this.log.logDetailed(this.toString(), "Populated table " + tablename);
            }
            catch (ETLDatabaseException dbe) {
                throw new ETLDatabaseException("Unable to close insert after populating table " + tablename, dbe);
            }
        }
        if (monitor != null) {
            monitor.worked(1);
        }
        Hashtable<String, Long> permissions = new Hashtable<String, Long>();
        boolean ok_permission = true;
        table = new Row();
        tablename = "T_ETL_Permission";
        if (monitor != null) {
            monitor.subTask("Checking table " + tablename);
        }
        table.addValue(new Value("ID_Permission", 5, KEY, 0));
        table.addValue(new Value("Code", 2, 255, 0));
        table.addValue(new Value("Description", 2, 2000, 0));
        sql = this.database.getDDL(tablename, table, null, false, "ID_Permission", false);
        if (sql != null && sql.length() > 0) {
            this.log.logDetailed(this.toString(), "executing SQL statements: " + Const.CR + sql);
            this.database.execStatements(sql);
            this.log.logDetailed(this.toString(), "Created or altered table " + tablename);
        } else {
            this.log.logDetailed(this.toString(), "Table " + tablename + " is OK.");
        }
        if (ok_permission) {
            code = PermissionMeta.permission_type_desc;
            desc = PermissionMeta.permissionTypeLongDesc;
            this.database.prepareInsert(table, tablename);
            for (int i = 1; i < code.length; ++i) {
                Row lookup = null;
                if (upgrade) {
                    lookup = this.database.getOneRow("SELECT ID_Permission FROM " + tablename + " WHERE Code = '" + code[i] + "'");
                }
                if (lookup != null) continue;
                long nextid = this.getNextPermissionID();
                table = new Row();
                table.addValue(new Value("ID_Permission", nextid));
                table.addValue(new Value("Code", code[i]));
                table.addValue(new Value("Description", desc[i]));
                this.database.setValuesInsert(table);
                this.database.insertRow();
                this.log.logDetailed(this.toString(), "Inserted new row into table " + tablename + " : " + table);
                permissions.put(code[i], new Long(nextid));
            }
            try {
                this.database.closeInsert();
                this.log.logDetailed(this.toString(), "Populated table " + tablename);
            }
            catch (ETLDatabaseException dbe) {
                throw new ETLDatabaseException("Unable to close insert after populating table " + tablename, dbe);
            }
        }
        if (monitor != null) {
            monitor.worked(1);
        }
        boolean ok_profile_permission = true;
        table = new Row();
        tablename = "T_ETL_ProfilePermission";
        if (monitor != null) {
            monitor.subTask("Checking table " + tablename);
        }
        table.addValue(new Value("ID_Profile", 5, KEY, 0));
        table.addValue(new Value("ID_Permission", 5, KEY, 0));
        sql = this.database.getDDL(tablename, table, null, false, null, false);
        if (sql != null && sql.length() > 0) {
            this.log.logDetailed(this.toString(), "executing SQL statements: " + Const.CR + sql);
            this.database.execStatements(sql);
            this.log.logDetailed(this.toString(), "Created or altered table " + tablename);
            try {
                indexname = "IDX_" + tablename.substring(2) + "_PK";
                keyfield = new String[]{"ID_Profile", "ID_Permission"};
                if (!this.database.checkIndexExists(tablename, keyfield)) {
                    sql = this.database.getCreateIndexStatement(tablename, indexname, keyfield, false, true, false, false);
                    this.log.logDetailed(this.toString(), "executing SQL statements: " + Const.CR + sql);
                    this.database.execStatements(sql);
                    this.log.logDetailed(this.toString(), "Created lookup index " + indexname + " on " + tablename);
                }
            }
            catch (ETLDatabaseException lookup) {}
        } else {
            this.log.logDetailed(this.toString(), "Table " + tablename + " is OK.");
        }
        if (ok_profile_permission) {
            Row lookup;
            long id_permission;
            Long permissionID;
            int i;
            this.database.prepareInsert(table, tablename);
            Long profileID = (Long)profiles.get("Administrator");
            long id_profile = -1L;
            if (profileID != null) {
                id_profile = profileID;
            }
            this.log.logDetailed(this.toString(), "Administrator profile id = " + id_profile);
            String[] perms = new String[]{PermissionMeta.permission_type_desc[2], PermissionMeta.permission_type_desc[3], PermissionMeta.permission_type_desc[4], PermissionMeta.permission_type_desc[5]};
            for (i = 0; i < perms.length; ++i) {
                permissionID = (Long)permissions.get(perms[i]);
                id_permission = -1L;
                if (permissionID != null) {
                    id_permission = permissionID;
                }
                this.log.logDetailed(this.toString(), "Permission id for '" + perms[i] + "' = " + id_permission);
                lookup = null;
                if (upgrade) {
                    String lookupSQL = "SELECT ID_Profile FROM " + tablename + " WHERE ID_Profile=" + id_profile + " AND ID_Permission=" + id_permission;
                    this.log.logDetailed(this.toString(), "Executing SQL: " + lookupSQL);
                    lookup = this.database.getOneRow(lookupSQL);
                }
                if (lookup == null) {
                    String insertSQL = "INSERT INTO " + tablename + "(ID_Profile, ID_Permission) VALUES(" + id_profile + "," + id_permission + ")";
                    this.database.execStatement(insertSQL);
                    this.log.logDetailed(this.toString(), "insertSQL = [" + insertSQL + "]");
                    continue;
                }
                this.log.logDetailed(this.toString(), "Found id_profile=" + id_profile + ", id_permission=" + id_permission);
            }
            profileID = (Long)profiles.get("User");
            id_profile = -1L;
            if (profileID != null) {
                id_profile = profileID;
            }
            this.log.logDetailed(this.toString(), "User profile id = " + id_profile);
            perms = new String[]{PermissionMeta.permission_type_desc[3], PermissionMeta.permission_type_desc[4], PermissionMeta.permission_type_desc[5]};
            for (i = 0; i < perms.length; ++i) {
                permissionID = (Long)permissions.get(perms[i]);
                id_permission = -1L;
                if (permissionID != null) {
                    id_permission = permissionID;
                }
                lookup = null;
                if (upgrade) {
                    lookup = this.database.getOneRow("SELECT ID_Profile FROM " + tablename + " WHERE ID_Profile=" + id_profile + " AND ID_Permission=" + id_permission);
                }
                if (lookup != null) continue;
                table = new Row();
                table.addValue(new Value("ID_Profile", id_profile));
                table.addValue(new Value("ID_Permission", id_permission));
                this.database.setValuesInsert(table);
                this.database.insertRow();
            }
            try {
                this.database.closeInsert();
                this.log.logDetailed(this.toString(), "Populated table " + tablename);
            }
            catch (ETLDatabaseException dbe) {
                throw new ETLDatabaseException("Unable to close insert after populating table " + tablename, dbe);
            }
        }
        if (monitor != null) {
            monitor.worked(1);
        }
        if (monitor != null) {
            monitor.done();
        }
        this.log.logBasic(this.toString(), (upgrade ? "Upgraded" : "Created") + " " + this.repositoryTableNames.length + " repository tables.");
    }

    public int countNrStepAttributes(long id_step, String code) throws ETLDatabaseException {
        if (this.stepAttributesBuffer != null) {
            int nr = this.searchNrStepAttributes(id_step, code);
            return nr;
        }
        String sql = "SELECT COUNT(*) FROM T_ETL_StepAttribute WHERE ID_Step = ? AND Code = ?";
        Row table = new Row();
        table.addValue(new Value("ID_Step", id_step));
        table.addValue(new Value("Code", code));
        Row r = this.database.getOneRow(sql, table);
        if (r == null) {
            return 0;
        }
        return (int)r.getValue(0).getInteger();
    }

    public long saveJobEntryAttribute(long id_job, long id_jobentry, String code, String value) throws ETLDatabaseException {
        return this.saveJobEntryAttribute(code, 0L, id_job, id_jobentry, 0.0, value);
    }

    public long saveJobEntryAttribute(long id_job, long id_jobentry, String code, double value) throws ETLDatabaseException {
        return this.saveJobEntryAttribute(code, 0L, id_job, id_jobentry, value, null);
    }

    public long saveJobEntryAttribute(long id_job, long id_jobentry, String code, boolean value) throws ETLDatabaseException {
        return this.saveJobEntryAttribute(code, 0L, id_job, id_jobentry, 0.0, value ? "Y" : "N");
    }

    public long saveJobEntryAttribute(long id_job, long id_jobentry, long nr, String code, String value) throws ETLDatabaseException {
        return this.saveJobEntryAttribute(code, nr, id_job, id_jobentry, 0.0, value);
    }

    public long saveJobEntryAttribute(long id_job, long id_jobentry, long nr, String code, double value) throws ETLDatabaseException {
        return this.saveJobEntryAttribute(code, nr, id_job, id_jobentry, value, null);
    }

    public long saveJobEntryAttribute(long id_job, long id_jobentry, long nr, String code, boolean value) throws ETLDatabaseException {
        return this.saveJobEntryAttribute(code, nr, id_job, id_jobentry, 0.0, value ? "Y" : "N");
    }

    private long saveJobEntryAttribute(String code, long nr, long id_job, long id_jobentry, double value_num, String value_str) throws ETLDatabaseException {
        return this.insertJobEntryAttribute(id_job, id_jobentry, nr, code, value_num, value_str);
    }

    public void setLookupJobEntryAttribute() throws ETLDatabaseException {
        String sql = "SELECT ValueStr, ValueNum FROM T_ETL_JobEntryAttribute WHERE ID_JobEntry = ?  AND Code = ?  AND Nr = ? ";
        this.pstmt_entry_attributes = this.database.prepareSQL(sql);
    }

    public void setLookupScheduleAttribute() throws ETLDatabaseException {
        String sql = "SELECT ValueStr, ValueNum FROM T_ETL_ScheduleAttribute WHERE ID_Schedule = ?  AND Code = ?  AND Nr = ? ";
        this.pstmt_schedule_attributes = this.database.prepareSQL(sql);
    }

    public void closeLookupJobEntryAttribute() throws ETLDatabaseException {
        this.database.closePreparedStatement(this.pstmt_entry_attributes);
    }

    public void closeLookupScheduleAttribute() throws ETLDatabaseException {
        this.database.closePreparedStatement(this.pstmt_schedule_attributes);
    }

    private Row getJobEntryAttributeRow(long id_jobentry, int nr, String code) throws ETLDatabaseException {
        Row par = new Row();
        par.addValue(new Value("ID_JobEntry", id_jobentry));
        par.addValue(new Value("Code", code));
        par.addValue(new Value("Nr", (long)nr));
        this.database.setValues(par, this.pstmt_entry_attributes);
        return this.database.getLookup(this.pstmt_entry_attributes);
    }

    private Row getScheduleAttributeRow(long id_schedule, int nr, String code) throws ETLDatabaseException {
        Row par = new Row();
        par.addValue(new Value("ID_Schedule", id_schedule));
        par.addValue(new Value("Code", code));
        par.addValue(new Value("Nr", (long)nr));
        this.database.setValues(par, this.pstmt_schedule_attributes);
        return this.database.getLookup(this.pstmt_schedule_attributes);
    }

    public long getJobEntryAttributeInteger(long id_jobentry, int nr, String code) throws ETLDatabaseException {
        Row r = this.getJobEntryAttributeRow(id_jobentry, nr, code);
        if (r == null) {
            return 0L;
        }
        return r.searchValue("ValueNum").getInteger();
    }

    public long getScheduleAttributeInteger(long id_schedule, int nr, String code) throws ETLDatabaseException {
        Row r = this.getScheduleAttributeRow(id_schedule, nr, code);
        if (r == null) {
            return 0L;
        }
        return r.searchValue("ValueNum").getInteger();
    }

    public double getJobEntryAttributeNumber(long id_jobentry, int nr, String code) throws ETLDatabaseException {
        Row r = this.getJobEntryAttributeRow(id_jobentry, nr, code);
        if (r == null) {
            return 0.0;
        }
        return r.searchValue("ValueNum").getNumber();
    }

    public String getJobEntryAttributeString(long id_jobentry, int nr, String code) throws ETLDatabaseException {
        Row r = this.getJobEntryAttributeRow(id_jobentry, nr, code);
        if (r == null) {
            return null;
        }
        return r.searchValue("ValueStr").getString();
    }

    public String getScheduleAttributeString(long id_schedule, int nr, String code) throws ETLDatabaseException {
        Row r = this.getScheduleAttributeRow(id_schedule, nr, code);
        if (r == null) {
            return null;
        }
        return r.searchValue("ValueStr").getString();
    }

    public boolean getJobEntryAttributeBoolean(long id_jobentry, int nr, String code) throws ETLDatabaseException {
        Row r = this.getJobEntryAttributeRow(id_jobentry, nr, code);
        if (r == null) {
            return false;
        }
        return r.searchValue("ValueStr").getBoolean();
    }

    public double getJobEntryAttributeNumber(long id_jobentry, String code) throws ETLDatabaseException {
        return this.getJobEntryAttributeNumber(id_jobentry, 0, code);
    }

    public long getJobEntryAttributeInteger(long id_jobentry, String code) throws ETLDatabaseException {
        return this.getJobEntryAttributeInteger(id_jobentry, 0, code);
    }

    public long getScheduleAttributeInteger(long id_schedule, String code) throws ETLDatabaseException {
        return this.getScheduleAttributeInteger(id_schedule, 0, code);
    }

    public String getJobEntryAttributeString(long id_jobentry, String code) throws ETLDatabaseException {
        return this.getJobEntryAttributeString(id_jobentry, 0, code);
    }

    public String getScheduleAttributeString(long id_schedule, String code) throws ETLDatabaseException {
        return this.getScheduleAttributeString(id_schedule, 0, code);
    }

    public boolean getJobEntryAttributeBoolean(long id_jobentry, String code) throws ETLDatabaseException {
        return this.getJobEntryAttributeBoolean(id_jobentry, 0, code);
    }

    public int countNrJobEntryAttributes(long id_jobentry, String code) throws ETLDatabaseException {
        String sql = "SELECT COUNT(*) FROM T_ETL_JobEntryAttribute WHERE ID_JobEntry = ? AND Code = ?";
        Row table = new Row();
        table.addValue(new Value("ID_JobEntry", id_jobentry));
        table.addValue(new Value("Code", code));
        Row r = this.database.getOneRow(sql, table);
        if (r == null) {
            return 0;
        }
        return (int)r.getValue(0).getInteger();
    }

    public void delSteps(long id_transformation) throws ETLDatabaseException {
        String sql = "DELETE FROM T_ETL_Step WHERE ID_Transformation = " + id_transformation;
        this.database.execStatement(sql);
    }

    public void delCondition(long id_condition) throws ETLDatabaseException {
        boolean ok = true;
        long[] ids = this.getSubConditionIDs(id_condition);
        if (ids.length > 0) {
            for (int i = 0; i < ids.length && ok; ++i) {
                this.delCondition(ids[i]);
            }
            this.delCondition(id_condition);
        } else {
            String sql = "DELETE FROM T_ETL_Condition WHERE ID_Condition = " + id_condition;
            this.database.execStatement(sql);
        }
    }

    public void delStepConditions(long id_transformation) throws ETLDatabaseException {
        long[] ids = this.getConditionIDs(id_transformation);
        for (int i = 0; i < ids.length; ++i) {
            this.delCondition(ids[i]);
        }
        String sql = "DELETE FROM T_ETL_TransStepCondition WHERE ID_Transformation = " + id_transformation;
        this.database.execStatement(sql);
    }

    public void delStepDatabases(long id_transformation) throws ETLDatabaseException {
        String sql = "DELETE FROM T_ETL_StepDatabase WHERE ID_Transformation = " + id_transformation;
        this.database.execStatement(sql);
    }

    public void delJobEntries(long id_job) throws ETLDatabaseException {
        String sql = "DELETE FROM T_ETL_JobEntry WHERE ID_Job = " + id_job;
        this.database.execStatement(sql);
    }

    public void delSchedule(long id_schedule) throws ETLDatabaseException {
        String sql = "DELETE FROM T_ETL_Schedule WHERE ID_Schedule = " + id_schedule;
        this.database.execStatement(sql);
    }

    public void delJobEntryCopies(long id_job) throws ETLDatabaseException {
        String sql = "DELETE FROM T_ETL_JobEntryCopy WHERE ID_Job = " + id_job;
        this.database.execStatement(sql);
    }

    public void delDependencies(long id_transformation) throws ETLDatabaseException {
        String sql = "DELETE FROM T_ETL_Dependency WHERE ID_Transformation = " + id_transformation;
        this.database.execStatement(sql);
    }

    public void delStepAttributes(long id_transformation) throws ETLDatabaseException {
        String sql = "DELETE FROM T_ETL_StepAttribute WHERE ID_Transformation = " + id_transformation;
        this.database.execStatement(sql);
    }

    public void delJobEntryAttributes(long id_job) throws ETLDatabaseException {
        String sql = "DELETE FROM T_ETL_JobEntryAttribute WHERE ID_Job = " + id_job;
        this.database.execStatement(sql);
    }

    public void delScheduleAttributes(long id_schedule) throws ETLDatabaseException {
        String sql = "DELETE FROM T_ETL_ScheduleAttribute WHERE ID_Schedule = " + id_schedule;
        this.database.execStatement(sql);
    }

    public void delTransHops(long id_transformation) throws ETLDatabaseException {
        String sql = "DELETE FROM T_ETL_TransHop WHERE ID_Transformation = " + id_transformation;
        this.database.execStatement(sql);
    }

    public void delJobHops(long id_job) throws ETLDatabaseException {
        String sql = "DELETE FROM T_ETL_JobHop WHERE ID_Job = " + id_job;
        this.database.execStatement(sql);
    }

    public void delTransNotes(long id_transformation) throws ETLDatabaseException {
        long[] ids = this.getTransNoteIDs(id_transformation);
        for (int i = 0; i < ids.length; ++i) {
            String sql = "DELETE FROM T_ETL_Note WHERE ID_Note = " + ids[i];
            this.database.execStatement(sql);
        }
        String sql = "DELETE FROM T_ETL_TransNote WHERE ID_Transformation = " + id_transformation;
        this.database.execStatement(sql);
    }

    public void delJobNotes(long id_job) throws ETLDatabaseException {
        long[] ids = this.getJobNoteIDs(id_job);
        for (int i = 0; i < ids.length; ++i) {
            String sql = "DELETE FROM T_ETL_Note WHERE ID_Note = " + ids[i];
            this.database.execStatement(sql);
        }
        String sql = "DELETE FROM T_ETL_JobNote WHERE ID_Job = " + id_job;
        this.database.execStatement(sql);
    }

    public void delTrans(long id_transformation) throws ETLDatabaseException {
        String sql = "DELETE FROM T_ETL_Transformation WHERE ID_Transformation = " + id_transformation;
        this.database.execStatement(sql);
    }

    public void delJob(long id_job) throws ETLDatabaseException {
        String sql = "DELETE FROM T_ETL_Job WHERE ID_Job = " + id_job;
        this.database.execStatement(sql);
    }

    public void delDatabase(long id_database) throws ETLDatabaseException {
        String[] transList = this.getTransformationsUsingDatabase(id_database);
        if (transList.length != 0) {
            String message = "Database used by the following transformations:" + Const.CR;
            for (int i = 0; i < transList.length; ++i) {
                message = message + "\t" + transList[i] + Const.CR;
            }
            ETLDependencyException e = new ETLDependencyException(message);
            throw new ETLDependencyException("This database is still in use by one or more transformations (" + transList.length + " references)", e);
        }
        String sql = "DELETE FROM T_ETL_Database WHERE ID_Database = " + id_database;
        this.database.execStatement(sql);
    }

    public void delTransStepCondition(long id_transformation) throws ETLDatabaseException {
        String sql = "DELETE FROM T_ETL_TransStepCondition WHERE ID_Transformation = " + id_transformation;
        this.database.execStatement(sql);
    }

    public void delValue(long id_value) throws ETLDatabaseException {
        String sql = "DELETE FROM T_ETL_Value WHERE ID_Value = " + id_value;
        this.database.execStatement(sql);
    }

    public void delUser(long id_user) throws ETLDatabaseException {
        String sql = "DELETE FROM T_ETL_User WHERE ID_User = " + id_user;
        this.database.execStatement(sql);
    }

    public void delProfile(long id_profile) throws ETLDatabaseException {
        String sql = "DELETE FROM T_ETL_Profile WHERE ID_Profile = " + id_profile;
        this.database.execStatement(sql);
    }

    public void delProfilePermissions(long id_profile) throws ETLDatabaseException {
        String sql = "DELETE FROM T_ETL_ProfilePermission WHERE ID_Profile = " + id_profile;
        this.database.execStatement(sql);
    }

    public void delAllFromTrans(long id_transformation) throws ETLDatabaseException {
        this.delStepAttributes(id_transformation);
        this.delSteps(id_transformation);
        this.delStepConditions(id_transformation);
        this.delStepDatabases(id_transformation);
        this.delTransHops(id_transformation);
        this.delTrans(id_transformation);
    }

    public void renameTransformation(long id_transformation, String newname) throws ETLDatabaseException {
        String sql = "UPDATE T_ETL_Transformation SET Name = ? WHERE ID_Transformation = ?";
        Row table = new Row();
        table.addValue(new Value("Name", newname));
        table.addValue(new Value("ID_Transformation", id_transformation));
        this.database.execStatement(sql, table);
    }

    public void renameUser(long id_user, String newname) throws ETLDatabaseException {
        String sql = "UPDATE T_ETL_User SET Name = ? WHERE ID_User = ?";
        Row table = new Row();
        table.addValue(new Value("Name", newname));
        table.addValue(new Value("ID_User", id_user));
        this.database.execStatement(sql, table);
    }

    public void renameProfile(long id_profile, String newname) throws ETLDatabaseException {
        String sql = "UPDATE T_ETL_Profile SET Name = ? WHERE ID_Profile = ?";
        Row table = new Row();
        table.addValue(new Value("Name", newname));
        table.addValue(new Value("ID_Profile", id_profile));
        this.database.execStatement(sql, table);
    }

    public void renameDatabase(long id_database, String newname) throws ETLDatabaseException {
        String sql = "UPDATE T_ETL_Database SET Name = ? WHERE ID_Database = ?";
        Row table = new Row();
        table.addValue(new Value("Name", newname));
        table.addValue(new Value("ID_Database", id_database));
        this.database.execStatement(sql, table);
    }

    public void delAllFromJob(long id_job) throws ETLDatabaseException {
        this.delJobEntryAttributes(id_job);
        this.delJobEntries(id_job);
        this.delJobEntryCopies(id_job);
        this.delJobHops(id_job);
        this.delJob(id_job);
    }

    public void renameJob(long id_job, String newname) throws ETLDatabaseException {
        String sql = "UPDATE T_ETL_Job SET Name = ? WHERE ID_Job = ?";
        Row table = new Row();
        table.addValue(new Value("Name", newname));
        table.addValue(new Value("ID_Job", id_job));
        this.database.execStatement(sql, table);
    }

    public boolean dropRepositorySchema() throws ETLDatabaseException {
        for (int i = 0; i < this.repositoryTableNames.length; ++i) {
            try {
                this.database.execStatement("DROP TABLE " + this.repositoryTableNames[i]);
                this.log.logDetailed(this.toString(), "dropped table " + this.repositoryTableNames[i]);
                continue;
            }
            catch (ETLDatabaseException dbe) {
                this.log.logDetailed(this.toString(), "Unable to drop table: " + this.repositoryTableNames[i]);
            }
        }
        this.log.logBasic(this.toString(), "Dropped all " + this.repositoryTableNames.length + " repository tables.");
        return true;
    }

    public void updateStepTypes() throws ETLDatabaseException {
        for (int i = 0; i < this.steploader.nrStepsWithType(0); ++i) {
            StepPlugin sp = this.steploader.getStepWithType(0, i);
            long id = this.getStepTypeID(sp.getID());
            if (id >= 0L) continue;
            id = this.getNextStepTypeID();
            Row table = new Row();
            table.addValue(new Value("ID_StepType", id));
            table.addValue(new Value("Code", sp.getID()));
            table.addValue(new Value("Description", sp.getDescription()));
            table.addValue(new Value("HelpText", sp.getTooltip()));
            this.database.prepareInsert(table, "T_ETL_StepType");
            this.database.setValuesInsert(table);
            this.database.insertRow();
            this.database.closeInsert();
        }
    }

    public void updateJobEntryTypes() throws ETLDatabaseException {
        for (int i = 1; i < JobEntryInterface.type_desc.length; ++i) {
            long id = this.getJobEntryTypeID(JobEntryInterface.type_desc[i]);
            if (id >= 0L) continue;
            id = this.getNextJobEntryTypeID();
            Row table = new Row();
            table.addValue(new Value("ID_JobEntryType", id));
            table.addValue(new Value("Code", JobEntryInterface.type_desc[i]));
            table.addValue(new Value("Description", JobEntryInterface.type_desc_long[i]));
            this.database.prepareInsert(table, "T_ETL_JobEntryType");
            this.database.setValuesInsert(table);
            this.database.insertRow();
            this.database.closeInsert();
        }
    }

    public void updateScheduleTypes() throws ETLDatabaseException {
        for (int i = 1; i < ScheduleEntryInterface.type_desc.length; ++i) {
            long id = this.getScheduleTypeID(ScheduleEntryInterface.type_desc[i]);
            if (id >= 0L) continue;
            id = this.getNextScheduleTypeID();
            Row table = new Row();
            table.addValue(new Value("ID_ScheduleType", id));
            table.addValue(new Value("Code", ScheduleEntryInterface.type_desc[i]));
            table.addValue(new Value("Description", ScheduleEntryInterface.type_desc_long[i]));
            this.database.prepareInsert(table, "T_ETL_ScheduleType");
            this.database.setValuesInsert(table);
            this.database.insertRow();
            this.database.closeInsert();
        }
    }

    public String toString() {
        if (this.repinfo == null) {
            return this.getClass().getName();
        }
        return this.repinfo.getName();
    }

    public Database getDatabase() {
        return this.database;
    }

    public void setDatabase(Database database) {
        this.database = database;
    }

    public RepositoryDirectory getDirectoryTree() {
        return this.directoryTree;
    }

    public void setDirectoryTree(RepositoryDirectory directoryTree) {
        this.directoryTree = directoryTree;
    }

    public void lockRepository() throws ETLDatabaseException {
        this.database.lockTables(this.repositoryTableNames);
    }

    public void unlockRepository() throws ETLDatabaseException {
        this.database.unlockTables(this.repositoryTableNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void exportAllObjects(IProgressMonitor monitor, String xmlFilename) throws ETLException {
        block22: {
            int i;
            RepositoryDirectory repdir;
            int d;
            if (monitor != null) {
                monitor.beginTask("Exporting the repository to XML...", 3);
            }
            String xml = XMLHandler.getXMLHeader();
            xml = xml + "<repository>" + Const.CR + Const.CR;
            xml = xml + "<transformations>" + Const.CR;
            if (monitor != null) {
                monitor.subTask("Exporting the transformations...");
            }
            long[] dirids = this.getDirectoryTree().getDirectoryIDs();
            for (d = 0; d < dirids.length && (monitor == null || monitor != null && !monitor.isCanceled()); ++d) {
                repdir = this.getDirectoryTree().findDirectory(dirids[d]);
                String[] trans = this.getTransformationNames(dirids[d]);
                for (i = 0; i < trans.length && (monitor == null || monitor != null && !monitor.isCanceled()); ++i) {
                    try {
                        TransMeta ti = new TransMeta(this, trans[i], repdir, this.getCtxConnection());
                        if (monitor != null) {
                            monitor.subTask("Exporting transformation [" + trans[i] + "]");
                        }
                        xml = xml + ti.getXML() + Const.CR;
                        continue;
                    }
                    catch (ETLException ke) {
                        this.log.logError(this.toString(), "An error occurred reading transformation [" + trans[i] + "] from directory [" + repdir + "] : " + ke.getMessage());
                        this.log.logError(this.toString(), "Transformation [" + trans[i] + "] from directory [" + repdir + "] was not exported because of a loading error!");
                    }
                }
            }
            xml = xml + "</transformations>" + Const.CR;
            if (monitor != null) {
                monitor.worked(1);
            }
            xml = xml + "<jobs>" + Const.CR;
            if (monitor != null) {
                monitor.subTask("Exporting the jobs...");
            }
            for (d = 0; d < dirids.length && (monitor == null || monitor != null && !monitor.isCanceled()); ++d) {
                repdir = this.getDirectoryTree().findDirectory(dirids[d]);
                String[] jobs = this.getJobNames(dirids[d]);
                for (i = 0; i < jobs.length && (monitor == null || monitor != null && !monitor.isCanceled()); ++i) {
                    try {
                        JobMeta ji = new JobMeta(this.log, this, jobs[i], repdir);
                        if (monitor != null) {
                            monitor.subTask("Exporting job [" + jobs[i] + "]");
                        }
                        xml = xml + ji.getXML() + Const.CR;
                        continue;
                    }
                    catch (ETLException ke) {
                        this.log.logError(this.toString(), "An error occurred reading job [" + jobs[i] + "] from directory [" + repdir + "] : " + ke.getMessage());
                        this.log.logError(this.toString(), "Job [" + jobs[i] + "] from directory [" + repdir + "] was not exported because of a loading error!");
                    }
                }
            }
            xml = xml + "</jobs>" + Const.CR;
            xml = xml + "</repository>" + Const.CR + Const.CR;
            if (monitor != null) {
                monitor.worked(1);
            }
            if (monitor != null && (monitor == null || monitor.isCanceled())) break block22;
            if (monitor != null) {
                monitor.subTask("Saving XML to file [" + xmlFilename + "]");
            }
            File f = new File(xmlFilename);
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(f);
                fos.write(xml.getBytes("UTF-8"));
            }
            catch (IOException iOException) {
                CloseUtil.close((Closeable[])new Closeable[]{fos});
                catch (Throwable throwable) {
                    CloseUtil.close((Closeable[])new Closeable[]{fos});
                    throw throwable;
                }
            }
            CloseUtil.close((Closeable[])new Closeable[]{fos});
            if (monitor != null) {
                monitor.worked(1);
            }
        }
        if (monitor != null) {
            monitor.done();
        }
    }
}

