/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.repository;

import com.kingdee.bos.ctrl.etl.database.DatabaseMeta;
import com.kingdee.bos.ctrl.etl.util.Const;
import com.kingdee.bos.ctrl.etl.util.XMLHandler;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;

public class RepositoryMeta {
    private String name;
    private String description;
    private DatabaseMeta connection;
    private boolean lock;

    public RepositoryMeta(String name, String description, DatabaseMeta connection) {
        this.name = name;
        this.description = description;
        this.connection = connection;
        this.lock = false;
    }

    public RepositoryMeta() {
        this.name = "";
        this.description = "";
        this.connection = null;
    }

    public boolean loadXML(Node repnode, ArrayList databases) {
        try {
            this.name = XMLHandler.getTagValue(repnode, "name");
            this.description = XMLHandler.getTagValue(repnode, "description");
            String conn = XMLHandler.getTagValue(repnode, "connection");
            this.connection = Const.findDatabase((List)databases, conn);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setConnection(DatabaseMeta connection) {
        this.connection = connection;
    }

    public DatabaseMeta getConnection() {
        return this.connection;
    }

    public boolean isLocked() {
        return this.lock;
    }

    public void setLock(boolean lock) {
        this.lock = lock;
    }

    public String getXML() {
        String retval = "";
        retval = retval + "  <repository>" + Const.CR;
        retval = retval + "    " + XMLHandler.addTagValue("name", this.name);
        retval = retval + "    " + XMLHandler.addTagValue("description", this.description);
        retval = retval + "    " + XMLHandler.addTagValue("connection", this.connection != null ? this.connection.getName() : null);
        retval = retval + "    </repository>" + Const.CR;
        return retval;
    }
}

