/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.schedule;

import com.kingdee.bos.ctrl.etl.exception.ETLScheduleException;
import com.kingdee.bos.ctrl.etl.job.Job;
import com.kingdee.bos.ctrl.etl.schedule.ScheduleMeta;
import com.kingdee.bos.ctrl.etl.schedule.entry.ScheduleEntryCopy;
import com.kingdee.bos.ctrl.etl.schedule.entry.ScheduleEntryInterface;
import java.util.List;

public class Schedule {
    ScheduleMeta sm = null;

    public Schedule(ScheduleMeta sm) {
        this.sm = sm;
    }

    public String getName() {
        if (this.sm == null) {
            return "";
        }
        return this.sm.getName();
    }

    public Job getJob() {
        if (this.sm == null) {
            return null;
        }
        return this.sm.getJob();
    }

    public boolean isUsed() {
        if (this.sm == null) {
            return false;
        }
        return this.sm.isUsed();
    }

    public String getScheduleExpression() {
        if (this.sm == null) {
            return "";
        }
        return this.sm.getScheduleExpression();
    }

    public void run() throws ETLScheduleException {
        if (!this.sm.isUsed()) {
            return;
        }
        List lstScheduleImpl = this.sm.getScheduleEntryList();
        for (ScheduleEntryCopy sc : lstScheduleImpl) {
            ScheduleEntryInterface si = sc.getEntry();
            si.execute(this.sm.getRepository());
        }
    }

    public void stop() throws ETLScheduleException {
        if (!this.sm.isUsed()) {
            return;
        }
        List lstScheduleImpl = this.sm.getScheduleEntryList();
        for (ScheduleEntryCopy sc : lstScheduleImpl) {
            ScheduleEntryInterface si = sc.getEntry();
            si.stop();
        }
    }
}

