/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.schedule;

import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.exception.ETLXMLException;
import com.kingdee.bos.ctrl.etl.job.Job;
import com.kingdee.bos.ctrl.etl.repository.Repository;
import com.kingdee.bos.ctrl.etl.repository.RepositoryDirectory;
import com.kingdee.bos.ctrl.etl.schedule.entry.ScheduleEntryCopy;
import com.kingdee.bos.ctrl.etl.util.LogWriter;
import com.kingdee.bos.ctrl.etl.util.XMLHandler;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ScheduleMeta {
    private List scheduleEntryCopies = null;
    private List scheduleEntries = null;
    private ScheduleEntryCopy sc = null;
    private String scheduleName = "";
    private Job job = null;
    private LogWriter log = null;
    private RepositoryDirectory directory;
    private Repository rep = null;
    private long id;
    private boolean usedFlag = false;

    public ScheduleMeta(LogWriter log, String xmlString, Connection ctxConnection, Job job) throws ETLXMLException {
        this.log = log;
        try {
            Document doc = XMLHandler.loadXMLString(xmlString);
            if (doc == null) {
                throw new ETLXMLException("Error reading/validating information from XML String: " + xmlString);
            }
            Node node = XMLHandler.getSubNode(doc, "schedule");
            this.loadXML(node, ctxConnection, job);
        }
        catch (ETLXMLException e) {
            throw new ETLXMLException("Unable to load the schedule from XML string [" + xmlString + "]", e);
        }
    }

    public ScheduleMeta(LogWriter log, Node scheduleNode, Connection ctxConnection, Job job) throws ETLXMLException {
        this.log = log;
        try {
            this.loadXML(scheduleNode, ctxConnection, job);
        }
        catch (ETLXMLException e) {
            throw new ETLXMLException("Unable to load the schedule from XML node [" + scheduleNode + "]", e);
        }
    }

    public ScheduleMeta(LogWriter log, Repository rep, RepositoryDirectory repdir, String scheduleName, Job job) throws ETLException {
        this.log = log;
        this.rep = rep;
        try {
            ScheduleEntryCopy sec;
            this.clear();
            this.directory = repdir;
            this.job = job;
            this.setID(rep.getScheduleID(scheduleName, repdir.getID()));
            if (this.getID() > 0L) {
                this.scheduleName = scheduleName;
                Row r = rep.getSchedule(this.getID());
                if (r != null) {
                    this.usedFlag = r.getBoolean("UsedFlag", true);
                }
            } else {
                throw new ETLException("Can't find schedule : " + scheduleName);
            }
            this.sc = sec = new ScheduleEntryCopy(log, rep, this.getID(), job);
            this.addScheduleEntryCopy(sec);
        }
        catch (ETLException dbe) {
            throw new ETLException("An error occurred reading schedule [" + scheduleName + "] from the repository", dbe);
        }
    }

    public void loadXML(Node scheduleNode, Connection ctxConnection, Job job) throws ETLXMLException {
        try {
            ScheduleEntryCopy si;
            this.clear();
            this.job = job;
            this.scheduleName = XMLHandler.getTagValue(scheduleNode, "name");
            String sUsedFlag = XMLHandler.getTagValue(scheduleNode, "usedflag");
            this.usedFlag = sUsedFlag == null ? true : "Y".equalsIgnoreCase(sUsedFlag);
            Node confignode = XMLHandler.getSubNode(scheduleNode, "config");
            this.sc = si = new ScheduleEntryCopy(confignode, ctxConnection, job, this.scheduleName);
            this.addScheduleEntryCopy(si);
        }
        catch (Exception e) {
            throw new ETLXMLException("Unable to load job info from XML node", e);
        }
    }

    private void addScheduleEntryCopy(ScheduleEntryCopy sc) {
        this.scheduleEntryCopies.add(sc);
    }

    private void clear() {
        this.scheduleEntryCopies = new ArrayList();
        this.scheduleEntries = new ArrayList();
    }

    public List getScheduleEntryList() {
        return this.scheduleEntryCopies;
    }

    public String getName() {
        return this.scheduleName;
    }

    public Job getJob() {
        return this.job;
    }

    private void setID(long id) {
        this.id = id;
    }

    private long getID() {
        return this.id;
    }

    public Repository getRepository() {
        return this.rep;
    }

    public boolean isUsed() {
        return this.usedFlag;
    }

    public String getScheduleExpression() {
        if (this.sc == null) {
            return "";
        }
        return this.sc.getEntry().getScheduleExpression();
    }
}

