/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.schedule.entry;

import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.exception.ETLDatabaseException;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.exception.ETLXMLException;
import com.kingdee.bos.ctrl.etl.job.Job;
import com.kingdee.bos.ctrl.etl.repository.Repository;
import com.kingdee.bos.ctrl.etl.repository.RepositoryDirectory;
import com.kingdee.bos.ctrl.etl.schedule.entry.ScheduleEntryCopy;
import com.kingdee.bos.ctrl.etl.schedule.entry.ScheduleEntryInterface;
import com.kingdee.bos.ctrl.etl.schedule.entry.cron.ScheduleEntryCron;
import com.kingdee.bos.ctrl.etl.schedule.entry.timer.ScheduleEntryTimer;
import java.sql.Connection;
import org.w3c.dom.Node;

public class ScheduleEntryBase {
    private String jobName = "";
    private RepositoryDirectory directory = null;
    private Connection ctxConnection = null;
    private String name = "";
    private int type;
    private Job job = null;

    public static ScheduleEntryInterface newScheduleEntryInterface(int type) throws ETLException {
        ScheduleEntryBase jei = null;
        switch (type) {
            case 1: {
                jei = new ScheduleEntryCron();
                break;
            }
            case 2: {
                jei = new ScheduleEntryTimer();
                break;
            }
            default: {
                throw new ETLException("Unknown schedule impl type : " + type);
            }
        }
        return jei;
    }

    protected void loadXML(Node entryNode, Connection ctxConnection, Job job, String scheduleName) throws ETLXMLException {
        try {
            this.ctxConnection = ctxConnection;
            this.job = job;
            this.setName(scheduleName);
        }
        catch (Exception e) {
            throw new ETLXMLException("Unable to load base info for schedule implement", e);
        }
    }

    private void setName(String name) {
        this.name = name;
    }

    protected String getName() {
        return this.name;
    }

    protected Connection getCtxConnection() {
        return this.ctxConnection;
    }

    public static final int getType(String desc) {
        int i;
        String[] d = ScheduleEntryInterface.type_desc;
        for (i = 1; i < d.length; ++i) {
            if (!d[i].equalsIgnoreCase(desc)) continue;
            return i;
        }
        d = ScheduleEntryInterface.type_desc_long;
        for (i = 1; i < d.length; ++i) {
            if (!d[i].equalsIgnoreCase(desc)) continue;
            return i;
        }
        return 0;
    }

    public void loadRep(Repository rep, long id_schedule, Job job) throws ETLException {
        this.job = job;
        try {
            this.jobName = job.getJobname();
            Row r = rep.getSchedule(id_schedule);
            if (r != null) {
                this.setName(r.searchValue("Name").getString());
                int id_schedule_type = (int)r.searchValue("ID_ScheduleType").getInteger();
                Row setrow = rep.getScheduleType(id_schedule_type);
                if (setrow != null) {
                    this.type = ScheduleEntryCopy.getType(setrow.searchValue("Code").getString());
                }
            }
        }
        catch (ETLDatabaseException dbe) {
            throw new ETLException("Unable to load base schedule entry information from the repository for id_schedule_entry=" + id_schedule, dbe);
        }
    }

    protected Job getJob() {
        return this.job;
    }

    protected RepositoryDirectory getDirectory() {
        return this.directory;
    }

    protected String getJobname() {
        return this.jobName;
    }
}

