/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.schedule.entry.cron.quartz;

import com.kingdee.bos.ctrl.etl.exception.ETLFatalScheduleException;
import com.kingdee.bos.ctrl.etl.exception.ETLScheduleException;
import com.kingdee.bos.ctrl.etl.schedule.entry.cron.quartz.ETLCronTrigger;
import com.kingdee.bos.ctrl.etl.util.LogWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.quartz.Calendar;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerFactory;
import org.quartz.Trigger;
import org.quartz.impl.StdSchedulerFactory;

public class ETLScheduler {
    protected final LogWriter logger = LogWriter.getInstance();
    private Class schedulerFactoryClass = StdSchedulerFactory.class;
    private Map schedulerContextMap;
    private List jobDetails;
    private Map calendars;
    private List triggers;
    private Scheduler scheduler;

    public void setSchedulerFactoryClass(Class schedulerFactoryClass) {
        this.schedulerFactoryClass = schedulerFactoryClass;
    }

    public void setSchedulerContextAsMap(Map schedulerContextAsMap) {
        this.schedulerContextMap = schedulerContextAsMap;
    }

    public void setJobDetails(JobDetail[] jobDetails) {
        this.jobDetails = Arrays.asList(jobDetails);
    }

    public void setCalendars(Map calendars) {
        this.calendars = calendars;
    }

    public void setTriggers(Trigger[] triggers) {
        this.triggers = Arrays.asList(triggers);
    }

    private Object instantiateClass(Class clazz) throws ETLFatalScheduleException {
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException ex) {
            throw new ETLFatalScheduleException("Could not instantiate class [" + clazz.getName() + "]; Is it an interface or an abstract class? Does it have a no-arg constructor?", ex);
        }
        catch (IllegalAccessException ex) {
            throw new ETLFatalScheduleException("Could not instantiate class [" + clazz.getName() + "]; has class definition changed? Is there a public no-arg constructor?", ex);
        }
    }

    public void run() throws ETLScheduleException {
        SchedulerFactory schedulerFactory = null;
        try {
            schedulerFactory = (SchedulerFactory)this.instantiateClass(this.schedulerFactoryClass);
        }
        catch (ETLFatalScheduleException e) {
            e.printStackTrace();
            throw new ETLScheduleException("occur error when instantiateClass..." + e.getMessage());
        }
        try {
            this.scheduler = this.createScheduler(schedulerFactory);
        }
        catch (SchedulerException e) {
            e.printStackTrace();
            throw new ETLScheduleException("occur error when createScheduler..." + e.getMessage());
        }
        if (this.schedulerContextMap != null) {
            try {
                this.scheduler.getContext().putAll(this.schedulerContextMap);
            }
            catch (SchedulerException e) {
                e.printStackTrace();
                throw new ETLScheduleException("occur error when put schedulerContextMap..." + e.getMessage());
            }
        }
        if (this.jobDetails != null) {
            for (JobDetail jobDetail : this.jobDetails) {
                try {
                    this.scheduler.addJob(jobDetail, true);
                }
                catch (SchedulerException e) {
                    e.printStackTrace();
                    throw new ETLScheduleException("occur error when addJob..." + e.getMessage());
                }
            }
        } else {
            this.jobDetails = new ArrayList();
        }
        if (this.calendars != null) {
            for (String calendarName : this.calendars.keySet()) {
                Calendar calendar = (Calendar)this.calendars.get(calendarName);
                try {
                    this.scheduler.addCalendar(calendarName, calendar, true, false);
                }
                catch (SchedulerException e) {
                    e.printStackTrace();
                    throw new ETLScheduleException("occur error when addCalendar..." + e.getMessage());
                }
            }
        }
        if (this.triggers != null) {
            for (Trigger trigger : this.triggers) {
                JobDetail jobDetail;
                if (trigger instanceof ETLCronTrigger && !this.jobDetails.contains(jobDetail = ((ETLCronTrigger)trigger).getJobDetail())) {
                    this.jobDetails.add(jobDetail);
                    try {
                        this.scheduler.addJob(jobDetail, true);
                    }
                    catch (SchedulerException e) {
                        e.printStackTrace();
                        throw new ETLScheduleException("occur error when addJob..." + e.getMessage());
                    }
                }
                try {
                    this.scheduler.scheduleJob(trigger);
                }
                catch (SchedulerException e) {
                    e.printStackTrace();
                    throw new ETLScheduleException("occur error when scheduleJob..." + e.getMessage());
                }
            }
        }
        this.logger.logBasic("Shutting down Quartz Scheduler", "Starting Quartz Scheduler");
        try {
            this.scheduler.start();
        }
        catch (SchedulerException e) {
            e.printStackTrace();
        }
    }

    protected Scheduler createScheduler(SchedulerFactory schedulerFactory) throws SchedulerException {
        return schedulerFactory.getScheduler();
    }

    public Object getObject() {
        return this.scheduler;
    }

    public Class getObjectType() {
        return this.scheduler != null ? this.scheduler.getClass() : Scheduler.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void destroy() throws SchedulerException {
        this.logger.logBasic("ETLScheduler", "Shutting down Quartz Scheduler");
        this.scheduler.shutdown();
    }
}

