/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.schedule.ui;

import com.kingdee.bos.ctrl.etl.schedule.entry.cron.CronExpression;
import com.kingdee.bos.ctrl.etl.schedule.entry.cron.CronExpressionException;
import com.kingdee.bos.ctrl.etl.schedule.entry.cron.CronExpressionUtil;
import com.kingdee.bos.ctrl.etl.schedule.ui.EveryDay;
import com.kingdee.bos.ctrl.etl.schedule.ui.EveryMonth;
import com.kingdee.bos.ctrl.etl.schedule.ui.EveryWeek;
import com.kingdee.bos.ctrl.etl.schedule.ui.OneTime;
import com.kingdee.bos.ctrl.etl.schedule.ui.SelTypeChangeEvent;
import com.kingdee.bos.ctrl.etl.schedule.ui.SelTypeListener;
import com.kingdee.bos.ctrl.etl.schedule.ui.SelectScheduleType;
import com.kingdee.bos.ctrl.etl.schedule.ui.UserDefine;
import com.kingdee.bos.ctrl.swing.KDPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;

public class CronDesignPanel
extends KDPanel
implements SelTypeListener {
    private static final long serialVersionUID = 1L;
    private String cronExpression = "";
    private SelectScheduleType panelSelect = null;
    private EveryDay panelEveryDay = null;
    private EveryWeek panelEveryWeek = null;
    private EveryMonth panelEveryMonth = null;
    private OneTime panelOneTime = null;
    private UserDefine panelUserDefine = null;
    private KDPanel nowSchedulePanel = null;
    private BorderLayout layout = null;

    public CronDesignPanel(String cronExpression) {
        this.setCronExpression(cronExpression);
        this.initUI();
        this.layoutUI();
        this.loadSchedulePanel();
    }

    private void initUI() {
        try {
            this.panelSelect = new SelectScheduleType();
            this.panelSelect.addSelTypeChangeListener(this);
            this.panelEveryDay = new EveryDay();
            this.panelEveryWeek = new EveryWeek();
            this.panelEveryMonth = new EveryMonth();
            this.panelOneTime = new OneTime();
            this.panelUserDefine = new UserDefine();
            this.nowSchedulePanel = null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        if (!this.cronExpression.equalsIgnoreCase("")) {
            switch (CronExpressionUtil.getScheduleType(this.cronExpression)) {
                case 1: {
                    this.panelSelect.setScheduleType(1, false);
                    this.panelEveryDay.setSchedule(this.cronExpression, false);
                    break;
                }
                case 2: {
                    this.panelSelect.setScheduleType(2, false);
                    this.panelEveryMonth.setSchedule(this.cronExpression, false);
                    break;
                }
                case 3: {
                    this.panelSelect.setScheduleType(3, false);
                    this.panelEveryWeek.setSchedule(this.cronExpression, false);
                    break;
                }
                case 4: {
                    this.panelSelect.setScheduleType(4, false);
                    this.panelOneTime.setSchedule(this.cronExpression, false);
                    break;
                }
                case 5: {
                    this.panelSelect.setScheduleType(5, false);
                    this.panelUserDefine.setSchedule(this.cronExpression, false);
                    break;
                }
            }
        }
    }

    private void layoutUI() {
        if (this.layout == null) {
            this.layout = new BorderLayout();
            this.setLayout(this.layout);
        }
        this.panelSelect.setPreferredSize(new Dimension(120, 300));
        this.add((Component)((Object)this.panelSelect), "West");
    }

    private void loadSchedulePanel() {
        if (this.layout == null) {
            return;
        }
        switch (this.panelSelect.getScheduleType()) {
            case 1: {
                if (this.nowSchedulePanel == this.panelEveryDay) break;
                if (this.nowSchedulePanel != null) {
                    this.remove((Component)this.nowSchedulePanel);
                }
                this.add((Component)((Object)this.panelEveryDay), "Center");
                this.nowSchedulePanel = this.panelEveryDay;
                break;
            }
            case 2: {
                if (this.nowSchedulePanel == this.panelEveryMonth) break;
                if (this.nowSchedulePanel != null) {
                    this.remove((Component)this.nowSchedulePanel);
                }
                this.add((Component)((Object)this.panelEveryMonth), "Center");
                this.nowSchedulePanel = this.panelEveryMonth;
                break;
            }
            case 3: {
                if (this.nowSchedulePanel == this.panelEveryWeek) break;
                if (this.nowSchedulePanel != null) {
                    this.remove((Component)this.nowSchedulePanel);
                }
                this.add((Component)((Object)this.panelEveryWeek), "Center");
                this.nowSchedulePanel = this.panelEveryWeek;
                break;
            }
            case 4: {
                if (this.nowSchedulePanel == this.panelOneTime) break;
                if (this.nowSchedulePanel != null) {
                    this.remove((Component)this.nowSchedulePanel);
                }
                this.add((Component)((Object)this.panelOneTime), "Center");
                this.nowSchedulePanel = this.panelOneTime;
                break;
            }
            case 5: {
                if (this.nowSchedulePanel == this.panelUserDefine) break;
                if (this.nowSchedulePanel != null) {
                    this.remove((Component)this.nowSchedulePanel);
                }
                this.add((Component)((Object)this.panelUserDefine), "Center");
                this.nowSchedulePanel = this.panelUserDefine;
            }
        }
        this.validate();
        this.repaint();
    }

    private void setCronExpression(String cron) {
        this.cronExpression = cron;
    }

    public String getCronExpression() throws CronExpressionException {
        String cron = "";
        switch (this.panelSelect.getScheduleType()) {
            case 1: {
                cron = "1 " + this.panelEveryDay.getSchedule();
                break;
            }
            case 2: {
                cron = "2 " + this.panelEveryMonth.getSchedule();
                break;
            }
            case 3: {
                cron = "3 " + this.panelEveryWeek.getSchedule();
                break;
            }
            case 4: {
                cron = "4 " + this.panelOneTime.getSchedule();
                break;
            }
            case 5: {
                cron = "5 " + this.panelUserDefine.getSchedule();
            }
        }
        CronExpression se = CronExpressionUtil.parseSchedule(cron);
        if (se == null) {
            throw new CronExpressionException();
        }
        return cron;
    }

    @Override
    public void selTypeChanged(SelTypeChangeEvent e) {
        this.loadSchedulePanel();
    }
}

