/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.server.facade;

import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.exception.ETLJobException;
import com.kingdee.bos.ctrl.etl.exception.ETLServerException;
import com.kingdee.bos.ctrl.etl.job.Job;
import com.kingdee.bos.ctrl.etl.schedule.Schedule;
import com.kingdee.bos.ctrl.etl.server.Server;
import com.kingdee.bos.ctrl.etl.server.facade.ETLServerFacade;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractETLServerFacade
implements ETLServerFacade {
    public abstract Server getServer();

    @Override
    public boolean serverIsRun() {
        return this.getServer() != null;
    }

    @Override
    public String test(String str) {
        return "From Server:" + str;
    }

    @Override
    public boolean scheduleExist(String schedulename) {
        return this.getServer().hasSchedulename(schedulename);
    }

    @Override
    public void updateSchedule(String schedulename, long id_job, String scheduleType, String user, boolean isUsed, String cron) throws ETLServerException {
        this.getServer().updateSchedule(schedulename, id_job, scheduleType, user, isUsed, cron);
    }

    @Override
    public void deleteSchedule(String schedulename) throws ETLServerException {
        this.getServer().deleteSchedule(schedulename);
    }

    @Override
    public HashMap listLogErrors() {
        HashMap<String, String[]> allAttrs = null;
        List logErrors = this.getServer().getLogErrors();
        int count = 0;
        Iterator it = null;
        if (logErrors != null) {
            it = logErrors.iterator();
            count = logErrors.size();
        }
        if (count > 0) {
            allAttrs = new HashMap<String, String[]>();
            int i = 0;
            String[] jobnames = new String[count];
            String[] scheduleNames = new String[count];
            String[] errorDesces = new String[count];
            String[] errorTimes = new String[count];
            while (it.hasNext()) {
                Row row = (Row)it.next();
                jobnames[i] = row.getString("JobName", "");
                scheduleNames[i] = row.getString("ScheduleName", "");
                errorDesces[i] = row.getString("Description", "");
                errorTimes[i] = row.getString("OccuredTime", "");
                ++i;
            }
            allAttrs.put("jobname", jobnames);
            allAttrs.put("schedulename", scheduleNames);
            allAttrs.put("ErrorDesc", errorDesces);
            allAttrs.put("ErrorTime", errorTimes);
        }
        return allAttrs;
    }

    @Override
    public HashMap listLogAudits() {
        HashMap<String, String[]> allAttrs = null;
        List logAudits = this.getServer().getLogAudits();
        int count = 0;
        Iterator it = null;
        if (logAudits != null) {
            it = logAudits.iterator();
            count = logAudits.size();
        }
        if (count > 0) {
            allAttrs = new HashMap<String, String[]>();
            int i = 0;
            String[] jobnames = new String[count];
            String[] scheduleNames = new String[count];
            String[] isSuccesses = new String[count];
            String[] startTimes = new String[count];
            String[] endTimes = new String[count];
            while (it.hasNext()) {
                Row row = (Row)it.next();
                jobnames[i] = row.getString("JobName", "");
                scheduleNames[i] = row.getString("ScheduleName", "");
                isSuccesses[i] = row.getBoolean("IsSuccess", false) ? "\u6210\u529f" : "\u5931\u8d25";
                startTimes[i] = row.getString("StartTime", "");
                endTimes[i] = row.getString("EndTime", "");
                ++i;
            }
            allAttrs.put("jobname", jobnames);
            allAttrs.put("schedulename", scheduleNames);
            allAttrs.put("IsSuccess", isSuccesses);
            allAttrs.put("StartTime", startTimes);
            allAttrs.put("EndTime", endTimes);
        }
        return allAttrs;
    }

    @Override
    public void runJob(long id_job) throws ETLJobException {
        this.getServer().runJob(id_job);
    }

    @Override
    public void importJobFile(String filepathname) throws ETLJobException {
        this.getServer().importJobFile(filepathname);
    }

    @Override
    public HashMap listJobs() {
        HashMap<String, String[]> allAttrs = null;
        if (this.getServer() != null) {
            List jobs = this.getServer().getJobs();
            int count = 0;
            Iterator it = null;
            if (jobs != null) {
                it = jobs.iterator();
                count = jobs.size();
            }
            if (count > 0) {
                allAttrs = new HashMap<String, String[]>();
                int i = 0;
                String[] jobids = new String[count];
                String[] jobnames = new String[count];
                String[] jobdesc = new String[count];
                String[] jobCreateUser = new String[count];
                String[] jobCreateDate = new String[count];
                while (it.hasNext()) {
                    Job job = (Job)it.next();
                    jobids[i] = String.valueOf(job.getJobid());
                    jobnames[i] = job.getJobname();
                    jobdesc[i] = job.getJobDesc();
                    jobCreateUser[i] = job.getModifiedUser();
                    jobCreateDate[i] = job.getModifiedDate();
                    ++i;
                }
                allAttrs.put("jobid", jobids);
                allAttrs.put("jobname", jobnames);
                allAttrs.put("jobdescription", jobdesc);
                allAttrs.put("JobCreateUser", jobCreateUser);
                allAttrs.put("JobCreateTime", jobCreateDate);
            }
        }
        return allAttrs;
    }

    @Override
    public HashMap listSchedules() {
        HashMap<String, String[]> allAttrs = null;
        List schedules = this.getServer().getSchedules();
        int count = 0;
        Iterator it = null;
        if (schedules != null) {
            it = schedules.iterator();
            count = schedules.size();
        }
        if (count > 0) {
            allAttrs = new HashMap<String, String[]>();
            int i = 0;
            String[] scheduleNames = new String[count];
            String[] jobnames = new String[count];
            String[] jobIDs = new String[count];
            String[] scheduleExpressions = new String[count];
            String[] isUseds = new String[count];
            while (it.hasNext()) {
                Schedule schedule = (Schedule)it.next();
                scheduleNames[i] = schedule.getName();
                jobnames[i] = schedule.getJob().getJobname();
                jobIDs[i] = Integer.toString((int)schedule.getJob().getID());
                scheduleExpressions[i] = schedule.getScheduleExpression();
                isUseds[i] = schedule.isUsed() ? "\u662f" : "\u5426";
                ++i;
            }
            allAttrs.put("schedulename", scheduleNames);
            allAttrs.put("jobname", jobnames);
            allAttrs.put("jobid", jobIDs);
            allAttrs.put("ScheduleExpression", scheduleExpressions);
            allAttrs.put("IsUsed", isUseds);
        }
        return allAttrs;
    }
}

