/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.transformation;

import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.database.DatabaseMeta;
import com.kingdee.bos.ctrl.etl.exception.ETLDatabaseException;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.exception.ETLXMLException;
import com.kingdee.bos.ctrl.etl.repository.Repository;
import com.kingdee.bos.ctrl.etl.util.Const;
import com.kingdee.bos.ctrl.etl.util.XMLHandler;
import com.kingdee.bos.ctrl.etl.util.XMLInterface;
import java.util.List;
import org.w3c.dom.Node;

public class TransDependency
implements XMLInterface {
    private DatabaseMeta db;
    private String tablename;
    private String fieldname;
    private long id;

    public TransDependency(DatabaseMeta db, String tablename, String fieldname) {
        this.db = db;
        this.tablename = tablename;
        this.fieldname = fieldname;
    }

    public TransDependency() {
        this(null, null, null);
    }

    public TransDependency(Node depnode, List databases) throws ETLXMLException {
        try {
            String depcon = XMLHandler.getTagValue(depnode, "connection");
            this.db = Const.findDatabase(databases, depcon);
            this.tablename = XMLHandler.getTagValue(depnode, "table");
            this.fieldname = XMLHandler.getTagValue(depnode, "field");
        }
        catch (Exception e) {
            throw new ETLXMLException("Unable to load transformation dependency from XML", e);
        }
    }

    public void setID(long id) {
        this.id = id;
    }

    public long getID() {
        return this.id;
    }

    public void setDatabase(DatabaseMeta db) {
        this.db = db;
    }

    public DatabaseMeta getDatabase() {
        return this.db;
    }

    public void setTablename(String tablename) {
        this.tablename = tablename;
    }

    public String getTablename() {
        return this.tablename;
    }

    public void setFieldname(String fieldname) {
        this.fieldname = fieldname;
    }

    public String getFieldname() {
        return this.fieldname;
    }

    @Override
    public String getXML() {
        String retval = "";
        retval = retval + "      <dependency>" + Const.CR;
        retval = retval + "        " + XMLHandler.addTagValue("connection", this.db == null ? "" : this.db.getName());
        retval = retval + "        " + XMLHandler.addTagValue("table", this.tablename);
        retval = retval + "        " + XMLHandler.addTagValue("field", this.fieldname);
        retval = retval + "        </dependency>" + Const.CR;
        return retval;
    }

    public TransDependency(Repository rep, long id_dependency, List databases) throws ETLException {
        try {
            this.setID(id_dependency);
            Row r = rep.getTransDependency(id_dependency);
            if (r != null) {
                long id_connection = r.searchValue("ID_Database").getInteger();
                this.db = Const.findDatabase(databases, id_connection);
                this.tablename = r.searchValue("TableName").getString();
                this.fieldname = r.searchValue("FieldName").getString();
            }
        }
        catch (ETLDatabaseException dbe) {
            throw new ETLException("Unable to load transformation dependency from the repository with id_dependency=" + id_dependency, dbe);
        }
    }

    public void saveRep(Repository rep, long id_transformation) throws ETLException {
        try {
            long id_database = this.db == null ? -1L : this.db.getID();
            this.setID(rep.insertDependency(id_transformation, id_database, this.tablename, this.fieldname));
        }
        catch (ETLDatabaseException dbe) {
            throw new ETLException("Unable to save transformation dependency to the repository for id_transformation=" + id_transformation, dbe);
        }
    }
}

