/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.transformation.step.addsequence;

import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.database.Database;
import com.kingdee.bos.ctrl.etl.exception.ETLDatabaseException;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.exception.ETLStepException;
import com.kingdee.bos.ctrl.etl.transformation.Trans;
import com.kingdee.bos.ctrl.etl.transformation.TransMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.BaseStep;
import com.kingdee.bos.ctrl.etl.transformation.step.StepDataInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMetaInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.addsequence.AddSequenceData;
import com.kingdee.bos.ctrl.etl.transformation.step.addsequence.AddSequenceMeta;
import com.kingdee.bos.ctrl.etl.value.Value;
import java.util.Hashtable;

public class AddSequence
extends BaseStep
implements StepInterface {
    private AddSequenceMeta meta;
    private AddSequenceData data;

    public AddSequence(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public synchronized boolean addSequence(Row row) throws ETLException {
        Value next = null;
        if (this.meta.isDatabaseUsed()) {
            try {
                next = this.data.getDb().getNextSequenceValue(this.meta.getSequenceName(), this.meta.getValuename());
            }
            catch (ETLDatabaseException dbe) {
                throw new ETLStepException("Error reading next value of sequence [" + this.meta.getSequenceName() + "] from database", dbe);
            }
        } else if (this.meta.isCounterUsed()) {
            Long prev = (Long)this.getTransMeta().getCounters().get(this.data.getLookup());
            long nval = prev + this.meta.getIncrementBy();
            if (this.meta.getIncrementBy() > 0L && nval > this.meta.getMaxValue()) {
                nval = this.meta.getStartAt();
            }
            if (this.meta.getIncrementBy() < 0L && nval < this.meta.getMaxValue()) {
                nval = this.meta.getStartAt();
            }
            this.getTransMeta().getCounters().put(this.data.getLookup(), new Long(nval));
            next = new Value(this.meta.getValuename(), (long)prev);
        } else {
            throw new ETLStepException("No method is specified in this step!");
        }
        if (next == null) {
            throw new ETLStepException("Couldn't find next value for sequence : " + this.meta.getValuename());
        }
        row.addValue(next);
        return true;
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (AddSequenceMeta)smi;
        this.data = (AddSequenceData)sdi;
        Row r = null;
        r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        this.log.logRowlevel(this.toString(), "Read row #" + this.linesRead + " : " + r);
        try {
            this.addSequence(r);
            this.putRow(r);
            this.log.logRowlevel(this.toString(), "Wrote row #" + this.linesWritten + " : " + r);
            if (this.linesRead > 0L && this.linesRead > 0L && this.linesRead % 5000L == 0L) {
                this.logBasic("linenr " + this.linesRead);
            }
        }
        catch (ETLException e) {
            this.logError("Because of an error, this step can't continue: " + e.getMessage());
            this.setErrors(1L);
            this.stopAll();
            this.setOutputDone();
            return false;
        }
        return true;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (AddSequenceMeta)smi;
        this.data = (AddSequenceData)sdi;
        if (super.init(smi, sdi)) {
            if (this.meta.isDatabaseUsed()) {
                this.data.setDb(new Database(this.meta.getDatabase()));
                try {
                    this.data.getDb().connect();
                    this.logBasic("Connected to database...");
                    return true;
                }
                catch (ETLDatabaseException dbe) {
                    this.logError("Step couldn't connect to the database: " + dbe.getMessage());
                }
            } else if (this.meta.isCounterUsed()) {
                this.data.setLookup("@@sequence:" + this.meta.getValuename());
                if (this.getTransMeta().getCounters() != null) {
                    Hashtable counters = this.getTransMeta().getCounters();
                    counters.put(this.data.getLookup(), new Long(this.meta.getStartAt()));
                    return true;
                }
                this.logError("Sorry, Transformation counters hash table not allocated! (internal error)");
            } else {
                this.logError("You need to select to create a sequence either using a database or an internal counter.");
            }
        }
        return false;
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (AddSequenceMeta)smi;
        this.data = (AddSequenceData)sdi;
        if (this.meta.isDatabaseUsed()) {
            this.data.getDb().disconnect();
        }
        super.dispose(smi, sdi);
    }

    @Override
    public void run() {
        try {
            this.logBasic("Starting to run...");
            while (this.processRow(this.meta, this.data) && !this.isStopped()) {
            }
        }
        catch (Exception e) {
            this.logError("Unexpected error in '" + this.debug + "' : " + e.toString());
            this.setErrors(1L);
            this.stopAll();
        }
        finally {
            this.dispose(this.meta, this.data);
            this.markStop();
            this.logSummary();
        }
    }
}

