/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.transformation.step.aggregaterows;

import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.transformation.Trans;
import com.kingdee.bos.ctrl.etl.transformation.TransMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.BaseStep;
import com.kingdee.bos.ctrl.etl.transformation.step.StepDataInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMetaInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.aggregaterows.AggregateRowsData;
import com.kingdee.bos.ctrl.etl.transformation.step.aggregaterows.AggregateRowsMeta;
import com.kingdee.bos.ctrl.etl.value.Value;

public class AggregateRows
extends BaseStep
implements StepInterface {
    private AggregateRowsMeta meta;
    private AggregateRowsData data;

    public AggregateRows(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    private synchronized void AddAggregate(Row r) {
        Value val = null;
        for (int i = 0; i < this.data.fieldnrs.length; ++i) {
            val = r.getValue(this.data.fieldnrs[i]);
            if (!val.isNull()) {
                int n = i;
                this.data.counts[n] = this.data.counts[n] + 1L;
                switch (this.meta.getAggregateType()[i]) {
                    case 1: 
                    case 2: {
                        if (this.data.values[i] == null) {
                            this.data.values[i] = new Value(val);
                            break;
                        }
                        this.data.values[i].setValue(this.data.values[i].getNumber() + val.getNumber());
                        break;
                    }
                    case 4: {
                        if (this.data.values[i] == null) {
                            this.data.values[i] = new Value(val);
                            break;
                        }
                        if (val.compare(this.data.values[i]) >= 0) break;
                        this.data.values[i] = val;
                        break;
                    }
                    case 5: {
                        if (this.data.values[i] == null) {
                            this.data.values[i] = new Value(val);
                            break;
                        }
                        if (val.compare(this.data.values[i]) <= 0) break;
                        this.data.values[i] = val;
                        break;
                    }
                    case 0: 
                    case 6: {
                        if (this.data.values[i] != null) break;
                        this.data.values[i] = new Value(val);
                        break;
                    }
                    case 7: {
                        this.data.values[i] = new Value(val);
                    }
                }
                continue;
            }
            if (this.data.values[i] != null) continue;
            this.data.values[i] = new Value(this.meta.getFieldName()[i], val.getType());
            this.data.values[i].setNull();
        }
    }

    private synchronized Row buildAggregate() {
        Row agg = new Row();
        for (int i = 0; i < this.data.fieldnrs.length; ++i) {
            Value val;
            switch (this.meta.getAggregateType()[i]) {
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    val = this.data.values[i];
                    break;
                }
                case 3: {
                    val = new Value(this.meta.getFieldName()[i], (double)this.data.counts[i]);
                    break;
                }
                case 2: {
                    val = this.data.values[i];
                    val.setValue(val.getNumber() / (double)this.data.counts[i]);
                    break;
                }
                default: {
                    val = new Value(this.meta.getFieldName()[i], 0);
                }
            }
            if (this.meta.getFieldNewName() != null && val != null) {
                val.setName(this.meta.getFieldNewName()[i]);
            }
            if (val == null) continue;
            agg.addValue(val);
        }
        return agg;
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws ETLException {
        this.meta = (AggregateRowsMeta)smi;
        this.data = (AggregateRowsData)sdi;
        Row r = null;
        r = this.getRow();
        if (r == null) {
            Row agg = this.buildAggregate();
            this.putRow(agg);
            this.setOutputDone();
            return false;
        }
        if (this.linesRead == 0L) {
            this.logError("Start of aggreg.rows, row=" + r.toString());
            this.logError("Start of aggreg.rows, row.size()=" + r.size());
            for (int i = 0; i < this.meta.getFieldName().length; ++i) {
                this.data.fieldnrs[i] = r.searchValueIndex(this.meta.getFieldName()[i]);
                if (this.data.fieldnrs[i] < 0) {
                    this.logError("Couldn't find field '" + this.meta.getFieldName()[i] + "' in row!");
                    this.setErrors(1L);
                    this.stopAll();
                    return false;
                }
                this.data.counts[i] = 0L;
            }
        }
        this.AddAggregate(r);
        if (this.linesRead > 0L && this.linesRead % 5000L == 0L) {
            this.logBasic("Linenr " + this.linesRead);
        }
        return true;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (AggregateRowsMeta)smi;
        this.data = (AggregateRowsData)sdi;
        if (super.init(smi, sdi)) {
            int nrfields = this.meta.getFieldName().length;
            this.data.fieldnrs = new int[nrfields];
            this.data.values = new Value[nrfields];
            this.data.counts = new long[nrfields];
            return true;
        }
        return false;
    }

    @Override
    public void run() {
        try {
            this.logBasic("Starting to run...");
            while (this.processRow(this.meta, this.data) && !this.isStopped()) {
            }
        }
        catch (Exception e) {
            this.logError("Unexpected error in '" + this.debug + "' : " + e.toString());
            this.setErrors(1L);
            this.stopAll();
        }
        finally {
            this.dispose(this.meta, this.data);
            this.markStop();
            this.logSummary();
        }
    }
}

