/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.transformation.step.databaselookup;

import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.database.Database;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.exception.ETLStepException;
import com.kingdee.bos.ctrl.etl.transformation.Trans;
import com.kingdee.bos.ctrl.etl.transformation.TransMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.BaseStep;
import com.kingdee.bos.ctrl.etl.transformation.step.StepDataInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMetaInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.databaselookup.DatabaseLookupData;
import com.kingdee.bos.ctrl.etl.transformation.step.databaselookup.DatabaseLookupMeta;
import com.kingdee.bos.ctrl.etl.value.Value;
import java.util.Enumeration;
import java.util.Hashtable;

public class DatabaseLookup
extends BaseStep
implements StepInterface {
    private DatabaseLookupMeta meta;
    private DatabaseLookupData data;

    public DatabaseLookup(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    private synchronized void lookupValues(Row row) throws ETLException {
        int i;
        boolean cache_now = false;
        this.debug = "Start of lookupValues()";
        if (this.first) {
            int i2;
            this.first = false;
            this.debug = "first row: start";
            if (this.meta.isCached()) {
                this.debug = "first row: cache allocate";
                this.data.look = this.meta.getCacheSize() > 0 ? new Hashtable((int)((double)this.meta.getCacheSize() * 1.5)) : new Hashtable();
            }
            this.debug = "first row: set lookup statement";
            this.data.db.setLookup(this.meta.getTablename(), this.meta.getTableKeyField(), this.meta.getKeyCondition(), this.meta.getReturnValueField(), this.meta.getReturnValueNewName(), this.meta.getOrderByClause());
            this.logDetailed("Checking row: " + row.toString());
            this.data.keynrs = new int[this.meta.getStreamKeyField1().length];
            this.data.keynrs2 = new int[this.meta.getStreamKeyField1().length];
            this.debug = "first row: get key fieldnrs";
            for (i2 = 0; i2 < this.meta.getStreamKeyField1().length; ++i2) {
                this.data.keynrs[i2] = row.searchValueIndex(this.meta.getStreamKeyField1()[i2]);
                if (this.data.keynrs[i2] < 0 && !"IS NULL".equalsIgnoreCase(this.meta.getKeyCondition()[i2]) && !"IS NOT NULL".equalsIgnoreCase(this.meta.getKeyCondition()[i2])) {
                    throw new ETLStepException("Field [" + this.meta.getStreamKeyField1()[i2] + "] is required and couldn't be found!");
                }
                this.data.keynrs2[i2] = row.searchValueIndex(this.meta.getStreamKeyField2()[i2]);
                if (this.data.keynrs2[i2] < 0 && "BETWEEN".equalsIgnoreCase(this.meta.getKeyCondition()[i2])) {
                    throw new ETLStepException("Field [" + this.meta.getStreamKeyField2()[i2] + "] is required and couldn't be found!");
                }
                this.logDebug("Field [" + this.meta.getStreamKeyField1()[i2] + "] has nr. " + this.data.keynrs[i2]);
            }
            this.data.nullif = new Value[this.meta.getReturnValueField().length];
            this.debug = "first row: get value fieldnrs";
            for (i2 = 0; i2 < this.meta.getReturnValueField().length; ++i2) {
                this.data.nullif[i2] = new Value(this.meta.getReturnValueNewName()[i2], this.meta.getReturnValueDefaultType()[i2]);
                if (this.meta.getReturnValueDefault()[i2] != null && this.meta.getReturnValueDefault()[i2].length() > 0) {
                    this.data.nullif[i2].setValue(this.meta.getReturnValueDefault()[i2]);
                    this.data.nullif[i2].setType(this.meta.getReturnValueDefaultType()[i2]);
                    continue;
                }
                this.data.nullif[i2].setNull();
            }
            this.data.keytypes = new int[this.meta.getTableKeyField().length];
            Row fields = this.data.db.getTableFields(this.meta.getTablename());
            if (fields != null) {
                for (int i3 = 0; i3 < this.meta.getTableKeyField().length; ++i3) {
                    Value key = fields.searchValue(this.meta.getTableKeyField()[i3]);
                    if (key == null) {
                        throw new ETLStepException("Field [" + this.meta.getTableKeyField()[i3] + "] couldn't be found in the table!");
                    }
                    this.data.keytypes[i3] = key.getType();
                }
            } else {
                throw new ETLStepException("Unable to determine the fields of table [" + this.meta.getTablename() + "]");
            }
        }
        Row lu = new Row();
        this.debug = "Adding values to lookup row";
        for (i = 0; i < this.meta.getStreamKeyField1().length; ++i) {
            if (this.data.keynrs[i] >= 0) {
                Value value = row.getValue(this.data.keynrs[i]);
                if (value.getType() != this.data.keytypes[i]) {
                    value.setType(this.data.keytypes[i]);
                }
                lu.addValue(value);
            }
            if (this.data.keynrs2[i] < 0) continue;
            Value value = row.getValue(this.data.keynrs2[i]);
            if (value.getType() != this.data.keytypes[i]) {
                value.setType(this.data.keytypes[i]);
            }
            lu.addValue(value);
        }
        Row add = this.meta.isCached() ? (Row)this.data.look.get(lu) : null;
        if (add == null) {
            this.logRowlevel("Added " + this.meta.getStreamKeyField1().length + " values to lookup row: " + lu);
            this.debug = "setValuesLookup()";
            this.data.db.setValuesLookup(lu);
            this.debug = "getLookup()";
            add = this.data.db.getLookup();
            cache_now = true;
        }
        this.debug = "add null values to result";
        if (add == null) {
            this.logRowlevel("No result found after database lookup! (add defaults)");
            add = new Row();
            for (i = 0; i < this.meta.getReturnValueField().length; ++i) {
                if (this.data.nullif[i] != null) {
                    add.addValue(new Value(this.data.nullif[i]));
                    continue;
                }
                Value v = new Value(this.meta.getReturnValueNewName()[i], this.meta.getReturnValueDefaultType()[i]);
                v.setNull();
                add.addValue(v);
            }
        } else {
            this.logRowlevel("Found result after database lookup: " + add);
        }
        this.debug = "Store result in cache";
        if (this.meta.isCached() && cache_now) {
            add.setLogdate();
            this.data.look.put(lu, add);
            if (this.meta.getCacheSize() > 0 && this.data.look.size() > this.meta.getCacheSize()) {
                long last_date = -1L;
                Enumeration elem = this.data.look.elements();
                Row smallest = null;
                while (elem.hasMoreElements()) {
                    Row r = (Row)elem.nextElement();
                    long time = r.getLogtime();
                    if (last_date >= 0L && time >= last_date) continue;
                    last_date = time;
                    smallest = r;
                }
                if (smallest != null) {
                    this.data.look.remove(smallest);
                }
            }
        }
        this.debug = "Add values to resulting row...";
        for (int i4 = 0; i4 < add.size(); ++i4) {
            row.addValue(add.getValue(i4));
        }
        this.debug = "end of lookupValues()";
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws ETLException {
        this.meta = (DatabaseLookupMeta)smi;
        this.data = (DatabaseLookupData)sdi;
        Row r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        this.logRowlevel("Got row from previous step: " + r);
        try {
            this.lookupValues(r);
            this.putRow(r);
            this.logRowlevel("Wrote row to next step: " + r);
            if (this.linesRead > 0L && this.linesRead % 5000L == 0L) {
                this.logBasic("linenr " + this.linesRead);
            }
        }
        catch (ETLException e) {
            this.logError("Because of an error, this step can't continue: " + e.getMessage());
            this.setErrors(1L);
            this.stopAll();
            this.setOutputDone();
            return false;
        }
        return true;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (DatabaseLookupMeta)smi;
        this.data = (DatabaseLookupData)sdi;
        if (super.init(smi, sdi)) {
            this.data.db = new Database(this.meta.getDatabaseMeta());
            try {
                this.data.db.connect();
                this.logBasic("Connected to database...");
                return true;
            }
            catch (Exception e) {
                this.logError("An error cause this step to stop: " + e.toString());
                this.data.db.disconnect();
            }
        }
        return false;
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (DatabaseLookupMeta)smi;
        this.data = (DatabaseLookupData)sdi;
        this.data.db.disconnect();
        super.dispose(smi, sdi);
    }

    @Override
    public void run() {
        this.logBasic("Starting to run...");
        try {
            this.logBasic("Connected to database...");
            while (this.processRow(this.meta, this.data) && !this.isStopped()) {
            }
        }
        catch (Exception e) {
            this.logError("An error cause this step to stop: " + e.getMessage());
            this.logError(e.toString());
            this.setErrors(1L);
            this.stopAll();
        }
        finally {
            this.dispose(this.meta, this.data);
            this.logSummary();
            this.markStop();
        }
    }

    @Override
    public String toString() {
        return this.getClass().getName();
    }
}

