/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.transformation.step.databaselookup;

import com.kingdee.bos.ctrl.etl.base.CheckResult;
import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.database.Database;
import com.kingdee.bos.ctrl.etl.database.DatabaseMeta;
import com.kingdee.bos.ctrl.etl.exception.ETLDatabaseException;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.exception.ETLXMLException;
import com.kingdee.bos.ctrl.etl.repository.Repository;
import com.kingdee.bos.ctrl.etl.transformation.DatabaseImpact;
import com.kingdee.bos.ctrl.etl.transformation.Trans;
import com.kingdee.bos.ctrl.etl.transformation.TransMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.BaseStepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepDataInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMetaInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.databaselookup.DatabaseLookup;
import com.kingdee.bos.ctrl.etl.transformation.step.databaselookup.DatabaseLookupData;
import com.kingdee.bos.ctrl.etl.util.Const;
import com.kingdee.bos.ctrl.etl.util.LogWriter;
import com.kingdee.bos.ctrl.etl.util.XMLHandler;
import com.kingdee.bos.ctrl.etl.value.Value;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.w3c.dom.Node;

public class DatabaseLookupMeta
extends BaseStepMeta
implements StepMetaInterface {
    private String tablename;
    private DatabaseMeta databaseMeta;
    private String[] streamKeyField1;
    private String[] streamKeyField2;
    private String[] keyCondition;
    private String[] tableKeyField;
    private String[] returnValueField;
    private String[] returnValueNewName;
    private String[] returnValueDefault;
    private int[] returnValueDefaultType;
    private String orderByClause;
    private boolean cached;
    private int cacheSize;

    public boolean isCached() {
        return this.cached;
    }

    public void setCached(boolean cached) {
        this.cached = cached;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    public DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }

    public void setDatabaseMeta(DatabaseMeta database) {
        this.databaseMeta = database;
    }

    public String[] getKeyCondition() {
        return this.keyCondition;
    }

    public void setKeyCondition(String[] keyCondition) {
        this.keyCondition = keyCondition;
    }

    public String getOrderByClause() {
        return this.orderByClause;
    }

    public void setOrderByClause(String orderByClause) {
        this.orderByClause = orderByClause;
    }

    public String[] getReturnValueDefault() {
        return this.returnValueDefault;
    }

    public void setReturnValueDefault(String[] returnValueDefault) {
        this.returnValueDefault = returnValueDefault;
    }

    public int[] getReturnValueDefaultType() {
        return this.returnValueDefaultType;
    }

    public void setReturnValueDefaultType(int[] returnValueDefaultType) {
        this.returnValueDefaultType = returnValueDefaultType;
    }

    public String[] getReturnValueField() {
        return this.returnValueField;
    }

    public void setReturnValueField(String[] returnValueField) {
        this.returnValueField = returnValueField;
    }

    public String[] getReturnValueNewName() {
        return this.returnValueNewName;
    }

    public void setReturnValueNewName(String[] returnValueNewName) {
        this.returnValueNewName = returnValueNewName;
    }

    public String[] getStreamKeyField1() {
        return this.streamKeyField1;
    }

    public void setStreamKeyField1(String[] streamKeyField1) {
        this.streamKeyField1 = streamKeyField1;
    }

    public String[] getStreamKeyField2() {
        return this.streamKeyField2;
    }

    public void setStreamKeyField2(String[] streamKeyField2) {
        this.streamKeyField2 = streamKeyField2;
    }

    public String[] getTableKeyField() {
        return this.tableKeyField;
    }

    public void setTableKeyField(String[] tableKeyField) {
        this.tableKeyField = tableKeyField;
    }

    public String getTablename() {
        return this.tablename;
    }

    public void setTablename(String tablename) {
        this.tablename = tablename;
    }

    @Override
    public void loadXML(Node stepnode, List databases, Hashtable counters) throws ETLXMLException {
        this.streamKeyField1 = null;
        this.returnValueField = null;
        this.readData(stepnode, databases);
    }

    public void allocate(int nrkeys, int nrvalues) {
        this.streamKeyField1 = new String[nrkeys];
        this.tableKeyField = new String[nrkeys];
        this.keyCondition = new String[nrkeys];
        this.streamKeyField2 = new String[nrkeys];
        this.returnValueField = new String[nrvalues];
        this.returnValueNewName = new String[nrvalues];
        this.returnValueDefault = new String[nrvalues];
        this.returnValueDefaultType = new int[nrvalues];
    }

    @Override
    public Object clone() {
        int i;
        DatabaseLookupMeta retval = (DatabaseLookupMeta)super.clone();
        int nrkeys = this.streamKeyField1.length;
        int nrvalues = this.returnValueField.length;
        retval.allocate(nrkeys, nrvalues);
        for (i = 0; i < nrkeys; ++i) {
            retval.streamKeyField1[i] = this.streamKeyField1[i];
            retval.tableKeyField[i] = this.tableKeyField[i];
            retval.keyCondition[i] = this.keyCondition[i];
            retval.streamKeyField2[i] = this.streamKeyField2[i];
        }
        for (i = 0; i < nrvalues; ++i) {
            retval.returnValueField[i] = this.returnValueField[i];
            retval.returnValueNewName[i] = this.returnValueNewName[i];
            retval.returnValueDefault[i] = this.returnValueDefault[i];
            retval.returnValueDefaultType[i] = this.returnValueDefaultType[i];
        }
        return retval;
    }

    private void readData(Node stepnode, List databases) throws ETLXMLException {
        try {
            int i;
            String con = XMLHandler.getTagValue(stepnode, "connection");
            this.databaseMeta = Const.findDatabase(databases, con);
            this.cached = "Y".equalsIgnoreCase(XMLHandler.getTagValue(stepnode, "cache"));
            String csize = XMLHandler.getTagValue(stepnode, "cache_size");
            this.cacheSize = Const.toInt(csize, 0);
            this.tablename = XMLHandler.getTagValue(stepnode, "lookup", "table");
            Node lookup = XMLHandler.getSubNode(stepnode, "lookup");
            int nrkeys = XMLHandler.countNodes(lookup, "key");
            int nrvalues = XMLHandler.countNodes(lookup, "value");
            this.allocate(nrkeys, nrvalues);
            for (i = 0; i < nrkeys; ++i) {
                Node knode = XMLHandler.getSubNodeByNr(lookup, "key", i);
                this.streamKeyField1[i] = XMLHandler.getTagValue(knode, "name");
                this.tableKeyField[i] = XMLHandler.getTagValue(knode, "field");
                this.keyCondition[i] = XMLHandler.getTagValue(knode, "condition");
                if (this.keyCondition[i] == null) {
                    this.keyCondition[i] = "=";
                }
                this.streamKeyField2[i] = XMLHandler.getTagValue(knode, "name2");
            }
            for (i = 0; i < nrvalues; ++i) {
                Node vnode = XMLHandler.getSubNodeByNr(lookup, "value", i);
                this.returnValueField[i] = XMLHandler.getTagValue(vnode, "name");
                this.returnValueNewName[i] = XMLHandler.getTagValue(vnode, "rename");
                if (this.returnValueNewName[i] == null) {
                    this.returnValueNewName[i] = this.returnValueField[i];
                }
                this.returnValueDefault[i] = XMLHandler.getTagValue(vnode, "default");
                String dtype = XMLHandler.getTagValue(vnode, "type");
                this.returnValueDefaultType[i] = Value.getType(dtype);
                if (this.returnValueDefaultType[i] >= 0) continue;
                this.returnValueDefaultType[i] = 2;
            }
            this.orderByClause = XMLHandler.getTagValue(lookup, "orderby");
        }
        catch (Exception e) {
            throw new ETLXMLException("Unable to load step info from XML", e);
        }
    }

    @Override
    public void setDefault() {
        int i;
        this.streamKeyField1 = null;
        this.returnValueField = null;
        this.databaseMeta = null;
        this.cached = false;
        this.cacheSize = 0;
        this.tablename = "lookup table";
        int nrkeys = 0;
        int nrvalues = 0;
        this.allocate(nrkeys, nrvalues);
        for (i = 0; i < nrkeys; ++i) {
            this.tableKeyField[i] = "age";
            this.keyCondition[i] = "BETWEEN";
            this.streamKeyField1[i] = "age_from";
            this.streamKeyField2[i] = "age_to";
        }
        for (i = 0; i < nrvalues; ++i) {
            this.returnValueField[i] = "return field #" + i;
            this.returnValueNewName[i] = "new name #" + i;
            this.returnValueDefault[i] = "default #" + i;
            this.returnValueDefaultType[i] = 2;
        }
        this.orderByClause = "";
    }

    @Override
    public Row getFields(Row r, String name, Row info) {
        Row row = r == null ? new Row() : r;
        if (info == null) {
            for (int i = 0; i < this.returnValueNewName.length; ++i) {
                Value v = new Value(this.returnValueNewName[i], this.returnValueDefaultType[i]);
                v.setOrigin(name);
                row.addValue(v);
            }
        } else {
            for (int i = 0; i < this.returnValueNewName.length; ++i) {
                Value v = info.searchValue(this.returnValueField[i]);
                if (v == null) continue;
                v.setName(this.returnValueNewName[i]);
                v.setOrigin(name);
                row.addValue(v);
            }
        }
        return row;
    }

    @Override
    public String getXML() {
        int i;
        String retval = "";
        retval = retval + "    " + XMLHandler.addTagValue("connection", this.databaseMeta == null ? "" : this.databaseMeta.getName());
        retval = retval + "    " + XMLHandler.addTagValue("cache", this.cached);
        retval = retval + "    " + XMLHandler.addTagValue("cache_size", this.cacheSize);
        retval = retval + "    <lookup>" + Const.CR;
        retval = retval + "      " + XMLHandler.addTagValue("table", this.tablename);
        retval = retval + "      " + XMLHandler.addTagValue("orderby", this.orderByClause);
        for (i = 0; i < this.streamKeyField1.length; ++i) {
            retval = retval + "      <key>" + Const.CR;
            retval = retval + "        " + XMLHandler.addTagValue("name", this.streamKeyField1[i]);
            retval = retval + "        " + XMLHandler.addTagValue("field", this.tableKeyField[i]);
            retval = retval + "        " + XMLHandler.addTagValue("condition", this.keyCondition[i]);
            retval = retval + "        " + XMLHandler.addTagValue("name2", this.streamKeyField2[i]);
            retval = retval + "        </key>" + Const.CR;
        }
        for (i = 0; i < this.returnValueField.length; ++i) {
            retval = retval + "      <value>" + Const.CR;
            retval = retval + "        " + XMLHandler.addTagValue("name", this.returnValueField[i]);
            retval = retval + "        " + XMLHandler.addTagValue("rename", this.returnValueNewName[i]);
            retval = retval + "        " + XMLHandler.addTagValue("default", this.returnValueDefault[i]);
            retval = retval + "        " + XMLHandler.addTagValue("type", Value.getTypeDesc(this.returnValueDefaultType[i]));
            retval = retval + "        </value>" + Const.CR;
        }
        retval = retval + "      </lookup>" + Const.CR;
        return retval;
    }

    @Override
    public void readRep(Repository rep, long id_step, List databases, Hashtable counters) throws ETLException {
        try {
            int i;
            long id_connection = rep.getStepAttributeInteger(id_step, "id_connection");
            this.databaseMeta = Const.findDatabase(databases, id_connection);
            this.cached = rep.getStepAttributeBoolean(id_step, "cache");
            this.cacheSize = (int)rep.getStepAttributeInteger(id_step, "cache_size");
            this.tablename = rep.getStepAttributeString(id_step, "lookup_table");
            this.orderByClause = rep.getStepAttributeString(id_step, "lookup_orderby");
            int nrkeys = rep.countNrStepAttributes(id_step, "lookup_key_name");
            int nrvalues = rep.countNrStepAttributes(id_step, "return_value_name");
            this.allocate(nrkeys, nrvalues);
            for (i = 0; i < nrkeys; ++i) {
                this.streamKeyField1[i] = rep.getStepAttributeString(id_step, i, "lookup_key_name");
                this.tableKeyField[i] = rep.getStepAttributeString(id_step, i, "lookup_key_field");
                this.keyCondition[i] = rep.getStepAttributeString(id_step, i, "lookup_key_condition");
                this.streamKeyField2[i] = rep.getStepAttributeString(id_step, i, "lookup_key_name2");
            }
            for (i = 0; i < nrvalues; ++i) {
                this.returnValueField[i] = rep.getStepAttributeString(id_step, i, "return_value_name");
                this.returnValueNewName[i] = rep.getStepAttributeString(id_step, i, "return_value_rename");
                this.returnValueDefault[i] = rep.getStepAttributeString(id_step, i, "return_value_default");
                this.returnValueDefaultType[i] = Value.getType(rep.getStepAttributeString(id_step, i, "return_value_type"));
            }
        }
        catch (Exception e) {
            throw new ETLException("Unexpected error reading step information from the repository", e);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_transformation, long id_step) throws ETLException {
        try {
            int i;
            rep.saveStepAttribute(id_transformation, id_step, "id_connection", this.databaseMeta == null ? -1.0 : (double)this.databaseMeta.getID());
            rep.saveStepAttribute(id_transformation, id_step, "cache", this.cached);
            rep.saveStepAttribute(id_transformation, id_step, "cache_size", this.cacheSize);
            rep.saveStepAttribute(id_transformation, id_step, "lookup_table", this.tablename);
            rep.saveStepAttribute(id_transformation, id_step, "lookup_orderby", this.orderByClause);
            for (i = 0; i < this.streamKeyField1.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "lookup_key_name", this.streamKeyField1[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "lookup_key_field", this.tableKeyField[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "lookup_key_condition", this.keyCondition[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "lookup_key_name2", this.streamKeyField2[i]);
            }
            for (i = 0; i < this.returnValueField.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "return_value_name", this.returnValueField[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "return_value_rename", this.returnValueNewName[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "return_value_default", this.returnValueDefault[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "return_value_type", Value.getTypeDesc(this.returnValueDefaultType[i]));
            }
            if (this.databaseMeta != null) {
                rep.insertStepDatabase(id_transformation, id_step, this.databaseMeta.getID());
            }
        }
        catch (Exception e) {
            throw new ETLException("Unable to save step information to the repository for id_step=" + id_step, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void check(List remarks, StepMeta stepinfo, Row prev, String[] input, String[] output, Row info) {
        CheckResult cr;
        String error_message = "";
        if (this.databaseMeta != null) {
            Database db = new Database(this.databaseMeta);
            this.databases = new Database[]{db};
            try {
                boolean error_found;
                boolean first;
                db.connect();
                if (this.tablename != null && this.tablename.length() != 0) {
                    first = true;
                    error_found = false;
                    error_message = "";
                    Row r = db.getTableFields(this.tablename);
                    if (r != null) {
                        Value v;
                        String lufield;
                        int i;
                        for (i = 0; i < this.tableKeyField.length; ++i) {
                            lufield = this.tableKeyField[i];
                            v = r.searchValue(lufield);
                            if (v != null) continue;
                            if (first) {
                                first = false;
                                error_message = error_message + "Missing compare fields in lookup table:" + Const.CR;
                            }
                            error_found = true;
                            error_message = error_message + "\t\t" + lufield + Const.CR;
                        }
                        cr = error_found ? new CheckResult(4, error_message, stepinfo) : new CheckResult(1, "All lookup fields found in the table.", stepinfo);
                        remarks.add(cr);
                        for (i = 0; i < this.returnValueField.length; ++i) {
                            lufield = this.returnValueField[i];
                            v = r.searchValue(lufield);
                            if (v != null) continue;
                            if (first) {
                                first = false;
                                error_message = error_message + "Missing return fields in lookup table:" + Const.CR;
                            }
                            error_found = true;
                            error_message = error_message + "\t\t" + lufield + Const.CR;
                        }
                        cr = error_found ? new CheckResult(4, error_message, stepinfo) : new CheckResult(1, "All return fields found in the table.", stepinfo);
                        remarks.add(cr);
                    } else {
                        error_message = "Couldn't read the table info, please check the table-name & permissions.";
                        cr = new CheckResult(4, error_message, stepinfo);
                        remarks.add(cr);
                    }
                }
                if (prev != null && prev.size() > 0) {
                    first = true;
                    error_message = "";
                    error_found = false;
                    for (int i = 0; i < this.streamKeyField1.length; ++i) {
                        Value v = prev.searchValue(this.streamKeyField1[i]);
                        if (v != null) continue;
                        if (first) {
                            first = false;
                            error_message = error_message + "Missing fields, not found in input from previous steps:" + Const.CR;
                        }
                        error_found = true;
                        error_message = error_message + "\t\t" + this.streamKeyField1[i] + Const.CR;
                    }
                    cr = error_found ? new CheckResult(4, error_message, stepinfo) : new CheckResult(1, "All fields found in the input stream.", stepinfo);
                    remarks.add(cr);
                }
                error_message = "Couldn't read fields from the previous step." + Const.CR;
                cr = new CheckResult(4, error_message, stepinfo);
                remarks.add(cr);
            }
            catch (ETLDatabaseException dbe) {
                error_message = "An error occurred: " + dbe.getMessage();
                cr = new CheckResult(4, error_message, stepinfo);
                remarks.add(cr);
            }
            finally {
                db.disconnect();
            }
        } else {
            error_message = "Please select or create a connection!";
            cr = new CheckResult(4, error_message, stepinfo);
            remarks.add(cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, "Step is receiving info from other steps.", stepinfo);
            remarks.add(cr);
        } else {
            cr = new CheckResult(4, "No input received from other steps!", stepinfo);
            remarks.add(cr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Row getTableFields() {
        LogWriter log = LogWriter.getInstance();
        Row fields = null;
        if (this.databaseMeta != null) {
            Database db = new Database(this.databaseMeta);
            this.databases = new Database[]{db};
            try {
                db.connect();
                fields = db.getTableFields(this.tablename);
            }
            catch (ETLDatabaseException dbe) {
                log.logError(this.toString(), "An error occurred: " + dbe.getMessage());
            }
            finally {
                db.disconnect();
            }
        }
        return fields;
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new DatabaseLookup(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new DatabaseLookupData();
    }

    public void analyseImpact(ArrayList impact, TransMeta transMeta, StepMeta stepinfo, Row prev, String[] input, String[] output, Row info) {
        int i;
        for (i = 0; i < this.streamKeyField1.length; ++i) {
            Value v = prev.searchValue(this.streamKeyField1[i]);
            DatabaseImpact ii = new DatabaseImpact(1, transMeta.getName(), stepinfo.getName(), this.databaseMeta.getDatabaseName(), this.tablename, this.tableKeyField[i], this.streamKeyField1[i], v != null ? v.getOrigin() : "?", "", "Key");
            impact.add(ii);
        }
        for (i = 0; i < this.returnValueField.length; ++i) {
            DatabaseImpact ii = new DatabaseImpact(1, transMeta.getName(), stepinfo.getName(), this.databaseMeta.getDatabaseName(), this.tablename, this.returnValueField[i], "", "", "", "Return value");
            impact.add(ii);
        }
    }
}

