/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.transformation.step.dbproc;

import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.database.Database;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.exception.ETLStepException;
import com.kingdee.bos.ctrl.etl.transformation.Trans;
import com.kingdee.bos.ctrl.etl.transformation.TransMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.BaseStep;
import com.kingdee.bos.ctrl.etl.transformation.step.StepDataInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMetaInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.dbproc.DBProcData;
import com.kingdee.bos.ctrl.etl.transformation.step.dbproc.DBProcMeta;

public class DBProc
extends BaseStep
implements StepInterface {
    private DBProcMeta meta;
    private DBProcData data;

    public DBProc(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    private synchronized void runProc(Row row) throws ETLException {
        int i;
        if (this.first) {
            this.first = false;
            this.data.argnrs = new int[this.meta.getArgument().length];
            for (i = 0; i < this.meta.getArgument().length; ++i) {
                if (!this.meta.getArgumentDirection()[i].equalsIgnoreCase("OUT")) {
                    this.data.argnrs[i] = row.searchValueIndex(this.meta.getArgument()[i]);
                    if (this.data.argnrs[i] >= 0) continue;
                    this.logError("Error finding field: " + this.meta.getArgument()[i] + "]");
                    throw new ETLStepException("Couldn't find field '" + this.meta.getArgument()[i] + "' in row!");
                }
                this.data.argnrs[i] = -1;
            }
            this.data.db.setProcLookup(this.meta.getProcedure(), this.meta.getArgument(), this.meta.getArgumentDirection(), this.meta.getArgumentType(), this.meta.getResultName(), this.meta.getResultType());
        }
        this.data.db.setProcValues(row, this.data.argnrs, this.meta.getArgumentDirection(), this.meta.getResultName() != null);
        Row add = this.data.db.callProcedure(this.meta.getArgument(), this.meta.getArgumentDirection(), this.meta.getArgumentType(), this.meta.getResultName(), this.meta.getResultType());
        for (i = 0; i < add.size(); ++i) {
            row.addValue(add.getValue(i));
        }
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws ETLException {
        this.meta = (DBProcMeta)smi;
        this.data = (DBProcData)sdi;
        Row r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        try {
            this.runProc(r);
            this.putRow(r);
            if (this.linesRead > 0L && this.linesRead % 5000L == 0L) {
                this.logBasic("linenr " + this.linesRead);
            }
        }
        catch (ETLException e) {
            this.logError("Because of an error, this step can't continue: " + e.getMessage());
            this.setErrors(1L);
            this.stopAll();
            this.setOutputDone();
            return false;
        }
        return true;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (DBProcMeta)smi;
        this.data = (DBProcData)sdi;
        if (super.init(smi, sdi)) {
            this.data.db = new Database(this.meta.getDatabase());
            try {
                this.data.db.connect();
                this.logBasic("Connected to database...");
                return true;
            }
            catch (ETLException e) {
                this.logError("An error occurred, processing will be stopped: " + e.getMessage());
                this.data.db.disconnect();
            }
        }
        return false;
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (DBProcMeta)smi;
        this.data = (DBProcData)sdi;
        this.data.db.disconnect();
        super.dispose(smi, sdi);
    }

    @Override
    public void run() {
        this.logBasic("Starting to run...");
        try {
            while (this.processRow(this.meta, this.data) && !this.isStopped()) {
            }
        }
        catch (Exception e) {
            this.logError("Unexpected error in '" + this.debug + "' : " + e.toString());
            this.setErrors(1L);
            this.stopAll();
        }
        finally {
            this.dispose(this.meta, this.data);
            this.logSummary();
            this.markStop();
        }
    }

    @Override
    public String toString() {
        return this.getClass().getName();
    }
}

