/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.transformation.step.joinrows;

import com.kingdee.bos.ctrl.etl.base.CheckResult;
import com.kingdee.bos.ctrl.etl.base.Condition;
import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.exception.ETLXMLException;
import com.kingdee.bos.ctrl.etl.repository.Repository;
import com.kingdee.bos.ctrl.etl.transformation.Trans;
import com.kingdee.bos.ctrl.etl.transformation.TransMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.BaseStepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepDataInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMetaInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.joinrows.JoinRows;
import com.kingdee.bos.ctrl.etl.transformation.step.joinrows.JoinRowsData;
import com.kingdee.bos.ctrl.etl.util.Const;
import com.kingdee.bos.ctrl.etl.util.XMLHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.w3c.dom.Node;

public class JoinRowsMeta
extends BaseStepMeta
implements StepMetaInterface {
    private String directory;
    private String prefix;
    private int cacheSize;
    private StepMeta mainStep;
    private String mainStepname;
    private Condition condition = new Condition();

    public StepMeta getMainStep() {
        return this.mainStep;
    }

    public void setMainStep(StepMeta lookupFromStep) {
        this.mainStep = lookupFromStep;
    }

    public String getMainStepname() {
        return this.mainStepname;
    }

    public void setMainStepname(String lookupFromStepname) {
        this.mainStepname = lookupFromStepname;
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public Condition getCondition() {
        return this.condition;
    }

    public void setCondition(Condition condition) {
        this.condition = condition;
    }

    @Override
    public void loadXML(Node stepnode, List databases, Hashtable counters) throws ETLXMLException {
        this.readData(stepnode);
    }

    @Override
    public Object clone() {
        JoinRowsMeta retval = (JoinRowsMeta)super.clone();
        return retval;
    }

    private void readData(Node stepnode) throws ETLXMLException {
        try {
            this.directory = XMLHandler.getTagValue(stepnode, "directory");
            this.prefix = XMLHandler.getTagValue(stepnode, "prefix");
            this.cacheSize = Const.toInt(XMLHandler.getTagValue(stepnode, "cache_size"), -1);
            this.mainStepname = XMLHandler.getTagValue(stepnode, "main");
            Node compare = XMLHandler.getSubNode(stepnode, "compare");
            Node condnode = XMLHandler.getSubNode(compare, "condition");
            this.condition = condnode != null ? new Condition(condnode) : new Condition();
        }
        catch (Exception e) {
            throw new ETLXMLException("Unable to read step information from XML", e);
        }
    }

    @Override
    public void setDefault() {
        this.directory = "%%java.io.tmpdir%%";
        this.prefix = "out";
        this.cacheSize = 500;
        this.mainStepname = null;
    }

    @Override
    public String getXML() {
        String retval = "";
        retval = retval + "      " + XMLHandler.addTagValue("directory", this.directory);
        retval = retval + "      " + XMLHandler.addTagValue("prefix", this.prefix);
        retval = retval + "      " + XMLHandler.addTagValue("cache_size", this.cacheSize);
        retval = retval + "      " + XMLHandler.addTagValue("main", this.getLookupStepname());
        retval = retval + "    <compare>" + Const.CR;
        if (this.condition != null) {
            retval = retval + this.condition.getXML();
        }
        retval = retval + "    </compare>" + Const.CR;
        return retval;
    }

    @Override
    public void readRep(Repository rep, long id_step, List databases, Hashtable counters) throws ETLException {
        try {
            this.directory = rep.getStepAttributeString(id_step, "directory");
            this.prefix = rep.getStepAttributeString(id_step, "prefix");
            this.cacheSize = (int)rep.getStepAttributeInteger(id_step, "cache_size");
            this.mainStepname = rep.getStepAttributeString(id_step, "main");
            long id_condition = rep.getStepAttributeInteger(id_step, 0, "id_condition");
            this.condition = id_condition > 0L ? new Condition(rep, id_condition) : new Condition();
        }
        catch (Exception e) {
            throw new ETLException("Unexpected error reading step information from the repository", e);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_transformation, long id_step) throws ETLException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "directory", this.directory);
            rep.saveStepAttribute(id_transformation, id_step, "prefix", this.prefix);
            rep.saveStepAttribute(id_transformation, id_step, "cache_size", this.cacheSize);
            rep.saveStepAttribute(id_transformation, id_step, "main", this.getLookupStepname());
            if (this.condition != null) {
                this.condition.saveRep(rep);
                rep.saveStepAttribute(id_transformation, id_step, "id_condition", this.condition.getID());
            }
        }
        catch (Exception e) {
            throw new ETLException("Unable to save step information to the repository for id_step=" + id_step, e);
        }
    }

    @Override
    public void check(List remarks, StepMeta stepMeta, Row prev, String[] input, String[] output, Row info) {
        CheckResult cr;
        if (prev != null && prev.size() > 0) {
            cr = new CheckResult(1, "Step is connected to previous one, receiving " + prev.size() + " fields", stepMeta);
            remarks.add(cr);
            File f = new File(this.directory);
            if (f.exists()) {
                if (f.isDirectory()) {
                    cr = new CheckResult(1, "[" + this.directory + "] exists and is a directory", stepMeta);
                    remarks.add(cr);
                } else {
                    cr = new CheckResult(4, "[" + this.directory + "] exists but is not a directory", stepMeta);
                    remarks.add(cr);
                }
            } else {
                cr = new CheckResult(4, "Directory [" + this.directory + "] doesn't exist!", stepMeta);
                remarks.add(cr);
            }
        } else {
            cr = new CheckResult(4, "Couldn't find fields from previous steps, check the hops...!", stepMeta);
            remarks.add(cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, "Step is receiving info from other steps.", stepMeta);
            remarks.add(cr);
        } else {
            cr = new CheckResult(4, "No input received from other steps!", stepMeta);
            remarks.add(cr);
        }
    }

    public String getLookupStepname() {
        if (this.mainStep != null && this.mainStep.getName() != null && this.mainStep.getName().length() > 0) {
            return this.mainStep.getName();
        }
        return null;
    }

    public void searchInfoAndTargetSteps(ArrayList steps) {
        this.mainStep = TransMeta.findStep(steps, this.mainStepname);
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new JoinRows(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new JoinRowsData();
    }
}

