/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.transformation.step.scriptvalues;

import com.kingdee.bos.ctrl.etl.base.CheckResult;
import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.exception.ETLXMLException;
import com.kingdee.bos.ctrl.etl.repository.Repository;
import com.kingdee.bos.ctrl.etl.transformation.Trans;
import com.kingdee.bos.ctrl.etl.transformation.TransMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.BaseStepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepDataInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMetaInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.scriptvalues.ContextUtil;
import com.kingdee.bos.ctrl.etl.transformation.step.scriptvalues.ScriptValues;
import com.kingdee.bos.ctrl.etl.transformation.step.scriptvalues.ScriptValuesData;
import com.kingdee.bos.ctrl.etl.util.Const;
import com.kingdee.bos.ctrl.etl.util.XMLHandler;
import com.kingdee.bos.ctrl.etl.value.Value;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.w3c.dom.Node;

public class ScriptValuesMeta
extends BaseStepMeta
implements StepMetaInterface {
    private String script;
    private String[] name;
    private String[] rename;
    private int[] type;
    private int[] length;
    private int[] precision;

    public int[] getLength() {
        return this.length;
    }

    public void setLength(int[] length) {
        this.length = length;
    }

    public String[] getName() {
        return this.name;
    }

    public void setName(String[] name) {
        this.name = name;
    }

    public int[] getPrecision() {
        return this.precision;
    }

    public void setPrecision(int[] precision) {
        this.precision = precision;
    }

    public String[] getRename() {
        return this.rename;
    }

    public void setRename(String[] rename) {
        this.rename = rename;
    }

    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public int[] getType() {
        return this.type;
    }

    public void setType(int[] type) {
        this.type = type;
    }

    @Override
    public void loadXML(Node stepnode, List databases, Hashtable counters) throws ETLXMLException {
        this.readData(stepnode);
    }

    public void allocate(int nrfields) {
        this.name = new String[nrfields];
        this.rename = new String[nrfields];
        this.type = new int[nrfields];
        this.length = new int[nrfields];
        this.precision = new int[nrfields];
    }

    @Override
    public Object clone() {
        ScriptValuesMeta retval = (ScriptValuesMeta)super.clone();
        int nrfields = this.name.length;
        retval.allocate(nrfields);
        for (int i = 0; i < nrfields; ++i) {
            retval.name[i] = this.name[i];
            retval.rename[i] = this.rename[i];
            retval.type[i] = this.type[i];
            retval.length[i] = this.length[i];
            retval.precision[i] = this.precision[i];
        }
        return retval;
    }

    private void readData(Node stepnode) throws ETLXMLException {
        try {
            this.script = XMLHandler.getTagValue(stepnode, "script");
            Node fields = XMLHandler.getSubNode(stepnode, "fields");
            int nrfields = XMLHandler.countNodes(fields, "field");
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr(fields, "field", i);
                this.name[i] = XMLHandler.getTagValue(fnode, "name");
                this.rename[i] = XMLHandler.getTagValue(fnode, "rename");
                this.type[i] = Value.getType(XMLHandler.getTagValue(fnode, "type"));
                String slen = XMLHandler.getTagValue(fnode, "length");
                String sprc = XMLHandler.getTagValue(fnode, "precision");
                this.length[i] = Const.toInt(slen, -1);
                this.precision[i] = Const.toInt(sprc, -1);
            }
        }
        catch (Exception e) {
            throw new ETLXMLException("Unable to load step info from XML", e);
        }
    }

    @Override
    public void setDefault() {
        this.script = "";
        int nrfields = 0;
        this.allocate(nrfields);
        for (int i = 0; i < nrfields; ++i) {
            this.name[i] = "newvalue";
            this.rename[i] = "newvalue";
            this.type[i] = 1;
            this.length[i] = -1;
            this.precision[i] = -1;
        }
    }

    @Override
    public Row getFields(Row r, String name, Row info) {
        Row row = r == null ? new Row() : r;
        for (int i = 0; i < this.name.length; ++i) {
            if (this.name[i] == null && this.rename[i] == null) continue;
            Value v = this.rename[i] != null && this.rename[i].length() != 0 ? new Value(this.rename[i], this.type[i]) : new Value(this.name[i], this.type[i]);
            v.setLength(this.length[i], this.precision[i]);
            v.setOrigin(name);
            row.addValue(v);
        }
        return row;
    }

    @Override
    public String getXML() {
        String retval = "";
        retval = retval + "    " + XMLHandler.addTagValue("script", this.script);
        retval = retval + "    <fields>";
        for (int i = 0; i < this.name.length; ++i) {
            retval = retval + "      <field>";
            retval = retval + "        " + XMLHandler.addTagValue("name", this.name[i]);
            retval = retval + "        " + XMLHandler.addTagValue("rename", this.rename[i]);
            retval = retval + "        " + XMLHandler.addTagValue("type", Value.getTypeDesc(this.type[i]));
            retval = retval + "        " + XMLHandler.addTagValue("length", this.length[i]);
            retval = retval + "        " + XMLHandler.addTagValue("precision", this.precision[i]);
            retval = retval + "        </field>";
        }
        retval = retval + "      </fields>";
        return retval;
    }

    @Override
    public void readRep(Repository rep, long id_step, List databases, Hashtable counters) throws ETLException {
        try {
            this.script = rep.getStepAttributeString(id_step, "script");
            int nrfields = rep.countNrStepAttributes(id_step, "field_name");
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                this.name[i] = rep.getStepAttributeString(id_step, i, "field_name");
                this.rename[i] = rep.getStepAttributeString(id_step, i, "field_rename");
                this.type[i] = Value.getType(rep.getStepAttributeString(id_step, i, "field_type"));
                this.length[i] = (int)rep.getStepAttributeInteger(id_step, i, "field_length");
                this.precision[i] = (int)rep.getStepAttributeInteger(id_step, i, "field_precision");
            }
        }
        catch (Exception e) {
            throw new ETLException("Unexpected error reading step information from the repository", e);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_transformation, long id_step) throws ETLException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "script", this.script);
            for (int i = 0; i < this.name.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_name", this.name[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_rename", this.rename[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_type", Value.getTypeDesc(this.type[i]));
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_length", this.length[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_precision", this.precision[i]);
            }
        }
        catch (Exception e) {
            throw new ETLException("Unable to save step information to the repository for id_step=" + id_step, e);
        }
    }

    @Override
    public void check(List remarks, StepMeta stepinfo, Row prev, String[] input, String[] output, Row info) {
        CheckResult cr;
        boolean error_found = false;
        String error_message = "";
        Context jscx = Context.enter();
        Scriptable jsscope = jscx.initStandardObjects(null);
        if (prev != null && prev.size() > 0) {
            cr = new CheckResult(1, "Step is connected to previous one, receiving " + prev.size() + " fields", stepinfo);
            remarks.add(cr);
            Scriptable jsrow = Context.toObject((Object)prev, (Scriptable)jsscope);
            jsscope.put("row", jsscope, (Object)jsrow);
            for (int i = 0; i < prev.size(); ++i) {
                Value val = prev.getValue(i);
                if (val.isDate()) {
                    val.setValue(new Date());
                }
                if (val.isString()) {
                    val.setValue("test value test value test value test value test value test value test value test value test value test value");
                }
                Scriptable jsarg = Context.toObject((Object)val, (Scriptable)jsscope);
                jsscope.put(val.getName(), jsscope, (Object)jsarg);
            }
            Scriptable jsval = Context.toObject(Value.class, (Scriptable)jsscope);
            jsscope.put("Value", jsscope, (Object)jsval);
            try {
                Script jsscript = ContextUtil.compileString(jscx, this.script, "script", 1, null);
                cr = new CheckResult(1, "Script compiled without a problem", stepinfo);
                remarks.add(cr);
                try {
                    jsscript.exec(jscx, jsscope);
                    cr = new CheckResult(1, "Script executed without a problem", stepinfo);
                    remarks.add(cr);
                    if (this.name.length > 0) {
                        StringBuffer message = new StringBuffer("Trying to retrieve " + this.name.length + " fields: " + Const.CR + Const.CR);
                        for (int i = 0; i < this.name.length; ++i) {
                            Value res = new Value();
                            message.append("   ");
                            if (this.getValue(jsscope, i, res, message)) {
                                error_found = true;
                            }
                            message.append(Const.CR);
                        }
                        cr = error_found ? new CheckResult(4, message.toString(), stepinfo) : new CheckResult(1, message.toString(), stepinfo);
                        remarks.add(cr);
                    }
                }
                catch (JavaScriptException jse) {
                    Context.exit();
                    error_message = "Couldn't execute this script! Error:" + Const.CR + jse.toString();
                    cr = new CheckResult(4, error_message, stepinfo);
                    remarks.add(cr);
                }
                catch (Exception e) {
                    Context.exit();
                    error_message = "General error executing script:" + Const.CR + e.toString();
                    cr = new CheckResult(4, error_message, stepinfo);
                    remarks.add(cr);
                }
            }
            catch (Exception e) {
                Context.exit();
                error_message = "Couldn't compile this script! Error:" + Const.CR + e.toString();
                cr = new CheckResult(4, error_message, stepinfo);
                remarks.add(cr);
            }
        } else {
            Context.exit();
            error_message = "Couldn't get fields from previous steps, please connect all needed hops!";
            cr = new CheckResult(4, error_message, stepinfo);
            remarks.add(cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, "Step is receiving info from other steps.", stepinfo);
            remarks.add(cr);
        } else {
            cr = new CheckResult(4, "No input received from other steps!", stepinfo);
            remarks.add(cr);
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean getValue(Scriptable scope, int i, Value res, StringBuffer message) {
        block26: {
            block24: {
                block23: {
                    error_found = false;
                    if (this.name[i] == null || this.name[i].length() <= 0) break block24;
                    res.setName(this.rename[i]);
                    res.setType(this.type[i]);
                    try {
                        block25: {
                            result = scope.get(this.name[i], scope);
                            if (result == null) break block25;
                            classname = result.getClass().getName();
                            switch (this.type[i]) {
                                case 1: {
                                    if (classname.equalsIgnoreCase("org.mozilla.javascript.Undefined")) {
                                        res.setNull();
                                        break;
                                    }
                                    if (classname.equalsIgnoreCase("org.mozilla.javascript.NativeJavaObject")) {
                                        v = (Value)Context.toType((Object)result, Value.class);
                                        res.setValue(v.getNumber());
                                        break;
                                    }
                                    res.setValue((Double)result);
                                    break;
                                }
                                case 5: {
                                    if (classname.equalsIgnoreCase("java.lang.Byte")) {
                                        res.setValue(((Byte)result).longValue());
                                        break;
                                    }
                                    if (classname.equalsIgnoreCase("java.lang.Short")) {
                                        res.setValue(((Short)result).longValue());
                                        break;
                                    }
                                    if (classname.equalsIgnoreCase("java.lang.Integer")) {
                                        res.setValue(((Integer)result).longValue());
                                        break;
                                    }
                                    if (classname.equalsIgnoreCase("java.lang.Long")) {
                                        res.setValue((Long)result);
                                        break;
                                    }
                                    if (classname.equalsIgnoreCase("org.mozilla.javascript.Undefined")) {
                                        res.setNull();
                                        break;
                                    }
                                    if (classname.equalsIgnoreCase("org.mozilla.javascript.NativeJavaObject")) {
                                        v = (Value)Context.toType((Object)result, Value.class);
                                        res.setValue(v.getInteger());
                                        break;
                                    }
                                    res.setValue(Math.round((Double)result));
                                    break;
                                }
                                case 2: {
                                    if (classname.equalsIgnoreCase("org.mozilla.javascript.NativeJavaObject") || classname.equalsIgnoreCase("org.mozilla.javascript.Undefined")) {
                                        try {
                                            v = (Value)Context.toType((Object)result, Value.class);
                                            res.setValue(v.getString());
                                        }
                                        catch (Exception ev) {
                                            s = (String)Context.toType((Object)result, String.class);
                                            res.setValue(s);
                                        }
                                        break;
                                    }
                                    res.setValue((String)result);
                                    break;
                                }
                                case 3: {
                                    dbl = 0.0;
                                    if (classname.equalsIgnoreCase("org.mozilla.javascript.Undefined")) {
                                        res.setNull();
                                        break;
                                    }
                                    if (!classname.equalsIgnoreCase("org.mozilla.javascript.NativeDate")) ** GOTO lbl62
                                    dbl = Context.toNumber((Object)result);
                                    ** GOTO lbl76
lbl62:
                                    // 1 sources

                                    if (!classname.equalsIgnoreCase("org.mozilla.javascript.NativeJavaObject")) ** GOTO lbl75
                                    try {
                                        dat = (Date)Context.toType((Object)result, Date.class);
                                        dbl = dat.getTime();
                                    }
                                    catch (Exception e) {
                                        v = (Value)Context.toType((Object)result, Value.class);
                                        dat = v.getDate();
                                        if (dat == null) ** GOTO lbl73
                                        dbl = dat.getTime();
                                        ** GOTO lbl76
lbl73:
                                        // 1 sources

                                        res.setNull();
                                    }
                                    ** GOTO lbl76
lbl75:
                                    // 1 sources

                                    dbl = (Double)result;
lbl76:
                                    // 5 sources

                                    lng = Math.round(dbl);
                                    dat = new Date(lng);
                                    res.setValue(dat);
                                    break;
                                }
                                case 4: {
                                    res.setValue((Boolean)result);
                                    break;
                                }
                                default: {
                                    res.setNull();
                                    break;
                                }
                            }
                            break block23;
                        }
                        res.setNull();
                    }
                    catch (Exception e) {
                        message.append("Error retrieving value " + this.name[i] + " : " + e.toString());
                        error_found = true;
                    }
                }
                res.setLength(this.length[i], this.precision[i]);
                message.append(" - Retrieved value " + this.name[i] + " of type " + res.toStringMeta());
                break block26;
            }
            message.append("Error: value #" + i + " is empty!");
            error_found = true;
        }
        return error_found;
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new ScriptValues(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new ScriptValuesData();
    }
}

